/*
* @category    Formulario Consultar HC Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmConsultarHCxPacienteUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Consultar HC x Paciente ::.',
    id: 'winFrmConsultarHCxPaciente',
    closable:false,
    width:980,
    height:520,
    //autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        stProfesionalesxIPS = new StoreProfesionales();
        function VerHoraLegaliza(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            return '<p style="color: red; font-weight:bold; text-decoration:blink; text-align:center;">'+value + '</p>Hora Estimada Atención: </br>' + record.get('HoraAtencion');
	}
        
        function VerPaciente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<p>' + record.get('TipDoc') + '-' + record.get('Documento') + '</br>' + record.get('PrimerNombre') + ' ' + record.get('SegundoNombre') + ' ' + record.get('PrimerApellido') + ' ' + record.get('SegundoApellido') + '</br>Genero: ' + record.get('Genero') + ' FecNac: ' + record.get('FecNac') + '</br>' + record.get('Edad');  
        }
        
        function VerCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('DescAdiHora');  
        }
        
        function VerCliente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('Cliente') + '</br>' + record.get('Actividad') + '</br>Programa: ' + record.get('Programa');  
        }
        var stGrid = new StoreGridCitasxEvolucionarxPaciente();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmConsultarHCxPaciente',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'sysPacienteSearchHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Paciente',
                                width: 790,
                                readOnly: true,
                                allowBlank: false,
                                emptyText: 'Seleccione Paciente ....',
                                id: 'fPacienteSearchHC'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPacienteUnificaMalo'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'displayfield',
                                fieldLabel: 'Filtro',
                                value: 'Desde:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: true,
                                id: 'fecDesdeSearchHC'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Hasta:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: true,
                                id: 'fecHastaSearchHC'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Profesional:'
                            },
                            {
                                xtype: 'combo',
                                width: 392,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                listWidth: 670,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: stProfesionalesxIPS,
                                triggerAction: 'all',
                                mode: 'local',
                                emptyText: 'Seleccione...!',
                                allowBlank: true,
                                id: 'intProfesionalSearchHC'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnFiltro',
                                tooltip: 'Aplicar Filtro',
                                id: 'btnFiltroBuscarHC'
                            }
                        ]
                    },
                    {
                        xtype: 'tabpanel',
                        width: 935,
                        height: 385,
                        border: false,
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evoluciones por Paciente',
                                height: 345,
                                width: 951,
                                frame: true,
                                border: false,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'hbox',
                                        anchor: '100%',
                                        height: 341,
                                        items: [
                                            {
                                                xtype: 'grid',
                                                store: 'StoreGridEvolucionesHC',
                                                title: 'Atenciones',
                                                width: 130,
                                                height: 345,
                                                flex: 1,
                                                id: 'gridHistorialEvoluciones',
                                                columns: [
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Fecha',
                                                        sortable: true,
                                                        width: 120,
                                                        dataIndex: 'FechaAtencion',
                                                        hideable: false
                                                    }
                                                ],
                                                viewConfig: {
                                                    forceFit:true
                                                }
                                            },
                                            {
                                                xtype: 'htmleditor',
                                                id: 'DetalleResumenHC',
                                                allowBlank: false,
                                                style: 'text-transform:uppercase;',
                                                width: 795,
                                                height: 345,
                                                readOnly: true,
                                                enableAlignments : false,
                                                enableColors : false,
                                                enableFont : false,
                                                enableFontSize : false,
                                                enableFormat : false,
                                                enableLinks : false,
                                                enableLists : false,
                                                enableSourceEdit : false
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Citas No Evolucionadas',
                                height: 241,
                                width: 951,
                                frame: true,
                                border: false,
                                items: [
                                    {
                                        xtype: 'grid',
                                        id: 'gridSinEvolucionar',
                                        store: stGrid,
                                        anchor: "100%",
                                        height: 335,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        stripeRows: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                header: 'CAS',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'CAS',
                                                width: 100,
                                                hideable: false
                                            },
                                            {
                                                header: 'Fecha',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'FechaCita',
                                                renderer: VerCita,
                                                width: 110,
                                                hideable: false
                                            },
                                            {
                                                header: 'Hora',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'HoraAgenda',
                                                renderer: VerCita,
                                                width: 110,
                                                hideable: false
                                            },
                                            {
                                                header: 'Hora Legalización',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'FechaLegaliza',
                                                width: 130,
                                                renderer: VerHoraLegaliza,
                                                hideable: false
                                            },
                                            {
                                                header: 'Paciente',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Paciente',
                                                width: 330,
                                                renderer: VerPaciente,
                                                hideable: false
                                            },
                                            {
                                                header: 'Cliente',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Cliente',
                                                width: 250,
                                                renderer: VerCliente,
                                                hideable: false
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                        view: new Ext.ux.grid.LockingGridView(),
                                        columnLines: true
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        winFrmConsultarHCxPacienteUi.superclass.initComponent.call(this);
    }
});
