/*
* @category    Programacion Eventos Formulario Tipo de Horario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmConsultarHCxPaciente = Ext.extend(winFrmConsultarHCxPacienteUi, {
    initComponent: function() {
        winFrmConsultarHCxPaciente.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        wAsignarProximaCita = 0;
        
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnBuscarPacienteUnificaMalo = Ext.getCmp('btnBuscarPacienteUnificaMalo').on("click",this.BuscarPacienteMalo,this);
        var btnFiltroBuscarHC = Ext.getCmp('btnFiltroBuscarHC').on("click",this.AplicarFiltro,this);
        var btnConsultaEvolucionHC = Ext.getCmp('btnConsultaEvolucionHC').on("click",this.ConsultaEvolucionHC,this);
        
        var sm_gridservicios = Ext.getCmp('gridFormulario').getSelectionModel();
        sm_gridservicios.on("rowselect",this.UpdateDetalleResumenHC,this);
        
    },
    ConsultaEvolucionHC: function(){
        if(parseInt(Ext.getCmp('gridFormulario').selModel.getCount()) === 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            var totalRegistros = -1;
            stCIE10 = new StoreCIE10();
            objMX = "NA";
            objMXADD = "NA";
            objEXA = "NA";
            objEXAADD = "NA";
            objREM = "NA";
            objREMADD = "NA";
            wPaciente = selections[0].json.Paciente;
            wCAS = selections[0].json.CAS;
            wNomPac = selections[0].json.TipDoc + "-" + selections[0].json.Documento + " " + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido;
            if(selections[0].json.RutaFrmMx !== null && selections[0].json.RutaFrmMx !== ""){
                ScriptMgr.loadJs({
                    scripts : selections[0].json.RutaFrmMx,
                    callback : function(){
                        objMX = selections[0].json.NomObjetoMx;
                        ScriptMgr.loadJs({
                            scripts : selections[0].json.RutaFrmAddMx,
                            callback : function(){
                                objMXADD = selections[0].json.NomObjetoAddMx;
                            }
                        });
                    }
                });
            }
            if(selections[0].json.RutaFrmExa !== null && selections[0].json.RutaFrmExa !== ""){
                ScriptMgr.loadJs({
                    scripts : selections[0].json.RutaFrmExa,
                    callback : function(){
                        objEXA = selections[0].json.NomObjetoExa;
                        ScriptMgr.loadJs({
                            scripts : selections[0].json.RutaFrmAddExa,
                            callback : function(){
                                objEXAADD = selections[0].json.NomObjetoAddExa;
                            }
                        });
                    }
                });
            }
            if(selections[0].json.RutaFrmRem !== null && selections[0].json.RutaFrmRem !== ""){
                ScriptMgr.loadJs({
                    scripts : selections[0].json.RutaFrmRem,
                    callback : function(){
                        objREM = selections[0].json.NomObjetoRem;
                        ScriptMgr.loadJs({
                            scripts : selections[0].json.RutaFrmAddRem,
                            callback : function(){
                                objREMADD = selections[0].json.NomObjetoAddRem;
                            }
                        });
                    }
                });
            }
            if(selections[0].json.UsaTestBarthel !== null && selections[0].json.UsaTestBarthel !== "" && selections[0].json.UsaTestBarthel === "1"){
                ScriptMgr.loadJs({
                    scripts : '../../../app/frm_js/asistencial/ofimedical/wintestbarthel.ui.js'
                });
            }
            if(selections[0].json.UsaTestHachinski !== null && selections[0].json.UsaTestHachinski !== "" && selections[0].json.UsaTestHachinski === "1"){
                ScriptMgr.loadJs({
                    scripts : '../../../app/frm_js/asistencial/ofimedical/wintesthachinski.ui.js'
                });
            }
            if(selections[0].json.UsaTestFolstein !== null && selections[0].json.UsaTestFolstein !== "" && selections[0].json.UsaTestFolstein === "1"){
                ScriptMgr.loadJs({
                    scripts : '../../../app/frm_js/asistencial/ofimedical/wintestfolstein.ui.js'
                });
            }
            if(selections[0].json.UsaTestLawton !== null && selections[0].json.UsaTestLawton !== "" && selections[0].json.UsaTestLawton === "1"){
                ScriptMgr.loadJs({
                    scripts : '../../../app/frm_js/asistencial/ofimedical/wintestlawton.ui.js'
                });
            }
            if(selections[0].json.UsaTestYesavage !== null && selections[0].json.UsaTestYesavage !== "" && selections[0].json.UsaTestYesavage === "1"){
                ScriptMgr.loadJs({
                    scripts : '../../../app/frm_js/asistencial/ofimedical/wintestyesavage.ui.js'
                });
            }

            // ***** CARGAR LOS COMPONENTES ASOCIADOS A LA PLANTILLA
            var dsComponentesPlantilla = new Ext.data.Store({
                id: 'dsComponentesPlantilla',
                proxy: new Ext.data.HttpProxy({
                    url: '../../controlador/asistencial/controlador_plantillashc.php',
                    method: 'POST'
                }),
                baseParams: {
                    task: "LISTAR_COMPONENTES",
                    pPlantilla: selections[0].json.IdPlantilla
                },
                loadMask: {msg:"Cargando Registros, por favor espere..."},
                autoload: false,
                reader: new Ext.data.JsonReader({
                    root: 'results',
                    totalProperty: 'total',
                    id: 'id'
                  },[
                    {name: 'RutaComponente'},
                    {name: 'NomComponente'},
                    {name: 'Tipo'}
                 ])
            });

            dsComponentesPlantilla.load({
                callback: function(){
                    var totalRegistros = dsComponentesPlantilla.getTotalCount();
                    var i = 0;
                    if(totalRegistros !== 0 && totalRegistros !== -1){
                        dsComponentesPlantilla.each(function(record){
                            ScriptMgr.loadJs({
                                scripts : record.get('RutaComponente'),
                                callback: function(){
                                    i++;
                                    //alert("componente: " + record.get('NomComponente'));
                                    //cargarFormularioHC(i,totalRegistros, selections[0].json.RutaPlantilla,selections[0].json.NomObjeto,selections[0].json.NomPlantilla, selections[0].json.IdPlantilla, selections[0].json.RutaRptHC, selections[0].json.RutaRptMx, selections[0].json.RutaRptExa, selections[0].json.RutaRptRem);
                                    if(i === totalRegistros){
                                        //alert("Se cargo el frm");
                                        ScriptMgr.loadJs({
                                            scripts : selections[0].json.RutaPlantilla,
                                            waitMsg: 'Por favor Espere...',
                                            callback : function(){
                                                wPaciente = selections[0].json.Paciente;
                                                wCAS = selections[0].json.CAS;
                                                paramOpcion = "Modificar";
                                                var winHC = eval(selections[0].json.NomObjeto);//new winHCUi();
                                                Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.NomPlantilla));

                                                Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(selections[0].json.Actividad));
                                                Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                                                Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                                                Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                                                Ext.getCmp('sysProfesionalHC').setValue(selections[0].json.Profesional); 
                                                Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                                                Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                                                Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                                                Ext.getCmp('sysProfesionalAgendaHC').setValue(PonerAcentosMayusculas(selections[0].json.NomProfe));
                                                Ext.getCmp('sysFechaHC').setValue(selections[0].json.FechaAtencion);
                                                Ext.getCmp('sysHoraHC').setValue(selections[0].json.HoraApertura);
                                                Ext.getCmp('sysLegalizaHC').setValue(selections[0].json.HoraAtencion);
                                                Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(wNomPac));
                                                Ext.getCmp('sysAperturaHC').setValue(selections[0].json.HoraApertura);
                                                Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
                                                Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.idCliente);
                                                Ext.getCmp('sysIdContratoHC').setValue(selections[0].json.idContrato);
                                                Ext.getCmp('sysIdCodPlantillaHC').setValue(selections[0].json.IdPlantilla);

                                                try {
                                                    var campo2 = Ext.getCmp('sysRutaRptHC');
                                                    if ( campo2 !== null ) {
                                                        Ext.getCmp('sysRutaRptHC').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptHC));
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campo3 = Ext.getCmp('sysRutaRptMx');
                                                    if ( campo3 !== null ) {
                                                        Ext.getCmp('sysRutaRptMx').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptMx));
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campo4 = Ext.getCmp('sysRutaRptExa');
                                                    if ( campo4 !== null ) {
                                                        Ext.getCmp('sysRutaRptExa').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptExa));
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campo5 = Ext.getCmp('sysRutaRptRem');
                                                    if ( campo5 !== null ) {
                                                        Ext.getCmp('sysRutaRptRem').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptRem));
                                                    }
                                                }catch(ex) {
                                                }
                                                try { 
                                                    var campo6 = Ext.getCmp('sysInfoPacHCEdad');
                                                    if ( campo6 !== null ) {
                                                        Ext.getCmp('sysInfoPacHCEdad').setValue(selections[0].json.Edad);
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campo9 = Ext.getCmp('sysInfoPacHCDireccion');
                                                    if ( campo9 !== null ) {
                                                        Ext.getCmp('sysInfoPacHCDireccion').setValue(selections[0].json.Direccion);
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campo10 = Ext.getCmp('sysInfoPacHCTelefonos');
                                                    if ( campo10 !== null ) {
                                                        Ext.getCmp('sysInfoPacHCTelefonos').setValue(selections[0].json.Telefono + " - " + selections[0].json.Telefono1);
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    if(selections[0].json.Genero !== null){
                                                        var campo3_1 = Ext.getCmp('sysGeneroPacHC');
                                                        if(selections[0].json.Genero === "M"){
                                                            Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                                                        }else{
                                                            Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                                                        }
                                                    }
                                                }catch(ex) {
                                                }

                                                //OJO OMAR
                                                try {
                                                    if(selections[0].json.Genero !== null){
                                                        var campo3_2 = Ext.getCmp('sysGeneroPacHC');
                                                        if(selections[0].json.Genero === "M"){
                                                            Ext.getCmp('sysGeneroHC').setValue("MASCULINO");
                                                        }else{
                                                            Ext.getCmp('sysGeneroHC').setValue("FEMENINO");
                                                        }
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campo5_2 = Ext.getCmp('sysFechaNac');
                                                    if ( campo5_2 !== null ) {
                                                        Ext.getCmp('sysFechaNac').setValue(selections[0].json.FecNac);
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campo4_2 = Ext.getCmp('sysEdadPacHC');
                                                    if ( campo4_2 !== null ) {
                                                        Ext.getCmp('sysEdadHC').setValue(selections[0].json.Edad);
                                                    }
                                                }catch(ex) {
                                                }    
                                                //FIN OMAR


                                                try {
                                                    var campo4_1 = Ext.getCmp('sysEdadPacHC');
                                                    if ( campo4_1 !== null ) {
                                                        Ext.getCmp('sysEdadPacHC').setValue(selections[0].json.Edad);
                                                    }
                                                }catch(ex) {
                                                }    
                                                try {
                                                    var campo5_1 = Ext.getCmp('sysFecNacPacHC');
                                                    if ( campo5_1 !== null ) {
                                                        Ext.getCmp('sysFecNacPacHC').setValue(selections[0].json.FecNac);
                                                    }
                                                }catch(ex) {
                                                }
                                                winHC.show();
                                                //DESHABILITAR BOTONES DE GUARDAR
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarEvolucion'))){
                                                    Ext.getCmp('btnGuardarEvolucion').setVisible(false);
                                                }
                                                if(Ext.isDefined(Ext.getCmp('btnAddActividadDiente'))){Ext.getCmp('btnAddActividadDiente').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnDelActividadDiente'))){Ext.getCmp('btnDelActividadDiente').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnEditOdontograma'))){Ext.getCmp('btnEditOdontograma').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnCrearOdontograma'))){Ext.getCmp('btnCrearOdontograma').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarEvolucionEnf'))){Ext.getCmp('btnGuardarEvolucionEnf').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarEncuesta'))){Ext.getCmp('btnGuardarEncuesta').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoEquilibrio'))){Ext.getCmp('btnGuardarAnexoEquilibrio').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnImportarInformeTerapia'))){Ext.getCmp('btnImportarInformeTerapia').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnImportarInformeFono'))){Ext.getCmp('btnImportarInformeFono').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnImportarInformeTEO'))){Ext.getCmp('btnImportarInformeTEO').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnImportarConclusiones'))){Ext.getCmp('btnImportarConclusiones').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnAddProxCitaDiente'))){Ext.getCmp('btnAddProxCitaDiente').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnDelProxCitaDiente'))){Ext.getCmp('btnDelProxCitaDiente').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarTriage'))){Ext.getCmp('btnGuardarTriage').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarTriage1'))){Ext.getCmp('btnGuardarTriage1').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarBarthel'))){Ext.getCmp('btnGuardarBarthel').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarFolstein'))){Ext.getCmp('btnGuardarFolstein').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarHachinski'))){Ext.getCmp('btnGuardarHachinski').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarLawton'))){Ext.getCmp('btnGuardarLawton').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarYesavage'))){Ext.getCmp('btnGuardarYesavage').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarTomaSignos'))){Ext.getCmp('btnGuardarTomaSignos').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoAlineacionPostural'))){Ext.getCmp('btnGuardarAnexoAlineacionPostural').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoAMA'))){Ext.getCmp('btnGuardarAnexoAMA').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoEscalaAschworth'))){Ext.getCmp('btnGuardarAnexoEscalaAschworth').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoEscalaFuerzaMuscular'))){Ext.getCmp('btnGuardarAnexoEscalaFuerzaMuscular').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoEscalaPerscepcionEsfuerzo'))){Ext.getCmp('btnGuardarAnexoEscalaPerscepcionEsfuerzo').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoEvaluacionCraneoMandibular'))){Ext.getCmp('btnGuardarAnexoEvaluacionCraneoMandibular').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoEvaluacionFuncionMusculosFaciales'))){Ext.getCmp('btnGuardarAnexoEvaluacionFuncionMusculosFaciales').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoExamenMuscularMMII'))){Ext.getCmp('btnGuardarAnexoExamenMuscularMMII').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoExamenMuscularMMSS'))){Ext.getCmp('btnGuardarAnexoExamenMuscularMMSS').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoReflejosNeuroDesarrollo'))){Ext.getCmp('btnGuardarAnexoReflejosNeuroDesarrollo').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnAddSolExamenes'))){Ext.getCmp('btnAddSolExamenes').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnDelSolExamenes'))){Ext.getCmp('btnDelSolExamenes').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnAddExaEvolucion'))){Ext.getCmp('btnAddExaEvolucion').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnDelExaEvolucion'))){Ext.getCmp('btnDelExaEvolucion').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnImportarUltimaFormula'))){Ext.getCmp('btnImportarUltimaFormula').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnVerHistorialFarmacologico'))){Ext.getCmp('btnVerHistorialFarmacologico').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnAddMxEvolucion'))){Ext.getCmp('btnAddMxEvolucion').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnDelMxEvolucion'))){Ext.getCmp('btnDelMxEvolucion').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnAddMxNOPOSItem'))){Ext.getCmp('btnAddMxNOPOSItem').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnDuplicarMxNOPOSItem'))){Ext.getCmp('btnDuplicarMxNOPOSItem').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnEditMxNOPOSItem'))){Ext.getCmp('btnEditMxNOPOSItem').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnDelMxNOPOSItem'))){Ext.getCmp('btnDelMxNOPOSItem').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnAddRemEvolucion'))){Ext.getCmp('btnAddRemEvolucion').setVisible(false);}
                                                if(Ext.isDefined(Ext.getCmp('btnDelRemEvolucion'))){Ext.getCmp('btnDelRemEvolucion').setVisible(false);}

                                                CargarDataHC(selections[0].json.Evolucion);
                                                CargarDataHC(selections[0].json.Barthel);
                                                CargarDataHC(selections[0].json.Hachinski);
                                                CargarDataHC(selections[0].json.Lawton);
                                                CargarDataHC(selections[0].json.Folstein);
                                                CargarDataHC(selections[0].json.Yesavage);
                                                CargarDataHC(selections[0].json.MNA);
                                                Ext.getCmp('sysYaGuardoHC').setValue(1);
                                                try {
                                                    var campoDiagppal = Ext.getCmp('sysDiagPpalHC');
                                                    if ( campoDiagppal !== null ) {
                                                        Ext.getCmp('sysDiagPpalHC').setValue(selections[0].json.Diagppal);
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: selections[0].json.Diagppal.toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    // Nada
                                                                } else {
                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                //nada
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campoDiagrel1 = Ext.getCmp('sysDiagRel1HC');
                                                    if ( campoDiagrel1 !== null ) {
                                                        Ext.getCmp('sysDiagRel1HC').setValue(selections[0].json.Diagrel1);
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: selections[0].json.Diagrel1.toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    // Nada
                                                                } else {
                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                //nada
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campoDiagrel2 = Ext.getCmp('sysDiagRel2HC');
                                                    if ( campoDiagrel2 !== null ) {
                                                        Ext.getCmp('sysDiagRel2HC').setValue(selections[0].json.DiagRel2);
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: selections[0].json.DiagRel2.toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    // Nada
                                                                } else {
                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                //nada
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campoDiagrel3 = Ext.getCmp('sysDiagRel3HC');
                                                    if ( campoDiagrel3 !== null ) {
                                                        Ext.getCmp('sysDiagRel3HC').setValue(selections[0].json.DiagRel3);
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: selections[0].json.DiagRel3.toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    // Nada
                                                                } else {
                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                //nada
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campoTipodiag = Ext.getCmp('sysTipoDiagosticoHC');
                                                    if ( campoTipodiag !== null ) {
                                                        Ext.getCmp('sysTipoDiagosticoHC').setValue(selections[0].json.Tipodiag);
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campoFinalidad = Ext.getCmp('sysFinalidadConsultaHC');
                                                    if ( campoFinalidad !== null ) {
                                                        Ext.getCmp('sysFinalidadConsultaHC').setValue(selections[0].json.Finalidad);
                                                    }
                                                }catch(ex) {
                                                }
                                                try {
                                                    var campoCausaExterna = Ext.getCmp('sysCausaExternaHC');
                                                    if ( campoCausaExterna !== null ) {
                                                        Ext.getCmp('sysCausaExternaHC').setValue(selections[0].json.CausaExterna);
                                                    }
                                                }catch(ex) {
                                                }
                                                //Aqui deberia ir el mostrar el contenido de la hc
                                            }
                                        });
                                    }
                                }
                            });
                        });
                    }else{
                        ScriptMgr.loadJs({
                            scripts : selections[0].json.RutaPlantilla,
                            waitMsg: 'Por favor Espere...',
                            callback : function(){
                                 wPaciente = selections[0].json.Paciente;
                                wCAS = selections[0].json.CAS;
                                paramOpcion = "Modificar";
                                var winHC = eval(selections[0].json.NomObjeto);//new winHCUi();
                                Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.NomPlantilla));

                                Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(selections[0].json.Actividad));
                                Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                                Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                                Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                                Ext.getCmp('sysProfesionalHC').setValue(selections[0].json.Profesional); 
                                Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                                Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                                Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                                Ext.getCmp('sysProfesionalAgendaHC').setValue(PonerAcentosMayusculas(selections[0].json.NomProfe));
                                Ext.getCmp('sysFechaHC').setValue(selections[0].json.FechaAtencion);
                                Ext.getCmp('sysHoraHC').setValue(selections[0].json.HoraApertura);
                                Ext.getCmp('sysLegalizaHC').setValue(selections[0].json.HoraAtencion);
                                Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(wNomPac));
                                Ext.getCmp('sysAperturaHC').setValue(selections[0].json.HoraApertura);
                                Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
                                Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.idCliente);
                                Ext.getCmp('sysIdContratoHC').setValue(selections[0].json.idContrato);
                                Ext.getCmp('sysIdCodPlantillaHC').setValue(selections[0].json.IdPlantilla);
                                try {
                                    var campo2 = Ext.getCmp('sysRutaRptHC');
                                    if ( campo2 !== null ) {
                                        Ext.getCmp('sysRutaRptHC').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptHC));
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campo3 = Ext.getCmp('sysRutaRptMx');
                                    if ( campo3 !== null ) {
                                        Ext.getCmp('sysRutaRptMx').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptMx));
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campo4 = Ext.getCmp('sysRutaRptExa');
                                    if ( campo4 !== null ) {
                                        Ext.getCmp('sysRutaRptExa').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptExa));
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campo5 = Ext.getCmp('sysRutaRptRem');
                                    if ( campo5 !== null ) {
                                        Ext.getCmp('sysRutaRptRem').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptRem));
                                    }
                                }catch(ex) {
                                }
                                try { 
                                    var campo6 = Ext.getCmp('sysInfoPacHCEdad');
                                    if ( campo6 !== null ) {
                                        Ext.getCmp('sysInfoPacHCEdad').setValue(selections[0].json.Edad);
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campo9 = Ext.getCmp('sysInfoPacHCDireccion');
                                    if ( campo9 !== null ) {
                                        Ext.getCmp('sysInfoPacHCDireccion').setValue(selections[0].json.Direccion);
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campo10 = Ext.getCmp('sysInfoPacHCTelefonos');
                                    if ( campo10 !== null ) {
                                        Ext.getCmp('sysInfoPacHCTelefonos').setValue(selections[0].json.Telefono + " - " + selections[0].json.Telefono1);
                                    }
                                }catch(ex) {
                                }
                                try {
                                    if(selections[0].json.Genero !== null){
                                        var campo3_1 = Ext.getCmp('sysGeneroPacHC');
                                        if(selections[0].json.Genero === "M"){
                                            Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                                        }else{
                                            Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                                        }
                                    }
                                }catch(ex) {
                                }

                                //OJO OMAR
                                try {
                                    if(selections[0].json.Genero !== null){
                                        var campo3_2 = Ext.getCmp('sysGeneroPacHC');
                                        if(selections[0].json.Genero === "M"){
                                            Ext.getCmp('sysGeneroHC').setValue("MASCULINO");
                                        }else{
                                            Ext.getCmp('sysGeneroHC').setValue("FEMENINO");
                                        }
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campo5_2 = Ext.getCmp('sysFechaNac');
                                    if ( campo5_2 !== null ) {
                                        Ext.getCmp('sysFechaNac').setValue(selections[0].json.FecNac);
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campo4_2 = Ext.getCmp('sysEdadPacHC');
                                    if ( campo4_2 !== null ) {
                                        Ext.getCmp('sysEdadHC').setValue(selections[0].json.Edad);
                                    }
                                }catch(ex) {
                                }    
                                //FIN OMAR
                                try {
                                    var campo4_1 = Ext.getCmp('sysEdadPacHC');
                                    if ( campo4_1 !== null ) {
                                        Ext.getCmp('sysEdadPacHC').setValue(selections[0].json.Edad);
                                    }
                                }catch(ex) {
                                }    
                                try {
                                    var campo5_1 = Ext.getCmp('sysFecNacPacHC');
                                    if ( campo5_1 !== null ) {
                                        Ext.getCmp('sysFecNacPacHC').setValue(selections[0].json.FecNac);
                                    }
                                }catch(ex) {
                                }
                                winHC.show();
                                //DESHABILITAR BOTONES DE GUARDAR
                                if(Ext.isDefined(Ext.getCmp('btnGuardarEvolucion'))){
                                    Ext.getCmp('btnGuardarEvolucion').setVisible(false);
                                }
                                if(Ext.isDefined(Ext.getCmp('btnAddActividadDiente'))){Ext.getCmp('btnAddActividadDiente').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnDelActividadDiente'))){Ext.getCmp('btnDelActividadDiente').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnEditOdontograma'))){Ext.getCmp('btnEditOdontograma').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnCrearOdontograma'))){Ext.getCmp('btnCrearOdontograma').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarEvolucionEnf'))){Ext.getCmp('btnGuardarEvolucionEnf').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarEncuesta'))){Ext.getCmp('btnGuardarEncuesta').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoEquilibrio'))){Ext.getCmp('btnGuardarAnexoEquilibrio').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnImportarInformeTerapia'))){Ext.getCmp('btnImportarInformeTerapia').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnImportarInformeFono'))){Ext.getCmp('btnImportarInformeFono').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnImportarInformeTEO'))){Ext.getCmp('btnImportarInformeTEO').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnImportarConclusiones'))){Ext.getCmp('btnImportarConclusiones').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnAddProxCitaDiente'))){Ext.getCmp('btnAddProxCitaDiente').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnDelProxCitaDiente'))){Ext.getCmp('btnDelProxCitaDiente').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarTriage'))){Ext.getCmp('btnGuardarTriage').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarTriage1'))){Ext.getCmp('btnGuardarTriage1').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarBarthel'))){Ext.getCmp('btnGuardarBarthel').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarFolstein'))){Ext.getCmp('btnGuardarFolstein').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarHachinski'))){Ext.getCmp('btnGuardarHachinski').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarLawton'))){Ext.getCmp('btnGuardarLawton').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarYesavage'))){Ext.getCmp('btnGuardarYesavage').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarTomaSignos'))){Ext.getCmp('btnGuardarTomaSignos').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoAlineacionPostural'))){Ext.getCmp('btnGuardarAnexoAlineacionPostural').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoAMA'))){Ext.getCmp('btnGuardarAnexoAMA').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoEscalaAschworth'))){Ext.getCmp('btnGuardarAnexoEscalaAschworth').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoEscalaFuerzaMuscular'))){Ext.getCmp('btnGuardarAnexoEscalaFuerzaMuscular').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoEscalaPerscepcionEsfuerzo'))){Ext.getCmp('btnGuardarAnexoEscalaPerscepcionEsfuerzo').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoEvaluacionCraneoMandibular'))){Ext.getCmp('btnGuardarAnexoEvaluacionCraneoMandibular').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoEvaluacionFuncionMusculosFaciales'))){Ext.getCmp('btnGuardarAnexoEvaluacionFuncionMusculosFaciales').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoExamenMuscularMMII'))){Ext.getCmp('btnGuardarAnexoExamenMuscularMMII').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoExamenMuscularMMSS'))){Ext.getCmp('btnGuardarAnexoExamenMuscularMMSS').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnGuardarAnexoReflejosNeuroDesarrollo'))){Ext.getCmp('btnGuardarAnexoReflejosNeuroDesarrollo').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnAddSolExamenes'))){Ext.getCmp('btnAddSolExamenes').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnDelSolExamenes'))){Ext.getCmp('btnDelSolExamenes').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnAddExaEvolucion'))){Ext.getCmp('btnAddExaEvolucion').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnDelExaEvolucion'))){Ext.getCmp('btnDelExaEvolucion').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnImportarUltimaFormula'))){Ext.getCmp('btnImportarUltimaFormula').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnVerHistorialFarmacologico'))){Ext.getCmp('btnVerHistorialFarmacologico').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnAddMxEvolucion'))){Ext.getCmp('btnAddMxEvolucion').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnDelMxEvolucion'))){Ext.getCmp('btnDelMxEvolucion').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnAddMxNOPOSItem'))){Ext.getCmp('btnAddMxNOPOSItem').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnDuplicarMxNOPOSItem'))){Ext.getCmp('btnDuplicarMxNOPOSItem').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnEditMxNOPOSItem'))){Ext.getCmp('btnEditMxNOPOSItem').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnDelMxNOPOSItem'))){Ext.getCmp('btnDelMxNOPOSItem').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnAddRemEvolucion'))){Ext.getCmp('btnAddRemEvolucion').setVisible(false);}
                                if(Ext.isDefined(Ext.getCmp('btnDelRemEvolucion'))){Ext.getCmp('btnDelRemEvolucion').setVisible(false);}

                                //Aqui deberia ir el mostrar el contenido de la hc
                                CargarDataHC(selections[0].json.Evolucion);
                                CargarDataHC(selections[0].json.Barthel);
                                CargarDataHC(selections[0].json.Hachinski);
                                CargarDataHC(selections[0].json.Lawton);
                                CargarDataHC(selections[0].json.Folstein);
                                CargarDataHC(selections[0].json.Yesavage);
                                CargarDataHC(selections[0].json.MNA);
                                Ext.getCmp('sysYaGuardoHC').setValue(1);
                                try {
                                    var campoDiagppal = Ext.getCmp('sysDiagPpalHC');
                                    if ( campoDiagppal !== null ) {
                                        Ext.getCmp('sysDiagPpalHC').setValue(selections[0].json.Diagppal);
                                        Ext.Ajax.request({
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: selections[0].json.Diagppal.toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                    // Nada
                                                } else {
                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                }
                                            },
                                            failure: function(response,options){
                                                //nada
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campoDiagrel1 = Ext.getCmp('sysDiagRel1HC');
                                    if ( campoDiagrel1 !== null ) {
                                        Ext.getCmp('sysDiagRel1HC').setValue(selections[0].json.Diagrel1);
                                        Ext.Ajax.request({
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: selections[0].json.Diagrel1.toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                    // Nada
                                                } else {
                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                }
                                            },
                                            failure: function(response,options){
                                                //nada
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campoDiagrel2 = Ext.getCmp('sysDiagRel2HC');
                                    if ( campoDiagrel2 !== null ) {
                                        Ext.getCmp('sysDiagRel2HC').setValue(selections[0].json.DiagRel2);
                                        Ext.Ajax.request({
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: selections[0].json.DiagRel2.toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                    // Nada
                                                } else {
                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                }
                                            },
                                            failure: function(response,options){
                                                //nada
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campoDiagrel3 = Ext.getCmp('sysDiagRel3HC');
                                    if ( campoDiagrel3 !== null ) {
                                        Ext.getCmp('sysDiagRel3HC').setValue(selections[0].json.DiagRel3);
                                        Ext.Ajax.request({
                                            url: '../../controlador/cie10/controlador_cie10.php',
                                            params:{
                                                task: 'BUSCAR',
                                                pCodigo: selections[0].json.DiagRel3.toUpperCase()
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                    // Nada
                                                } else {
                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                }
                                            },
                                            failure: function(response,options){
                                                //nada
                                            },
                                            scope:this //bind the callbacks
                                        });
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campoTipodiag = Ext.getCmp('sysTipoDiagosticoHC');
                                    if ( campoTipodiag !== null ) {
                                        Ext.getCmp('sysTipoDiagosticoHC').setValue(selections[0].json.Tipodiag);
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campoFinalidad = Ext.getCmp('sysFinalidadConsultaHC');
                                    if ( campoFinalidad !== null ) {
                                        Ext.getCmp('sysFinalidadConsultaHC').setValue(selections[0].json.Finalidad);
                                    }
                                }catch(ex) {
                                }
                                try {
                                    var campoCausaExterna = Ext.getCmp('sysCausaExternaHC');
                                    if ( campoCausaExterna !== null ) {
                                        Ext.getCmp('sysCausaExternaHC').setValue(selections[0].json.CausaExterna);
                                    }
                                }catch(ex) {
                                }
                            }
                        });
                    }
                }
            });
        }
    },
    AplicarFiltro: function(){
        var fecdsd;
        var fechst;
        
        if(Ext.getCmp('fecDesdeSearchHC').getValue()==null || Ext.getCmp('fecDesdeSearchHC').getValue()=="")
            fecdsd = null;
        else
            fecdsd = Ext.getCmp('fecDesdeSearchHC').getValue().format('Y-m-d');
        
        if(Ext.getCmp('fecHastaSearchHC').getValue()==null || Ext.getCmp('fecHastaSearchHC').getValue()=="")
            fechst = null;
        else
            fechst = Ext.getCmp('fecHastaSearchHC').getValue().format('Y-m-d');
        
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pEmpresa: ID_EMPRESA,
                pPaciente: Ext.getCmp('sysPacienteSearchHC').getValue(),
                pProfesional: Ext.getCmp('intProfesionalSearchHC').getValue(),
                pDesde: fecdsd,
                pHasta: fechst
            }
        });
        Ext.getCmp('gridSinEvolucionar').store.load({
            params: {
                pEmpresa: ID_EMPRESA,
                pIPS: ID_IPS,
                pPaciente: Ext.getCmp('sysPacienteSearchHC').getValue(),
                pProfesional: Ext.getCmp('intProfesionalSearchHC').getValue()
            }
        });
        Ext.getCmp('DetalleResumenHC').load({
            url: '../../controlador/asistencial/viewhcxformato.php?pEmpresa=0&pIPS=0&pPaciente=0&pEvolucion=0',
            scripts:true,
            scope:this,
            nocache: false,
            text: 'Cargando...'
        });
    },
    BuscarPacienteMalo: function(){
        buscarpaciente("ConsultarHCxPaciente");
    },
    UpdateDetalleResumenHC: function(sm, rowIdx, r) {
        Ext.getCmp('DetalleResumenHC').load({
            url: '../../controlador/asistencial/viewhcxformato.php?pEmpresa=' + ID_EMPRESA + '&pIPS=' + ID_IPS + '&pPaciente=' + r.data.Paciente + '&pEvolucion=' + r.data.ConsecutivoHC,
            scripts:true,
            scope:this,
            nocache: false,
            text: 'Cargando...'
        });
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
    
});

