/*
* @category    Programacion Eventos Formulario Resumen HC Terapia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmResumenHCTerapiaMensualxPaciente = Ext.extend(winFrmResumenHCTerapiaMensualxPacienteUi, {
    initComponent: function() {
        winFrmResumenHCTerapiaMensualxPaciente.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnBuscarPacienteUnificaMalo = Ext.getCmp('btnBuscarPacienteUnificaMalo').on("click",this.BuscarPacienteMalo,this);
        var btnCrearInformeMensualResumenNeurodesarrollo = Ext.getCmp('btnCrearInformeMensualResumenNeurodesarrollo').on("click",this.CrearInformeNeurodesa,this);
        var btnEvolTFisicaResumenNeurodesarrollo = Ext.getCmp('btnEvolTFisicaResumenNeurodesarrollo').on("click",this.EvolucionarTerapiaFisica,this);
        var btnEvolFonoaudiologiaResumenNeurodesarrollo = Ext.getCmp('btnEvolFonoaudiologiaResumenNeurodesarrollo').on("click",this.EvolucionarFonoaudiologia,this);
        var btnEvolTOcupacionalResumenNeurodesarrollo = Ext.getCmp('btnEvolTOcupacionalResumenNeurodesarrollo').on("click",this.EvolucionarTerapiaOcupacional,this);
        var btnEvolConclusuinesResumenNeurodesarrollo = Ext.getCmp('btnEvolConclusuinesResumenNeurodesarrollo').on("click",this.EvolucionarConclusiones,this);
        var btnImprimirInformeMensualResumenNeurodesarrollo = Ext.getCmp('btnImprimirInformeMensualResumenNeurodesarrollo').on("click",this.ImprimirInforme,this);
        var sm_gridservicios = Ext.getCmp('gridHistorialEvoluciones').getSelectionModel();
        sm_gridservicios.on("rowselect",this.UpdateDetalleResumenHC,this);
    },
    ImprimirInforme: function(){
        if(Ext.getCmp('gridHistorialEvoluciones').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridHistorialEvoluciones').selModel.getSelections();
            if (selections[0].json.ConsecutivoHC != 0 && selections[0].json.ConsecutivoHC != null)
            {
                var param = "../../controlador/asistencial/infsoporteinformemensualneurodesa.php?pConsecutivoHC=" + selections[0].json.ConsecutivoHC + "&";
                param += "pEmpresa=" + ID_EMPRESA  + "&";
                param += "pIPS=" + ID_IPS
                location.href = param;
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Debe Seleccionar Solo un Periodo.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe Seleccionar Solo un Periodo.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
            
    },
    EvolucionarTerapiaFisica: function(){
        if(Ext.getCmp('gridHistorialEvoluciones').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridHistorialEvoluciones').selModel.getSelections();
            if (selections[0].json.ConsecutivoHC != 0 && selections[0].json.ConsecutivoHC != null)
            {
                var winResumen = new winHCFISIOCENTER003Ui();
                Ext.getCmp('sysYaGuardoHC').setValue(0);
                Ext.getCmp('sysEmpresaHC').setValue(selections[0].json.Prestador);
                Ext.getCmp('sysIPSHC').setValue(selections[0].json.IPS);
                Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                Ext.getCmp('intConsecutivoHC').setValue(selections[0].json.ConsecutivoHC);
                Ext.getCmp('sysProcesoHC').setValue("Fisioterapia");
                Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(selections[0].json.TipDoc + ' ' + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido + ' Genero: (' + selections[0].json.Genero + ') FechaNac: (' + selections[0].json.FecNac + ')'));
                Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                Ext.getCmp('sysPeriodoHC').setValue(selections[0].json.Periodo);
                Ext.getCmp('memEvolucionTerapiaFisica').setValue(PonerAcentosMayusculas(selections[0].json.EvaluacionTerapiaFisica));
                Ext.getCmp('intProfesionalTerapiaFisica').setValue(selections[0].json.ProfesionalTerapiaFisica);
                Ext.getCmp('memEvolucionFonoaudiologia').setValue(PonerAcentosMayusculas(selections[0].json.EvaluacionFonoaudiologia));
                Ext.getCmp('intProfesionalFonoaudiologia').setValue(selections[0].json.ProfesionalFonoaudiologia);
                Ext.getCmp('memEvolucionTerapiaOcupacional').setValue(PonerAcentosMayusculas(selections[0].json.EvaluacionTerapiaOcupacional));
                Ext.getCmp('intProfesionalTerapiaOcupacional').setValue(selections[0].json.ProfesionalTerapiaOcupacional);
                Ext.getCmp('memConclusiones').setValue(PonerAcentosMayusculas(selections[0].json.Conlusiones));
                Ext.getCmp('intProfesionalConclusiones').setValue(selections[0].json.ProfesionalConclusiones);
                
                Ext.getCmp('memEvolucionTerapiaFisica').allowBlank = false;
                Ext.getCmp('intProfesionalTerapiaFisica').allowBlank = false;
                Ext.getCmp('memEvolucionFonoaudiologia').setReadOnly(true);
                Ext.getCmp('intProfesionalFonoaudiologia').setReadOnly(true);
                Ext.getCmp('memEvolucionTerapiaOcupacional').setReadOnly(true);
                Ext.getCmp('intProfesionalTerapiaOcupacional').setReadOnly(true);
                Ext.getCmp('memConclusiones').setReadOnly(true);
                Ext.getCmp('intProfesionalConclusiones').setReadOnly(true);
                
                winResumen.show();
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Debe Seleccionar Solo un Periodo.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe Seleccionar Solo un Periodo.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    EvolucionarFonoaudiologia: function(){
        if(Ext.getCmp('gridHistorialEvoluciones').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridHistorialEvoluciones').selModel.getSelections();
            if (selections[0].json.ConsecutivoHC != 0 && selections[0].json.ConsecutivoHC != null)
            {
                var winResumen = new winHCFISIOCENTER003Ui();
                Ext.getCmp('sysYaGuardoHC').setValue(0);
                Ext.getCmp('sysEmpresaHC').setValue(selections[0].json.Prestador);
                Ext.getCmp('sysIPSHC').setValue(selections[0].json.IPS);
                Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                Ext.getCmp('intConsecutivoHC').setValue(selections[0].json.ConsecutivoHC);
                Ext.getCmp('sysProcesoHC').setValue("Fonoaudiologia");
                Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(selections[0].json.TipDoc + ' ' + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido + ' Genero: (' + selections[0].json.Genero + ') FechaNac: (' + selections[0].json.FecNac + ')'));
                Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                Ext.getCmp('sysPeriodoHC').setValue(selections[0].json.Periodo);
                Ext.getCmp('memEvolucionTerapiaFisica').setValue(PonerAcentosMayusculas(selections[0].json.EvaluacionTerapiaFisica));
                Ext.getCmp('intProfesionalTerapiaFisica').setValue(selections[0].json.ProfesionalTerapiaFisica);
                Ext.getCmp('memEvolucionFonoaudiologia').setValue(PonerAcentosMayusculas(selections[0].json.EvaluacionFonoaudiologia));
                Ext.getCmp('intProfesionalFonoaudiologia').setValue(selections[0].json.ProfesionalFonoaudiologia);
                Ext.getCmp('memEvolucionTerapiaOcupacional').setValue(PonerAcentosMayusculas(selections[0].json.EvaluacionTerapiaOcupacional));
                Ext.getCmp('intProfesionalTerapiaOcupacional').setValue(selections[0].json.ProfesionalTerapiaOcupacional);
                Ext.getCmp('memConclusiones').setValue(PonerAcentosMayusculas(selections[0].json.Conlusiones));
                Ext.getCmp('intProfesionalConclusiones').setValue(selections[0].json.ProfesionalConclusiones);
                
                Ext.getCmp('memEvolucionFonoaudiologia').allowBlank = false;
                Ext.getCmp('intProfesionalFonoaudiologia').allowBlank = false;
                Ext.getCmp('memEvolucionTerapiaFisica').setReadOnly(true);
                Ext.getCmp('intProfesionalTerapiaFisica').setReadOnly(true);
                Ext.getCmp('memEvolucionTerapiaOcupacional').setReadOnly(true);
                Ext.getCmp('intProfesionalTerapiaOcupacional').setReadOnly(true);
                Ext.getCmp('memConclusiones').setReadOnly(true);
                Ext.getCmp('intProfesionalConclusiones').setReadOnly(true);
                
                winResumen.show();
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Debe Seleccionar Solo un Periodo.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe Seleccionar Solo un Periodo.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    EvolucionarTerapiaOcupacional: function(){
        if(Ext.getCmp('gridHistorialEvoluciones').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridHistorialEvoluciones').selModel.getSelections();
            if (selections[0].json.ConsecutivoHC != 0 && selections[0].json.ConsecutivoHC != null)
            {
                var winResumen = new winHCFISIOCENTER003Ui();
                Ext.getCmp('sysYaGuardoHC').setValue(0);
                Ext.getCmp('sysEmpresaHC').setValue(selections[0].json.Prestador);
                Ext.getCmp('sysIPSHC').setValue(selections[0].json.IPS);
                Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                Ext.getCmp('intConsecutivoHC').setValue(selections[0].json.ConsecutivoHC);
                Ext.getCmp('sysProcesoHC').setValue("Ocupacional");
                Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(selections[0].json.TipDoc + ' ' + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido + ' Genero: (' + selections[0].json.Genero + ') FechaNac: (' + selections[0].json.FecNac + ')'));
                Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                Ext.getCmp('sysPeriodoHC').setValue(selections[0].json.Periodo);
                Ext.getCmp('memEvolucionTerapiaFisica').setValue(PonerAcentosMayusculas(selections[0].json.EvaluacionTerapiaFisica));
                Ext.getCmp('intProfesionalTerapiaFisica').setValue(selections[0].json.ProfesionalTerapiaFisica);
                Ext.getCmp('memEvolucionFonoaudiologia').setValue(PonerAcentosMayusculas(selections[0].json.EvaluacionFonoaudiologia));
                Ext.getCmp('intProfesionalFonoaudiologia').setValue(selections[0].json.ProfesionalFonoaudiologia);
                Ext.getCmp('memEvolucionTerapiaOcupacional').setValue(PonerAcentosMayusculas(selections[0].json.EvaluacionTerapiaOcupacional));
                Ext.getCmp('intProfesionalTerapiaOcupacional').setValue(selections[0].json.ProfesionalTerapiaOcupacional);
                Ext.getCmp('memConclusiones').setValue(PonerAcentosMayusculas(selections[0].json.Conlusiones));
                Ext.getCmp('intProfesionalConclusiones').setValue(selections[0].json.ProfesionalConclusiones);
                
                Ext.getCmp('memEvolucionTerapiaOcupacional').allowBlank = false;
                Ext.getCmp('intProfesionalTerapiaOcupacional').allowBlank = false;
                Ext.getCmp('memEvolucionTerapiaFisica').setReadOnly(true);
                Ext.getCmp('intProfesionalTerapiaFisica').setReadOnly(true);
                Ext.getCmp('memEvolucionFonoaudiologia').setReadOnly(true);
                Ext.getCmp('intProfesionalFonoaudiologia').setReadOnly(true);
                Ext.getCmp('memConclusiones').setReadOnly(true);
                Ext.getCmp('intProfesionalConclusiones').setReadOnly(true);
                
                winResumen.show();
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Debe Seleccionar Solo un Periodo.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe Seleccionar Solo un Periodo.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    EvolucionarConclusiones: function(){
        if(Ext.getCmp('gridHistorialEvoluciones').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridHistorialEvoluciones').selModel.getSelections();
            if (selections[0].json.ConsecutivoHC != 0 && selections[0].json.ConsecutivoHC != null)
            {
                var winResumen = new winHCFISIOCENTER003Ui();
                Ext.getCmp('sysYaGuardoHC').setValue(0);
                Ext.getCmp('sysEmpresaHC').setValue(selections[0].json.Prestador);
                Ext.getCmp('sysIPSHC').setValue(selections[0].json.IPS);
                Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                Ext.getCmp('intConsecutivoHC').setValue(selections[0].json.ConsecutivoHC);
                Ext.getCmp('sysProcesoHC').setValue("Conclusiones");
                Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(selections[0].json.TipDoc + ' ' + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido + ' Genero: (' + selections[0].json.Genero + ') FechaNac: (' + selections[0].json.FecNac + ')'));
                Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                Ext.getCmp('sysPeriodoHC').setValue(selections[0].json.Periodo);
                Ext.getCmp('memEvolucionTerapiaFisica').setValue(PonerAcentosMayusculas(selections[0].json.EvaluacionTerapiaFisica));
                Ext.getCmp('intProfesionalTerapiaFisica').setValue(selections[0].json.ProfesionalTerapiaFisica);
                Ext.getCmp('memEvolucionFonoaudiologia').setValue(PonerAcentosMayusculas(selections[0].json.EvaluacionFonoaudiologia));
                Ext.getCmp('intProfesionalFonoaudiologia').setValue(selections[0].json.ProfesionalFonoaudiologia);
                Ext.getCmp('memEvolucionTerapiaOcupacional').setValue(PonerAcentosMayusculas(selections[0].json.EvaluacionTerapiaOcupacional));
                Ext.getCmp('intProfesionalTerapiaOcupacional').setValue(selections[0].json.ProfesionalTerapiaOcupacional);
                Ext.getCmp('memConclusiones').setValue(PonerAcentosMayusculas(selections[0].json.Conlusiones));
                Ext.getCmp('intProfesionalConclusiones').setValue(selections[0].json.ProfesionalConclusiones);
                
                Ext.getCmp('memEvolucionTerapiaOcupacional').allowBlank = false;
                Ext.getCmp('intProfesionalTerapiaOcupacional').allowBlank = false;
                Ext.getCmp('memEvolucionTerapiaFisica').allowBlank = false;
                Ext.getCmp('intProfesionalTerapiaFisica').allowBlank = false;
                Ext.getCmp('memEvolucionFonoaudiologia').allowBlank = false;
                Ext.getCmp('intProfesionalFonoaudiologia').allowBlank = false;
                Ext.getCmp('memConclusiones').allowBlank = false;
                Ext.getCmp('intProfesionalConclusiones').allowBlank = false;
                
                winResumen.show();
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Debe Seleccionar Solo un Periodo.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe Seleccionar Solo un Periodo.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    CrearInformeNeurodesa: function(){
        var frm = Ext.getCmp('frmResumenNeurodesaxPaciente').getForm();
        if (frm.isValid())
        {
            var listacampos = ExtraerCamposFrmHC(frm);
            frm.submit({
                url: '../../controlador/asistencial/evolucionhc.php',
                params:{
                    task: 'crear_resumen_neurodesarrollo',
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: Ext.getCmp('sysPacienteResumenNeurodesa').getValue(),
                    pCliente: Ext.getCmp('intClienteResumenNeurodesa').getValue(),
                    pAno: Ext.getCmp('intAnoResumenNeurodesa').getValue(),
                    pMes: Ext.getCmp('strMesResumenNeurodesa').getValue()
                },
                success: function(res,req)
                {
                    switch(req.result.requestedId){
                        case "1":
                            Ext.MessageBox.show({
                                title: 'Guardar',
                                msg: 'Se Guardo la Información con Exito.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.INFO
                            });
                            Ext.getCmp('gridHistorialEvoluciones').store.load({
                                params: {
                                    pEmpresa: ID_EMPRESA,
                                    pIPS: ID_IPS,
                                    pPaciente: Ext.getCmp('sysPacienteResumenNeurodesa').getValue()
                                }
                            });
                            break;

                        default:
                            Ext.MessageBox.show({
                                title: 'Guardar',
                                msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                            break;
                    }
                },
                failure: function(response,options)
                {
                    Ext.MessageBox.show({
                        title: 'Guardar',
                        msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Guardar',
                msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
        
    },
    BuscarPacienteMalo: function(){
        buscarpaciente("ResumenNeurodesa");
    },
    UpdateDetalleResumenHC: function(sm, rowIdx, r) {
        
        var mostrarHC = '<table border="0" width="760" style="font-size:14px; color:#000;">';
        mostrarHC += '<tr>';
        mostrarHC += '<td colspan="2" align="center" style="text-decoration:underline; font-weight:bolder">INFORME MENSUAL DE TERAPIA DE NEURODESARROLLO</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td colspan="2" align="center">&nbsp;&nbsp;</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td width="150">Paciente:</td>';
        mostrarHC += '<td>' + r.data.TipDoc + ' ' + r.data.Documento + ' - ' + r.data.PrimerNombre + ' ' + r.data.SegundoNombre + ' ' + r.data.PrimerApellido + ' ' + r.data.SegundoApellido + ' Genero: (' + r.data.Genero + ') FechaNac: (' + r.data.FecNac + ')</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>Cliente:</td>';
        mostrarHC += '<td>' + r.data.Cliente + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '<tr>';
        mostrarHC += '<td>Periodo:</td>';
        mostrarHC += '<td>' + r.data.Periodo + '</td>';
        mostrarHC += '</tr>';
        mostrarHC += '</table>';
        mostrarHC += "<hr>"
        
        mostrarHC += '<span style="text-decoration:underline; font-size:14px; color:#000; font-weight:bolder">EVALUACION FINAL TERAPIA FISICA:</span><br>';
        mostrarHC += '<span style="font-size:12px; color:#000;">';
        mostrarHC += r.data.EvaluacionTerapiaFisica + '<br><br>';
        mostrarHC += 'Responsable: ' + r.data.profeTerapiaFisicaNom + '</span><hr>';
        
        mostrarHC += '<span style="text-decoration:underline; font-size:14px; color:#000; font-weight:bolder">EVALUACION FINAL FONOAUDIOLOGIA:</span><br>';
        mostrarHC += '<span style="font-size:12px; color:#000;">';
        mostrarHC += r.data.EvaluacionFonoaudiologia + '<br><br>';
        mostrarHC += 'Responsable: ' + r.data.profeTerapiaFonoNom + '</span><hr>';
        
        mostrarHC += '<span style="text-decoration:underline; font-size:14px; color:#000; font-weight:bolder">EVALUACION FINAL TERAPIA OCUPACIONAL:</span><br>';
        mostrarHC += '<span style="font-size:12px; color:#000;">';
        mostrarHC += r.data.EvaluacionTerapiaOcupacional + '<br><br>';
        mostrarHC += 'Responsable: ' + r.data.profeTerapiaOcupaNom + '</span><hr>';
        
        mostrarHC += '<span style="text-decoration:underline; font-size:14px; color:#000; font-weight:bolder">CONCLUSIONES:</span><br>';
        mostrarHC += '<span style="font-size:12px; color:#000;">';
        mostrarHC += r.data.Conlusiones + '<br><br>';
        mostrarHC += 'Responsable: ' + r.data.profeTerapiaConclusionNom + '</span>';
        
        Ext.getCmp('DetalleResumenNeurodesa').setValue(mostrarHC);
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
    
});

function DevolverTextoHTML(wTexto){
    var cadena = wTexto;
    var txtRes = "";
    for (var i=0; i<cadena.length; i++)
    {
        if(cadena.charCodeAt(i)==10)
            txtRes += "<br>";
        else
            txtRes += cadena[i];
    }
    return txtRes;
}