/*
* @category    Formulario Consultar HC Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmResumenHCTerapiaMensualxPacienteUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Informe Mensual Terapia Neurodesarrollo ::.',
    id: 'winFrmResumenHCTerapiaMensualxPaciente',
    closable:false,
    width:980,
    height:520,
    //autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        stProfesionalesxIPS = new StoreProfesionales();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmResumenNeurodesaxPaciente',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'sysPacienteResumenNeurodesa'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Paciente',
                                width: 790,
                                readOnly: true,
                                allowBlank: false,
                                emptyText: 'Seleccione Paciente ....',
                                id: 'fPacienteResumenNeurodesa'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPacienteUnificaMalo'
                            }
                        ]
                    },
                    {
                        xtype: 'combo',
                        anchor: '100%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreCliente',
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: false,
                        fieldLabel: 'Cliente',
                        id: 'intClienteResumenNeurodesa'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'displayfield',
                                fieldLabel: 'Periodo',
                                value: 'Año:'
                            },
                            new Ext.ux.form.Spinner({
                                width: 80,
                                name: 'intAnoResumenNeurodesa',
                                value: new Date().getFullYear(),
                                strategy: new Ext.ux.form.Spinner.NumberStrategy({minValue: 2010, maxValue: (new Date().getFullYear() + 20) }),
                                id: 'intAnoResumenNeurodesa'
                            }),
                            {
                                xtype: 'displayfield',
                                value: 'Mes:'
                            },
                            {
                                xtype: 'combo',
                                width: 120,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                valueField: 'Id',
                                displayField: 'Id',
                                store: 'StoreMes',
                                triggerAction: 'all',
                                mode: 'local',
                                emptyText: 'Seleccione...!',
                                allowBlank: false,
                                id: 'strMesResumenNeurodesa'
                            },
                            {
                                xtype: 'button',
                                text: 'Crear Informe Mensual',
                                iconCls: 'btnAdd',
                                tooltip: 'Crear Informe',
                                id: 'btnCrearInformeMensualResumenNeurodesarrollo'
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Informes por Paciente',
                        height: 345,
                        anchor: '100%',
                        frame: true,
                        border: false,
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'hbox',
                                anchor: '100%',
                                height: 341,
                                items: [
                                    {
                                        xtype: 'grid',
                                        store: 'StoreGridInformeFinalNeurodesarrollo',
                                        width: 130,
                                        height: 345,
                                        flex: 1,
                                        id: 'gridHistorialEvoluciones',
                                        columns: [
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Periodo',
                                                sortable: true,
                                                width: 120,
                                                dataIndex: 'Periodo',
                                                hideable: false
                                            }
                                        ],
                                        viewConfig: {
                                            forceFit:true
                                        }
                                    },
                                    {
                                        xtype: 'htmleditor',
                                        id: 'DetalleResumenNeurodesa',
                                        allowBlank: false,
                                        style: 'text-transform:uppercase;',
                                        width: 795,
                                        height: 280,
                                        readOnly: true,
                                        enableAlignments : false,
                                        enableColors : false,
                                        enableFont : false,
                                        enableFontSize : false,
                                        enableFormat : false,
                                        enableLinks : false,
                                        enableLists : false,
                                        enableSourceEdit : false
                                    }
                                ],
                                tbar: [
                                    {
                                        xtype: 'button',
                                        text: 'Imprimir Informe',
                                        iconCls: 'btnImprimir',
                                        tooltip: 'Imprimir Informe',
                                        id: 'btnImprimirInformeMensualResumenNeurodesarrollo'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    '->',
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Terapia Física',
                                        iconCls: 'btnEvolucionar',
                                        tooltip: 'Evolucionar Terapia Fisica',
                                        id: 'btnEvolTFisicaResumenNeurodesarrollo'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Fonoaudiología',
                                        iconCls: 'btnEvolucionar',
                                        tooltip: 'Evolucionar Fonoaudiologia',
                                        id: 'btnEvolFonoaudiologiaResumenNeurodesarrollo'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Terapia Ocupacional',
                                        iconCls: 'btnEvolucionar',
                                        tooltip: 'Evolucionar Terapia Ocupacional',
                                        id: 'btnEvolTOcupacionalResumenNeurodesarrollo'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Conclusiones',
                                        iconCls: 'btnEvolucionar',
                                        tooltip: 'Evolucionar Conclusiones',
                                        id: 'btnEvolConclusuinesResumenNeurodesarrollo'
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        winFrmResumenHCTerapiaMensualxPacienteUi.superclass.initComponent.call(this);
    }
});
