
/*
* @category    Formulario Seleccion Plantilla HC y Apertura HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSeleccionPlantillaOpenHCUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Apertura de Historia Clínica ::.',
    width: 730,
    autoHeight: true,
    modal: true,
    closable: false,
    frame: true,
    padding: 10,
    labelWidth: 150,
    layout: 'form',
    id: 'winSeleccionPlantillaOpenHC',
    style: 'background:transparent;',
    initComponent: function() {
        
        var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Cargando Formulario..."});
        myMask.show();
        
        var stGrid = new StoreGridPlantillasHC();
        stGrid.setBaseParam('pEmpresa', ID_EMPRESA);
        stGrid.load();
        
        this.items = [
            {
                xtype: 'hidden',
                id: 'sysEmpresaPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysSedePlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysIPSPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysActividadPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysPlantillaPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysUsuarioPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysProfesionalPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysPacientePlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysUbicacionPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysConsecutivoDetalle_HC'
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'CAS',
                id: 'sysCASPlantillaHC'
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Profesional',
                id: 'sysNomProfesionalPlantillaHC'
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Consultorio',
                id: 'sysConsultorioPlantillaHC'
            },
            {
                xtype: 'compositefield',
                frame: true,
                fieldLabel: 'Fecha Cita',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Fecha',
                        id: 'sysFechaPlantillaHC'
                    },
                    {
                        xtype: 'displayfield',
                        value: ' - Hora:'
                    },
                    {
                        xtype: 'textfield',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysHoraPlantillaHC'
                    },
                    {
                        xtype: 'displayfield',
                        value: ' - Legalización:'
                    },
                    {
                        xtype: 'textfield',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysFechaLegalizaPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysHoraEstimadaPlantillaHC'
                    }
                ]
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Cliente',
                id: 'sysClientePlantillaHC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysIdCliente_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysIdPlan_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysIdSubPlan_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysIdContrato_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysGeneroPaciente_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysEdadPaciente_HC'
            },
            {
                xtype: 'hidden',
                fieldLabel: 'OJO',
                anchor: '100%',
                allowBlank: true,
                id: 'sysFecNacPaciente_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Concepto Programado',
                id: 'sysIdConceptoPlantillaHC'
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Actividad Programada',
                id: 'sysActividadPlantillaHC'
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                autoHeight: true,
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Paciente',
                id: 'sysNomPacientePlantillaHC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                autoHeight: true,
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Edad',
                id: 'strEdad'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                autoHeight: true,
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Ocupacion',
                id: 'strProfesionPac'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                autoHeight: true,
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Direccion',
                id: 'strDireccion'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                autoHeight: true,
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Telefono',
                id: 'strTel1'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                autoHeight: true,
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Telefono',
                id: 'strTel2'
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                autoHeight: true,
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Genero',
                id: 'sysGeneroPlantillaHC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                autoHeight: true,
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Fecha Nac',
                id: 'fecFecNac'
            },
            {
                xtype: 'grid',
                id: 'gridSeleccionarPlantillaHC',
                store: stGrid,
                anchor: "100%",
                height: 290,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                columnLines: true,
                columns: [
                    {
                        header: 'Plantilla',
                        dataIndex: 'NomPlantilla',
                        readOnly: true,
                        sortable: false,
                        width: 650,
                        hideable: false
                    },{
                        header: 'Grupo',
                        dataIndex: 'Grupo',
                        readOnly: true,
                        sortable: false,
                        width: 100,
                        hidden: true,
                        hideable: false
                    }
                ],
                tbar:
                {
                    xtype: 'toolbar',
                    items: [
                        '->',
                        new Ext.app.SearchField({
                            id: 'qryPlantillasHC',
                            store: stGrid,
                            emptyText: 'Escriba el criterio que desea buscar',
                            width: 120
                        })
                    ]
                },
                viewConfig: {
                    forceFit:true
                },
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                view: new Ext.grid.GroupingView({
                   groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
                }),
                buttons: [
                    {
                        text: 'Abrir Histora Clínica',
                        iconCls: 'btnEvolucionar',
                        listeners: {
                            click : function() {
                                if(Ext.getCmp('gridSeleccionarPlantillaHC').selModel.getCount() == 1){
                                    var selections = Ext.getCmp('gridSeleccionarPlantillaHC').selModel.getSelections();
                                    var totalRegistros = -1;
                                    stCIE10 = new StoreCIE10();
                                    objMX = "NA";
                                    objMXADD = "NA";
                                    objEXA = "NA";
                                    objEXAADD = "NA";
                                    objREM = "NA";
                                    objREMADD = "NA";
                                    wPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
                                    wCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
                                    wConsecutivoDetalle = Ext.getCmp('sysConsecutivoDetalle_HC').getValue();  
                                    if(selections[0].json.RutaFrmMx != null && selections[0].json.RutaFrmMx != ""){
                                        ScriptMgr.loadJs({
                                            scripts : selections[0].json.RutaFrmMx,
                                            callback : function(){
                                                objMX = selections[0].json.NomObjetoMx;
                                                ScriptMgr.loadJs({
                                                    scripts : selections[0].json.RutaFrmAddMx,
                                                    callback : function(){
                                                        objMXADD = selections[0].json.NomObjetoAddMx;
                                                    }
                                                });
                                            }
                                        });
                                    }
                                    if(selections[0].json.RutaFrmExa != null && selections[0].json.RutaFrmExa != ""){
                                        ScriptMgr.loadJs({
                                            scripts : selections[0].json.RutaFrmExa,
                                            callback : function(){
                                                objEXA = selections[0].json.NomObjetoExa;
                                                ScriptMgr.loadJs({
                                                    scripts : selections[0].json.RutaFrmAddExa,
                                                    callback : function(){
                                                        objEXAADD = selections[0].json.NomObjetoAddExa;
                                                    }
                                                });
                                            }
                                        });
                                    }
                                    if(selections[0].json.RutaFrmRem != null && selections[0].json.RutaFrmRem != ""){
                                        ScriptMgr.loadJs({
                                            scripts : selections[0].json.RutaFrmRem,
                                            callback : function(){
                                                objREM = selections[0].json.NomObjetoRem;
                                                ScriptMgr.loadJs({
                                                    scripts : selections[0].json.RutaFrmAddRem,
                                                    callback : function(){
                                                        objREMADD = selections[0].json.NomObjetoAddRem;
                                                    }
                                                });
                                            }
                                        });
                                    }
                                    if(selections[0].json.UsaTestBarthel != null && selections[0].json.UsaTestBarthel != "" && selections[0].json.UsaTestBarthel == "1"){
                                        ScriptMgr.loadJs({
                                            scripts : '../../../app/frm_js/asistencial/ofimedical/wintestbarthel.ui.js'
                                        });
                                    }
                                    if(selections[0].json.UsaTestHachinski != null && selections[0].json.UsaTestHachinski != "" && selections[0].json.UsaTestHachinski == "1"){
                                        ScriptMgr.loadJs({
                                            scripts : '../../../app/frm_js/asistencial/ofimedical/wintesthachinski.ui.js'
                                        });
                                    }
                                    if(selections[0].json.UsaTestFolstein != null && selections[0].json.UsaTestFolstein != "" && selections[0].json.UsaTestFolstein == "1"){
                                        ScriptMgr.loadJs({
                                            scripts : '../../../app/frm_js/asistencial/ofimedical/wintestfolstein.ui.js'
                                        });
                                    }
                                    if(selections[0].json.UsaTestLawton != null && selections[0].json.UsaTestLawton != "" && selections[0].json.UsaTestLawton == "1"){
                                        ScriptMgr.loadJs({
                                            scripts : '../../../app/frm_js/asistencial/ofimedical/wintestlawton.ui.js'
                                        });
                                    }
                                    if(selections[0].json.UsaTestYesavage != null && selections[0].json.UsaTestYesavage != "" && selections[0].json.UsaTestYesavage == "1"){
                                        ScriptMgr.loadJs({
                                            scripts : '../../../app/frm_js/asistencial/ofimedical/wintestyesavage.ui.js'
                                        });
                                    }
                                    
                                    // ***** CARGAR LOS COMPONENTES ASOCIADOS A LA PLANTILLA
                                    var dsComponentesPlantilla = new Ext.data.Store({
                                        id: 'dsComponentesPlantilla',
                                        proxy: new Ext.data.HttpProxy({
                                            url: '../../controlador/asistencial/controlador_plantillashc.php',
                                            method: 'POST'
                                        }),
                                        baseParams: {
                                            task: "LISTAR_COMPONENTES",
                                            pPlantilla: selections[0].json.IdPlantilla
                                        },
                                        loadMask: {msg:"Cargando Registros, por favor espere..."},
                                        autoload: false,
                                        reader: new Ext.data.JsonReader({
                                            root: 'results',
                                            totalProperty: 'total',
                                            id: 'id'
                                          },[
                                            {name: 'RutaComponente'},
                                            {name: 'NomComponente'},
                                            {name: 'Tipo'}
                                         ])
                                    });
                                    dsComponentesPlantilla.load({
                                        callback: function(){
                                            var totalRegistros = dsComponentesPlantilla.getTotalCount();
                                            var i = 0;
                                            if(totalRegistros !== 0 && totalRegistros !== -1){
                                                dsComponentesPlantilla.each(function(record){
                                                    ScriptMgr.loadJs({
                                                        scripts : record.get('RutaComponente'),
                                                        callback: function(){
                                                            i++;
                                                            //alert("componente: " + record.get('NomComponente'));
                                                            //cargarFormularioHC(i,totalRegistros, selections[0].json.RutaPlantilla,selections[0].json.NomObjeto,selections[0].json.NomPlantilla, selections[0].json.IdPlantilla, selections[0].json.RutaRptHC, selections[0].json.RutaRptMx, selections[0].json.RutaRptExa, selections[0].json.RutaRptRem);
                                                            if(i === totalRegistros){
                                                                //alert("Se cargo el frm");
                                                                ScriptMgr.loadJs({
                                                                    scripts : selections[0].json.RutaPlantilla,
                                                                    waitMsg: 'Por favor Espere...',
                                                                    callback : function(){
                                                                        wPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
                                                                        wCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
                                                                        paramOpcion = "Nuevo";
                                                                        //alert(selections[0].json.NomObjeto);
                                                                        var winHC = eval(selections[0].json.NomObjeto);//new winHCUi();
                                                                        //alert("AHIQ02");
                                                                        Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.NomPlantilla));
                                                                        Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysActividadPlantillaHC').getValue()));
                                                                        Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                                                                        Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                                                                        Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                                                                        Ext.getCmp('sysProfesionalHC').setValue(Ext.getCmp('sysProfesionalPlantillaHC').getValue());
                                                                        Ext.getCmp('sysIdPacienteHC').setValue(Ext.getCmp('sysPacientePlantillaHC').getValue());
                                                                        Ext.getCmp('sysClienteHC').setValue(Ext.getCmp('sysClientePlantillaHC').getRawValue());
                                                                        Ext.getCmp('sysCASHC').setValue(Ext.getCmp('sysCASPlantillaHC').getValue());
                                                                        Ext.getCmp('sysProfesionalAgendaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysNomProfesionalPlantillaHC').getValue()));

                                                                        if(Ext.getCmp('sysFechaPlantillaHC').getValue()!== "" && Ext.getCmp('sysFechaPlantillaHC').getValue()!== null){
                                                                            Ext.getCmp('sysFechaHC').setValue(Ext.getCmp('sysFechaPlantillaHC').getValue());
                                                                        }
                                                                        
                                                                        Ext.getCmp('sysHoraHC').setValue(new Date().format("h:i:s"));
                                                                        Ext.getCmp('sysLegalizaHC').setValue(new Date().format("h:i:s"));
                                                                        Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysNomPacientePlantillaHC').getValue()));
                                                                        Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
                                                                        Ext.getCmp('sysConsecutivoDetalleHC').setValue(Ext.getCmp('sysConsecutivoDetalle_HC').getValue());
                                                                        Ext.getCmp('sysIdClienteHC').setValue(Ext.getCmp('sysIdCliente_HC').getValue());
                                                                        Ext.getCmp('sysIdContratoHC').setValue(1);
                                                                        Ext.getCmp('sysIdCodPlantillaHC').setValue(selections[0].json.IdPlantilla);
                                                                        
                                                                        try {
                                                                            var campo2 = Ext.getCmp('sysRutaRptHC');
                                                                            if ( campo2 != null ) {
                                                                                Ext.getCmp('sysRutaRptHC').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptHC));
                                                                            }
                                                                        }catch(ex) {
                                                                        }
                                                                        try {
                                                                            var campo3 = Ext.getCmp('sysRutaRptMx');
                                                                            if ( campo3 != null ) {
                                                                                Ext.getCmp('sysRutaRptMx').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptMx));
                                                                            }
                                                                        }catch(ex) {
                                                                        }
                                                                        try {
                                                                            var campo4 = Ext.getCmp('sysRutaRptExa');
                                                                            if ( campo4 != null ) {
                                                                                Ext.getCmp('sysRutaRptExa').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptExa));
                                                                            }
                                                                        }catch(ex) {
                                                                        }
                                                                        try {
                                                                            var campo5 = Ext.getCmp('sysRutaRptRem');
                                                                            if ( campo5 != null ) {
                                                                                Ext.getCmp('sysRutaRptRem').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptRem));
                                                                            }
                                                                        }catch(ex) {
                                                                        }
                                                                        try { 
                                                                            var campo6 = Ext.getCmp('sysInfoPacHCEdad');
                                                                            if ( campo6 != null ) {
                                                                                Ext.getCmp('sysInfoPacHCEdad').setValue(Ext.getCmp('strEdad').getValue());
                                                                            }
                                                                        }catch(ex) {
                                                                        }
                                                                        try {
                                                                            var campo8 = Ext.getCmp('sysInfoPacHCOcupacion');
                                                                            if ( campo8 != null ) {
                                                                                Ext.getCmp('sysInfoPacHCOcupacion').setValue(Ext.getCmp('strProfesionPac').getRawValue());
                                                                            }
                                                                        }catch(ex) {
                                                                        }
                                                                        try {
                                                                            var campo9 = Ext.getCmp('sysInfoPacHCDireccion');
                                                                            if ( campo9 != null ) {
                                                                                Ext.getCmp('sysInfoPacHCDireccion').setValue(Ext.getCmp('strDireccion').getValue());
                                                                            }
                                                                        }catch(ex) {
                                                                        }
                                                                        try {
                                                                            var campo10 = Ext.getCmp('sysInfoPacHCTelefonos');
                                                                            if ( campo10 != null ) {
                                                                                Ext.getCmp('sysInfoPacHCTelefonos').setValue(Ext.getCmp('strTel1').getValue() + " - " + Ext.getCmp('strTel2').getValue());
                                                                            }
                                                                        }catch(ex) {
                                                                        }
                                                                        try {
                                                                            if(Ext.getCmp('sysGeneroPaciente_HC').getValue() != null){
                                                                                var campo3_1 = Ext.getCmp('sysGeneroPacHC');
                                                                                if(Ext.getCmp('sysGeneroPaciente_HC').getValue() == "M"){
                                                                                    Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                                                                                }else{
                                                                                    Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                                                                                }
                                                                            }
                                                                        }catch(ex) {
                                                                        }

                                                                        //OJO OMAR
                                                                        try {
                                                                            if(Ext.getCmp('sysGeneroPaciente_HC').getValue() != null){
                                                                                var campo3_2 = Ext.getCmp('sysGeneroPacHC');
                                                                                if(Ext.getCmp('sysGeneroPaciente_HC').getValue() == "M"){
                                                                                    Ext.getCmp('sysGeneroHC').setValue("MASCULINO");
                                                                                }else{
                                                                                    Ext.getCmp('sysGeneroHC').setValue("FEMENINO");
                                                                                }
                                                                            }
                                                                        }catch(ex) {
                                                                        }
                                                                        try {
                                                                            var campo5_2 = Ext.getCmp('sysFechaNac');
                                                                            if ( campo5_2 != null ) {
                                                                                Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNacPaciente_HC').getValue());
                                                                            }
                                                                        }catch(ex) {
                                                                        }
                                                                        try {
                                                                            var campo4_2 = Ext.getCmp('sysEdadPacHC');
                                                                            if ( campo4_2 != null ) {
                                                                                Ext.getCmp('sysEdadHC').setValue(Ext.getCmp('sysEdadPaciente_HC').getValue());
                                                                            }
                                                                        }catch(ex) {
                                                                        }    
                                                                        try {
                                                                            var campoVerificaDoc = Ext.getCmp('sysVerificarDocenteHC');
                                                                            if ( campoVerificaDoc != null ) {
                                                                                Ext.getCmp('sysVerificarDocenteHC').setValue(1);
                                                                            }
                                                                        }catch(ex) {
                                                                        }    
                                                                        //FIN OMAR


                                                                        try {
                                                                            var campo4_1 = Ext.getCmp('sysEdadPacHC');
                                                                            if ( campo4_1 != null ) {
                                                                                Ext.getCmp('sysEdadPacHC').setValue(Ext.getCmp('sysEdadPaciente_HC').getValue());
                                                                            }
                                                                        }catch(ex) {
                                                                        }    
                                                                        try {
                                                                            var campo5_1 = Ext.getCmp('sysFecNacPacHC');
                                                                            if ( campo5_1 != null ) {
                                                                                Ext.getCmp('sysFecNacPacHC').setValue(Ext.getCmp('sysFecNacPaciente_HC').getValue());
                                                                            }
                                                                        }catch(ex) {
                                                                        }
                                                                        
                                                                        winHC.show();
                                                                        Ext.getCmp('winSeleccionPlantillaOpenHC').close();
                                                                    }
                                                                });
                                                            }
                                                        }
                                                    });
                                                });
                                            }else{
                                                ScriptMgr.loadJs({
                                                    scripts : selections[0].json.RutaPlantilla,
                                                    waitMsg: 'Por favor Espere...',
                                                    callback : function(){
                                                        wPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
                                                        wCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
                                                        paramOpcion = "Nuevo";
                                                        var winHC = eval(selections[0].json.NomObjeto);//new winHCUi();
                                                        Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.NomPlantilla));

                                                        Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysActividadPlantillaHC').getValue()));
                                                        Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                                                        Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                                                        Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                                                        Ext.getCmp('sysProfesionalHC').setValue(Ext.getCmp('sysProfesionalPlantillaHC').getValue());
                                                        Ext.getCmp('sysIdPacienteHC').setValue(Ext.getCmp('sysPacientePlantillaHC').getValue());
                                                        Ext.getCmp('sysClienteHC').setValue(Ext.getCmp('sysClientePlantillaHC').getRawValue());
                                                        Ext.getCmp('sysCASHC').setValue(Ext.getCmp('sysCASPlantillaHC').getValue());
                                                        Ext.getCmp('sysProfesionalAgendaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysNomProfesionalPlantillaHC').getValue()));

                                                        if(Ext.getCmp('sysFechaPlantillaHC').getValue()!== "" && Ext.getCmp('sysFechaPlantillaHC').getValue()!== null){
                                                            Ext.getCmp('sysFechaHC').setValue(Ext.getCmp('sysFechaPlantillaHC').getValue());
                                                        }

                                                        Ext.getCmp('sysHoraHC').setValue(new Date().format("h:i:s"));
                                                        Ext.getCmp('sysLegalizaHC').setValue(new Date().format("h:i:s"));
                                                        Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysNomPacientePlantillaHC').getValue()));
                                                        Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
                                                        Ext.getCmp('sysConsecutivoDetalleHC').setValue(Ext.getCmp('sysConsecutivoDetalle_HC').getValue());
                                                        Ext.getCmp('sysIdClienteHC').setValue(Ext.getCmp('sysIdCliente_HC').getValue());
                                                        Ext.getCmp('sysIdContratoHC').setValue(1);
                                                        Ext.getCmp('sysIdCodPlantillaHC').setValue(selections[0].json.IdPlantilla);

                                                        try {
                                                            var campo2 = Ext.getCmp('sysRutaRptHC');
                                                            if ( campo2 != null ) {
                                                                Ext.getCmp('sysRutaRptHC').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptHC));
                                                            }
                                                        }catch(ex) {
                                                        }
                                                        try {
                                                            var campo3 = Ext.getCmp('sysRutaRptMx');
                                                            if ( campo3 != null ) {
                                                                Ext.getCmp('sysRutaRptMx').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptMx));
                                                            }
                                                        }catch(ex) {
                                                        }
                                                        try {
                                                            var campo4 = Ext.getCmp('sysRutaRptExa');
                                                            if ( campo4 != null ) {
                                                                Ext.getCmp('sysRutaRptExa').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptExa));
                                                            }
                                                        }catch(ex) {
                                                        }
                                                        try {
                                                            var campo5 = Ext.getCmp('sysRutaRptRem');
                                                            if ( campo5 != null ) {
                                                                Ext.getCmp('sysRutaRptRem').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptRem));
                                                            }
                                                        }catch(ex) {
                                                        }
                                                        try { 
                                                            var campo6 = Ext.getCmp('sysInfoPacHCEdad');
                                                            if ( campo6 != null ) {
                                                                Ext.getCmp('sysInfoPacHCEdad').setValue(Ext.getCmp('strEdad').getValue());
                                                            }
                                                        }catch(ex) {
                                                        }
                                                        try {
                                                            var campo8 = Ext.getCmp('sysInfoPacHCOcupacion');
                                                            if ( campo8 != null ) {
                                                                Ext.getCmp('sysInfoPacHCOcupacion').setValue(Ext.getCmp('strProfesionPac').getRawValue());
                                                            }
                                                        }catch(ex) {
                                                        }
                                                        try {
                                                            var campo9 = Ext.getCmp('sysInfoPacHCDireccion');
                                                            if ( campo9 != null ) {
                                                                Ext.getCmp('sysInfoPacHCDireccion').setValue(Ext.getCmp('strDireccion').getValue());
                                                            }
                                                        }catch(ex) {
                                                        }
                                                        try {
                                                            var campo10 = Ext.getCmp('sysInfoPacHCTelefonos');
                                                            if ( campo10 != null ) {
                                                                Ext.getCmp('sysInfoPacHCTelefonos').setValue(Ext.getCmp('strTel1').getValue() + " - " + Ext.getCmp('strTel2').getValue());
                                                            }
                                                        }catch(ex) {
                                                        }
                                                        try {
                                                            if(Ext.getCmp('sysGeneroPaciente_HC').getValue() != null){
                                                                var campo3_1 = Ext.getCmp('sysGeneroPacHC');
                                                                if(Ext.getCmp('sysGeneroPaciente_HC').getValue() == "M"){
                                                                    Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                                                                }else{
                                                                    Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                                                                }
                                                            }
                                                        }catch(ex) {
                                                        }

                                                        //OJO OMAR
                                                        try {
                                                            if(Ext.getCmp('sysGeneroPaciente_HC').getValue() != null){
                                                                var campo3_2 = Ext.getCmp('sysGeneroPacHC');
                                                                if(Ext.getCmp('sysGeneroPaciente_HC').getValue() == "M"){
                                                                    Ext.getCmp('sysGeneroHC').setValue("MASCULINO");
                                                                }else{
                                                                    Ext.getCmp('sysGeneroHC').setValue("FEMENINO");
                                                                }
                                                            }
                                                        }catch(ex) {
                                                        }
                                                        try {
                                                            var campo5_2 = Ext.getCmp('sysFechaNac');
                                                            if ( campo5_2 != null ) {
                                                                Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNacPaciente_HC').getValue());
                                                            }
                                                        }catch(ex) {
                                                        }
                                                        try {
                                                            var campo4_2 = Ext.getCmp('sysEdadPacHC');
                                                            if ( campo4_2 != null ) {
                                                                Ext.getCmp('sysEdadHC').setValue(Ext.getCmp('sysEdadPaciente_HC').getValue());
                                                            }
                                                        }catch(ex) {
                                                        }    
                                                        try {
                                                            var campoVerificaDoc = Ext.getCmp('sysVerificarDocenteHC');
                                                            if ( campoVerificaDoc != null ) {
                                                                Ext.getCmp('sysVerificarDocenteHC').setValue(1);
                                                            }
                                                        }catch(ex) {
                                                        }
                                                        //FIN OMAR


                                                        try {
                                                            var campo4_1 = Ext.getCmp('sysEdadPacHC');
                                                            if ( campo4_1 != null ) {
                                                                Ext.getCmp('sysEdadPacHC').setValue(Ext.getCmp('sysEdadPaciente_HC').getValue());
                                                            }
                                                        }catch(ex) {
                                                        }    
                                                        try {
                                                            var campo5_1 = Ext.getCmp('sysFecNacPacHC');
                                                            if ( campo5_1 != null ) {
                                                                Ext.getCmp('sysFecNacPacHC').setValue(Ext.getCmp('sysFecNacPaciente_HC').getValue());
                                                            }
                                                        }catch(ex) {
                                                        }
                                                        winHC.show();
                                                        Ext.getCmp('winSeleccionPlantillaOpenHC').close();
                                                    }
                                                });
                                            }
                                        }
                                    });
                                    // ***** FIN CARGA COMPONENTES
                                }else{
                                    Ext.MessageBox.show({
                                        title: 'eOfiClinic',
                                        msg: 'Debe Seleccionar una Plantilla.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            }
                        }
                    },
                    {
                        text: 'Cancelar',
                        iconCls: 'btnCancelar',
                        listeners: {
                            click : function() {
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea cerrar la ventana?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                            Ext.getCmp('winSeleccionPlantillaOpenHC').close();
                                        }
                                    }
                                });
                            }
                        }
                    }
                ],
                buttonAlign: 'center',
                listeners: {
                    viewready : function() {
                        myMask.hide();
                    }
                }
            }
        ];
        winSeleccionPlantillaOpenHCUi.superclass.initComponent.call(this);
    }
});
