/*
* @category    Formulario Ver Evoluciones HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winViewEvolucionHCUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Ver Historial Evoluciones HC ::.',
    width: 970,
    height: 570,
    border: false,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winViewEvolucionHC',
    initComponent: function() {
        el = Ext.get('idaplicacion');
        //NOMAPLICACION = el.getValue();
        NOMAPLICACION = "OfiClinic";
        
        function VerInfoServicio(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<h3><b>' + value + '</b></h3>' + '</br><h4>' + record.get('Actividad') + '</br><span style="color: darkblue;">Profesional: ' + record.get('NomProfe') + '</span></h4>';  
        }
        
        var viewResumenHC = new Ext.Panel({
            //autoLoad:{
            //    url: '../../controlador/asistencial/ximprimirhc.php?pEmpresa=' + ID_EMPRESA + '&pIPS=' + ID_IPS + '&pPaciente=' + Ext.getCmp('sysIdPacienteHC').getValue() + '&pEvolucion=' + xConsecutivoHC,
            //    scripts:true,
            //    scope:this
            //},
            id:'viewResumenHC',
            width: 618,
            height: 467,
            autoScroll:true,
            closable:false
        });
        
        this.bbar = [
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Imprimir Evolución',
                iconCls: 'btnImprimir',
                id: 'detImprimirHC',
                listeners: {
                    click : function() {
                        if(parseInt(Ext.getCmp('gridHistorialEvoluciones').selModel.getCount()) === 1){
                            var selections = Ext.getCmp('gridHistorialEvoluciones').selModel.getSelections();
                            switch (NOMAPLICACION){
                                case "OfiMedical":
                                    window.open ("../../controlador/asistencial/imprimirhc.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Historia Clinica");
                                    break;
                                default:
                                    window.open ("../../controlador/asistencial/imprimirhc.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Historia Clinica");
                                    break;
                            }
                        }else{
                            Ext.MessageBox.show({
                                title: NOMAPLICACION,
                                msg: 'Debe Seleccionar una Evolución.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Imprimir Toda la Historia',
                iconCls: 'btnImprimir',
                id: 'detImprimirHCAll',
                listeners: {
                    click : function() {
                        switch (NOMAPLICACION){
                            case "OfiMedical":
                                window.open ("../../controlador/asistencial/imprimirhc.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pEvolucion=0","Historia Clinica");
                                break;
                            default:
                                window.open ("../../controlador/asistencial/imprimirhc.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pEvolucion=0","Historia Clinica");
                                break;
                        }
                    }
                }
            },
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'button',
                text: 'Salir',
                iconCls: 'btnSalir',
                ref: '../detAgendaSalir',
                id: 'detAgendaSalir',
                listeners: {
                    click : function() {
                        Ext.getCmp('winViewEvolucionHC').close();
                    }
                }
            }
        ];
        
        this.items = [
            {
                xtype: 'panel',
                title: 'Historial de Evoluciones',
                layout: 'hbox',
                //width: 900,
                anchor: '100%',
                height: 500,
                items: [
                    {
                        xtype: 'grid',
                        store: 'StoreGridEvolucionesHC',
                        title: 'Atenciones',
                        width: 320,
                        height: 485,
                        flex: 1,
                        id: 'gridHistorialEvoluciones',
                        columns: [
                            {
                                xtype: 'gridcolumn',
                                header: 'Fecha',
                                sortable: true,
                                width: 120,
                                dataIndex: 'FechaAtencion',
                                renderer: VerInfoServicio,
                                hideable: false
                            }
                        ],
                        viewConfig: {
                            forceFit:true
                        },
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true})
                    },
                    viewResumenHC
                    /*{
                        xtype: 'htmleditor',
                        id: 'DetalleResumenHC',
                        allowBlank: false,
                        style: 'text-transform:uppercase;',
                        width: 800,
                        height: 475,
                        readOnly: true,
                        enableAlignments : false,
                        enableColors : false,
                        enableFont : false,
                        enableFontSize : false,
                        enableFormat : false,
                        enableLinks : false,
                        enableLists : false,
                        enableSourceEdit : false
                    }*/
                ]
            }
        ];
        winViewEvolucionHCUi.superclass.initComponent.call(this);
    }
});
