/*
* @category    Formulario Barra de Servicios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winBaraServiciosUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©      .:: Barra de Servicios ::.',
    width: 1004,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winBaraServicios',
    initComponent: function() {
        
        //var stGridProfesionalesCitas = new StoreGridProfesionalesCitas();
        //var stGridConsultoriosCitas = new StoreGridConsultoriosCitas();
        //var stGridAgendasDisponiblesCitas = new StoreGridAgendasDisponiblesCitas();
        //var stGridHoarariosxAgendaDisponiblesCitas = new StoreGridHoarariosxAgendaDisponiblesCitas();
        var stGridCitasxLegalizar = new StoreGridCitasManualxLegalizar();
        
        var controlCampos = false;
        
        function renderFechaAgenda(value, p, record){
            return String.format(
                value + ' - ' + FormatoFechaLarga(value),
                value);
        }
        
        function renderCitaObservacionesPlantilla(value, p, record){
            return String.format(
                '<table border="0"><tr><td><b>{0}</b></td></tr><tr><td>{1}</td></tr></table>',
                value, record.data.citaObservacionesPlantilla);
        }
        
        var xg = Ext.grid;
               
        var chkColumnSeleccionarHorario = new xg.CheckColumn({
           header: ' ',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionarHorario',
           value: false,
           width: 10
        });
        
        var strcitaInfoAdd = new Ext.form.TextField();
        
        var dataHorasCitas = [
            ['7:00 AM'],
            ['7:45 AM'],
            ['8:30 AM'],
            ['9:15 AM'],
            ['10:15 AM'],
            ['11:00 AM'],
            ['11:45 AM'],
            ['12:30 PM'],
            ['1:15 PM'],
            ['2:00 PM'],
            ['2:45 PM'],
            ['3:45 PM'],
            ['4:30 PM'],
            ['5:15 PM'],
            ['6:00 PM'],
            ['6:45 PM']
        ];
        var stHorasCitas = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stHorasCitas.loadData(dataHorasCitas);

        this.items = [
            {
                xtype: 'tabpanel',
                width: 998,
                height: 585,
                border: false,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Identificación del Servicio',
                        height: 441,
                        width: 951,
                        frame: true,
                        border: false,
                        autoScroll: true,
                        id: 'fichaDatos',
                        items: [
                            {
                                xtype: 'form',
                                title: '',
                                padding: 5,
                                border: false,
                                id: 'frmPacientesCitaManual',
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Paciente',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 949,
                                        autoHeight: true,
                                        id: 'fsPaciente',
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                id: 'sysIdEmpresa',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysIdSede',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysIdIPS',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysIdUsuario',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'intIdPaciente',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysPacienteValido',
                                                value: 0
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Tipo Doc ID',
                                                        name: 'cbTdoc',
                                                        allowBlank: false,
                                                        width: 50,
                                                        id: 'strTdoc'
                                                    },
                                                    {
                                                        html: '-'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'txtDocID',
                                                        allowBlank: false,
                                                        width: 160,
                                                        id: 'strDocID',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB && Ext.getCmp('strDocID').getValue() !== "" && Ext.getCmp('strDocID').getValue() !== null && parseInt(Ext.getCmp('intIdPaciente').getValue()) === 0){
                                                                    Ext.Ajax.request({
                                                                        url: '../../controlador/util/controlador_varios.php',
                                                                        params:{
                                                                            task: 'BUSCAR_PACIENTE',
                                                                            pTdoc: Ext.getCmp('strTdoc').getValue(),
                                                                            pDoc: Ext.getCmp('strDocID').getValue()
                                                                        },
                                                                        success: function(response,options){
                                                                            var Respuesta = response.responseText;
                                                                            var Contenido = Respuesta.split('^');
                                                                            if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                                Ext.getCmp('intIdPaciente').setValue(0);
                                                                                Ext.getCmp('sysPacienteValido').setValue(0);    
                                                                            } else {
                                                                                Ext.getCmp('intIdPaciente').setValue(Contenido[14]);
                                                                                Ext.getCmp('strTdoc').setValue(Contenido[0]);
                                                                                Ext.getCmp('sysPacienteValido').setValue(1);
                                                                                Ext.getCmp('strGenero').setValue(Contenido[2]);
                                                                                Ext.getCmp('strApe1').setValue(Contenido[3]);
                                                                                Ext.getCmp('strApe2').setValue(Contenido[4]);
                                                                                Ext.getCmp('strNom1').setValue(Contenido[5]);
                                                                                Ext.getCmp('strNom2').setValue(Contenido[6]);
                                                                                Ext.getCmp('fecFecNac').setValue(Contenido[7]);
                                                                                Ext.getCmp('strDeptoMuni').setValue(Contenido[8]);
                                                                                Ext.getCmp('strDireccion').setValue(Contenido[9]);
                                                                                Ext.getCmp('strTel1').setValue(Contenido[10]);
                                                                                Ext.getCmp('strTel2').setValue(Contenido[11]);
                                                                                Ext.getCmp('strZona').setValue(Contenido[12]);
                                                                                Ext.getCmp('strEmail').setValue(Contenido[13]);
                                                                                CargarDatosUltimaAsignacion(parseInt(Contenido[14]));
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            Ext.getCmp('intIdPaciente').setValue(0);
                                                                            Ext.getCmp('sysPacienteValido').setValue(0);
                                                                        },
                                                                        scope:this 
                                                                    });
                                                                }
                                                            },
                                                            blur: function(t){
                                                                if (Ext.getCmp('strDocID').getValue() !== "" && Ext.getCmp('strDocID').getValue() !== null && parseInt(Ext.getCmp('intIdPaciente').getValue()) === 0){
                                                                    Ext.Ajax.request({
                                                                        url: '../../controlador/util/controlador_varios.php',
                                                                        params:{
                                                                            task: 'BUSCAR_PACIENTE',
                                                                            pTdoc: Ext.getCmp('strTdoc').getValue(),
                                                                            pDoc: Ext.getCmp('strDocID').getValue()
                                                                        },
                                                                        success: function(response,options){
                                                                            var Respuesta = response.responseText;
                                                                            var Contenido = Respuesta.split('^');
                                                                            if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                                Ext.getCmp('intIdPaciente').setValue(0);
                                                                                Ext.getCmp('sysPacienteValido').setValue(0);    
                                                                            } else {
                                                                                Ext.getCmp('intIdPaciente').setValue(Contenido[14]);
                                                                                Ext.getCmp('strTdoc').setValue(Contenido[0]);
                                                                                Ext.getCmp('sysPacienteValido').setValue(1);
                                                                                Ext.getCmp('strGenero').setValue(Contenido[2]);
                                                                                Ext.getCmp('strApe1').setValue(Contenido[3]);
                                                                                Ext.getCmp('strApe2').setValue(Contenido[4]);
                                                                                Ext.getCmp('strNom1').setValue(Contenido[5]);
                                                                                Ext.getCmp('strNom2').setValue(Contenido[6]);
                                                                                Ext.getCmp('fecFecNac').setValue(Contenido[7]);
                                                                                Ext.getCmp('strDeptoMuni').setValue(Contenido[8]);
                                                                                Ext.getCmp('strDireccion').setValue(Contenido[9]);
                                                                                Ext.getCmp('strTel1').setValue(Contenido[10]);
                                                                                Ext.getCmp('strTel2').setValue(Contenido[11]);
                                                                                Ext.getCmp('strZona').setValue(Contenido[12]);
                                                                                Ext.getCmp('strEmail').setValue(Contenido[13]);
                                                                                CargarDatosUltimaAsignacion(parseInt(Contenido[14]));
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            Ext.getCmp('intIdPaciente').setValue(0);
                                                                            Ext.getCmp('sysPacienteValido').setValue(0);
                                                                        },
                                                                        scope:this 
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Paciente',
                                                        id: 'btnBuscarPaciente'
                                                    },
                                                    {
                                                        html: ' - Genero:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 30,
                                                        name: 'strGenero',
                                                        allowBlank: false,
                                                        id: 'strGenero',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB){
                                                                    switch(f.getValue().toUpperCase()){
                                                                        case "M":
                                                                            Ext.getCmp('strGenero').setValue(f.getValue().toUpperCase());
                                                                            Ext.getCmp('sysGenero').setValue("MASCULINO");
                                                                            break;
                                                                        case "F":
                                                                            Ext.getCmp('strGenero').setValue(f.getValue().toUpperCase());
                                                                            Ext.getCmp('sysGenero').setValue("FEMENINO");
                                                                            break;
                                                                        default:
                                                                            Ext.getCmp('strGenero').setValue(null);
                                                                            Ext.getCmp('sysGenero').setValue(null);
                                                                    }
                                                                }
                                                            },
                                                            blur: function(t){
                                                                if (Ext.getCmp('strGenero').getValue() !== "" && Ext.getCmp('strGenero').getValue() !== null && (Ext.getCmp('sysGenero').getValue() === "" || Ext.getCmp('sysGenero').getValue() === null)){
                                                                    switch(Ext.getCmp('strGenero').getValue()){
                                                                        case "M":
                                                                            Ext.getCmp('strGenero').setValue(Ext.getCmp('strGenero').getValue().toUpperCase());
                                                                            Ext.getCmp('sysGenero').setValue("MASCULINO");
                                                                            break;
                                                                        case "F":
                                                                            Ext.getCmp('strGenero').setValue(Ext.getCmp('strGenero').getValue().toUpperCase());
                                                                            Ext.getCmp('sysGenero').setValue("FEMENINO");
                                                                            break;
                                                                        default:
                                                                            Ext.getCmp('strGenero').setValue(null);
                                                                            Ext.getCmp('sysGenero').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        html: '-'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 130,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        disabled: true,
                                                        id: 'sysGenero'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '1er Apellido',
                                                        width: 150,
                                                        name: 'strApe1',
                                                        style: 'text-transform:uppercase;',
                                                        allowBlank: false,
                                                        id: 'strApe1'
                                                    },
                                                    {
                                                        html: '2do Apellido:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 140,
                                                        name: 'strApe2',
                                                        style: 'text-transform:uppercase;',
                                                        id: 'strApe2'
                                                    },
                                                    {
                                                        html: '1er Nombre:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 145,
                                                        name: 'strNom1',
                                                        allowBlank: false,
                                                        style: 'text-transform:uppercase;',
                                                        id: 'strNom1'
                                                    },
                                                    {
                                                        html: '2do Nombre:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 140,
                                                        name: 'strNom2',
                                                        style: 'text-transform:uppercase;',
                                                        id: 'strNom2'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Nacimiento',
                                                        width: 130,
                                                        name: 'fecFecNac',
                                                        allowBlank: false,
                                                        disabledDates: '',
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'fecFecNac'
                                                    },
                                                    {
                                                        html: '-'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 280,
                                                        name: 'strEdad',
                                                        readOnly: true,
                                                        style: 'color: blue;text-align:center',
                                                        disabled: true,
                                                        id: 'strEdad'
                                                    },
                                                    {
                                                        html: 'Municipio:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 50,
                                                        allowBlank: false,
                                                        id: 'strDeptoMuni',
                                                        listeners:{
                                                            blur: function(t){
                                                                if (Ext.getCmp('strDeptoMuni').getValue() !== "" && Ext.getCmp('strDeptoMuni').getValue() !== null){
                                                                    Ext.Ajax.request({
                                                                        url: '../../controlador/util/controlador_varios.php',
                                                                        params:{
                                                                            task: 'BUSCAR_MUNICIPIO',
                                                                            pMunicipio: Ext.getCmp('strDeptoMuni').getValue()
                                                                        },
                                                                        success: function(response,options)
                                                                        {
                                                                            var Respuesta = response.responseText;
                                                                            var Contenido = Respuesta.split('^');
                                                                            if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                                Ext.getCmp('strDeptoMuni').setValue(null);
                                                                                Ext.getCmp('sysDeptoMuni').setValue(null);
                                                                            } else {
                                                                                Ext.getCmp('sysDeptoMuni').setValue(Contenido[1]);
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            Ext.getCmp('strDeptoMuni').setValue(null);
                                                                            Ext.getCmp('sysDeptoMuni').setValue(null);
                                                                        },
                                                                        scope:this 
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        html: '-'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 266,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        disabled: true,
                                                        id: 'sysDeptoMuni'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'strDireccion',
                                                        allowBlank: false,
                                                        fieldLabel: 'Dirección',
                                                        emptyText: 'Dirección....',
                                                        style: 'text-transform:uppercase;',
                                                        width: 295,
                                                        id: 'strDireccion'
                                                    },
                                                    {
                                                        html: 'Telefonos:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'strTel1',
                                                        allowBlank: false,
                                                        emptyText: 'Teléfono',
                                                        width: 160,
                                                        id: 'strTel1'
                                                    },
                                                    {
                                                        html: '-'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'strTel2',
                                                        emptyText: 'Teléfono (Otro - Cel.)',
                                                        width: 160,
                                                        id: 'strTel2'
                                                    },
                                                    {
                                                        html: 'Zona:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        flex: 1,
                                                        store: 'StoreZonaResidencia',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        name: 'strZona',
                                                        emptyText: 'Zona....',
                                                        allowBlank: false,
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        width: 80,
                                                        value: 'Urbana',
                                                        triggerAction: 'all',
                                                        id: 'strZona'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Email',
                                                        name: 'strEmail',
                                                        vtype: 'email',
                                                        emptyText: 'Email....',
                                                        width: 230,
                                                        id: 'strEmail'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Guardar',
                                                        iconCls: 'btnGuardar',
                                                        id: 'btn_AdicionarItemAgendaManual'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        tooltip: 'Limpiar Datos del Paciente',
                                                        iconCls: 'btnLimpiar',
                                                        id: 'btnNuevoAgendaManual'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: 'Datos del Cliente y del Solicitante',
                                layout: 'form',
                                width: 949,
                                autoHeight: true,
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                id: 'fsCliente',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Cliente',
                                                style: 'text-transform:uppercase;',
                                                width: 60,
                                                allowBlank: false,
                                                id: 'sysCliente',
                                                listeners: {
                                                    specialkey: function(f,e){
                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB && (Ext.getCmp('sysCliente').getValue() !== null && Ext.getCmp('sysCliente').getValue() !== "")){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/util/controlador_varios.php',
                                                                params:{
                                                                    task: 'BUSCAR_CLIENTE',
                                                                    pCliente: Ext.getCmp('sysCliente').getValue(),
                                                                    pEmpresa: Ext.getCmp('sysIdEmpresa').getValue(),
                                                                    pIPS: Ext.getCmp('sysIdIPS').getValue()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                        Ext.getCmp('sysCliente').setValue(null);
                                                                        Ext.getCmp('sysClienteInfo').setValue(null);
                                                                        Ext.getCmp('intCliente').setValue(0);
                                                                        Ext.getCmp('sysPlan').setValue(null);
                                                                        Ext.getCmp('sysPlanInfo').setValue(null);
                                                                        Ext.getCmp('intPlan').setValue(0);
                                                                        Ext.getCmp('sysPlan').setDisabled(true);
                                                                        Ext.getCmp('sysSubPlan').setValue(null);
                                                                        Ext.getCmp('sysSubPlanInfo').setValue(null);
                                                                        Ext.getCmp('intSubPlan').setValue(0);
                                                                        Ext.getCmp('intSubPlan').setDisabled(true);
                                                                        Ext.getCmp('sysContrato').setValue(null);
                                                                        Ext.getCmp('sysContratoInfo').setValue(null);
                                                                        Ext.getCmp('intContrato').setValue(0);
                                                                        Ext.getCmp('intContrato').setDisabled(true);
                                                                        Ext.getCmp('fCodConcepto').setValue(null);
                                                                        Ext.getCmp('fCodConcepto').setDisabled(true);
                                                                        Ext.getCmp('fDesConcepto').setValue(null);
                                                                        Ext.getCmp('fVlrUnitario').setValue(0);
                                                                        Ext.getCmp('fidConcepto').setValue(0);
                                                                        Ext.getCmp('sysProfesional').setValue(null);
                                                                        Ext.getCmp('sysProfesionalCitaInfo').setValue(null);
                                                                        Ext.getCmp('intProfesional').setValue(0);
                                                                        Ext.getCmp('sysProfesional').setDisabled(true);
                                                                        Ext.getCmp('fecFechaAgenda').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita').setDisabled(false);
                                                                    } else {
                                                                        Ext.getCmp('intCliente').setValue(Contenido[0]);
                                                                        Ext.getCmp('sysClienteInfo').setValue(Contenido[1]);
                                                                        Ext.getCmp('sysPlan').setDisabled(false);
                                                                        Ext.getCmp('sysContrato').setDisabled(false);
                                                                        Ext.getCmp('sysPlan').focus();
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.getCmp('sysCliente').setValue(null);
                                                                    Ext.getCmp('sysClienteInfo').setValue(null);
                                                                    Ext.getCmp('intCliente').setValue(0);
                                                                    Ext.getCmp('sysPlan').setValue(null);
                                                                    Ext.getCmp('sysPlanInfo').setValue(null);
                                                                    Ext.getCmp('intPlan').setValue(0);
                                                                    Ext.getCmp('sysPlan').setDisabled(true);
                                                                    Ext.getCmp('sysSubPlan').setValue(null);
                                                                    Ext.getCmp('sysSubPlanInfo').setValue(null);
                                                                    Ext.getCmp('intSubPlan').setValue(0);
                                                                    Ext.getCmp('intSubPlan').setDisabled(true);
                                                                    Ext.getCmp('sysContrato').setValue(null);
                                                                    Ext.getCmp('sysContratoInfo').setValue(null);
                                                                    Ext.getCmp('intContrato').setValue(0);
                                                                    Ext.getCmp('intContrato').setDisabled(true);
                                                                    Ext.getCmp('fCodConcepto').setValue(null);
                                                                    Ext.getCmp('fCodConcepto').setDisabled(true);
                                                                    Ext.getCmp('fDesConcepto').setValue(null);
                                                                    Ext.getCmp('fVlrUnitario').setValue(0);
                                                                    Ext.getCmp('fidConcepto').setValue(0);
                                                                    Ext.getCmp('sysProfesional').setValue(null);
                                                                    Ext.getCmp('sysProfesionalInfo').setValue(null);
                                                                    Ext.getCmp('intProfesional').setValue(0);
                                                                    Ext.getCmp('sysProfesional').setDisabled(true);
                                                                    Ext.getCmp('fecFechaAgenda').setDisabled(false);
                                                                    Ext.getCmp('strHoraCita').setDisabled(false);
                                                                },
                                                                scope:this 
                                                            });
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                html: '-'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 717,
                                                allowBlank: true,
                                                readOnly: true,
                                                disabled: true,
                                                id: 'sysClienteInfo'
                                            },
                                            {
                                                xtype: 'button',
                                                tooltip: 'Buscar',
                                                iconCls: 'btnBuscar',
                                                listeners: {
                                                    click: function(){
                                                        buscargeneral("intCliente","sysClienteInfo","sysCliente","SEARCH_CLIENTES_BARRA001");
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'intCliente'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Plan',
                                                style: 'text-transform:uppercase;',
                                                width: 60,
                                                allowBlank: false,
                                                disabled: true,
                                                id: 'sysPlan',
                                                listeners: {
                                                    specialkey: function(f,e){
                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB && (Ext.getCmp('sysPlan').getValue() !== null && Ext.getCmp('sysPlan').getValue() !== "")){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/util/controlador_varios.php',
                                                                params:{
                                                                    task: 'BUSCAR_PLAN',
                                                                    pCliente: Ext.getCmp('intCliente').getValue(),
                                                                    pPlan: Ext.getCmp('sysPlan').getValue()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                        Ext.getCmp('sysPlan').setValue(null);
                                                                        Ext.getCmp('sysPlanInfo').setValue(null);
                                                                        Ext.getCmp('intPlan').setValue(0);
                                                                        Ext.getCmp('sysSubPlan').setValue(null);
                                                                        Ext.getCmp('sysSubPlanInfo').setValue(null);
                                                                        Ext.getCmp('intSubPlan').setValue(0);
                                                                        Ext.getCmp('intSubPlan').setDisabled(true);
                                                                        Ext.getCmp('fCodConcepto').setValue(null);
                                                                        Ext.getCmp('fCodConcepto').setDisabled(true);
                                                                        Ext.getCmp('fDesConcepto').setValue(null);
                                                                        Ext.getCmp('fVlrUnitario').setValue(0);
                                                                        Ext.getCmp('fidConcepto').setValue(0);
                                                                    } else {
                                                                        Ext.getCmp('intPlan').setValue(Contenido[0]);
                                                                        Ext.getCmp('sysPlanInfo').setValue(Contenido[1]);
                                                                        Ext.getCmp('sysSubPlan').setDisabled(false);
                                                                        Ext.getCmp('sysSubPlan').focus();
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.getCmp('sysPlan').setValue(null);
                                                                    Ext.getCmp('sysPlanInfo').setValue(null);
                                                                    Ext.getCmp('intPlan').setValue(0);
                                                                    Ext.getCmp('sysSubPlan').setValue(null);
                                                                    Ext.getCmp('sysSubPlanInfo').setValue(null);
                                                                    Ext.getCmp('intSubPlan').setValue(0);
                                                                    Ext.getCmp('intSubPlan').setDisabled(true);
                                                                    Ext.getCmp('fCodConcepto').setValue(null);
                                                                    Ext.getCmp('fCodConcepto').setDisabled(true);
                                                                    Ext.getCmp('fDesConcepto').setValue(null);
                                                                    Ext.getCmp('fVlrUnitario').setValue(0);
                                                                    Ext.getCmp('fidConcepto').setValue(0);
                                                                },
                                                                scope:this 
                                                            });
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                html: '-'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 717,
                                                allowBlank: true,
                                                readOnly: true,
                                                disabled: true,
                                                id: 'sysPlanInfo'
                                            },
                                            {
                                                xtype: 'button',
                                                tooltip: 'Buscar',
                                                iconCls: 'btnBuscar'
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'intPlan'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'SubPlan',
                                                style: 'text-transform:uppercase;',
                                                width: 60,
                                                allowBlank: false,
                                                disabled: true,
                                                id: 'sysSubPlan',
                                                listeners: {
                                                    specialkey: function(f,e){
                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB && (Ext.getCmp('sysSubPlan').getValue() !== null && Ext.getCmp('sysSubPlan').getValue() !== "")){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/util/controlador_varios.php',
                                                                params:{
                                                                    task: 'BUSCAR_SUBPLAN',
                                                                    pSubPlan: Ext.getCmp('sysSubPlan').getValue(),
                                                                    pPlan: Ext.getCmp('intPlan').getValue()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                        Ext.getCmp('sysSubPlan').setValue(null);
                                                                        Ext.getCmp('sysSubPlanInfo').setValue(null);
                                                                        Ext.getCmp('intSubPlan').setValue(0);
                                                                        Ext.getCmp('fCodConcepto').setValue(null);
                                                                        Ext.getCmp('fCodConcepto').setDisabled(true);
                                                                        Ext.getCmp('fDesConcepto').setValue(null);
                                                                        Ext.getCmp('fVlrUnitario').setValue(0);
                                                                        Ext.getCmp('fidConcepto').setValue(0);
                                                                    } else {
                                                                        Ext.getCmp('intSubPlan').setValue(Contenido[0]);
                                                                        Ext.getCmp('sysSubPlanInfo').setValue(Contenido[1]);
                                                                        Ext.getCmp('fCodConcepto').setDisabled(false);
                                                                        Ext.getCmp('sysContrato').focus();
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.getCmp('sysSubPlan').setValue(null);
                                                                    Ext.getCmp('sysSubPlanInfo').setValue(null);
                                                                    Ext.getCmp('intSubPlan').setValue(0);
                                                                    Ext.getCmp('fCodConcepto').setValue(null);
                                                                    Ext.getCmp('fCodConcepto').setDisabled(true);
                                                                    Ext.getCmp('fDesConcepto').setValue(null);
                                                                    Ext.getCmp('fVlrUnitario').setValue(0);
                                                                    Ext.getCmp('fidConcepto').setValue(0);
                                                                },
                                                                scope:this 
                                                            });
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                html: '-'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 717,
                                                allowBlank: true,
                                                readOnly: true,
                                                disabled: true,
                                                id: 'sysSubPlanInfo'
                                            },
                                            {
                                                xtype: 'button',
                                                tooltip: 'Buscar',
                                                iconCls: 'btnBuscar'
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'intSubPlan'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Contrato',
                                                style: 'text-transform:uppercase;',
                                                width: 60,
                                                disabled: true,
                                                allowBlank: false,
                                                id: 'sysContrato',
                                                listeners: {
                                                    specialkey: function(f,e){
                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB && (Ext.getCmp('sysContrato').getValue() !== null && Ext.getCmp('sysContrato').getValue() !== "")){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/util/controlador_varios.php',
                                                                params:{
                                                                    task: 'BUSCAR_CONTRATO',
                                                                    pContrato: Ext.getCmp('sysContrato').getValue(),
                                                                    pCliente: Ext.getCmp('intCliente').getValue()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                        Ext.getCmp('sysContrato').setValue(null);
                                                                        Ext.getCmp('sysContratoInfo').setValue(null);
                                                                        Ext.getCmp('intContrato').setValue(0);
                                                                    } else {
                                                                        Ext.getCmp('intContrato').setValue(Contenido[0]);
                                                                        Ext.getCmp('sysContratoInfo').setValue(Contenido[1]);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.getCmp('sysContrato').setValue(null);
                                                                    Ext.getCmp('sysContratoInfo').setValue(null);
                                                                    Ext.getCmp('intContrato').setValue(0);
                                                                },
                                                                scope:this 
                                                            });
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                html: '-'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 717,
                                                allowBlank: true,
                                                readOnly: true,
                                                disabled: true,
                                                id: 'sysContratoInfo'
                                            },
                                            {
                                                xtype: 'button',
                                                tooltip: 'Buscar',
                                                iconCls: 'btnBuscar'
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'intContrato'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Autorización',
                                                anchor: '100%',
                                                name: 'txtAutorizacion',
                                                style: 'text-transform:uppercase;',
                                                allowBlank: true,
                                                //disabled: true,
                                                id: 'strAutorizacion'
                                            },
                                            {
                                                html: 'Fecha Solicitud'
                                            },
                                            {
                                                xtype: 'datefield',
                                                width: 130,
                                                name: 'txtFecSol',
                                                allowBlank: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                value: new Date().format('d/m/Y'),
                                                id: 'fecFecSol'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Concepto',
                                                style: 'text-transform:uppercase;',
                                                allowBlank: false,
                                                disabled: true,
                                                width: 120,
                                                value: 'FISIO030',
                                                id: 'fCodConcepto',
                                                listeners: {
                                                    specialkey: function(f,e){
                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB && (Ext.getCmp('fCodConcepto').getValue() !== null && Ext.getCmp('fCodConcepto').getValue() !== "")){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/util/controlador_varios.php',
                                                                params:{
                                                                    task: 'BUSCAR_CONCEPTO',
                                                                    pCliente: Ext.getCmp('intCliente').getValue(),
                                                                    pPlan: Ext.getCmp('intPlan').getValue(),
                                                                    pSubPlan: Ext.getCmp('intSubPlan').getValue(),
                                                                    pConcepto: Ext.getCmp('fCodConcepto').getValue()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                        Ext.getCmp('fCodConcepto').setValue(null);
                                                                        Ext.getCmp('fDesConcepto').setValue(null);
                                                                        Ext.getCmp('fVlrUnitario').setValue(0);
                                                                        Ext.getCmp('fidConcepto').setValue(0);
                                                                        Ext.getCmp('sysProfesional').setValue(null);
                                                                        Ext.getCmp('sysProfesionalCitaInfo').setValue(null);
                                                                        Ext.getCmp('intProfesional').setValue(0);
                                                                        Ext.getCmp('sysProfesional').setDisabled(true);
                                                                        Ext.getCmp('fecFechaAgenda').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita').setDisabled(false);
                                                                    } else {
                                                                        Ext.getCmp('fidConcepto').setValue(Contenido[0]);
                                                                        Ext.getCmp('fDesConcepto').setValue(Contenido[1]);
                                                                        Ext.getCmp('fVlrUnitario').setValue(Contenido[2]);
                                                                        Ext.getCmp('sysProfesional').setDisabled(false);
                                                                        Ext.getCmp('sysProfesional').focus();
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.getCmp('fCodConcepto').setValue(null);
                                                                    Ext.getCmp('fDesConcepto').setValue(null);
                                                                    Ext.getCmp('fVlrUnitario').setValue(0);
                                                                    Ext.getCmp('fidConcepto').setValue(0);
                                                                    Ext.getCmp('sysProfesional').setValue(null);
                                                                    Ext.getCmp('sysProfesionalCitaInfo').setValue(null);
                                                                    Ext.getCmp('intProfesional').setValue(0);
                                                                    Ext.getCmp('sysProfesional').setDisabled(true);
                                                                    Ext.getCmp('fecFechaAgenda').setDisabled(false);
                                                                    Ext.getCmp('strHoraCita').setDisabled(false);
                                                                },
                                                                scope:this 
                                                            });
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                html: '-'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 657,
                                                allowBlank: true,
                                                readOnly: true,
                                                disabled: true,
                                                id: 'fDesConcepto'
                                            },
                                            {
                                                xtype: 'button',
                                                tooltip: 'Buscar',
                                                iconCls: 'btnBuscar',
                                                id: 'btnSearchConcepto_Citas'
                                            },
                                            {
                                                xtype: 'hidden',
                                                flex: 1,
                                                readOnly: true,
                                                width: 120,
                                                style: 'color: #0000cc; font-weight: bold;',
                                                id: 'fVlrUnitario'
                                            },
                                            {
                                                xtype: 'hidden',
                                                flex: 1,
                                                readOnly: true,
                                                width: 120,
                                                id: 'fidConcepto'
                                            },
                                            {
                                                xtype: 'hidden',
                                                flex: 1,
                                                readOnly: true,
                                                width: 120,
                                                id: 'strTipoRegistroDetalle'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: 'Profesional, Fecha y Hora Asignacion Cita',
                                layout: 'form',
                                width: 949,
                                autoHeight: true,
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Profesional',
                                                width: 110,
                                                allowBlank: false,
                                                disabled: true,
                                                id: 'sysProfesional',
                                                listeners: {
                                                    specialkey: function(f,e){
                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB && (Ext.getCmp('sysProfesional').getValue() !== null && Ext.getCmp('sysProfesional').getValue() !== "")){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/util/controlador_varios.php',
                                                                params:{
                                                                    task: 'BUSCAR_PROFESIONAL',
                                                                    pConcepto: Ext.getCmp('fidConcepto').getValue(),
                                                                    pProfesional: Ext.getCmp('sysProfesional').getValue()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                        //Ext.getCmp('fecFechaAgenda').setValue(null);
                                                                        //Ext.getCmp('fecFechaAgenda').setDisabled(true);
                                                                        //Ext.getCmp('strHoraCita').setValue(null);
                                                                        //Ext.getCmp('strHoraCita').setDisabled(true);
                                                                        Ext.getCmp('sysProfesional').setValue(null);
                                                                        Ext.getCmp('sysProfesionalCitaInfo').setValue(null);
                                                                        Ext.getCmp('intProfesional').setValue(0);
                                                                    } else {
                                                                        Ext.getCmp('fecFechaAgenda').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda1').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita1').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda2').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita2').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda3').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita3').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda4').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita4').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda5').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita5').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda6').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita6').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda7').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita7').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda8').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita8').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda9').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita9').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda10').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita10').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda11').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita11').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda12').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita12').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda13').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita13').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda14').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita14').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda15').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita15').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda16').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita16').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda17').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita17').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda18').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita18').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda19').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita19').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda20').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita20').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda21').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita21').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda22').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita22').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda23').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita23').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda24').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita24').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda25').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita25').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda26').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita26').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda27').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita27').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda28').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita28').setDisabled(false);
                                                                        Ext.getCmp('fecFechaAgenda29').setDisabled(false);
                                                                        Ext.getCmp('strHoraCita29').setDisabled(false);
                                                                        Ext.getCmp('sysProfesionalCitaInfo').setValue(Contenido[1]);
                                                                        Ext.getCmp('intProfesional').setValue(Contenido[0]);
                                                                        Ext.getCmp('fecFechaAgenda').focus();
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    //Ext.getCmp('fecFechaAgenda').setValue(null);
                                                                    //Ext.getCmp('fecFechaAgenda').setDisabled(true);
                                                                    //Ext.getCmp('strHoraCita').setValue(null);
                                                                    //Ext.getCmp('strHoraCita').setDisabled(true);
                                                                    Ext.getCmp('sysProfesional').setValue(null);
                                                                    Ext.getCmp('sysProfesionalCitaInfo').setValue(null);
                                                                    Ext.getCmp('intProfesional').setValue(0);
                                                                },
                                                                scope:this 
                                                            });
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                html: '-'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 642,
                                                allowBlank: true,
                                                readOnly: true,
                                                disabled: true,
                                                id: 'sysProfesionalCitaInfo'
                                            },
                                            {
                                                xtype: 'button',
                                                tooltip: 'Buscar',
                                                iconCls: 'btnBuscar'
                                            },
                                            {
                                                xtype: 'button',
                                                tooltip: 'Imprimir Agenda',
                                                iconCls: 'btnImprimir'
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'intProfesional'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield', //rafa
                                                width: 90,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                allowBlank: false,
                                                forceSelection: true,
                                                disabled: true,
                                                minValue: '07:00 AM',
                                                maxValue: '07:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                value: 'Información Adicional Cita:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                id: 'strInfoAddHoraCita'
                                            },
                                            {
                                                html:'<b style="color: #ff3333;">A Solicitud Pac:</b>&nbsp;',
                                                border: false
                                            },
                                            {
                                                xtype: 'checkbox',
                                                anchor: '100%',
                                                value: 'true',
                                                id: 'bolAsignaCitasSolicitudUsuario'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Asignar Cita',
                                                iconCls: 'btnAsignarCita',
                                                id: 'btnAsignarCita'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda1'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita1'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda2'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita2'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda3'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita3'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda4'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita4'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda5'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita5'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda6'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita6'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda7'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita7'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda8'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita8'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda9'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita9'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda10'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita10'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda11'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita11'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda12'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita12'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda13'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita13'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda14'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita14'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda15'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita15'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda16'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita16'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda17'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita17'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda18'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita18'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda19'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita19'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda20'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita20'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda21'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita21'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda22'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita22'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda23'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita23'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda24'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita24'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda25'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita25'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda26'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita26'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda27'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita27'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda28'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita28'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                fieldLabel: 'Fecha Agenda',
                                                width: 120,
                                                allowBlank: false,
                                                disabled: true,
                                                style: 'text-align:center;',
                                                emptyText: '(dia/mes/año) ',
                                                id: 'fecFechaAgenda29'
                                            },
                                            {
                                                html: 'Hora Cita'
                                            },
                                            {
                                                xtype: 'timefield',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: true,
                                                store: stHorasCitas,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'strHoraCita29'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Legalizar Citas',
                        height: screen.height-240,
                        //width: 951,
                        frame: true,
                        border: false,
                        layout: 'fit',
                        id: 'fichaLegaliza',
                        listeners:{
                            beforeshow : function(){
                                Ext.getCmp('intPacienteLegalizacion').setValue(Ext.getCmp('intIdPaciente').getValue());
                                Ext.getCmp('sysPacienteLegalizacion').setValue(Ext.getCmp('strApe1').getValue() + " " + Ext.getCmp('strApe2').getValue() + " " + Ext.getCmp('strNom1').getValue() + " " + Ext.getCmp('strNom2').getValue());
                            }
                        },
                        tbar:{
                            items: [
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasAsignadas',
                                    text: 'Ver Historial Citas',
                                    tooltip: 'Ver Historial de Citas Asignadas por Paciente',
                                    id: 'btnVerHistorialCitas_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasCanceladas',
                                    text: 'Ver Historial Cancelaciones',
                                    tooltip: 'Ver Historial de Citas Canceladas por Paciente',
                                    id: 'btnVerHistorialCanceladas_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasInasistencia',
                                    text: 'Ver Historial Inasistencias',
                                    tooltip: 'Ver Historial de Citas Inasistidas por Paciente',
                                    id: 'btnVerHistorialInasistencia_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                anchor: '99%',
                                frame: true,
                                border: false,
                                id: 'infoPac_Citas1',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        id: 'intPacienteLegalizacion',
                                        value: 0
                                    },
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'displayfield',
                                                value: 'Paciente:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 800,
                                                readOnly: true,
                                                allowBlank: true,
                                                emptyText: 'Debe Buscar Paciente....',
                                                id: 'sysPacienteLegalizacion'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Paciente',
                                                id: 'btnBuscarPacienteLegalizacion'
                                            },
                                            {
                                                xtype: 'button',
                                                tooltip: 'Limpiar Datos del Paciente',
                                                iconCls: 'btnLimpiar',
                                                id: 'btnLimpiarPacienteLegalizacion'
                                            }
                                        ]
                                    },
                                    {
                                        html:'<hr>',
                                        border: false
                                    },
                                    {
                                        xtype: 'grid',
                                        id: 'gridLegalizarCitas',
                                        store: stGridCitasxLegalizar,
                                        anchor: "100%",
                                        height: 450,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        stripeRows: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                header: 'CAS',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'CAS',
                                                width: 100,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Fecha',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'FechaCita',
                                                width: 80,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Hora',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'HoraAgenda',
                                                width: 110,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Hora Estimada',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'HoraAtencion',
                                                width: 80,
                                                hideable: false
                                            },
                                            {
                                                header: 'Profesional',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Profesional',
                                                width: 280,
                                                hideable: false
                                            },
                                            {
                                                header: 'Cliente',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Cliente',
                                                width: 250,
                                                hideable: false
                                            },
                                            {
                                                header: 'Actividad',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Actividad',
                                                width: 280,
                                                hideable: false
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                        view: new Ext.ux.grid.LockingGridView(),
                                        columnLines: true,
                                        tbar:{
                                            items: [
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    iconCls: 'btnCitasLegalizacion',
                                                    text: 'Ver Historial Legalizaciones',
                                                    tooltip: 'Ver Historial de Citas Legalizadas por Paciente',
                                                    id: 'btnHistorialLegalizaciones_citas'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Citas Pendientes por Legalizar',
                                                    iconCls: 'btnCitasBuscar',
                                                    id: 'btnCitasxLegalizar'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        },
                                        bbar:{
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    text: 'Legalizar Cita',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Legalizar la Cita Seleccionada',
                                                    id: 'btnLegalizarCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Cancelar Cita',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Cancelar la Cita Seleccionada',
                                                    id: 'btnCancelarCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Marcar Cita Inasistente',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Marcar Inasistente la Cita Seleccionada',
                                                    id: 'btnInasistenciaCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winBaraServiciosUi.superclass.initComponent.call(this);
    }
});

function CargarDatosUltimaAsignacion(wIdPaciente){
    Ext.Ajax.request({
        url: '../../controlador/util/controlador_varios.php',
        params:{
            task: 'BUSCAR_DATOS ULTIMAASIGNA',
            pPaciente: wIdPaciente
        },
        success: function(response,options)
        {
            var Respuesta = response.responseText;
            //alert(Respuesta);
            var Contenido = Respuesta.split('^');
            if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                //Nada
            } else {
                Ext.getCmp('sysCliente').setValue(Contenido[0]);
                Ext.getCmp('sysClienteInfo').setValue(Contenido[2]);
                Ext.getCmp('intCliente').setValue(Contenido[1]);
                Ext.getCmp('sysPlan').setValue(Contenido[3]);
                Ext.getCmp('sysPlanInfo').setValue(Contenido[5]);
                Ext.getCmp('intPlan').setValue(Contenido[3]);
                Ext.getCmp('sysSubPlan').setValue(Contenido[6]);
                Ext.getCmp('sysSubPlanInfo').setValue(Contenido[8]);
                Ext.getCmp('intSubPlan').setValue(Contenido[7]);
                Ext.getCmp('sysContrato').setValue(Contenido[9]);
                Ext.getCmp('sysContratoInfo').setValue(Contenido[11]);
                Ext.getCmp('intContrato').setValue(Contenido[10]);
            }
        },
        failure: function(response,options){
            //Nada
        },
        scope:this 
    });
}