/*
* @category    Formulario Inasistencia Cita
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winInasistenciaCitaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Inasistencia Cita ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winInasistenciaCita',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmInansistenciaCita',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        html: '<img src="../../../resources/varios/agendainasistencia.png" align="left" alt=""/>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioAgendaManualInasistencia'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'idAgenda',
                        id: 'sysIdAgendaManualInasistencia'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCASAgendaManualInasistencia'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaManualInasistencia'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Fecha',
                        id: 'sysFechaAgendaManualInasistencia'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Hora',
                        id: 'sysHoraAgendaManualInasistencia'
                    },
                    {
                        xtype: 'displayfield',
                        value: ' '
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'Motivo',
                        name: 'strMotivo',
                        maxLength: 250,
                        allowBlank: false,
                        emptyText: 'Digite el Motivo de la Inasistencia...!',
                        id: 'strMotivoAgendaManualInasistencia'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Inasistencia Cita',
                            iconCls: 'btnInasistencia',
                            id: 'btnInasistencia_Cita',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmInansistenciaCita').getForm();
                                    if (frm.isValid())
                                    {
                                        frm.submit({
                                            url: '../../controlador/profesionales/controlador_profesionales.php',
                                            params: {
                                                task: 'AGENDA_MANUAL_INASISTENCIA',
                                                pIdAgenda: Ext.getCmp('sysIdAgendaManualInasistencia').getValue(),
                                                pCAS: Ext.getCmp('sysCASAgendaManualInasistencia').getValue(),
                                                pMotivo: QuitarAcentosMayusculas(Ext.getCmp('strMotivoAgendaManualInasistencia').getValue()),
                                                pUsuario: Ext.getCmp('sysUsuarioAgendaManualInasistencia').getValue()
                                            },
                                            success: function(res,req)
                                            {
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        try {
                                                            var campo1 = Ext.getCmp('gridFormularioCitasManual');
                                                            if ( campo1 != null ) {
                                                                Ext.getCmp('gridFormularioCitasManual').store.reload();
                                                            }
                                                            var campo2 = Ext.getCmp('gridFormulario');
                                                            if ( campo2 != null ) {
                                                                Ext.getCmp('gridFormulario').store.reload();
                                                            }
                                                        }catch(ex) {
                                                            // aqui se atrapo el error y se le puede mandar un mensaje al usuario o hacer alguna acción que controle el error.
                                                            //Ext.Msg('El campo no se encontro,' + ex.Message);
                                                        }
                                                        Ext.getCmp('winInasistenciaCita').close();
                                                        Ext.MessageBox.show({
                                                            title: 'Inasistencia Citas',
                                                            msg: 'Se Marco Como Inasistente a la Cita con Exito.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'Inasistencia Citas',
                                                            msg: 'Ocurrio un error al marcar inasistente la cita o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos Marcar Inasistente la Cita en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'El Motivo de la Inasistencia es Requerido',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winInasistenciaCitaUi.superclass.initComponent.call(this);
    }
});
