/*
* @category    Formulario Grid Agenda Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmVerAgendaUi = Ext.extend(Ext.Window, {
    //title: 'OfiClinic© Web..! .:: Agenda por Profesional ::.',
    id: 'winFrmVerAgenda',
    closable:false,
    draggable : false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    padding: 5,
    maximized: true,
    frame: true,
    layout: 'form',
    initComponent: function() {
        function VerHora(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            return value + '<br><span style="color: darkblue; font-weight:bold; text-align:center;">' + record.get('HoraCitaInfAdd');
	}
        function VerDescripcion(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        function VerPaciente(value, metaData, record, rowIndex, colIndex, store){  
            var observaEstado = "";
            if(record.get('EstadoReg')=='C'){
                observaEstado = '</br></br><span style="color: #002953; font-weight:bolder;">Cita Cancelada: ' + record.get('ObservacionesEstado') + '</span>';
            }
            if(record.get('EstadoReg')=='I'){
                observaEstado = '</br></br><span style="color: #002953; font-weight:bolder;">Cita Inasistente: ' + record.get('ObservacionesEstado') + '</span>';
            }
            metaData.attr = 'style="white-space:normal"';  
            return '<p>' + record.get('TipDoc') + '-' + record.get('Documento') + '</br>' + record.get('PrimerNombre') + ' ' + record.get('SegundoNombre') + ' ' + record.get('PrimerApellido') + ' ' + record.get('SegundoApellido') + '</br></br><span style="color:brown;">Telefonos: ' + record.get('Telefono') + ' - ' + record.get('Telefono1') + '</span>' + observaEstado;  
        }
        
        function VerCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('DescAdiHora');  
        }
        
        function VerCliente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('Cliente') + '</br>' + record.get('Actividad') + '</br>Programa: ' + record.get('Programa');  
        }
        var stGridCitasxLegalizar = new StoreGridCitasManualxLegalizar();
        var mybbar = new utilBbarUi();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'tabpanel',
                //width: 990,
                height: screen.height,
                border: false,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Asignación de Citas',
                        height: screen.height-240,
                        //width: 951,
                        frame: true,
                        border: false,
                        layout: 'form',
                        id: 'fichaDatos',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Profesional',
                                allowBlank: true,
                                store: 'StoreProfesionales',
                                forceSelection: true,
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                emptyText: 'Seleccione Profesional....',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                anchor: '100%',
                                submitValue: true,
                                id: 'sysProfeAgendaCitasManual'
                            },
                            {
                                xtype: 'datefield',
                                fieldLabel: 'Fecha Agenda',
                                width: 120,
                                allowBlank: false,
                                style: 'text-align:center;',
                                emptyText: '(dia/mes/año) ',
                                id: 'sysFechaAgendaCitasManual'
                            },
                            {
                                xtype: 'grid',
                                id: 'gridFormularioCitasManual',
                                store: 'StoreProfesionalesAgendaManual',
                                layout: 'fit',
                                anchor: "100%",
                                height: screen.height-250,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    new Ext.grid.RowNumberer(),
                                    {
                                        header: 'CAS',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'CAS',
                                        width: 100,
                                        align: 'center',
                                        hideable: false
                                    },
                                    {
                                        header: 'Hora',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'HoraCita',
                                        renderer: VerHora,
                                        width: 110,
                                        align: 'center',
                                        hideable: false
                                    },
                                    {
                                        header: 'Paciente',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Paciente',
                                        width: 350,
                                        renderer: VerPaciente,
                                        hideable: false
                                    },
                                    {
                                        header: 'Cliente',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Cliente',
                                        renderer: VerDescripcion,
                                        width: 260,
                                        hideable: false
                                    },
                                    {
                                        header: 'Actividad Agendada',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'DesProced',
                                        renderer: VerDescripcion,
                                        width: 290,
                                        hideable: false
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                view: new Ext.ux.grid.LockingGridView(),
                                columnLines: true,
                                tbar:
                                    {
                                        xtype: 'toolbar',
                                        items: [
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Asignar Cita',
                                                iconCls: 'btnProgramarAgenda',
                                                tooltip: 'Asignar Cita',
                                                id: 'btnAsignarCitasManual'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'cycle',
                                                prependText: 'Vista por: ',
                                                iconCls: 'btnBuscar',
                                                showText: true,
                                                id: 'btnViewAsignarCitasManual',
                                                items: [
                                                    {
                                                        text:'Citas Asignadas',
                                                        checked:true
                                                    },
                                                    {
                                                        text:'Citas Canceladas'
                                                    },
                                                    {
                                                        text:'Citas Inasistentes'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Actualizar Agenda',
                                                iconCls: 'btnActualizarGrid',
                                                tooltip: 'Actualizar Agenda',
                                                id: 'btnActualizarAgendaCitasManual'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'tbfill'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Cancelar Cita',
                                                iconCls: 'btnAsignarCita',
                                                tooltip: 'Cancelar la Cita Seleccionada',
                                                id: 'btnCancelarCitasManual'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Marcar Cita Inasistente',
                                                iconCls: 'btnAsignarCita',
                                                tooltip: 'Marcar Inasistente la Cita Seleccionada',
                                                id: 'btnInasistenciaCitasManual'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Imprimir Agenda',
                                                iconCls: 'btnImprimir',
                                                tooltip: 'Imprimir Agenda',
                                                id: 'btnPrintAgendaCitasManual'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            }
                                        ]
                                    }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Legalizar Citas',
                        height: screen.height-240,
                        //width: 951,
                        frame: true,
                        border: false,
                        layout: 'fit',
                        id: 'fichaLegaliza',
                        tbar:{
                            items: [
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasAsignadas',
                                    text: 'Ver Historial Citas',
                                    tooltip: 'Ver Historial de Citas Asignadas por Paciente',
                                    id: 'btnVerHistorialCitas_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasCanceladas',
                                    text: 'Ver Historial Cancelaciones',
                                    tooltip: 'Ver Historial de Citas Canceladas por Paciente',
                                    id: 'btnVerHistorialCanceladas_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasInasistencia',
                                    text: 'Ver Historial Inasistencias',
                                    tooltip: 'Ver Historial de Citas Inasistidas por Paciente',
                                    id: 'btnVerHistorialInasistencia_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                anchor: '99%',
                                frame: true,
                                border: false,
                                id: 'infoPac_Citas1',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        id: 'intPacienteLegalizacion',
                                        value: 0
                                    },
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'displayfield',
                                                value: 'Paciente:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 800,
                                                readOnly: true,
                                                allowBlank: true,
                                                emptyText: 'Debe Buscar Paciente....',
                                                id: 'sysPacienteLegalizacion'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Paciente',
                                                id: 'btnBuscarPacienteLegalizacion'
                                            },
                                            {
                                                xtype: 'button',
                                                tooltip: 'Limpiar Datos del Paciente',
                                                iconCls: 'btnLimpiar',
                                                id: 'btnLimpiarPacienteLegalizacion'
                                            },
                                        ]
                                    },
                                    {
                                        html:'<hr>',
                                        border: false
                                    },
                                    {
                                        xtype: 'grid',
                                        id: 'gridLegalizarCitas',
                                        store: stGridCitasxLegalizar,
                                        anchor: "100%",
                                        height: 450,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        stripeRows: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                header: 'CAS',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'CAS',
                                                width: 100,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Fecha',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'FechaCita',
                                                width: 80,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Hora',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'HoraAgenda',
                                                width: 110,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Hora Estimada',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'HoraAtencion',
                                                width: 80,
                                                hideable: false
                                            },
                                            {
                                                header: 'Profesional',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Profesional',
                                                width: 280,
                                                hideable: false
                                            },
                                            {
                                                header: 'Cliente',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Cliente',
                                                width: 250,
                                                hideable: false
                                            },
                                            {
                                                header: 'Actividad',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Actividad',
                                                width: 280,
                                                hideable: false
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                        view: new Ext.ux.grid.LockingGridView(),
                                        columnLines: true,
                                        tbar:{
                                            items: [
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    iconCls: 'btnCitasLegalizacion',
                                                    text: 'Ver Historial Legalizaciones',
                                                    tooltip: 'Ver Historial de Citas Legalizadas por Paciente',
                                                    id: 'btnHistorialLegalizaciones_citas'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Citas Pendientes por Legalizar',
                                                    iconCls: 'btnCitasBuscar',
                                                    id: 'btnCitasxLegalizar'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        },
                                        bbar:{
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    text: 'Legalizar Cita',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Legalizar la Cita Seleccionada',
                                                    id: 'btnLegalizarCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Cancelar Cita',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Cancelar la Cita Seleccionada',
                                                    id: 'btnCancelarCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Marcar Cita Inasistente',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Marcar Inasistente la Cita Seleccionada',
                                                    id: 'btnInasistenciaCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        winFrmVerAgendaUi.superclass.initComponent.call(this);
    }
});








