/*
* @category    Formulario Barra de Servicios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var xbtnValidarDoc = new btnValidarDoc({
    id: 'btnValidarDoc',
    ref: '../../../../../../btnValidarDoc'
});

winBaraServiciosUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©      .:: Barra de Servicios ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winBaraServicios',
    initComponent: function() {
        
        var stGridProfesionalesCitas = new StoreGridProfesionalesCitas();
        var stGridConsultoriosCitas = new StoreGridConsultoriosCitas();
        var stGridAgendasDisponiblesCitas = new StoreGridAgendasDisponiblesCitas();
        var stGridHoarariosxAgendaDisponiblesCitas = new StoreGridHoarariosxAgendaDisponiblesCitas();
        var stGridCitasxLegalizar = new StoreGridCitasxLegalizar();
        
        var controlCampos = false;
        
        function renderFechaAgenda(value, p, record){
            return String.format(
                value + ' - ' + FormatoFechaLarga(value),
                value);
        }
        
        var xg = Ext.grid;
               
        var chkColumnSeleccionarHorario = new xg.CheckColumn({
           header: ' ',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionarHorario',
           value: false,
           width: 10
        });
        
        var strcitaInfoAdd = new Ext.form.TextField();
        
        this.items = [
            {
                xtype: 'tabpanel',
                width: 990,
                height: 585,
                border: false,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Identificación del Servicio',
                        height: 441,
                        width: 951,
                        frame: true,
                        border: false,
                        id: 'fichaDatos',
                        items: [
                            {
                                xtype: 'form',
                                title: '',
                                padding: 5,
                                border: false,
                                id: 'frmPacienteBarraServicios',
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Paciente',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 949,
                                        autoHeight: true,
                                        id: 'fsPaciente',
                                        layoutConfig: {
                                            columns: 4
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTdoc',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo Doc ID',
                                                        anchor: '100%',
                                                        name: 'cbTdoc',
                                                        allowBlank: false,
                                                        store: 'StoreTdocPac',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Tipo Documento....',
                                                        mode: 'local',
                                                        triggerAction: 'all',
                                                        forceSelection: true,
                                                        id: 'strTdoc_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 269,
                                                border: false,
                                                id: 'pnDocID',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Documento ID',
                                                                name: 'txtDocID',
                                                                allowBlank: false,
                                                                //anchor: '100%',
                                                                width: 200,
                                                                id: 'strdocpac_citas'
                                                                
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Paciente',
                                                                id: 'btnBuscarPacienteRadica'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnUsrVerifica',
                                                                tooltip: 'Verificar Paciente en el Listado de Atención',
                                                                ref: '../../../../btnVerificaPacienteListado',
                                                                id: 'btnVerificaPacienteListado'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnRegimen',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Régimen / Tipo Usuario',
                                                        anchor: '100%',
                                                        name: 'cbRegimen',
                                                        allowBlank: false,
                                                        store: 'StoreTipoRegimen',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Régimen/Tipo Usuario....',
                                                        forceSelection: true,
                                                        value: '1 - Contributivo',
                                                        listWidth: 350,
                                                        id: 'strRegimen_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 172,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnGenero',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Genero',
                                                        anchor: '100%',
                                                        name: 'cbGenero',
                                                        allowBlank: false,
                                                        store: 'StoreGenero',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Genero....',
                                                        forceSelection: true,
                                                        id: 'strgenero_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnApe1',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '1er Apellido',
                                                        anchor: '100%',
                                                        name: 'txtApe1',
                                                        style: 'text-transform:uppercase;',
                                                        allowBlank: false,
                                                        id: 'strApe1_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnApe2',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '2do Apellido',
                                                        anchor: '100%',
                                                        name: 'txtApe2',
                                                        style: 'text-transform:uppercase;',
                                                        id: 'strApe2_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                id: 'pnNom1',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '1er Nombre',
                                                        anchor: '100%',
                                                        name: 'txtNom1',
                                                        allowBlank: false,
                                                        style: 'text-transform:uppercase;',
                                                        id: 'strNom1_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 172,
                                                id: 'pnNom2',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '2do Nombre',
                                                        anchor: '100%',
                                                        name: 'txtNom2',
                                                        style: 'text-transform:uppercase;',
                                                        id: 'strNom2_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 146,
                                                border: false,
                                                id: 'pnFecNac',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Nacimiento',
                                                        anchor: '100%',
                                                        name: 'txtFecNac',
                                                        allowBlank: false,
                                                        disabledDates: '',
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'fecFecNac_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnEdad',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Edad Actual',
                                                        anchor: '100%',
                                                        name: 'txtEdad',
                                                        readOnly: true,
                                                        style: 'color: blue;text-align:center',
                                                        disabled: true,
                                                        id: 'strEdad_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 386,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnDeptoMuni',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Municipio - Departamento',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: 'StoreDeptoMuni',
                                                        valueField: 'IdDeptoMunicipio',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Municipio - Departamento....',
                                                        mode: 'local',
                                                        listWidth: 450,
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        id: 'strDeptoMuni_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 928,
                                                border: false,
                                                colspan: 4,
                                                height: 54,
                                                id: 'pnDatDirTel',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                                        anchor: '100%',
                                                        id: 'composDatDirTel',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtDireccion',
                                                                allowBlank: false,
                                                                emptyText: 'Dirección....',
                                                                style: 'text-transform:uppercase;',
                                                                width: 250,
                                                                id: 'strDireccion_citas'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtTel1',
                                                                allowBlank: false,
                                                                emptyText: 'Teléfono',
                                                                width: 160,
                                                                id: 'strTel1_citas'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtTel2',
                                                                emptyText: 'Teléfono (Otro - Cel.)',
                                                                width: 160,
                                                                id: 'strTel2_citas'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                flex: 1,
                                                                fieldLabel: 'Zona',
                                                                store: 'StoreZonaResidencia',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                name: 'cbZona',
                                                                emptyText: 'Zona....',
                                                                allowBlank: false,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                width: 80,
                                                                value: 'Urbana',
                                                                triggerAction: 'all',
                                                                id: 'strZona_citas'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtEmail',
                                                                vtype: 'email',
                                                                allowBlank: false,
                                                                emptyText: 'Email....',
                                                                width: 147,
                                                                id: 'strEmail_citas'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                tooltip: 'Limpiar Datos del Paciente',
                                                                iconCls: 'btnLimpiar',
                                                                id: 'btnLimpiarPac_citas'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                tooltip: 'Crear Datos del Paciente',
                                                                iconCls: 'btnGuardar',
                                                                id: 'btnGuardarPac_citas'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTafiliado',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Afiliado',
                                                        anchor: '100%',
                                                        name: 'cbTafiliado',
                                                        allowBlank: false,
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreTipoAfiliado',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Tipo de Afiliado....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        tpl: '',
                                                        id: 'strTafiliado_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTafiliacion',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Parentesco',
                                                        anchor: '100%',
                                                        name: 'cbParentesco',
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreParentesco',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        emptyText: 'Seleccione Parentesco....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        disabled: true,
                                                        id: 'strParentesco_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 213,
                                                border: false,
                                                id: 'pnRango',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Rango Salarial',
                                                        anchor: '100%',
                                                        name: 'cbRango',
                                                        allowBlank: false,
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreRangoSal',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Rango Salarial....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        tpl: '<tpl for="."><div class="cbRango"><h3>{Descripcion}</h3><p style="font-size: 12; color: #AA0033">Valor: $ {VlrCuotaModeradora}</p><p style="font-size: 11; color: #0000EE ">Porcentaje: {txtPorcentaje} %</p><p style="font-size: 10; color: #33373d">{Observaciones}</p><hr /></div></tpl>',
                                                        itemSelector: 'div.cbRango',
                                                        listWidth: 450,
                                                        autoHeight: true,
                                                        id: 'strRango_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 170,
                                                border: false,
                                                id: 'pnEstado',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Estado - Listado Atención',
                                                        anchor: '100%',
                                                        name: 'cbEstado',
                                                        allowBlank: false,
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreEstadoLA',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        emptyText: 'Estado Actual....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        disabled: true,
                                                        autoSelect: false,
                                                        id: 'strEstado_citas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdEmpresa',
                                                id: 'sysIdEmpresa',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdSede',
                                                id: 'sysIdSede',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdIPS',
                                                id: 'sysIdIPS',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdPaciente',
                                                id: 'intIdPaciente_citas',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtExcento',
                                                id: 'sysExento',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtTutela',
                                                id: 'sysTutela',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtClieteLA',
                                                id: 'sysClienteLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtPlanLA',
                                                id: 'sysPlanLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtSubPlanLA',
                                                id: 'sysSubPlanLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtPacienteValido',
                                                id: 'sysPacienteValido',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Cliente y del Solicitante',
                                        layout: 'table',
                                        width: 949,
                                        autoHeight: true,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsCliente',
                                        layoutConfig: {
                                            columns: 8
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 240,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnCliete',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Cliente',
                                                        anchor: '100%',
                                                        name: 'cbCliente',
                                                        allowBlank: true,
                                                        store: 'StoreCliente',
                                                        displayField: 'Descripcion',
                                                        valueField: 'IdCliente',
                                                        emptyText: 'Selecione Cliente....',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        listWidth: 450,
                                                        typeAhead: true,
                                                        autoSelect: false,
                                                        typeAheadDelay: 50,
                                                        submitValue: true,
                                                        enableKeyEvents: true,
                                                        triggerAction: 'all',
                                                        id: 'sysCliente'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 240,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnPlan',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Plan',
                                                        anchor: '100%',
                                                        name: 'cbPlan',
                                                        allowBlank: true,
                                                        mode: 'local',
                                                        store: 'StoreClientesPlan',
                                                        valueField: 'IdPlan',
                                                        displayField: 'Descripcion',
                                                        typeAhead: true,
                                                        triggerAction: 'all',
                                                        disabled: true,
                                                        typeAheadDelay: 50,
                                                        listWidth: 450,
                                                        emptyText: 'Selecione Plan....',
                                                        forceSelection: true,
                                                        id: 'sysPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 240,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnSubplan',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Sub Plan',
                                                        anchor: '100%',
                                                        name: 'cbSubplan',
                                                        allowBlank: true,
                                                        disabled: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        store: 'StoreClienteSubplan',
                                                        displayField: 'Descripcion',
                                                        valueField: 'IdSubPlan',
                                                        mode: 'local',
                                                        emptyText: 'Selecione Sub Plan....',
                                                        listWidth: 450,
                                                        forceSelection: true,
                                                        ref: '../../../../../fSubPlan',
                                                        id: 'sysSubPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 6,
                                                border: false,
                                                width: 350,
                                                colspan: 2,
                                                id: 'pnContrato',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Contrato',
                                                        anchor: '50%',
                                                        name: 'cbContrato',
                                                        allowBlank: true,
                                                        disabled: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        store: 'StoreClienteContrato',
                                                        valueField: 'IdContrato',
                                                        displayField: 'Contrato',
                                                        mode: 'local',
                                                        listWidth: 450,
                                                        emptyText: 'Selecione Contrato....',
                                                        forceSelection: true,
                                                        ref: '../../../../../fContrato',
                                                        id: 'sysContrato'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 240,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnPrograma',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Programa',
                                                        anchor: '100%',
                                                        name: 'cbPrograma',
                                                        allowBlank: true,
                                                        store: 'StorePrograma',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'IdPrograma',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Programa....',
                                                        submitValue: true,
                                                        id: 'sysPrograma'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 240,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnProgramaTipoAtencion',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        disabled: true,
                                                        fieldLabel: 'Tipo de Atención',
                                                        anchor: '100%',
                                                        name: 'cbProgramaTipoAtencion',
                                                        allowBlank: true,
                                                        store: 'StoreProgramaTipoAtencion',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Programa....',
                                                        submitValue: true,
                                                        id: 'sysProgramaTipoAtencion'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'sysHorasPrograma',
                                                        value: 1
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 240,
                                                colspan: 2,
                                                border: false,
                                                iconCls: '',
                                                id: 'pnAutorizacion',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Autorización',
                                                        anchor: '100%',
                                                        name: 'txtAutorizacion',
                                                        style: 'text-transform:uppercase;',
                                                        allowBlank: true,
                                                        disabled: true,
                                                        id: 'sysAutorizacion',
                                                        listeners: {
                                                            blur: function(t){
                                                                if (Ext.getCmp('sysAutorizacion').getValue() !== "" && Ext.getCmp('sysAutorizacion').getValue() !== null){
                                                                    Ext.Ajax.request({
                                                                        url: '../../controlador/util/controlador_varios.php',
                                                                        params:{
                                                                            task: 'BUSCAR_NROAUTORIZACION',
                                                                            pAutoriza: Ext.getCmp('sysAutorizacion').getValue(),
                                                                            pCliente: Ext.getCmp('sysCliente').getValue()
                                                                        },
                                                                        success: function(response,options){
                                                                            var Respuesta = response.responseText;
                                                                            var Contenido = Respuesta.split('^');
                                                                            if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                                // Nro Autorizacion Valido
                                                                            } else {
                                                                                Ext.MessageBox.show({
                                                                                    title: 'OfiClinic',
                                                                                    msg: 'El Nro de Autorizacion ya existe y esta radicado con la Orden Nro. ' + Contenido[0],
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            // Nro Autorizacion Valido
                                                                        },
                                                                        scope:this 
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 150,
                                                colspan: 2,
                                                border: false,
                                                id: 'pnFecSol',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Solicitud',
                                                        anchor: '100%',
                                                        name: 'txtFecSol',
                                                        allowBlank: true,
                                                        style: 'text-align:center;',
                                                        emptyText: '(dia/mes/año) ',
                                                        value: new Date().format('d/m/Y'),
                                                        id: 'sysFecSol'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 350,
                                                colspan: 8,
                                                id: 'pnProfesional',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Profesional / IPS  Solicitante',
                                                                name: 'cbProfeSol',
                                                                allowBlank: true,
                                                                store: 'StoreProfeSol',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                emptyText: 'Seleccione Profesional / IPS Solicitante....',
                                                                valueField: 'idProfeSolicitante',
                                                                displayField: 'Descripcion',
                                                                width: 300,
                                                                listWidth: 450,
                                                                submitValue: true,
                                                                id: 'sysProfeSol'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnDoctor',
                                                                tooltip: 'Adicionar Profesional / IPS Solicitante',
                                                                id: 'btnAddProfeSol'
                                                            }
                                                        ]
                                                    }
                                                 ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtUsaListado',
                                                id: 'sysUsaListado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtAtenderFueraListado',
                                                id: 'sysAtenderFueraListado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtRequiereAutorizacion',
                                                id: 'sysRequiereAutorizacion',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtFacturarParticular',
                                                id: 'sysFacturarParticular',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtMaxCopago',
                                                id: 'sysMaxCopago',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'sysFacturarCopagos',
                                                id: 'sysFacturarCopagos',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'sysCopagoDigitado',
                                                id: 'sysCopagoDigitado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'sysvlrCuotaModeradoraIndicada',
                                                id: 'sysvlrCuotaModeradoraIndicada',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'sysPorCopagos',
                                                id: 'sysPorCopagos',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtUsaAuditoria',
                                                id: 'sysUsaAuditoria',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtFinalidad',
                                                id: 'sysFinalidad',
                                                value: '10'
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtExento',
                                                id: 'sysExentoPrograma',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'hidden',
                                        name: 'txtCas',
                                        id: 'sysCas',
                                        value: 0
                                    }
                                ]
                            } // fin formulario
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Asignación de Citas',
                        height: 441,
                        width: 951,
                        layout: 'fit',
                        id: 'fichaAsignacionCita',
                        listeners:{
                            beforeshow : function(){
                                TieneCitaTramite = 0;
                                if(Ext.getCmp('intIdPaciente_citas').getValue() !== null && Ext.getCmp('intIdPaciente_citas').getValue() !== 0 && Ext.getCmp('intIdPaciente_citas').getValue() !== "0"){
                                    Ext.Ajax.request({
                                        waitMsg: 'Por favor Espere...',
                                        url: "../../controlador/asignarcitasesp/controlador_radicarcitas.php",
                                        params: {
                                            task: "VALIDAR_RADICARCITA_PENDIENTES",
                                            pEmpresa: ID_EMPRESA,
                                            pIPS: ID_IPS, 
                                            pPaciente: Ext.getCmp('intIdPaciente_citas').getValue()
                                        },
                                        success: function(response)
                                        {
                                            var result = response.responseText.split("^");
                                            if (result[0] > 0){
                                                TieneCitaTramite = 1;
                                            }else{
                                                TieneCitaTramite = 0;
                                            }
                                        },
                                        failure: function(response){
                                            var result = response.responseText;
                                            Ext.MessageBox.show({
                                                title: 'Error Base Datos',
                                                msg: 'Error de conexión - No podemos validar la informacion en estos momentos',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        },
                                        callback: function(){
                                            var winFrmHistorialCitaRadicadas2 = new winFrmHistorialCitaRadicadasUi();
											Ext.getCmp('sysOrigenOpcion').setValue("BARRASERVICIOS");
                                            Ext.getCmp('gridHistorialCitasRadicada').store.load({
                                                params: {
                                                    task: 'HISTORIAL_CITAS_RADICADAS',
                                                    pEmpresa: ID_EMPRESA,
                                                    pIPS: ID_IPS, 
                                                    pPaciente: Ext.getCmp('intIdPaciente_citas').getValue(),
                                                    pEspecialidad: null,
                                                    pRangoFechas1Mes: "NO", 
                                                    pRangoFechas: "NO"
                                                }
                                            });
                                            winFrmHistorialCitaRadicadas2.show();
                                            if(TieneCitaTramite === 1){
                                                Ext.MessageBox.show({
                                                    title: 'Atencion',
                                                    msg: 'El Paciente tiene actualmente una cita radicada para esta especialidad y esta en tramite de asignacion.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.INFO
                                                });
                                            }
                                        }
                                    });
                                    var idInfoPac = Ext.getCmp('strNom1_citas').getValue() + " " + Ext.getCmp('strNom2_citas').getValue() +  " " + Ext.getCmp('strApe1_citas').getValue() + " " + Ext.getCmp('strApe2_citas').getValue() + " - CLIENTE: " + Ext.getCmp('sysCliente').getRawValue();
                                    Ext.getCmp('systxtIdPac').setValue("Paciente: " + idInfoPac);
                                }
                                if((Ext.getCmp('sysCliente').getValue() === null || Ext.getCmp('sysCliente').getValue() === "") && Ext.getCmp('intIdPaciente_citas').getValue() !== 0){
                                    var html = '<table><tr><td width="50"><img src="../../../resources/varios/alert.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #ff9900; font-size: 14px;">Barra de Servicios:</h1><br/><p style="color: #003333;font-weight: bold;">Antes de asignar una cita usted debe:</p></br>';
                                    html += '<strong><ul>';
                                    html += '<li>Crear o Seleccionar un Paciente</li>';
                                    html += '<li>Seleccionar un Cliente - Plan - SubPlan</li>';
                                    html += '<li>Seleccionar Tipo de Afiliación</li>';
                                    html += '<li>Seleccionar Tipo de Afiliado</li>';
                                    html += '<li>Seleccionar un Programa</li>';
                                    html += '<li>Seleccionar una Finalidad</li>';
                                    html += '</ul></strong></td><td width="70">&nbsp</td></tr></table>'
                                    if(TieneCitaTramite === 0){
                                        Sexy.info(html);
                                    }
                                }
                            }
                        },
                        items: [
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                anchor: '99%',
                                frame: true,
                                border: false,
                                id: 'infoPac_Citas',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                readOnly: true,
                                                width: 935,
                                                id: 'systxtIdPac',
                                                style: 'text-transform:uppercase; color: #610B0B; font-size: 13px; font-weight: bold;',
                                                value: 'Paciente:'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnAgendasBloqueada',
                                                tooltip: 'Ver Citas Radicadas',
                                                listeners: {
                                                    click: function(){
                                                        if(parseInt(Ext.getCmp('intIdPaciente_citas').getValue()) !== 0){
                                                            var winFrmHistorialCitaRadicadas1 = new winFrmHistorialCitaRadicadasUi();
                                                            Ext.getCmp('gridHistorialCitasRadicada').store.load({
                                                                params: {
                                                                    task: 'HISTORIAL_CITAS_RADICADAS',
                                                                    pEmpresa: ID_EMPRESA,
                                                                    pIPS: ID_IPS, 
                                                                    pPaciente: Ext.getCmp('intIdPaciente_citas').getValue(),
                                                                    pEspecialidad: null,
                                                                    pRangoFechas1Mes: "NO", 
                                                                    pRangoFechas: "NO"
                                                                }
                                                            });
                                                            winFrmHistorialCitaRadicadas1.show();
                                                        }
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        html:'<hr>',
                                        border: false
                                    },
                                    {
                                        xtype: 'compositefield',
                                        fieldLabel: 'Concepto',
                                        anchor: '100%',
                                        padding: 5,
                                        items: [
                                            {
                                                xtype: 'displayfield',
                                                value: 'Concepto:'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Concepto',
                                                id: 'btnSearchConcepto_Citas'
                                            },
                                            {
                                                xtype: 'textfield',
                                                flex: 1,
                                                readOnly: true,
                                                width: 120,
                                                style: 'color: #0000cc; font-weight: bold;',
                                                id: 'fCodConcepto'
                                            },
                                            {
                                                xtype: 'textarea',
                                                flex: 1,
                                                readOnly: true,
                                                width: 750,
                                                height: 40,
                                                style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                                id: 'fDesConcepto'
                                            },
                                            {
                                                xtype: 'hidden',
                                                flex: 1,
                                                readOnly: true,
                                                width: 120,
                                                style: 'color: #0000cc; font-weight: bold;',
                                                id: 'fVlrUnitario'
                                            },
                                            {
                                                xtype: 'hidden',
                                                flex: 1,
                                                readOnly: true,
                                                width: 120,
                                                id: 'fidConcepto'
                                            },
                                            {
                                                xtype: 'hidden',
                                                flex: 1,
                                                readOnly: true,
                                                width: 120,
                                                id: 'strTipoRegistroDetalle'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'container',
                                        width: 965,
                                        height: 550,
                                        layout: 'border',
                                        items: [
                                            {
                                                xtype: 'panel',
                                                //title: 'Profesionales',
                                                region: 'north',
                                                border: true,
                                                width: 951,
                                                height: 220,
                                                items:[
                                                    {
                                                        xtype: 'panel',
                                                        //title: '',
                                                        layout: 'table',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 951,
                                                        border: false,
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'grid',
                                                                id: 'gridProfesionalesCitas',
                                                                store: stGridProfesionalesCitas,
                                                                anchor: "100%",
                                                                height: 210,
                                                                border: false,
                                                                frame: true,
                                                                loadMask: true,
                                                                title: 'Profesionales:',
                                                                columns: [
                                                                    {
                                                                        header: 'profesionalID',
                                                                        readOnly: true,
                                                                        sortable: false,
                                                                        dataIndex: 'profesionalID',
                                                                        width: 1,
                                                                        hidden: true,
                                                                        hideable: false
                                                                    },
                                                                    {
                                                                        header: 'Especialidad',
                                                                        readOnly: true,
                                                                        sortable: true,
                                                                        dataIndex: 'especialidadDescripcion',
                                                                        width: 0.1,
                                                                        hidden: true
                                                                    },
                                                                    {
                                                                        header: 'Profesional',
                                                                        readOnly: true,
                                                                        sortable: true,
                                                                        dataIndex: 'profesionalDescripcion',
                                                                        width: 435
                                                                    }
                                                                ],
                                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                                iconCls:'icon-profesionales',
                                                                view: new Ext.grid.GroupingView({
                                                                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
                                                                }),
                                                                viewConfig: {
                                                                    forceFit:true
                                                                },
                                                                columnLines: true,
                                                                tbar:{
                                                                    items: [
                                                                        '->',
                                                                        {
                                                                            xtype: 'tbseparator'
                                                                        },
                                                                        {
                                                                            xtype: 'button',
                                                                            iconCls: 'btnAsignarCita',
                                                                            text: 'Asignar Citas para Sesiones',
                                                                            tooltip: 'Asignar Citas para Sesiones',
                                                                            id: 'btnAsignarSesiones_citas'
                                                                        }
                                                                    ]
                                                                }
                                                            },
                                                            {
                                                                xtype: 'grid',
                                                                id: 'gridConsultoriosCitas',
                                                                store: stGridConsultoriosCitas,
                                                                anchor: "100%",
                                                                height: 210,
                                                                border: false,
                                                                frame: true,
                                                                loadMask: true,
                                                                stripeRows: true,
                                                                title: 'Consultorio / Unidad:',
                                                                columns: [
                                                                    {
                                                                        header: 'Codigo',
                                                                        readOnly: true,
                                                                        sortable: false,
                                                                        dataIndex: 'Codigo',
                                                                        width: 1,
                                                                        hidden: true,
                                                                        hideable: false
                                                                    },
                                                                    {
                                                                        header: 'Descripcion',
                                                                        readOnly: true,
                                                                        sortable: true,
                                                                        dataIndex: 'Descripcion',
                                                                        width: 435
                                                                    }
                                                                ],
                                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                                iconCls:'icon-consultorios',
                                                                viewConfig: {
                                                                    forceFit:true
                                                                },
                                                                columnLines: true
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                region: 'west',
                                                border: true,
                                                width: 400,
                                                height: 180,
                                                padding: 5,
                                                items:[
                                                    {
                                                        xtype: 'grid',
                                                        id: 'gridDiasAgendaCitas',
                                                        store: stGridAgendasDisponiblesCitas,
                                                        anchor: "100%",
                                                        height: 250,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        title: 'Agendas Programadas',
                                                        stripeRows: true,
                                                        columns: [
                                                            {
                                                                header: 'agendaID',
                                                                readOnly: true,
                                                                sortable: false,
                                                                dataIndex: 'agendaID',
                                                                width: 1,
                                                                hidden: true,
                                                                hideable: false
                                                            },
                                                            {
                                                                header: 'Fecha Disponible',
                                                                readOnly: true,
                                                                sortable: true,
                                                                dataIndex: 'agendaFecha',
                                                                renderer: renderFechaAgenda,
                                                                width: 270
                                                            },
                                                            {
                                                                header: 'Citas Disponibles',
                                                                readOnly: true,
                                                                sortable: true,
                                                                dataIndex: 'Disponibles'
                                                            }
                                                        ],
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                        iconCls:'icon-fechas',
                                                        viewConfig: {
                                                            forceFit:true
                                                        },
                                                        columnLines: true,
                                                        bbar:{
                                                            items: [
                                                                {
                                                                    xtype: 'button',
                                                                    iconCls: 'btnImprimir',
                                                                    text: 'Imprimir Agenda',
                                                                    tooltip: 'Imprimir Agenda',
                                                                    id: 'btnImpAgenda_citas'
                                                                },
                                                                '->',
                                                                {
                                                                    xtype: 'button',
                                                                    iconCls: 'btnAgendasBloqueada',
                                                                    text: 'Ver Agendas Bloqueadas',
                                                                    tooltip: 'Verificar las Agendas Bloqueadas por Usuario',
                                                                    id: 'btnVarAgendaBloqueada_citas'
                                                                }
                                                            ]
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                region: 'center',
                                                border: true,
                                                width: 551,
                                                height: 300,
                                                padding: 5,
                                                items:[
                                                    {
                                                        xtype: 'editorgrid',
                                                        id: 'gridHorariosAgendasCitas',
                                                        store: stGridHoarariosxAgendaDisponiblesCitas,
                                                        anchor: "100%",
                                                        height: 250,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        stripeRows: true,
                                                        clicksToEdit: 1,
                                                        title: 'Horarios Disponibles por Agenda',
                                                        cm: new xg.ColumnModel([
                                                            chkColumnSeleccionarHorario,
                                                            {
                                                                header: 'Codigo',
                                                                readOnly: true,
                                                                sortable: false,
                                                                dataIndex: 'citaID',
                                                                width: 1,
                                                                hidden: true,
                                                                hideable: false
                                                            },
                                                            {
                                                                header: 'Descripción del Horario',
                                                                readOnly: true,
                                                                sortable: false,
                                                                dataIndex: 'citaDescripcion',
                                                                width: 200
                                                            },
                                                            {
                                                                header: 'Información Adicional de la Cita',
                                                                readOnly: false,
                                                                sortable: false,
                                                                dataIndex: 'citaInfoAdd',
                                                                editor: strcitaInfoAdd,
                                                                width: 200
                                                            }
                                                        ]),
                                                        plugins: [chkColumnSeleccionarHorario],
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                        iconCls:'icon-horarios',
                                                        viewConfig: {
                                                            forceFit:true
                                                        },
                                                        columnLines: true,
                                                        tbar:{
                                                            items: [
                                                                {
                                                                    html:'<b style="color: #ff3333;">A Solicitud del Usuario:</b>&nbsp;&nbsp;&nbsp;',
                                                                    border: false
                                                                },
                                                                {
                                                                    xtype: 'checkbox',
                                                                    anchor: '100%',
                                                                    value: 'true',
                                                                    id: 'bolAsignaCitasSolicitudUsuario'
                                                                },
                                                                {
                                                                    html:'<b style="color: blue;">&nbsp;&nbsp;&nbsp; - EXENTO:</b>&nbsp;&nbsp;&nbsp;',
                                                                    border: false
                                                                },
                                                                {
                                                                    xtype: 'checkbox',
                                                                    anchor: '100%',
                                                                    value: 'true',
                                                                    id: 'bolMarcaExento'
                                                                },
                                                                {
                                                                    xtype: 'tbfill'
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                },
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Radicar Cita',
                                                                    iconCls: 'btnRadicar',
                                                                    listeners: {
                                                                        click: function(){
                                                                            window.open ("../../frm/radicacitascx/frmradicacitascx.php","Radicacion Citas");
                                                                        }
                                                                    }
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                },
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Asignar Cita',
                                                                    iconCls: 'btnAsignarCita',
                                                                    id: 'btnCitasAsignarCita'
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                }
                                                            ]
                                                        },
                                                        bbar:{
                                                            items: [
                                                                {
                                                                    html:'Observaciones:&nbsp;&nbsp;&nbsp;',
                                                                    border: false
                                                                },
                                                                {
                                                                    xtype: 'textfield',
                                                                    width: 440,
                                                                    maxLength: 150,
                                                                    allowBlank: true,
                                                                    emptyText: 'Observaciones',
                                                                    id: 'strObservacionesCita'
                                                                }
                                                            ]
                                                        }
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Legalización de Citas',
                        height: 240,
                        width: 951,
                        layout: 'fit',
                        id: 'fichaLegalizacionCita',
                        listeners:{
                            beforeshow : function(){
                                if(Ext.getCmp('intIdPaciente_citas').getValue() != 0){
                                    var idInfoPac = Ext.getCmp('strTdoc_citas').getValue() + "-" + Ext.getCmp('strdocpac_citas').getValue() + " " + Ext.getCmp('strNom1_citas').getValue() + " " + Ext.getCmp('strNom2_citas').getValue() +  " " + Ext.getCmp('strApe1_citas').getValue() + " " + Ext.getCmp('strApe2_citas').getValue();
                                    Ext.getCmp('systxtIdPac1').setValue("Paciente: " + idInfoPac);
                                }else{
                                    var html = '<table><tr><td width="50"><img src="../../../resources/varios/alert.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #ff9900; font-size: 14px;">Barra de Servicios:</h1><br/><p style="color: #003333;font-weight: bold;">Antes de realizar operaciones con citas usted debe:</p></br>';
                                    html += '<strong><ul>';
                                    html += '<li>Seleccionar un Paciente</li>';
                                    html += '</ul></strong></td><td width="70">&nbsp</td></tr></table>'
                                    Sexy.info(html);
                                }
                            }
                        },
                        tbar:{
                            items: [
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasAsignadas',
                                    text: 'Ver Historial Citas',
                                    tooltip: 'Ver Historial de Citas Asignadas por Paciente',
                                    id: 'btnVerHistorialCitas_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasCanceladas',
                                    text: 'Ver Historial Cancelaciones',
                                    tooltip: 'Ver Historial de Citas Canceladas por Paciente',
                                    id: 'btnVerHistorialCanceladas_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnCitasInasistencia',
                                    text: 'Ver Historial Inasistencias',
                                    tooltip: 'Ver Historial de Citas Inasistidas por Paciente',
                                    id: 'btnVerHistorialInasistencia_citas'
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                anchor: '99%',
                                frame: true,
                                border: false,
                                id: 'infoPac_Citas1',
                                items: [
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtIdPac1',
                                        style: 'text-transform:uppercase; color: #610B0B; font-size: 13px; font-weight: bold;',
                                        value: 'Paciente:'
                                    },
                                    {
                                        html:'<hr>',
                                        border: false
                                    },
                                    {
                                        xtype: 'grid',
                                        id: 'gridLegalizarCitas',
                                        store: stGridCitasxLegalizar,
                                        anchor: "100%",
                                        height: 480,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        stripeRows: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                header: 'CAS',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'CAS',
                                                width: 100,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Fecha',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'FechaCita',
                                                width: 80,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Hora',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'HoraAgenda',
                                                width: 110,
                                                hideable: false,
                                                locked: true
                                            },
                                            {
                                                header: 'Hora Estimada',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'HoraAtencion',
                                                width: 80,
                                                hideable: false
                                            },
                                            {
                                                header: 'Profesional',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Profesional',
                                                width: 280,
                                                hideable: false
                                            },
                                            {
                                                header: 'Ubicacion',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Ubicacion',
                                                width: 220,
                                                hideable: false
                                            },
                                            {
                                                header: 'Cliente',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Cliente',
                                                width: 250,
                                                hideable: false
                                            },
                                            {
                                                header: 'Actividad',
                                                readOnly: true,
                                                sortable: false,
                                                dataIndex: 'Actividad',
                                                width: 280,
                                                hideable: false
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                        view: new Ext.ux.grid.LockingGridView(),
                                        columnLines: true,
                                        tbar:{
                                            items: [
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    iconCls: 'btnCitasLegalizacion',
                                                    text: 'Ver Historial Legalizaciones',
                                                    tooltip: 'Ver Historial de Citas Legalizadas por Paciente',
                                                    id: 'btnHistorialLegalizaciones_citas'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Citas Pendientes por Legalizar',
                                                    iconCls: 'btnCitasBuscar',
                                                    id: 'btnCitasxLegalizar'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        },
                                        bbar:{
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    text: 'Legalizar Cita',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Legalizar la Cita Seleccionada',
                                                    id: 'btnLegalizarCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Cancelar Cita',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Cancelar la Cita Seleccionada',
                                                    id: 'btnCancelarCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Marcar Cita Inasistente',
                                                    iconCls: 'btnAsignarCita',
                                                    tooltip: 'Marcar Inasistente la Cita Seleccionada',
                                                    id: 'btnInasistenciaCita'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winBaraServiciosUi.superclass.initComponent.call(this);
    }
});
