/*
* @category    Formulario Grid Historial de Otros Pagos Realizados 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmDetalleCopagosUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Detalle del Copago ::.',
    id: 'winFrmDetalleCopagos',
    closable: true,
    width: 980,
    height: 480,
    plain: true,
    resizable: false,
    modal: true,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var stGrid = new StoreGridDetalleCopago();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        
        Ext.util.Format.Currency = function(v){
            return FormatoMoneda(v);
        };
        
        function DescripcionActividad(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            return record.get('CodProced') + " - " + record.get('DesProced');
	}
         
        this.items = [
            {
                xtype: 'grid',
                id: 'gridVerDetalleCopagos',
                store: stGrid,
                anchor: "100%",
                border: false,
                frame: true,
                stripeRows: true,
                columns:[
                    {
                        header: 'CAS',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'CAS_REF',
                        width: 80,
                        hideable: false,
                        locked: true
                    },
                    {
                        header: 'Fecha',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Fecha',
                        width: 80,
                        hideable: false,
                        locked: true
                    },
                    {
                        header: 'Diente',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Diente',
                        width: 40,
                        hideable: false,
                        locked: true
                    },
                    {
                        header: 'Superficie',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Superficie',
                        width: 40,
                        hideable: false
                    },
                    {
                        header: 'Concepto',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Concepto',
                        renderer: DescripcionActividad,
                        width: 410,
                        hideable: false
                    },
                    {
                        header: 'Tarifa',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Tarifa',
                        width: 130,
                        align: 'right',
                        hideable: false
                    },
                    {
                        header: 'Copago',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Copago',
                        width: 130,
                        align: 'right',
                        hideable: false
                    }
                ]
            }
        ];
        winFrmDetalleCopagosUi.superclass.initComponent.call(this);
    }
});
