/*
* @category    Formulario Adicionar Planes x Cliente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddMatrizAutorizaciones2015Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Matriz Autorizaciones ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddMatrizAutorizaciones2015Ui',
    initComponent: function() {
        
        
        var searchServicios = new Ext.data.Store({
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/clientes/search_clientes_conceptos.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, [
                {name: 'IdProced'},
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ])
        });
        
        var dataNivelAuditoria = [
            ['B','CONCEPTO BLOQUEADO'],
            ['A','REVISION POR AUDITORIA'],
            ['P','CONCEPTO PREAUTORIZADO'],
            ['X','CONCEPTO NO CONTRATADO']
        ];
        var stNivelAuditoria = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stNivelAuditoria.loadData(dataNivelAuditoria);
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddMatrizAutorizaciones',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'IdClienteMatriz'
                    },
                    {
                        xtype: 'textfield',
                        fieldLabel: 'Concepto',
                        name: 'Concepto',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysConceptoMatriz'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Concepto',
                        name: 'Concepto',
                        store: searchServicios,
                        allowBlank: false,
                        valueField: 'IdProced',
                        displayField: 'Descripcion',
                        typeAhead: false,
                        loadingText: 'Buscando...',
                        anchor: '100%',
                        hideTrigger: true,
                        minChars: 4,
                        emptyText:'Escriba el nombre del Servicio -- p.e: COLEST',
                        id: 'intIdProcedimientosMatriz'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Nivel Auditoria',
                        name: 'Nivel Auditoria',
                        anchor: '100%',
                        allowBlank: false,
                        store: stNivelAuditoria,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strNivelAuditoria'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'Cantidad Maxima Solicitada',
                        fieldLabel: 'Cantidad Maxima Solicitada',
                        width: 350,
                        minValue: 0,
                        decimalPrecision: 0,
                        allowBlank: false,
                        id: 'intCantidadMax'
                    },
                    {
                        xtype: 'numberfield',
                        fieldLabel: 'Dias Vigencia Servicio',
                        name: 'Dias Vigencia Servicio',
                        width: 350,
                        minValue: 0,
                        decimalPrecision: 0,
                        allowBlank: false,
                        id: 'intVigenciaServicio'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarMatriz',
                            listeners:{
                                click : function(){
                                    guardarMatriz();
                                }
                            }
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnModificarMatriz',
                            listeners:{
                                click : function(){
                                    modificarMatriz();
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddMatrizAutorizaciones2015Ui.superclass.initComponent.call(this);
    }
});


function guardarMatriz(){
    Ext.Msg.show({
        title: 'Guardar Cliente....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn==="yes"){
              var frm = Ext.getCmp('frmAddMatrizAutorizaciones').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/clientes/controlador_clientes.php',
                        params: {
                            task: 'INSERTAR_MATRIZ_AUTORIZACIONES',
                            pCliente: Ext.getCmp('IdClienteMatriz').getValue(),
                            pProcedimiento: Ext.getCmp('intIdProcedimientosMatriz').getValue(),
                            pNivelAuditoria: Ext.getCmp('strNivelAuditoria').getValue(),
                            pCantMaxSol: Ext.getCmp('intCantidadMax').getValue(),
                            pMinDiasSol: Ext.getCmp('intVigenciaServicio').getValue(),
                            pUsuario: ID_USUARIO
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar Cliente',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    
                                    Ext.getCmp('gridMatrizAutorizaciones').store.baseParams = {
                                            pCliente: Ext.getCmp('IdClienteMatriz').getValue(),
                                            task: "LISTAR_GRID_MATRIZ_AUTORIZACIONES"
                                    };

                                    Ext.getCmp('gridMatrizAutorizaciones').store.load({
                                        params: {
                                            pCliente: Ext.getCmp('IdClienteMatriz').getValue()
                                        }
                                    });
                                    Ext.getCmp('winAddMatrizAutorizaciones2015Ui').close();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar Cliente',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
        
}

function modificarMatriz(){
    Ext.Msg.show({
        title: 'Modificar Cliente....!',
        msg: 'Esta seguro que desea Modificar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn==="yes"){
              var frm = Ext.getCmp('frmAddMatrizAutorizaciones').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/clientes/controlador_clientes.php',
                        params: {
                            task: 'MODIFICAR_MATRIZ_AUTORIZACIONES',
                            pCliente: Ext.getCmp('IdClienteMatriz').getValue(),
                            pProcedimiento: Ext.getCmp('intIdProcedimientosMatriz').getValue(),
                            pNivelAuditoria: Ext.getCmp('strNivelAuditoria').getValue(),
                            pCantMaxSol: Ext.getCmp('intCantidadMax').getValue(),
                            pMinDiasSol: Ext.getCmp('intVigenciaServicio').getValue(),
                            pUsuario: ID_USUARIO
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Modificar Cliente',
                                        msg: 'Se Modifico Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    
                                    Ext.getCmp('gridMatrizAutorizaciones').store.baseParams = {
                                            pCliente: Ext.getCmp('IdClienteMatriz').getValue(),
                                            task: "LISTAR_GRID_MATRIZ_AUTORIZACIONES"
                                    };

                                    Ext.getCmp('gridMatrizAutorizaciones').store.load({
                                        params: {
                                            pCliente: Ext.getCmp('IdClienteMatriz').getValue()
                                        }
                                    });
                                    Ext.getCmp('winAddMatrizAutorizaciones2015Ui').close();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Modificar Cliente',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
        
}