/*
* @category    Formulario Grid Clientes, Proveedores, Terceros
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmClientesUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Clientes, Proveedores, Terceros ::.',
    id: 'winFrmClientes',
    closable:false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    layout: 'fit',
    initComponent: function() {
        
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };

        Ext.apply(Ext.form.VTypes,{
            exclusionNotZero: function(val, field){
                try{
                    if (val < 1){
                        return false;
                    } else {
                        field.clearInvalid();
                        return true;
                    }
                }catch(e){
                    return false;
                }
            },
            exclusionNotZeroText: 'No puede tener valor cero!'
        });
        var stGrid = new StoreGridClientes();
        var mybbar = new utilBbarUi();
        /*this.tbar = [
            {
                xtype: 'toolbar',
                items: [
                    {
                        xtype: 'button',
                        text: 'Exportar a Excel',
                        iconCls: 'btnExcel',
                        ref: '../btnExcelItems',
                        id: 'btnExcelItems'
                    },
                    {
                        xtype: 'tbseparator'
                    },
                    {
                        xtype: 'button',
                        text: 'Imprimir',
                        iconCls: 'btnImprimir',
                        ref: '../btnImprimirItems',
                        id: 'btnImprimirItems'
                    },
                    {
                        xtype: 'tbseparator'
                    }
                ]
            }
        ],*/
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'hidden',
                id: 'sysProfeDocumento',
                value: 0
            },
            {
                xtype: 'hidden',
                id: 'sysProfeNombre',
                value: 'Todos'
            },
            {
                xtype: 'hidden',
                id: 'sysProfeEspecialidad',
                value: 'Todos'
            },
            {
                xtype: 'hidden',
                id: 'sysProfeTipo',
                value: '0'
            },
            {
                xtype: 'grid',
                id: 'gridFormulario',
                store: 'StoreGridClientes',
                anchor: "100%",
                height: 420,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        header: 'IdCliente',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'IdCliente',
                        width: 10,
                        hidden: true,
                        hideable: false
                    },{
                        header: 'Nombre',
                        dataIndex: 'Descripcion',
                        sortable: true,
                        locked: true,
                        width: 450
                    },{
                        header: 'Documento ID',
                        readOnly: true,
                        sortable: true,
                        dataIndex: 'Documento',
                        width: 100,
                        hidden: false
                    },{
                        header: 'Dirección',
                        dataIndex: 'Direccion',
                        width: 190
                    },{
                        header: 'Teléfono',
                        dataIndex: 'Telefono',
                        width: 150
                    },{
                        header: 'Tipo',
                        dataIndex: 'DescTipo',
                        width: 1,
                        hidden: true,
                        hideable: false
                    },{
                        header: 'Activo',
                        dataIndex: 'Activo',
                        width: 50
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                iconCls:'icon-grid',
                view: new Ext.grid.GroupingView({
                //view: new Ext.ux.grid.LockingGridView({
                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                    getRowClass: function(record, index, rowParams, store){
                        var estado = record.data.Activo;
                        switch (estado)
                        {
                            case "NO":
                                return 'NoActivo';
                                break;
                            default:
                                break;
                        }
                    }
                }),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Adicionar',
                                iconCls: 'btnAddRow',
                                ref: '../btnAddItemGrid',
                                id: 'btnAddItemGrid'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Modificar',
                                iconCls: 'btnEditRow',
                                ref: '../btnEditItemGrid',
                                id: 'btnEditItemGrid'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar',
                                iconCls: 'btnDelRow',
                                ref: '../btnDelItemGrid',
                                id: 'btnDelItemGrid'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'tbfill'
                            },
                            new Ext.app.SearchField({
                                id: 'qryProfesional',
                                store: stGrid,
                                emptyText: 'Escriba el criterio que desea buscar',
                                params: {pEmpresa: Ext.get('idempresa').getValue(), start: 0, limit: 15},
                                width: 120
                            })
                        ]
                    },
                bbar: new Ext.PagingToolbar({
                    pageSize: 15,
                    store: 'StoreGridClientes',
                    displayInfo: true
                })
            }
        ];
        winFrmClientesUi.superclass.initComponent.call(this);
    }
});
