/*
* @category    Formulario Adicionar IPS x Cliente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddClienteIPSUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar IPS - Clientes ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddClienteIPSUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddClienteIPS',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'IdClienteGridIPS'
                    },
                    {
                        xtype: 'hidden',
                        id: 'intidUsuarioGridIPS'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Sede',
                        anchor: '100%',
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreSedexEmpresa',
                        forceSelection: false,
                        allowBlank: false,
                        id: 'sysSede'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'IPS',
                        anchor: '100%',
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreIPSxSedexEmpresa',
                        forceSelection: false,
                        allowBlank: false,
                        disabled: true,
                        id: 'intidIPSGridIPS'
                    },
                    {
                        xtype: 'textfield',
                        fieldLabel: 'Codigo Cliente',
                        anchor: '100%',
                        allowBlank: true,
                        id: 'strcodIPSCliente'
                    },
                    {
                        xtype: 'hidden',
                        value: "1",
                        id: 'bolActivoGridIPS'
                    },
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarIPS'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnModificarIPS'
                        }
                    ]
                }
            }
        ];
        winAddClienteIPSUi.superclass.initComponent.call(this);
    }
});
