/*
* @category    Formulario Adicionar Contrato x Cliente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddContratoUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Contrato - Clientes ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddContratoUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddContrato',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'IdIdContratoGrid'
                    },
                    {
                        xtype: 'hidden',
                        id: 'IdIdClienteGrid'
                    },
                    {
                        xtype: 'hidden',
                        id: 'intidUsuarioGrid'
                    },
                    {
                        xtype: 'textfield',
                        width: 100,
                        maxLength: 10,
                        fieldLabel: 'Cod. Rapido',
                        allowBlank: false,
                        emptyText: 'p.e: 020',
                        id: 'strCodRapidoContratoGrid'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '28%',
                        fieldLabel: 'Nro Contrato',
                        allowBlank: false,
                        id: 'strNroContratoGrid'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Descripción',
                        allowBlank: false,
                        emptyText: 'Digite la Descripción o Nombre',
                        id: 'strDescripcionGrid'
                    },
                    {
                        xtype: 'datefield',
                        fieldLabel: 'Fecha Desde',
                        anchor: '28%',
                        allowBlank: false,
                        disabledDates: '',
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecFecDesdeGrid'
                    },
                    {
                        xtype: 'datefield',
                        fieldLabel: 'Fecha Hasta',
                        anchor: '28%',
                        allowBlank: false,
                        disabledDates: '',
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecFecHastaGrid'
                    },
                    {
                        xtype: 'numericfield',
                        fieldLabel: 'Vlr Contrato',
                        currencySymbol: "$",
                        useThousandSeparator: true,
                        alwaysDisplayDecimals: true,
                        thousandSeparator: ',',
                        minValue: 0,
                        decimalPrecision: 2,
                        allowBlank: false,
                        id: 'intVlrTotalGrid'
                    },
                    {
                        xtype: 'numericfield',
                        fieldLabel: 'Vlr Alerta',
                        currencySymbol: "$",
                        useThousandSeparator: true,
                        alwaysDisplayDecimals: true,
                        thousandSeparator: ',',
                        minValue: 0,
                        decimalPrecision: 2,
                        allowBlank: false,
                        id: 'intVlrAlertaGrid'
                    },
                    {
                        xtype: 'numberfield',
                        anchor: '28%',
                        fieldLabel: 'Dias Vencimiento Factura',
                        allowBlank: false,
                        minValue: 0,
                        maxValue: 365,
                        id: 'intDiasVenceFacGrid'
                    },
                    {
                        xtype: 'checkbox',
                        anchor: '100%',
                        value: 'false',
                        fieldLabel: 'Asignar Cita por Defecto',
                        id: 'bolAsignarCitaGrid'
                    },
                    {
                        xtype: 'checkbox',
                        anchor: '100%',
                        value: 'false',
                        fieldLabel: 'Activo',
                        id: 'bolActivoGrid'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarContrato'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnModificarContrato'
                        }
                    ]
                }
            }
        ];
        winAddContratoUi.superclass.initComponent.call(this);
    }
});
