/*
* @category    Formulario Clientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winClientesUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Clientes ::.',
    width: 970,
    height: 580,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winClientesUi',
    initComponent: function() {
        
        var stPlanesCliente = new StoreGridPlanesClientes();
        var stSubPlanesCliente = new StoreGridSubPlanesClientes();
        var stContratosClientes = new StoreGridContratosClientes();
        var stIPSClientes = new StoreGridIPSClientes();
        var stTarifasClientes = new StoreGridTarifasClientes();
        
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };
        
        function renderTopic(value, p, record){
            return String.format(
                '<b style="color:#36C;">{0}</b><table border="0"><tr><td>Codigo Interno:</td><td>{1}</td></tr><tr><td>Codigo CUPS:</td><td>{2}</td></tr></table>',
                value, record.data.CodProced, record.data.CUPSCodigo);
        }
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                height: 535,
                anchor: '100%',
                id: 'frmClientes',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 130,
                        items: [
                         
                            {
                                xtype: 'hidden',
                                id: 'intIdCliente'
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestador',
                                value: 0
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                fieldLabel: 'Codigo',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        maxLength: 20,
                                        allowBlank: false,
                                        emptyText: 'Codigo',
                                        id: 'strCodigo'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxttipo',
                                        value: 'Tipo:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 150,
                                        fieldLabel: 'Tipo',
                                        anchor: '100%',
                                        triggerAction: 'all',
                                        mode: 'local',
                                        typeAhead: true,
                                        emptyText: 'Tipo...!',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        store: 'StoreTipoClientes',
                                        forceSelection: false,
                                        allowBlank: false,
                                        id: 'strTipoCliente'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtclase',
                                        value: 'Clase:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 400,
                                        fieldLabel: 'Clase',
                                        anchor: '100%',
                                        triggerAction: 'all',
                                        mode: 'local',
                                        typeAhead: true,
                                        emptyText: 'Clase...!',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        store: 'StoreClaseClientes',
                                        forceSelection: false,
                                        allowBlank: false,
                                        id: 'strClaseCliente'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                fieldLabel: 'Identificación',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo Doc ID',
                                        width: 180,
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: 'StoreTdocPac',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Tipo Documento....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'strTdoc'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 165,
                                        allowBlank: false,
                                        emptyText: 'Documento de ID',
                                        id: 'strDocumento'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtno',
                                        value: '-'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 30,
                                        maxLength: 1,
                                        allowBlank: true,
                                        emptyText: 'DV',
                                        id: 'strDigitover'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtsupersal',
                                        value: ' Supersalud:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 65,
                                        maxLength: 6,
                                        allowBlank: true,
                                        id: 'strCodigoSUPERSALUD'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtregimen',
                                        value: ' Régimen:'
                                    },
                                    {
                                        xtype: 'combo',
                                        anchor: '100%',
                                        name: 'cbRegimen',
                                        allowBlank: false,
                                        store: 'StoreTipoRegimen',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        emptyText: 'Seleccione Régimen....',
                                        forceSelection: true,
                                        listWidth: 150,
                                        id: 'strTipoAfiliado'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                fieldLabel: 'Descripción',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 320,
                                        maxLength: 150,
                                        allowBlank: false,
                                        emptyText: 'Descripción',
                                        id: 'strDescripcion'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtDescFac',
                                        value: ' Descripción Factura: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 330,
                                        maxLength: 150,
                                        allowBlank: false,
                                        emptyText: 'Descripción que Aparecerá en la Factura',
                                        id: 'strDescripcionFac'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                fieldLabel: 'Dir / Tel / Email',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        fieldLabel: 'Dirección',
                                        maxLength: 100,
                                        width: 268,
                                        allowBlank: false,
                                        emptyText: 'Dirección',
                                        id: 'strDireccion'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        fieldLabel: 'Teléfono',
                                        maxLength: 100,
                                        width: 245,
                                        allowBlank: false,
                                        emptyText: 'Teléfono',
                                        id: 'strTelefono'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        fieldLabel: 'Email',
                                        maxLength: 200,
                                        width: 245,
                                        vtype: 'email',
                                        allowBlank: true,
                                        emptyText: 'Email',
                                        id: 'strEmail'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                style: 'background:transparent;',
                                fieldLabel: 'Verificar',
                                items: [
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtFacPac',
                                        value: 'Fac. por Paciente:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolFacturarPaciene'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtFacProfe',
                                        value: 'Fac. Particulares:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolFacturarParticular'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtRdoAut',
                                        value: 'Recaudo Automatico Particulares:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolRdoAutomaticoParticular'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtcopagos',
                                        value: 'Fac. Copagos:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolFacturarCopagos'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtcopagos1',
                                        value: 'Copago Digitado:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolCopagoDigitado'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtusala',
                                        value: 'Usa Listado:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolUsaListadoAtencion'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                style: 'background:transparent;',
                                fieldLabel: '',
                                items: [
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtusala1',
                                        value: 'Usa Fuera Listado:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolAtenderFueraListado'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtusamul',
                                        value: 'Multas:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolUsaMultas'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtusaaud',
                                        value: 'Usa Auditoria:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolUsaAuditoria'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtreqautoriza',
                                        value: 'Usa Autoriza:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolRequiereAutorizacion'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtrdomx',
                                        value: 'Rdo. Mx:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolRecaudoMedicamentos'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtrdorem',
                                        value: 'Rdo. Rem.:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolRecaudoRemisiones'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'systxtrdoord',
                                        value: 'Rdo. Ord.:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'bolRecaudoOrdenamientos'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        style: 'color:#00C;',
                                        id: 'sysActivo',
                                        value: 'ACTIVO:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'true',
                                        id: 'bolActivo'
                                    }
                                ]
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuario',
                                value: 0
                            },
                        ]
                    },
                    {
                        xtype: 'tabpanel',
                        id: 'tbOpcionesProfesionales',
                        activeTab: 0,
                        height: 285,
                        border: false,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Tarifas',
                                items: [
                                    {
                                        xtype: 'grid',
                                        id: 'gridTarifasCliente',
                                        store: stTarifasClientes,
                                        anchor: "100%",
                                        border: false,
                                        frame: true,
                                        height: 255,
                                        loadMask: true,
                                        stripeRows: true,
                                        columns: [
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'IdPrestador',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdPrestador'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'IdCliente',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdCliente'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Tipo Estudio',
                                                sortable: false,
                                                width: 375,
                                                hidden: false,
                                                hideable: false,
                                                dataIndex: 'TipoEstudio'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Manual Tarifario',
                                                sortable: false,
                                                width: 375,
                                                hidden: false,
                                                hideable: false,
                                                dataIndex: 'ManualTarifario'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Ajuste Tarifa',
                                                sortable: false,
                                                width: 120,
                                                hidden: false,
                                                hideable: false,
                                                renderer: function(v, params, record){
                                                    return (record.data.Ajuste * 100) + " %";
                                                },
                                                dataIndex: 'Ajuste'
                                            }
                                        ],
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar Tarifa',
                                                        iconCls: 'btnAddRow',
                                                        id: 'btnAddTarifa'
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar Tarifa',
                                                        iconCls: 'btnDelRow',
                                                        id: 'btnDelTarifa'
                                                    }
                                                ]
                                            }
                                    }
                                ]
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            ref: '../btn_AdicionarItemFrm',
                            id: 'btn_AdicionarItemFrm'
                        },
                        {
                            xtype: 'button',
                            text: 'Modificar',
                            iconCls: 'btnGuardar',
                            ref: '../btn_ModificarItemFrm',
                            id: 'btn_ModificarItemFrm'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            ref: '../btn_SalirItemFrm',
                            id: 'btn_SalirItemFrm'
                        }
                    ]
                }
            }
        ];
        winClientesUi.superclass.initComponent.call(this);
    }
});
