/*
* @category    Formulario Conceptos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winConceptosUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Conceptos ::.',
    width: 900,
    height: 600,
    modal: true,
    closable: false,
    id: 'winConceptos',
    initComponent: function() {
        var summary = new Ext.ux.grid.GroupSummary();
        var dataNatCuenta = [
            ['D','DEBITO'],
            ['C','CREDITO']
        ];
        var stNatCuenta = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stNatCuenta.loadData(dataNatCuenta);
        
        var dataVerKardex = [
            ['GENERAL']
        ];
        var stVerKardex = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stVerKardex.loadData(dataVerKardex);
        
        var stGridMovimientoxConceptos = new StoreGridMovimientoxConceptos();
        stGridMovimientoxConceptos.setBaseParam('pEmpresa', ID_EMPRESA);
        stGridMovimientoxConceptos.setBaseParam('pIPS', ID_IPS);
        stGridMovimientoxConceptos.load();
        
        var stGridLotesxConceptos = new StoreGridLotesxConceptos();
        
        var stBodegas = new StoreBodegas();
        stBodegas.load({
            params: {
                pIPS: ID_IPS
            }
        });
        
        var stBodegasZonas = new StoreBodegasZonas();
        
        function VerInfoLoteVenc(value, metaData, record, rowIndex, colIndex, store){  
            if(record.get('Activo') === "SI"){
                wActivo = "Activo";
            }else{
                wActivo = "Inactivo";
            }
            metaData.attr = 'style="white-space:normal"';  
            return 'Nro Lote: ' + value + '</br>Vencimiento: ' + record.get('Vencimiento') + '</br>Estado: ' + wActivo;
        }
        
        function DescripcionConceptoMvto(val, x, store){
            var html = '<table><tr><td>'+val+'</td></tr></table>';
            return html;
        }
        
        this.items = [
            {
                xtype: 'tabpanel',
                id: 'tbOpcionesConceptos',
                activeTab: 0,
                height: 570,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Datos Básicos',
                        items:[
                            {
                                xtype: 'form',
                                frame: true,
                                anchor: '100%',
                                autoScroll: true,
                                id: 'frmConceptos',
                                padding: 10,
                                height: 515,
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: '',
                                        layout: 'form',
                                        border: false,
                                        collapseFirst: false,
                                        collapsible: false,
                                        animCollapse: false,
                                        titleCollapse: false,
                                        width: 830,
                                        autoHeight: true,
                                        id: 'fs0',
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                border: false,
                                                labelWidth: 100,
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'intIdProced',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'intUsuario',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'strTipoCodificacion',
                                                        value: "CUPS"
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        frame: true,
                                                        fieldLabel: 'Codigo Interno',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 115,
                                                                maxLength: 20,
                                                                allowBlank: false,
                                                                emptyText: 'Codigo',
                                                                id: 'strCodProced'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCUPS',
                                                                value: 'CUPS:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 110,
                                                                maxLength: 20,
                                                                allowBlank: false,
                                                                emptyText: 'CUPS',
                                                                id: 'strCUPSCodigo'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysTipoRegistro',
                                                                value: 'Tipo Registro:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 135,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                emptyText: 'Seleccione...!',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                store: 'StoreTipoRegistroConcepto',
                                                                forceSelection: false,
                                                                allowBlank: false,
                                                                id: 'intTipoRegProced'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysUtilización',
                                                                value: 'Utilización:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                emptyText: 'Seleccione...!',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                store: 'StoreUtilizacionConcepto',
                                                                forceSelection: false,
                                                                allowBlank: false,
                                                                id: 'strUtilizacion'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysPOS',
                                                                value: '  POS:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                labelStyle: 'color: Brown;',
                                                                anchor: '100%',
                                                                value: 'true',
                                                                id: 'bolPOS'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        frame: true,
                                                        fieldLabel: 'Descripción',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                width: 485,
                                                                fieldLabel: 'Descripción',
                                                                allowBlank: false,
                                                                emptyText: 'Digite la Descripcón del Concepto',
                                                                id: 'strDesProced'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCBARRAS',
                                                                value: 'C/Barras:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 160,
                                                                allowBlank: true,
                                                                id: 'strCodigoBarras'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        frame: true,
                                                        fieldLabel: 'Tipo Estudio',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 205,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                emptyText: 'Seleccione...!',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                store: 'StoreTipoEstudio',
                                                                forceSelection: false,
                                                                allowBlank: false,
                                                                id: 'intIdTipoEstudio'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysNivel',
                                                                value: 'Nivel:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 40,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                emptyText: 'Seleccione...!',
                                                                valueField: 'Codigo',
                                                                displayField: 'Codigo',
                                                                store: 'StoreNivelConcepto',
                                                                forceSelection: false,
                                                                allowBlank: false,
                                                                id: 'intNivelProced'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysQX',
                                                                value: 'Es Qx?:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                labelStyle: 'color: Brown;',
                                                                anchor: '100%',
                                                                value: 'true',
                                                                tooltip: 'Es Quirurgico',
                                                                id: 'bolEsCX'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysMX',
                                                                value: 'Es Mx?:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                labelStyle: 'color: Brown;',
                                                                anchor: '100%',
                                                                value: 'true',
                                                                toolTip: 'Es Medicamento',
                                                                id: 'bolEsMX'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysAnatomo',
                                                                value: 'Es Anatomopatológico?:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                labelStyle: 'color: Brown;',
                                                                anchor: '100%',
                                                                value: 'true',
                                                                id: 'bolEsAnatomo'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysLAB',
                                                                value: 'Es Laboratorio?:'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                labelStyle: 'color: Brown;',
                                                                anchor: '100%',
                                                                value: 'true',
                                                                id: 'bolEsLab'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Preparación Especial',
                                                        allowBlank: true,
                                                        emptyText: 'Digite la información de la preparación especial para la prestación del servicio',
                                                        id: 'strPreparacionEspecial'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        frame: true,
                                                        fieldLabel: 'Archivo Externo',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysPrefijo',
                                                                value: 'Prefijo:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 65,
                                                                maxLength: 5,
                                                                allowBlank: true,
                                                                id: 'strPrefijoArchivo'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysArchivo',
                                                                value: 'Archivo:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 543,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                emptyText: 'Seleccione...!',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                store: 'StoreArchivosAnexosConceptos',
                                                                forceSelection: false,
                                                                allowBlank: true,
                                                                id: 'strArchivoPlantilla'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        frame: true,
                                                        fieldLabel: 'Cantidad Máxima',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                minValue: 0,
                                                                width: 30,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intCantidadMaxSol'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysDiasReq',
                                                                value: 'Días Requeridos:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                minValue: 0,
                                                                width: 30,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intMinDiasSol'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysNumeralPyP',
                                                                value: 'Numeral PyP:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 90,
                                                                allowBlank: true,
                                                                id: 'strNumeralPyP'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysNumeralOdo',
                                                                value: 'Numeral Odontología:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 90,
                                                                allowBlank: true,
                                                                id: 'strNumeralNumeralODO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCosto',
                                                                value: 'Costo:'
                                                            },
                                                            {
                                                                xtype: 'numericfield',
                                                                currencySymbol: "$",
                                                                width: 110,
                                                                useThousandSeparator: true,
                                                                alwaysDisplayDecimals: true,
                                                                thousandSeparator: ',',
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                labelStyle: '',
                                                                value: 0,
                                                                id: 'intVlrCosto'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        html:'<hr>',border: false
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Nro. Cuenta',
                                                width: 200,
                                                allowBlank: true,
                                                id: 'strcodCuenta'
                                            },
                                            {
                                                html: 'Naturaleza:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 90,
                                                triggerAction: 'all',
                                                mode: 'local',
                                                typeAhead: true,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                store: stNatCuenta,
                                                forceSelection: true,
                                                allowBlank: true,
                                                id: 'strnatCuenta'
                                            },
                                            {
                                                html: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Usa IVA:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                labelStyle: 'color: Brown;',
                                                anchor: '100%',
                                                id: 'bolUsaIVA'
                                            },
                                            {
                                                html: '-'
                                            },
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "%",
                                                width: 70,
                                                useThousandSeparator: false,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                decimalPrecision: 2,
                                                allowBlank: false,
                                                labelStyle: '',
                                                value: 0,
                                                maxValue: 100,
                                                minValue: 0,
                                                id: 'intIVA'
                                            }
                                        ]
                                    },
                                    {
                                        html:'<hr>',border: false
                                    },
                                    {
                                        xtype: 'compositefield',
                                        frame: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'checkbox',
                                                fieldLabel: 'Usar Kardex Inv.',
                                                labelStyle: 'color: Brown;',
                                                anchor: '100%',
                                                value: 'true',
                                                id: 'bolManejaKardex'
                                            },
                                            {
                                                html: 'Usar Lote y Vencimientos:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                labelStyle: 'color: Brown;',
                                                anchor: '100%',
                                                value: 'true',
                                                id: 'bolUsaLoteVencimiento'
                                            },
                                            {
                                                html: 'Concepto Radicacion:'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Concepto',
                                                id: 'btnSearchConceptoRadicaInst',
                                                handler:function(){
                                                    buscarconceptoBasico('Conceptos');
                                                }
                                            },
                                            {
                                                xtype: 'hidden',
                                                flex: 1,
                                                readOnly: true,
                                                allowBlank: true,
                                                width: 96,
                                                id: 'intIdConceptoRadicaInst'
                                            },
                                            {
                                                xtype: 'textfield',
                                                flex: 1,
                                                readOnly: true,
                                                width: 96,
                                                allowBlank: true,
                                                style: 'color: #0000cc; font-weight: bold;',
                                                id: 'sysCodConceptoRadicaInst'
                                            },
                                            {
                                                xtype: 'textarea',
                                                flex: 1,
                                                readOnly: true,
                                                allowBlank: true,
                                                width: 265,
                                                height: 50,
                                                style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                                id: 'sysDesConceptoRadicaInst'
                                            }
                                        ]
                                    },
                                    {
                                        html:'<hr>',border: false
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Quirurgico',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 830,
                                        autoHeight: true,
                                        id: 'fsQx',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysUVR',
                                                        value: 'UVR:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        minValue: 0,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        id: 'intUVR'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysGrupoQX',
                                                        value: 'Grupo Qx:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'intGrupoQx'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Medicamentos',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 830,
                                        autoHeight: true,
                                        id: 'fsMx',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                fieldLabel: 'Codigo Ministerio',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        allowBlank: true,
                                                        anchor: '100%',
                                                        id: 'strCodMxMinisterio'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysCUM',
                                                        value: 'Codigo CUM:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strCodigoCUM'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysINVIMA',
                                                        value: 'Registro INVIMA:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strRegistroINVIMA'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Principio Activo',
                                                anchor: '100%',
                                                triggerAction: 'all',
                                                mode: 'local',
                                                typeAhead: true,
                                                emptyText: 'Seleccione...!',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                store: 'StoreMxPrincipioActivo',
                                                forceSelection: false,
                                                allowBlank: true,
                                                value: 1,
                                                id: 'intPrincipioActivo'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Presentación',
                                                anchor: '100%',
                                                triggerAction: 'all',
                                                mode: 'local',
                                                typeAhead: true,
                                                emptyText: 'Seleccione...!',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                store: 'StoreMxPresentacion',
                                                forceSelection: false,
                                                allowBlank: true,
                                                value: 1,
                                                id: 'intPresentacion'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Forma Farmac.',
                                                anchor: '100%',
                                                triggerAction: 'all',
                                                mode: 'local',
                                                typeAhead: true,
                                                emptyText: 'Seleccione...!',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                store: 'StoreMxFormaFarmaceutica',
                                                forceSelection: false,
                                                allowBlank: true,
                                                value: 1,
                                                id: 'intFormaFarmaceutica'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                fieldLabel: 'Concentración',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        width: 175,
                                                        listWidth: 350,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        emptyText: 'Seleccione...!',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        store: 'StoreMxConcentracion',
                                                        forceSelection: false,
                                                        allowBlank: true,
                                                        value: 1,
                                                        id: 'intConcentracion'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysUnidadMed',
                                                        value: 'Unidad Medida:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 170,
                                                        listWidth: 350,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        emptyText: 'Seleccione...!',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        store: 'StoreMxUnidadMedida',
                                                        forceSelection: false,
                                                        allowBlank: true,
                                                        value: 1,
                                                        id: 'intUnidadMedida'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysDosis',
                                                        value: 'Dosis Máxima Paciente:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        minValue: 0,
                                                        value: 0,
                                                        decimalPrecision: 0,
                                                        allowBlank: false,
                                                        id: 'intDosisMaxPac'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Laboratorio',
                                                anchor: '100%',
                                                triggerAction: 'all',
                                                mode: 'local',
                                                typeAhead: true,
                                                emptyText: 'Seleccione...!',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                store: 'StoreMxLaboratorio',
                                                forceSelection: false,
                                                allowBlank: true,
                                                value: 1,
                                                id: 'intLaboratorio'
                                            }
                                        ]
                                    },
									{
                                        xtype: 'fieldset',
                                        title: 'NO POS',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 830,
                                        autoHeight: true,
                                        id: 'fsNOPOS',
                                        items: [
											{
												xtype: 'compositefield',
												anchor: '100%',
												style: 'background:transparent;',
												items: [
													{
														xtype: 'combo',
														fieldLabel: 'Homologo',
														name: 'Homologo',
														width: 70,
														allowBlank: true,
														readOnly: true,
														store: 'StoreSiNo',
														forceSelection: true,
														triggerAction: 'all',
														typeAhead: true,
														typeAheadDelay: 50,
														mode: 'local',
														valueField: 'Descripcion',
														displayField: 'Descripcion',
														emptyText: 'Seleccione....',
														submitValue: true,
														id: 'strNOPOSHomologo',
														listeners:{
															select : function(cmb, rec, idx){
																if(cmb.getValue() === "SI"){
																	Ext.getCmp('strNOPOSHomologoPrincipio').setReadOnly(false);
																	Ext.getCmp('strNOPOSHomologoPrincipio').allowBlank = false;
																	Ext.getCmp('strNOPOSHomologoPresentacion').setReadOnly(false);
																	Ext.getCmp('strNOPOSHomologoPresentacion').allowBlank = false;
																	Ext.getCmp('strNOPOSHomologoPosologia').setReadOnly(false);
																	Ext.getCmp('strNOPOSHomologoPosologia').allowBlank = false;
																	Ext.getCmp('strNOPOSHomologoDosisDia').setReadOnly(false);
																	Ext.getCmp('strNOPOSHomologoDosisDia').allowBlank = false;
																	Ext.getCmp('strNOPOSHomologoCantidad').setReadOnly(false);
																	Ext.getCmp('strNOPOSHomologoCantidad').allowBlank = false;
																	Ext.getCmp('strNOPOSHomologoTiempoMeses').setReadOnly(false);
																	Ext.getCmp('strNOPOSHomologoTiempoMeses').allowBlank = false;
																}else{
																	Ext.getCmp('strNOPOSHomologoPrincipio').clearInvalid();
																	Ext.getCmp('strNOPOSHomologoPrincipio').setReadOnly(true);
																	Ext.getCmp('strNOPOSHomologoPrincipio').setValue(null);
																	Ext.getCmp('strNOPOSHomologoPrincipio').allowBlank = true;
																	Ext.getCmp('strNOPOSHomologoPresentacion').clearInvalid();
																	Ext.getCmp('strNOPOSHomologoPresentacion').setReadOnly(true);
																	Ext.getCmp('strNOPOSHomologoPresentacion').setValue(null);
																	Ext.getCmp('strNOPOSHomologoPresentacion').allowBlank = true;
																	Ext.getCmp('strNOPOSHomologoPosologia').clearInvalid();
																	Ext.getCmp('strNOPOSHomologoPosologia').setReadOnly(true);
																	Ext.getCmp('strNOPOSHomologoPosologia').setValue(null);
																	Ext.getCmp('strNOPOSHomologoPosologia').allowBlank = true;
																	Ext.getCmp('strNOPOSHomologoDosisDia').clearInvalid();
																	Ext.getCmp('strNOPOSHomologoDosisDia').setReadOnly(true);
																	Ext.getCmp('strNOPOSHomologoDosisDia').setValue(null);
																	Ext.getCmp('strNOPOSHomologoDosisDia').allowBlank = true;
																	Ext.getCmp('strNOPOSHomologoCantidad').clearInvalid();
																	Ext.getCmp('strNOPOSHomologoCantidad').setReadOnly(true);
																	Ext.getCmp('strNOPOSHomologoCantidad').setValue(null);
																	Ext.getCmp('strNOPOSHomologoCantidad').allowBlank = true;																	
																	Ext.getCmp('strNOPOSHomologoTiempoMeses').clearInvalid();
																	Ext.getCmp('strNOPOSHomologoTiempoMeses').setReadOnly(true);
																	Ext.getCmp('strNOPOSHomologoTiempoMeses').setValue(null);
																	Ext.getCmp('strNOPOSHomologoTiempoMeses').allowBlank = true;
																}
															}
														}
													},
													{
														html: 'Principio Activo:'
													},
													{
														xtype: 'textfield',
														width: 535,
														name: 'Principio Activo:',
														allowBlank: true,
														readOnly: true,
														id: 'strNOPOSHomologoPrincipio'
													}
												]
											},
											{
												xtype: 'compositefield',
												anchor: '100%',
												style: 'background:transparent;',
												items: [
													{
														xtype: 'textfield',
														width: 317,
														fieldLabel: 'Presentacion',
														name: 'Presentacion',
														allowBlank: true,
														readOnly: true,
														id: 'strNOPOSHomologoPresentacion'
													},
													{
														html: 'Posologia:'
													},
													{
														xtype: 'textfield',
														width: 320,
														name: 'Posologia',
														allowBlank: true,
														readOnly: true,
														id: 'strNOPOSHomologoPosologia'
													}
												]
											},
											{
												xtype: 'compositefield',
												anchor: '100%',
												style: 'background:transparent;',
												items: [
													{
														xtype: 'textfield',
														width: 200,
														fieldLabel: 'Dosis/Dia',
														name: 'Dosis/Dia',
														allowBlank: true,
														readOnly: true,
														id: 'strNOPOSHomologoDosisDia'
													},
													{
														html: 'Cantidad:'
													},
													{
														xtype: 'textfield',
														width: 120,
														name: 'Cantidad',
														allowBlank: true,
														readOnly: true,
														id: 'strNOPOSHomologoCantidad'
													},
													{
														html: 'Tiempo/Meses:'
													},
													{
														xtype: 'textfield',
														width: 227,
														name: 'Tiempo/Meses',
														allowBlank: true,
														readOnly: true,
														id: 'strNOPOSHomologoTiempoMeses'
													}
												]
											},
											{
												xtype: 'textarea',
												anchor: '100%',
												fieldLabel: 'Respuesta Clinica Alcanzada',
												emptyText: 'RESPUESTA CLINICA Y PARACLINICA ALCANZADA CON MEDICAMENTOS, PROCEDIMIENTOS Y/O INSUMOS POS UTILIZADOS',
												allowBlank: true,
												readOnly: true,
												id: 'strNOPOSHomologoRespuestaClinica'
											},
											{
												xtype: 'textarea',
												anchor: '100%',
												fieldLabel: 'Contraindicacion Uso POS',
												emptyText: 'Si no se utilizaron alternativas POS, indique si HAY INDICACION EXPRESA O CONTRAINDICACION EXPRESA PARA LA UTILIZACION DE OPCIONES POS',
												allowBlank: true,
												readOnly: true,
												id: 'strNOPOSHomologoContraindicacion'
											},
											{
												html: '<hr>'
											},
											{
												xtype: 'textarea',
												anchor: '100%',
												fieldLabel: 'Justificacion',
												emptyText: 'JUSTIFICACION PARA EL USO DEL MEDICAMENTO, PROCEDIMIENTO O INSUMO NO POS',
												allowBlank: true,
												readOnly: true,
												id: 'strNOPOSJustificacion'
											}
										]
									},
                                    {
                                        xtype: 'fieldset',
                                        title: 'Laboratorio Clínico',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 830,
                                        autoHeight: true,
                                        id: 'fsLab',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                fieldLabel: 'Interpretación',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        allowBlank: true,
                                                        width: 620,
                                                        id: 'strLabInterpretacion'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysPrintInterpreta',
                                                        value: 'Imprimir:'
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        labelStyle: 'color: Brown;',
                                                        anchor: '100%',
                                                        id: 'bolLabPrintInterpretacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                fieldLabel: 'Técnica',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        allowBlank: true,
                                                        width: 620,
                                                        id: 'strLabTecnica'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysPrintInterpreta',
                                                        value: 'Imprimir:'
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        labelStyle: 'color: Brown;',
                                                        anchor: '100%',
                                                        id: 'bolLabPrintTecnica'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                fieldLabel: 'Otros',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        allowBlank: true,
                                                        width: 620,
                                                        id: 'strLabOtros'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysPrintInterpreta',
                                                        value: 'Imprimir:'
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        labelStyle: 'color: Brown;',
                                                        anchor: '100%',
                                                        id: 'bolLabPrintOtros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'checkbox',
                                                anchor: '100%',
                                                fieldLabel: 'Formato 2 Columnas',
                                                id: 'bolLabFormato2Cols'
                                            }
                                        ]
                                    }
                                ],
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_AdicionarItemFrm'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Modificar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_ModificarItemFrm'
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Lotes - Vencimientos / Kardex Inventario',
                        frame: true,
                        border: false,
                        layout: 'form',
                        listeners:{
                            beforeshow : function(){
                                Ext.getCmp('systxtInfoConcepto').setValue(Ext.getCmp('strCodProced').getValue() + ' - ' + Ext.getCmp('strDesProced').getValue());
                            }
                        },
                        items:[
                            {
                                xtype: 'panel',
                                layout: 'form',
                                frame: true,
                                border: false,
                                style: 'background:transparent;',
                                labelWidth: 0.1,
                                items: [
                                    {
                                        xtype: 'textfield',
                                        style: 'text-transform:uppercase; color: #610B0B; font-size: 13px; font-weight: bold;',
                                        allowBlank: true,
                                        readOnly: true,
                                        width: 850,
                                        id: 'systxtInfoConcepto'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                border: false, 
                                autoHeight: true,
                                layout: {
                                    columns: 2,
                                    type: 'table'
                                },
                                items:[
                                    {
                                        xtype: 'panel',
                                        //title: 'Lotes/Vencimientos',
                                        //autoHeight: true,
                                        autoScroll: true,
                                        width: 195,
                                        height: 415,
                                        frame: true,
                                        border: false,
                                        tbar: {
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    text: 'Adicionar',
                                                    iconCls: 'btnAddRow',
                                                    tooltip: 'Adicionar',
                                                    id: 'btnAdicionarLoteVenc',
                                                    listeners: {
                                                        click: function() {
                                                            if(Ext.getCmp('intIdProced').getValue() !== 0 && Ext.getCmp('intIdProced').getValue() !== "0"){
                                                                winLotes = new winLotesUi();
                                                                Ext.getCmp('intIdProcedLote').setValue(Ext.getCmp('intIdProced').getValue());
                                                                Ext.getCmp('intUsuarioLote').setValue(ID_USUARIO);
                                                                winLotes.show();
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Eliminar',
                                                    iconCls: 'btnDelRow',
                                                    tooltip: 'Eliminar',
                                                    id: 'btnEliminarLoteVenc',
                                                    listeners: {
                                                        click: function() {
                                                            if(Ext.getCmp('gridLotesxConcepto').selModel.getCount() === 1){
                                                                var selections = Ext.getCmp('gridLotesxConcepto').selModel.getSelections();
                                                                if(selections[0].json.Activo === "SI"){
                                                                    Ext.Ajax.request({
                                                                        url: '../../controlador/inventario/controlador_inventario.php',
                                                                        params:{
                                                                            task: 'SALDO_GENERAL_LOTE',
                                                                            pLote: selections[0].json.idLote
                                                                        },
                                                                        success: function(response,options)
                                                                        {
                                                                            var Respuesta = response.responseText;
                                                                            var Contenido = Respuesta.split('^');
                                                                            if(Contenido[0] === "{success:false}"){
                                                                                Ext.MessageBox.show({
                                                                                    title: 'eOfiClinic',
                                                                                    msg: 'Ocurrio un error al validar el saldo de inventario del lote.',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                            } else {
                                                                                var SaldoInv = parseInt(Contenido[0], 10);
                                                                                if(SaldoInv > 0){
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'Lote',
                                                                                        msg: 'No podemos eliminar el lote ' + selections[0].json.Lote + ' porque presenta un saldo en inventario de: ' + SaldoInv + ' unidades.',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                }else{
                                                                                    winEliminarLotes = new winEliminarLotesUi();
                                                                                    Ext.getCmp('sysidLoteDelLote').setValue(selections[0].json.idLote);
                                                                                    Ext.getCmp('sysnroLoteDelLote').setValue(selections[0].json.Lote);
                                                                                    Ext.getCmp('sysVencimientoDelLote').setValue(selections[0].json.Vencimiento);
                                                                                    winEliminarLotes.show();
                                                                                }
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            Ext.MessageBox.show({
                                                                                title: 'Error Conexión',
                                                                                msg: 'No podemos realizar la validacion del saldo de inventario y/o No se pudo establecer conexión con el servidor',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        },
                                                                        scope:this 
                                                                    });
                                                                }
                                                            }else{
                                                                Ext.MessageBox.show({
                                                                    title: 'Error',
                                                                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        },
                                        bbar: {
                                            items: [
                                                '->',
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Consultar',
                                                    iconCls: 'btnActualizarGrid',
                                                    tooltip: 'Consultar',
                                                    id: 'btnActualizarLoteVenc',
                                                    listeners: {
                                                        click: function() {
                                                            if(Ext.getCmp('intIdProced').getValue() !== 0 && Ext.getCmp('intIdProced').getValue() !== null){
                                                                stGridLotesxConceptos.load({
                                                                    params: {
                                                                        pConcepto: Ext.getCmp('intIdProced').getValue()
                                                                    }
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        },
                                        items: [
                                            {
                                                xtype: 'grid',
                                                layout: 'fit',
                                                id: 'gridLotesxConcepto',
                                                store: stGridLotesxConceptos,
                                                anchor: "100%",
                                                height: 347,
                                                border: false,
                                                frame: true,
                                                loadMask: true,
                                                stripeRows : true,
                                                colModel: new Ext.ux.grid.LockingColumnModel([
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Id',
                                                        sortable: false,
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false,
                                                        dataIndex: 'idLote',
                                                        id: 'idLote'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Lote/Vencimiento',
                                                        sortable: true,
                                                        width: 130,
                                                        dataIndex: 'Lote',
                                                        renderer: VerInfoLoteVenc,
                                                        id: 'Lote'
                                                    }
                                                ]),
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                viewConfig: {
                                                    getRowClass: function(record, rowIndex, rp, ds){
                                                        var estado = record.data.Activo;
                                                        switch (estado){
                                                            case "NO":
                                                                return 'NoActivo';
                                                                break;
                                                            default:
                                                                break;
                                                        }
                                                    }
                                                },
                                                listeners:{
                                                    rowclick : function(grid, fila, e){
                                                        Ext.getCmp('sysTotEntradas').setValue(null);
                                                        Ext.getCmp('sysTotSalidas').setValue(null);
                                                        Ext.getCmp('sysTotSaldo').setValue(null);
                                                        var selections = grid.selModel.getSelections();
                                                        stGridMovimientoxConceptos.setBaseParam('pEmpresa', ID_EMPRESA);
                                                        stGridMovimientoxConceptos.setBaseParam('pIPS', ID_IPS);
                                                        stGridMovimientoxConceptos.setBaseParam('pTipoKardex', "POR LOTE");
                                                        stGridMovimientoxConceptos.setBaseParam('pBodega', Ext.getCmp('sysBtnBodega').getValue());
                                                        stGridMovimientoxConceptos.setBaseParam('pZona', Ext.getCmp('sysBtnZona').getValue());
                                                        stGridMovimientoxConceptos.setBaseParam('pConcepto', Ext.getCmp('intIdProced').getValue());
                                                        stGridMovimientoxConceptos.setBaseParam('pLote', selections[0].json.idLote);
                                                        stGridMovimientoxConceptos.load({
                                                            callback: function(){
                                                                Ext.Ajax.request({
                                                                    url: '../../controlador/inventario/controlador_inventario.php',
                                                                    params:{
                                                                        task: 'SALDO_LOTE',
                                                                        pEmpresa: ID_EMPRESA,
                                                                        pIPS: ID_IPS,
                                                                        pBodega: Ext.getCmp('sysBtnBodega').getValue(),
                                                                        pZona: Ext.getCmp('sysBtnZona').getValue(),
                                                                        pLote: selections[0].json.idLote
                                                                    },
                                                                    success: function(response,options){
                                                                        var Respuesta = response.responseText;
                                                                        var Contenido = Respuesta.split('^');
                                                                        if(Contenido[0] !== "{success:false}"){
                                                                            var EntradasInv = parseInt(Contenido[0]);
                                                                            var SalidasInv = parseInt(Contenido[1]);
                                                                            var SaldoInv = parseInt(Contenido[2]);
                                                                            Ext.getCmp('sysTotEntradas').setValue(EntradasInv);
                                                                            Ext.getCmp('sysTotSalidas').setValue(SalidasInv);
                                                                            Ext.getCmp('sysTotSaldo').setValue(SaldoInv);
                                                                        }
                                                                    },
                                                                    failure: function(response,options){
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error Conexión',
                                                                            msg: 'No podemos realizar la validacion del saldo de inventario y/o No se pudo establecer conexión con el servidor',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    },
                                                                    scope:this 
                                                                });
                                                            }
                                                        });
                                                        
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        //title: 'Kaxdex Iventario',
                                        width: 685,
                                        height: 415,
                                        tbar:{
                                            items: [
                                                {
                                                    html: 'Bodega:'
                                                },
                                                {
                                                    xtype: 'combo',
                                                    width: 110,
                                                    allowBlank: true,
                                                    store: stBodegas,
                                                    valueField: 'IdBodega',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'sysBtnBodega',
                                                    listeners: {
                                                        select: function(cmb, rec, idx) {
                                                            Ext.getCmp('sysBtnZona').clearValue();
                                                            Ext.getCmp('sysBtnZona').store.removeAll(true);

                                                            Ext.getCmp('sysBtnZona').store.load({
                                                                params: { 
                                                                    pIPS: ID_IPS ,
                                                                    pBodega: cmb.getValue() 
                                                                }
                                                            });
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    html: 'Zona:'
                                                },
                                                {
                                                    xtype: 'combo',
                                                    width: 110,
                                                    allowBlank: true,
                                                    store: stBodegasZonas,
                                                    valueField: 'IdZona',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'sysBtnZona'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    html: 'Ver Kardex:'
                                                },
                                                {
                                                    xtype: 'combo',
                                                    width: 110,
                                                    allowBlank: false,
                                                    store: stVerKardex,
                                                    valueField: 'Descripcion',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    value: 'GENERAL',
                                                    id: 'sysBtnTipoKardex'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Consultar',
                                                    iconCls: 'btnActualizarGrid',
                                                    tooltip: 'Consultar',
                                                    id: 'btnActualizarKardex',
                                                    listeners: {
                                                        click: function() {
                                                            if(Ext.getCmp('intIdProced').getValue() !== 0 && Ext.getCmp('intIdProced').getValue() !== null){
                                                                if(Ext.getCmp('sysBtnTipoKardex').getValue() === "GENERAL"){
                                                                    stGridMovimientoxConceptos.setBaseParam('pEmpresa', ID_EMPRESA);
                                                                    stGridMovimientoxConceptos.setBaseParam('pIPS', ID_IPS);
                                                                    stGridMovimientoxConceptos.setBaseParam('pTipoKardex', "GENERAL");
                                                                    stGridMovimientoxConceptos.setBaseParam('pBodega', Ext.getCmp('sysBtnBodega').getValue());
                                                                    stGridMovimientoxConceptos.setBaseParam('pZona', Ext.getCmp('sysBtnZona').getValue());
                                                                    stGridMovimientoxConceptos.setBaseParam('pConcepto', Ext.getCmp('intIdProced').getValue());
                                                                    stGridMovimientoxConceptos.load({
                                                                        callback: function(){
                                                                            Ext.Ajax.request({
                                                                                url: '../../controlador/inventario/controlador_inventario.php',
                                                                                params:{
                                                                                    task: 'SALDO_CONCEPTO',
                                                                                    pEmpresa: ID_EMPRESA,
                                                                                    pIPS: ID_IPS,
                                                                                    pBodega: Ext.getCmp('sysBtnBodega').getValue(),
                                                                                    pZona: Ext.getCmp('sysBtnZona').getValue(),
                                                                                    pConcepto: Ext.getCmp('intIdProced').getValue()
                                                                                },
                                                                                success: function(response,options){
                                                                                    var Respuesta = response.responseText;
                                                                                    var Contenido = Respuesta.split('^');
                                                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                        Ext.MessageBox.show({
                                                                                            title: 'eOfiClinic',
                                                                                            msg: 'Ocurrio un error al validar el saldo de inventario.',
                                                                                            buttons: Ext.MessageBox.OK,
                                                                                            icon: Ext.MessageBox.ERROR
                                                                                        });
                                                                                    } else {
                                                                                        var EntradasInv = parseInt(Contenido[0]);
                                                                                        var SalidasInv = parseInt(Contenido[1]);
                                                                                        var SaldoInv = parseInt(Contenido[2]);
                                                                                        Ext.getCmp('sysTotEntradas').setValue(EntradasInv);
                                                                                        Ext.getCmp('sysTotSalidas').setValue(SalidasInv);
                                                                                        Ext.getCmp('sysTotSaldo').setValue(SaldoInv);
                                                                                    }
                                                                                },
                                                                                failure: function(response,options){
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'Error Conexión',
                                                                                        msg: 'No podemos realizar la validacion del saldo de inventario y/o No se pudo establecer conexión con el servidor',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                },
                                                                                scope:this 
                                                                            });
                                                                        }
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        },
                                        items: [
                                            {
                                                xtype: 'grid',
                                                layout: 'fit',
                                                id: 'gridMovimientosxConcepto',
                                                store: stGridMovimientoxConceptos,
                                                anchor: "100%",
                                                height: 390,
                                                border: false,
                                                frame: true,
                                                loadMask: true,
                                                //plugins	: summary,
                                                colModel: new Ext.ux.grid.LockingColumnModel([
                                                    {
                                                        header: 'Grupo',
                                                        readOnly: true,
                                                        sortable: false,
                                                        dataIndex: 'IdGrupo',
                                                        width: 1,
                                                        hidden: true,
                                                        hideable: false
                                                    },{
                                                        xtype: 'gridcolumn',
                                                        header: 'Fecha',
                                                        sortable: false,
                                                        hideable: false,
                                                        width: 68,
                                                        dataIndex: 'FecMovimiento',
                                                        id: 'FecMovimiento'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Concepto',
                                                        sortable: false,
                                                        hideable: false,
                                                        width: 180,
                                                        dataIndex: 'DescConcepto',
                                                        renderer: DescripcionConceptoMvto,
                                                        id: 'DescConcepto'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Inicial /Saldo Ant.',
                                                        sortable: false,
                                                        hideable: false,
                                                        width: 100,
                                                        dataIndex: 'SaldoIniAnt',
                                                        id: 'SaldoIniAnt'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Entradas',
                                                        sortable: false,
                                                        hideable: false,
                                                        width: 100,
                                                        //summaryType : "sum",
                                                        //render : function(v){
                                                        //    return v;
                                                        //},
                                                        dataIndex: 'Entradas',
                                                        id: 'Entradas'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Salidas',
                                                        sortable: false,
                                                        hideable: false,
                                                        width: 100,
                                                        dataIndex: 'Salidas',
                                                        id: 'Salidas'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Saldo',
                                                        sortable: false,
                                                        hideable: false,
                                                        width: 100,
                                                        dataIndex: 'Saldo',
                                                        id: 'Saldo'
                                                    }
                                                ]),
                                                stripeRows : true,
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                view: new Ext.grid.GroupingView({
                                                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
                                                }),
                                                bbar: new Ext.PagingToolbar({
                                                    pageSize: 15,
                                                    store: stGridMovimientoxConceptos,
                                                    displayInfo: true
                                                })
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                frame: true,
                                border: false,
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        //frame: true,
                                        //style: 'background:transparent;',
                                        items: [
                                            {
                                                html: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;+ Entradas:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                style: 'background-color:#69F; font-size: 13px; font-weight: bold; text-align:right;',
                                                allowBlank: true,
                                                readOnly: true,
                                                width: 110,
                                                id: 'sysTotEntradas'
                                            },
                                            {
                                                html: ' - Salidas:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                style: 'background-color:#F0C8C6; font-size: 13px; font-weight: bold; text-align:right;',
                                                allowBlank: true,
                                                readOnly: true,
                                                width: 110,
                                                id: 'sysTotSalidas'
                                            },
                                            {
                                                html: ' = Saldo:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                style: 'background-color:#CFC; font-size: 13px; font-weight: bold; text-align:right;',
                                                allowBlank: true,
                                                readOnly: true,
                                                width: 110,
                                                id: 'sysTotSaldo'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                    /*,
                    {
                        xtype: 'panel',
                        title: 'Plantilla Resultados Laboratorio Clínico',
                        items:[
                        ]
                    }*/
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirItemFrm'
                        }
                    ]
                }
            }
        ];
        winConceptosUi.superclass.initComponent.call(this);
    }
});