/*
* @category    Formulario Borrar Lotes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winEliminarLotesUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Eliminar Lotes ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winEliminarLotes',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmEliminarLotes',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysidLoteDelLote'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Nro Lote',
                        id: 'sysnroLoteDelLote'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Vencimiento',
                        id: 'sysVencimientoDelLote'
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'Motivo',
                        name: 'strMotivoDelLote',
                        maxLength: 250,
                        allowBlank: false,
                        emptyText: 'Digite el Motivo ...!',
                        id: 'strMotivoDelLote'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Eliminar',
                            iconCls: 'btnBorrar',
                            id: 'btnEliminarDelLote',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmEliminarLotes').getForm();
                                    if (frm.isValid()){
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea eliminar/inactivar el lote, si hace esto el lote quedara inactivo permanentemente en el sistema?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    frm.submit({
                                                        url: '../../controlador/inventario/controlador_inventario.php',
                                                        params: {
                                                            task: 'DEL_LOTE',
                                                            pEmpresa: ID_EMPRESA,
                                                            pIPS: ID_IPS,
                                                            pLote: Ext.getCmp('sysidLoteDelLote').getValue(),
                                                            pMotivo: QuitarAcentosMayusculas(Ext.getCmp('strMotivoDelLote').getValue()),
                                                            pUsuario: ID_USUARIO
                                                        },
                                                        success: function(res,req)
                                                        {
                                                            switch(req.result.requestedId){
                                                                case "1":
                                                                    Ext.getCmp('gridLotesxConcepto').store.reload();
                                                                    Ext.getCmp('winEliminarLotes').close();
                                                                    Ext.MessageBox.show({
                                                                        title: 'Lotes',
                                                                        msg: 'El Lote se Elimino con Exito.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.INFO
                                                                    });
                                                                    break;

                                                                default:
                                                                    Ext.getCmp('gridLotesxConcepto').store.reload();
                                                                    Ext.getCmp('winEliminarLotes').close();
                                                                    Ext.MessageBox.show({
                                                                        title: 'Lotes',
                                                                        msg: 'El Lote se Inactivo con Exito.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.INFO
                                                                    });
                                                                    break;
                                                            }
                                                        },
                                                        failure: function(response,options)
                                                        {
                                                            Ext.MessageBox.show({
                                                                title: 'Error Base Datos',
                                                                msg: 'No podemos Eliminar el Lote en estos momentos',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }
                                                    });
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'El Motivo de la Eliminacion es Requerido',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winEliminarLotesUi.superclass.initComponent.call(this);
    }
});
