/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmMaestroConceptos = Ext.extend(winFrmMaestroConceptosUi, {
    initComponent: function() {
        winFrmMaestroConceptos.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        ID_CONSULTORIO = el.getValue();
        
        IDGUARDAR = "NO";
        
        this.title = NOM_APLICACION + " .:: Maestro Conceptos ::.";

        if(NOM_APLICACION == "OfiClinic"){
            Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        }else{
            Ext.getCmp('fNomEmpresa').setValue("");
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("");
        }

        Ext.getCmp('gridFormulario').store.load({params: {query: null, start: 0, limit: 15}});
        Ext.getCmp('btnNoFilterItemGrid').setVisible(false);
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnAddItemGrid = Ext.getCmp('btnAddItemGrid').on("click",this.AddItemGrid,this);
        var btnDelItemGrid = Ext.getCmp('btnDelItemGrid').on("click",this.DelItemGrid,this);
        var btnEditItemGrid = Ext.getCmp('btnEditItemGrid').on("click",this.EditItemGrid,this);

        var btnGrouping1 = Ext.getCmp('btnGrouping1').on("click",this.GroupingGrid1,this);
        var btnGrouping2 = Ext.getCmp('btnGrouping2').on("click",this.GroupingGrid2,this);
        var btnGrouping3 = Ext.getCmp('btnGrouping3').on("click",this.GroupingGrid3,this);
        
        var btnFilterItemGrid = Ext.getCmp('btnFilterItemGrid').on("click",this.LlamarFiltro,this);
        var btnNoFilterItemGrid = Ext.getCmp('btnNoFilterItemGrid').on("click",this.QuitarFiltro,this);

    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    LlamarFiltro: function(){
        var winFilterConceptos = new winFilterConceptosUi();
        var btn_CancelFiltroProfe = Ext.getCmp('btn_CancelFiltroProfe').on("click",this.CancelarVentanaFiltro,this);
        var btn_FiltroProfe = Ext.getCmp('btn_FiltroProfe').on("click",this.AplicarFiltro,this);
        winFilterConceptos.show();
    },
    AplicarFiltro: function(){
        Ext.Msg.show({
            title: 'Búsqueda....!',
            msg: 'Esta seguro que desea aplicar los criterios de búsqueda?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if (Ext.getCmp('strqryTipoEstudioConcepto').getValue() == null || Ext.getCmp('strqryTipoEstudioConcepto').getValue() == "")
                    {
                        Ext.getCmp('sysTipoEstudioConcepto').setValue("Todos");
                    }else{
                        Ext.getCmp('sysTipoEstudioConcepto').setValue(Ext.getCmp('strqryTipoEstudioConcepto').getValue());
                    }
                    if (Ext.getCmp('strqryTipoRegistroConcepto').getValue() == null || Ext.getCmp('strqryTipoRegistroConcepto').getValue() == "")
                    {
                        Ext.getCmp('sysTipoRegistroConcepto').setValue("Todos");
                    }else{
                        Ext.getCmp('sysTipoRegistroConcepto').setValue(Ext.getCmp('strqryTipoRegistroConcepto').getValue());
                    }
                    if (Ext.getCmp('strqryClasificaoConcepto').getValue() == null || Ext.getCmp('strqryClasificaoConcepto').getValue() == "")
                    {
                        Ext.getCmp('sysClasificaoConcepto').setValue("Todos");
                    }else{
                        Ext.getCmp('sysClasificaoConcepto').setValue(Ext.getCmp('strqryClasificaoConcepto').getValue());
                    }
                    Ext.getCmp('gridFormulario').store.setBaseParam('pTipoReg', Ext.getCmp('sysTipoRegistroConcepto').getValue());
                    Ext.getCmp('gridFormulario').store.setBaseParam('pClasificacion', Ext.getCmp('sysClasificaoConcepto').getValue());
                    Ext.getCmp('gridFormulario').store.setBaseParam('pTipoEstudio', Ext.getCmp('sysTipoEstudioConcepto').getValue());
                    Ext.getCmp('gridFormulario').store.reload({
                        params: {
                            task: 'BUSCAR',
                            query: "Todos",
                            //pTipoReg: Ext.getCmp('sysTipoRegistroConcepto').getValue(),
                            //pClasificacion: Ext.getCmp('sysClasificaoConcepto').getValue(),
                            //pTipoEstudio: Ext.getCmp('sysTipoEstudioConcepto').getValue(),
                            start: 0,
                            limit: 15
                        }
                    });
                    if (Ext.getCmp('sysTipoRegistroConcepto').getValue() == "Todos" && Ext.getCmp('sysClasificaoConcepto').getValue() == "Todos" && Ext.getCmp('sysTipoEstudioConcepto').getValue() == "Todos")
                    {
                        Ext.getCmp('btnNoFilterItemGrid').setVisible(false);
                        Ext.getCmp('btnFilterItemGrid').setVisible(true);
                    }else{
                        Ext.getCmp('btnNoFilterItemGrid').setVisible(true);
                        Ext.getCmp('btnFilterItemGrid').setVisible(false);
                    }
                    Ext.getCmp('winFilterConceptos').close();
                }
            }
        });
    },
    CancelarVentanaFiltro: function(){
        Ext.getCmp('winFilterConceptos').close();
    },
    QuitarFiltro: function(){
        Ext.Msg.show({
            title: 'Quitar Búsqueda....!',
            msg: 'Esta seguro que desea quitar los criterios de búsqueda?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    Ext.getCmp('qryConceptos').setValue(null);
                    Ext.getCmp('sysTipoRegistroConcepto').setValue("Todos");
                    Ext.getCmp('sysClasificaoConcepto').setValue("Todos");
                    Ext.getCmp('sysTipoEstudioConcepto').setValue("Todos");
                    Ext.getCmp('gridFormulario').store.setBaseParam('pTipoReg', "Todos");
                    Ext.getCmp('gridFormulario').store.setBaseParam('pClasificacion', "Todos");
                    Ext.getCmp('gridFormulario').store.setBaseParam('pTipoEstudio', "Todos");
                    Ext.getCmp('gridFormulario').store.reload({
                        params: {
                            task: 'BUSCAR',
                            query: "Todos",
                            start: 0,
                            limit: 15
                        }
                    });
                    Ext.getCmp('btnNoFilterItemGrid').setVisible(false);
                    Ext.getCmp('btnFilterItemGrid').setVisible(true);
                }
            }
        });
    },
    GroupingGrid1: function(){
        Ext.getCmp('gridFormulario').store.clearGrouping();
        Ext.getCmp('gridFormulario').store.groupBy("TipoEstudio");
    },
    GroupingGrid2: function(){
        Ext.getCmp('gridFormulario').store.clearGrouping();
        Ext.getCmp('gridFormulario').store.groupBy("fClasificacion");
    },
    GroupingGrid3: function(){
        Ext.getCmp('gridFormulario').store.clearGrouping();
        Ext.getCmp('gridFormulario').store.groupBy("fTipoRegistro");
    },
    AddItemGrid: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddConceptos";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Conceptos - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            var winAddProfesional = new winConceptosUi();
            winAddProfesional.title = NOM_APLICACION + ' .::Adicionar Conceptos::.';
            Ext.getCmp('btn_AdicionarItemFrm').setVisible(true);
            Ext.getCmp('btn_ModificarItemFrm').setVisible(false);
            Ext.getCmp('fsQx').setVisible(false);
            Ext.getCmp('fsMx').setVisible(false);
            Ext.getCmp('fsLab').setVisible(false);
            Ext.getCmp('intUsuario').setValue(ID_USUARIO); 
            var btn_AdicionarItemFrm = Ext.getCmp('btn_AdicionarItemFrm').on("click",this.GuardarItem,this);
            var btn_SalirItemFrm = Ext.getCmp('btn_SalirItemFrm').on("click",this.CerrarVentana,this);
            var bolEsCX = Ext.getCmp('bolEsCX').on("check",this.ValidarEsQx,this);
            var bolEsMX = Ext.getCmp('bolEsMX').on("check",this.ValidarEsMx,this);
            var bolEsLab = Ext.getCmp('bolEsLab').on("check",this.ValidarEsLab,this);
            var bolUsaIVA = Ext.getCmp('bolUsaIVA').on("check",this.ValidarUsaIVA,this);
            Ext.getCmp('bolPOS').setValue("true");
            Ext.getCmp('intIVA').disable();
            Ext.getCmp('intIVA').setValue(0);
            winAddProfesional.show();
        }
    },
    ValidarUsaIVA: function(f,c){
        if (c){
            Ext.getCmp('intIVA').enable();
        }else{
            Ext.getCmp('intIVA').disable();
            Ext.getCmp('intIVA').setValue(0);
        }
    },
    ValidarEsLab: function(f,c){
        if (c){
            Ext.getCmp('fsLab').setVisible(true);
        }else{
            if(IDGUARDAR == "NO"){
                Ext.Msg.show({
                    title: 'Conceptos',
                    msg: 'Esta seguro que desae desmarcar la opción de concepto laboratorio clínico, si hace esto se borrara la información ingresada sobre este ítem?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            Ext.getCmp('fsLab').setVisible(false);
                            Ext.getCmp('strLabInterpretacion').setValue(null);
                            Ext.getCmp('bolLabPrintInterpretacion').setValue(false);
                            Ext.getCmp('strLabTecnica').setValue(null);
                            Ext.getCmp('bolLabPrintTecnica').setValue(false);
                            Ext.getCmp('strLabOtros').setValue(null);
                            Ext.getCmp('bolLabPrintOtros').setValue(false);
                            Ext.getCmp('bolLabFormato2Cols').setValue(false);
                        }else{
                            Ext.getCmp('fsLab').setVisible(true);
                            Ext.getCmp('bolEsLab').setValue(true);
                        }
                    }
                });
            }
        }
    },
    ValidarEsMx: function(f,c){
        if (c){
            Ext.getCmp('fsMx').setVisible(true);
        }else{
            if(IDGUARDAR == "NO"){
                Ext.Msg.show({
                    title: 'Conceptos',
                    msg: 'Esta seguro que desae desmarcar la opción de concepto medicamentos, si hace esto se borrara la información ingresada sobre este ítem?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            Ext.getCmp('fsMx').setVisible(false);
                            Ext.getCmp('strCodMxMinisterio').setValue(null);
                            Ext.getCmp('strCodigoCUM').setValue(null);
                            Ext.getCmp('strRegistroINVIMA').setValue(null);
                            Ext.getCmp('intPrincipioActivo').setValue(1);
                            Ext.getCmp('intPresentacion').setValue(1);
                            Ext.getCmp('intFormaFarmaceutica').setValue(1);
                            Ext.getCmp('intConcentracion').setValue(1);
                            Ext.getCmp('intUnidadMedida').setValue(1);
                            Ext.getCmp('intLaboratorio').setValue(1);
                            Ext.getCmp('intDosisMaxPac').setValue(0);
                        }else{
                            Ext.getCmp('fsMx').setVisible(true);
                            Ext.getCmp('bolEsMX').setValue(true);
                        }
                    }
                });
            }
        }
    },
    ValidarEsQx: function(f,c){
        if (c){
            Ext.getCmp('fsQx').setVisible(true);
        }else{
            if(IDGUARDAR == "NO"){
                Ext.Msg.show({
                    title: 'Conceptos',
                    msg: 'Esta seguro que desae desmarcar la opción de concepto quirúrgico, si hace esto se borrara la información ingresada sobre este ítem?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            Ext.getCmp('fsQx').setVisible(false);
                            Ext.getCmp('intGrupoQx').setValue(null);
                            Ext.getCmp('intUVR').setValue(null);
                        }else{
                            Ext.getCmp('fsQx').setVisible(true);
                            Ext.getCmp('bolEsCX').setValue(true);
                        }
                    }
                });
            }
        }
    },
    EditItemGrid: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "EditConceptos";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Conceptos - Modificar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
                var winAddProfesional = new winConceptosUi();
                winAddProfesional.title = NOM_APLICACION + ' .::Modificar Conceptos::.';
                Ext.getCmp('btn_AdicionarItemFrm').setVisible(false);
                Ext.getCmp('btn_ModificarItemFrm').setVisible(true);
                Ext.getCmp('fsQx').setVisible(false);
                Ext.getCmp('fsMx').setVisible(false);
                Ext.getCmp('fsLab').setVisible(false);
                Ext.getCmp('intUsuario').setValue(selections[0].json.Usuario); 
                Ext.getCmp('intIdProced').setValue(selections[0].json.IdProced); 
                Ext.getCmp('strTipoCodificacion').setValue(selections[0].json.TipoCodificacion); 
                Ext.getCmp('strCodProced').setValue(selections[0].json.CodProced); 
                Ext.getCmp('strDesProced').setValue(selections[0].json.DesProced); 
                Ext.getCmp('strCUPSCodigo').setValue(selections[0].json.CUPSCodigo); 
                Ext.getCmp('intTipoRegProced').setValue(selections[0].json.TipoRegProced); 
                Ext.getCmp('strUtilizacion').setValue(selections[0].json.Utilizacion); 
                if(selections[0].json.POS == "1")
                {
                    Ext.getCmp('bolPOS').setValue(true);
                }else{
                    Ext.getCmp('bolPOS').setValue(false);
                }
                Ext.getCmp('strCodigoBarras').setValue(selections[0].json.CodigoBarras); 
                Ext.getCmp('intIdTipoEstudio').setValue(selections[0].json.IdTipoEstudio); 
                Ext.getCmp('intNivelProced').setValue(selections[0].json.NivelProced); 
                Ext.getCmp('strPreparacionEspecial').setValue(selections[0].json.PreparacionEspecial); 
                Ext.getCmp('strPrefijoArchivo').setValue(selections[0].json.PrefijoArchivo); 
                Ext.getCmp('strArchivoPlantilla').setValue(selections[0].json.ArchivoPlantilla); 
                Ext.getCmp('intCantidadMaxSol').setValue(selections[0].json.CantidadMaxSol); 
                Ext.getCmp('intMinDiasSol').setValue(selections[0].json.MinDiasSol); 
                Ext.getCmp('strNumeralPyP').setValue(selections[0].json.NumeralPyP); 
                Ext.getCmp('strNumeralNumeralODO').setValue(selections[0].json.NumeralODO); 
                Ext.getCmp('intVlrCosto').setValue(selections[0].json.VlrCosto); 
                Ext.getCmp('strcodCuenta').setValue(selections[0].json.codCuenta); 
                Ext.getCmp('strnatCuenta').setValue(selections[0].json.natCuenta); 
                if(selections[0].json.ManejaKardex === "1"){
                    Ext.getCmp('bolManejaKardex').setValue(true); 
                }else{
                    Ext.getCmp('bolManejaKardex').setValue(false); 
                }
                if(selections[0].json.UsaLoteVencimiento === "1"){
                    Ext.getCmp('bolUsaLoteVencimiento').setValue(true); 
                }else{
                    Ext.getCmp('bolUsaLoteVencimiento').setValue(false); 
                }
                if(selections[0].json.UsaIVA === "1"){
                    Ext.getCmp('bolUsaIVA').setValue(true); 
                    Ext.getCmp('intIVA').enable();
                }else{
                    Ext.getCmp('bolUsaIVA').setValue(false); 
                    Ext.getCmp('intIVA').disable();
                    Ext.getCmp('intIVA').setValue(0);
                }
                Ext.getCmp('intIVA').setValue(selections[0].json.IVA); 
                Ext.getCmp('intIdConceptoRadicaInst').setValue(selections[0].json.IdConceptoRadicaInst); 
                Ext.getCmp('sysCodConceptoRadicaInst').setValue(selections[0].json.CodConceptoRad); 
                Ext.getCmp('sysDesConceptoRadicaInst').setValue(selections[0].json.DesConceptoRad); 
                Ext.getCmp('intUVR').setValue(selections[0].json.UVR); 
                Ext.getCmp('intGrupoQx').setValue(selections[0].json.GrupoQx); 
                Ext.getCmp('strCodMxMinisterio').setValue(selections[0].json.CodMxMinisterio); 
                Ext.getCmp('strCodigoCUM').setValue(selections[0].json.CodigoCUM); 
                Ext.getCmp('strRegistroINVIMA').setValue(selections[0].json.RegistroINVIMA); 
                Ext.getCmp('intPrincipioActivo').setValue(selections[0].json.PrincipioActivo); 
                Ext.getCmp('intPresentacion').setValue(selections[0].json.Presentacion); 
                Ext.getCmp('intFormaFarmaceutica').setValue(selections[0].json.FormaFarmaceutica); 
                Ext.getCmp('intConcentracion').setValue(selections[0].json.Concentracion); 
                Ext.getCmp('intUnidadMedida').setValue(selections[0].json.UnidadMedida); 
                Ext.getCmp('intLaboratorio').setValue(selections[0].json.Laboratorio); 
                Ext.getCmp('intDosisMaxPac').setValue(selections[0].json.DosisMaxPac); 
                Ext.getCmp('strLabInterpretacion').setValue(selections[0].json.LabInterpretacion); 
                Ext.getCmp('bolLabPrintInterpretacion').setValue(selections[0].json.LabPrintInterpretacion); 
                Ext.getCmp('strLabTecnica').setValue(selections[0].json.LabTecnica); 
                Ext.getCmp('bolLabPrintTecnica').setValue(selections[0].json.LabPrintTecnica); 
                Ext.getCmp('strLabOtros').setValue(selections[0].json.LabOtros); 
                Ext.getCmp('bolLabPrintOtros').setValue(selections[0].json.LabPrintOtros); 
                Ext.getCmp('bolLabFormato2Cols').setValue(selections[0].json.LabFormato2Cols); 
                if(selections[0].json.EsCX == "1")
                {
                    Ext.getCmp('bolEsCX').setValue(true);
                    Ext.getCmp('fsQx').setVisible(true);
                }else{
                    Ext.getCmp('bolEsCX').setValue(false);
                    Ext.getCmp('fsQx').setVisible(false);
                }
                if(selections[0].json.EsMX == "1")
                {
                    Ext.getCmp('bolEsMX').setValue(true);
                    Ext.getCmp('fsMx').setVisible(true);
                }else{
                    Ext.getCmp('bolEsMX').setValue(false);
                    Ext.getCmp('fsMx').setVisible(false);
                }
                if(selections[0].json.EsAnatomo == "1")
                {
                    Ext.getCmp('bolEsAnatomo').setValue(true);
                }else{
                    Ext.getCmp('bolEsAnatomo').setValue(false);
                }
                if(selections[0].json.EsLaboratorio == "1")
                {
                    Ext.getCmp('bolEsLab').setValue(true);
                    Ext.getCmp('fsLab').setVisible(true);
                }else{
                    Ext.getCmp('bolEsLab').setValue(false);
                    Ext.getCmp('fsLab').setVisible(false);
                }
                
                var btn_ModificarItemFrm = Ext.getCmp('btn_ModificarItemFrm').on("click",this.ModificarItem,this);
                var btn_SalirItemFrm = Ext.getCmp('btn_SalirItemFrm').on("click",this.CerrarVentana,this);
                var bolEsCX = Ext.getCmp('bolEsCX').on("check",this.ValidarEsQx,this);
                var bolEsMX = Ext.getCmp('bolEsMX').on("check",this.ValidarEsMx,this);
                var bolEsLab = Ext.getCmp('bolEsLab').on("check",this.ValidarEsLab,this);
                var bolUsaIVA = Ext.getCmp('bolUsaIVA').on("check",this.ValidarUsaIVA,this);
                winAddProfesional.show();
            }
        }
    },
    GuardarItem: function(){
        Ext.Msg.show({
            title: 'Guardar Conceptos',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR002","SI","winConceptos","frmConceptos","../../controlador/conceptos/controlador_conceptos.php","gridFormulario");
                }
            }
        });
    },
    ModificarItem: function(){
        Ext.Msg.show({
            title: 'Guardar Conceptos',
            msg: 'Esta Seguro que Desea Modificar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR002","SI","winConceptos","frmConceptos","../../controlador/conceptos/controlador_conceptos.php","gridFormulario");
                }
            }
        });
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winConceptos').close();
                }
            }
        });
    }
});


function fnEliminarRegistros(URL,arrParam, pGrid, arrParamStore)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: NOM_APLICACION,
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                IDGUARDAR = "SI";
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        IDGUARDAR = "NO";
                        break;

                    default:
                        IDGUARDAR = "NO";
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
                IDGUARDAR = "NO";
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
        IDGUARDAR = "NO";
    }
}
