/*
* @category    Formulario Grid Horarios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmConsultoriosUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Consultorios Ubicaciones ::.',
    id: 'winFrmConsultorios',
    closable:false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'grid',
                id: 'gridConsultorios',
                store: 'StoreGridConsultorios',
                anchor: "100%",
                border: false,
                frame: true,
                columns: [
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'Codigo',
                        id: 'Codigo'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 930,
                        dataIndex: 'Descripcion',
                        id: 'Descripcion'
                    }
                ],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar Consultorio',
                                iconCls: 'btnAddRow',
                                ref: '../btnAddTipoHorario',
                                id: 'btnAddTipoHorario'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Modificar Consultorio',
                                iconCls: 'btnEditRow',
                                ref: '../btnEditTipoHorario',
                                id: 'btnEditTipoHorario'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Consultorio',
                                iconCls: 'btnDelRow',
                                ref: '../btnDelTipoHorario',
                                id: 'btnDelTipoHorario'
                            }
                        ]
                    }
            }
        ];
        winFrmConsultoriosUi.superclass.initComponent.call(this);
    }
});
