/*
* @category    Programacion Eventos Formulario Tipo de Horario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmDiasNoHabiles = Ext.extend(winFrmDiasNoHabilesUi, {
    initComponent: function() {
        winFrmDiasNoHabiles.superclass.initComponent.call(this);
        
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        ID_CONSULTORIO = el.getValue();
        
        this.title = NOM_APLICACION + " .:: Dias No Habiles ::.";
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        if(NOM_APLICACION == "OfiClinic"){
            Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        }else{
            Ext.getCmp('fNomEmpresa').setValue("");
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("");
        }
        
        Ext.getCmp('gridDiasNoHabiles').store.load({
            params: {
                pEmpresa: ID_EMPRESA
            }
        });

        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnAddDiaNoHabil = Ext.getCmp('btnAddDiaNoHabil').on("click",this.AddDiaNoHabil,this);
        var btnDelDiaNoHabil = Ext.getCmp('btnDelDiaNoHabil').on("click",this.DelDiaNoHabil,this);

    },
    SalirOpcion: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    
    AddDiaNoHabil: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddConsultorio";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Dias No Habiles - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            el = Ext.get('idaplicacion');
            var NOM_APLICACION = el.getValue();
            var winDiaNoHabil = new winDiaNoHabilUi();
            winDiaNoHabil.title = NOM_APLICACION + ' .::Adicionar Dias No Habiles::.';
            Ext.getCmp('btn_AdicionarDiaNoHabil').setVisible(true);
            Ext.getCmp('intEmpresa').setValue(ID_EMPRESA);
            var btn_AdicionarDiaNoHabil = Ext.getCmp('btn_AdicionarDiaNoHabil').on("click",this.GuardarDiaNoHabil,this);
            var btn_SalirDiaNoHabil = Ext.getCmp('btn_SalirDiaNoHabil').on("click",this.CerrarVentana,this);
            winDiaNoHabil.show();
        }
    },
    GuardarDiaNoHabil: function(){
        Ext.Msg.show({
            title: 'Guardar Dia No Habil',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR","SI","winDiasNoHabiles","frmDiasNoHabiles","../../controlador/diasnohabiles/controlador_diasnohabiles.php","gridDiasNoHabiles");
                }
            }
        });
    },
    DelDiaNoHabil: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelConsultorio";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Dias No Habiles - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridDiasNoHabiles').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridDiasNoHabiles').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Dia No Habil',
                    msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.NoHabil + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/diasnohabiles/controlador_diasnohabiles.php",{task: "ELIMINAR", pEmpresa:ID_EMPRESA, pFecha: selections[0].json.NoHabil}, 'gridDiasNoHabiles',{params:{pEmpresa:ID_EMPRESA}})
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    CerrarVentana: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winDiasNoHabiles').close();
                }
            }
        });
    }
});


function fnEliminarRegistros(URL,arrParam, pGrid, arrParamStore)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar los registros en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
