/*
* @category    Formulario Grid Empresas Trabaja
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winEditEmpresasTrabajaUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Editar Lista de Empresas Donde Trabaja ::.',
    id: 'winEditEmpresasTrabaja',
    width: 980,
    height: 480,
    plain: true,
    resizable: false,
    closable: true,
    modal: true,
    y: 120,
    layout: 'fit',
    initComponent: function() {
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        var textField = new Ext.form.TextField({
            style: 'text-transform:uppercase;'
        });

        var st = new StoreEmpresaTrabaja();
        st.load();
        
        this.items = [
           {
                xtype: 'editorgrid',
                id: 'gridEmpresaTrabaja',
                store: st,
                anchor: "100%",
                border: false,
                frame: true,
                layout: 'fit',
                columns: [
                    new Ext.grid.RowNumberer(),
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'OldDescripcion',
                        id: 'OldDescripcion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: true,
                        editor: textField,
                        width: 930,
                        dataIndex: 'Descripcion',
                        id: 'Descripcion'
                    }
                ],
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Modificar',
                                iconCls: 'btnEditRow',
                                id: 'btnEditEmpresaTrabaja',
                                listeners:{
                                    click : function(){
                                        var modified = Ext.getCmp('gridEmpresaTrabaja').getStore().getModifiedRecords();
                                        if(!Ext.isEmpty(modified)){
                                            var recordsToSend = [];
                                            Ext.each(modified, function(record) {
                                                recordsToSend.push(Ext.apply({OldDescripcion: QuitarAcentosTxt(record.data.OldDescripcion.toUpperCase())},{Descripcion: QuitarAcentosTxt(record.data.Descripcion.toUpperCase())}));
                                            });
                                            Ext.getCmp('gridEmpresaTrabaja').el.mask('Guardando Información...', 'x-mask-loading');
                                            Ext.getCmp('gridEmpresaTrabaja').stopEditing();
                                            recordsToSend = Ext.encode(recordsToSend);
                                            Ext.Ajax.request({
                                                url : '../../controlador/empresatrabaja/controlador_empresatrabaja.php',
                                                params :{
                                                    task: 'Modificar',
                                                    records : recordsToSend
                                                },
                                                scope:this,
                                                success : function(response) {
                                                    Ext.getCmp('gridEmpresaTrabaja').getStore().commitChanges();
                                                    Ext.getCmp('gridEmpresaTrabaja').store.reload();
                                                    Ext.getCmp('strEmpresaTrabaja').store.reload();
                                                    Ext.getCmp('gridEmpresaTrabaja').el.unmask();
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        winEditEmpresasTrabajaUi.superclass.initComponent.call(this);
    }
});
