/*
* @category    Programacion Eventos Formulario Cambiar Concepto Factura
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmCambiarConceptoFac = Ext.extend(winFrmCambiarConceptoFacUi, {
    initComponent: function() {
        winFrmCambiarConceptoFac.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnCambiarConceptoFactura = Ext.getCmp('btnCambiarConceptoFactura').on("click",this.CambiarConceptoFactura,this);
        var sysClienteFacturacion = Ext.getCmp('sysClienteFacturacion').on("select",this.CargaFacturas,this);
        var sysNroFactura = Ext.getCmp('sysNroFactura').on("select",this.CargaInfoFactura,this);
    },
    CambiarConceptoFactura: function(){
        if(parseInt(Ext.getCmp('sysPuedeAnular').getValue()) === 1){
            Ext.Msg.show({
                title: 'Facturación',
                msg: 'Esta seguro que desea Cambiar el Concepto de la Factura?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn === "yes"){
                        var frm = Ext.getCmp('frmFacturacion').getForm();
                        if (frm.isValid()){
                            Ext.Msg.wait('Anulando Factura... por favor espere!');
                            Ext.Ajax.request({
                                url: "../../controlador/facturacion/facturacion.php",
                                params: {
                                    task: "CAMBIAR_CONCEPTO_FACTURA",
                                    pEmpresa: ID_EMPRESA,
                                    pCliente: Ext.getCmp('sysClienteFacturacion').getValue(),
                                    pFactura: Ext.getCmp('sysNroFactura').getValue(),
                                    pMotivo: Ext.getCmp('sysConceptoFactura').getValue()
                                },
                                success: function(response)
                                {
                                    var result = response.responseText;
                                    if (result > 0)
                                    {
                                        Ext.Msg.hide();
                                        Ext.MessageBox.show({
                                            title: 'eOfiClinic',
                                            msg: 'Se Cambio el Concepto de la factura con exito.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.INFO
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'No podemos Cambiar el Concepto de la Factura en estos momentos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                },
                                failure: function(response){
                                    var result = response.responseText;
                                    Ext.MessageBox.show({
                                        title: 'Error Base Datos',
                                        msg: 'No podemos Cambiar el Concepto de la Factura en estos momentos',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            });
                        }else{
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'Verifique los campos requeridos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'La Factura no esta disponible para cambiar el concepto',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    CargaFacturas: function(cmb, rec, idx) {
        Ext.getCmp('sysNroFactura').setValue(null);
        Ext.getCmp('sysNroFactura').store.load({
           params: {
               pEmpresa: ID_EMPRESA,
               pCliente: cmb.getValue(),
               pIPS: ID_IPS
           } 
        });
    },
    CargaInfoFactura: function(cmb, rec, idx) {
        Ext.getCmp('sysPuedeAnular').setValue(0);
        Ext.getCmp('sysConceptoFactura').setValue(rec.data.Concepto);
        if(rec.data.Anulada == 1 || rec.data.Anulada == '1'){
            Ext.getCmp('sysPuedeAnular').setValue(0);
        }else{
            Ext.Ajax.request({
                url: '../../controlador/facturacion/facturacion.php',
                params:{
                    task: 'BUSCAR_RCxFACTURA',
                    pDocumentoCruce: rec.data.idLegalizacion
                },
                success: function(response,options){
                    var el = Ext.get('response'); 
                    var Respuesta = response.responseText;
                    var Contenido = Respuesta.split('^');
                    if(Contenido[0]!="{success:false}"){
                        Ext.getCmp('sysPuedeAnular').setValue(0);
                    }else{
                        Ext.getCmp('sysPuedeAnular').setValue(1);
                    }
                },
                failure: function(response,options){
                    var el = Ext.get('response');
                    Ext.MessageBox.show({
                        title: 'eOfiClinic',
                        msg: 'No se pudo establecer conexión con el servidor.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                },
                scope:this 
            });
        }
    },
    ImprimirFacturaAnulada: function(){
        window.open ("../../controlador/facturacion/inffacturaxdetalleanula.php?pFactura="+Ext.getCmp('sysNroFactura').getValue(),"Factura Anulada");
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn){
                if(btn === "yes"){
                    window.close();
                }
            }
        });
    }
    
});

