/*
* @category    Formulario Facturacion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmUnificarPacienteUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Facturación Institucional ::.',
    id: 'winFrmUnificarPaciente',
    closable:false,
    width:980,
    height:510,
    //autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    //autoScroll: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmFacturacion',
                border: false,
                height: 450,
                padding: 3,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intPacienteFacturacion',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'intConceptoFacturacion',
                        value: 0
                    },
                    {
                        xtype: 'combo',
                        anchor: '96%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreCliente',
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: false,
                        fieldLabel: 'Cliente',
                        id: 'intClienteFacturacion'
                    },
                    {
                        xtype: 'combo',
                        anchor: '96%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        valueField: 'IdPlan',
                        displayField: 'Descripcion',
                        store: 'StoreClientesPlan',
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: true,
                        fieldLabel: 'Plan',
                        id: 'intPlanFacturacion'
                    },
                    {
                        xtype: 'combo',
                        anchor: '96%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        valueField: 'IdSubPlan',
                        displayField: 'Descripcion',
                        store: 'StoreClienteSubplan',
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: true,
                        fieldLabel: 'SubPlan',
                        id: 'intSubPlanFacturacion'
                    },
                    {
                        xtype: 'combo',
                        anchor: '96%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        valueField: 'IdContrato',
                        displayField: 'Contrato',
                        store: 'StoreClienteContrato',
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: false,
                        fieldLabel: 'Contrato',
                        id: 'intContratoFacturacion'
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '96%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Paciente',
                                width: 760,
                                readOnly: true,
                                allowBlank: true,
                                emptyText: 'Debe Buscar Paciente....',
                                id: 'sysPacienteFacturacion'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPacienteFacturacion'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '96%',
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Concepto',
                                width: 760,
                                readOnly: true,
                                allowBlank: true,
                                emptyText: 'Debe Buscar Concepto / Procedimieto / Medicamento / etc....',
                                id: 'sysConceptoFacturacion'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Concepto',
                                id: 'btnBuscarCoceptoFacturacion'
                            }
                        ]
                    },
                    {
                        xtype: 'combo',
                        anchor: '96%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreTipoEstudio',
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: true,
                        fieldLabel: 'Tipo Estudio',
                        id: 'intTipoEstudioFacturacion'
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '96%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'displayfield',
                                fieldLabel: 'Ordenar por',
                                value: 'Criterio 1:'
                            },
                            {
                                xtype: 'combo',
                                width: 205,
                                allowBlank: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                store: 'StoreCriteriosOrden',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                emptyText: 'Selecione....',
                                forceSelection: true,
                                id: 'strCampo1'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Criterio 2:'
                            },
                            {
                                xtype: 'combo',
                                width: 205,
                                allowBlank: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                store: 'StoreCriteriosOrden',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                emptyText: 'Selecione....',
                                forceSelection: true,
                                id: 'strCampo2'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Criterio 3:'
                            },
                            {
                                xtype: 'combo',
                                width: 213,
                                allowBlank: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                store: 'StoreCriteriosOrden',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                emptyText: 'Selecione....',
                                forceSelection: true,
                                id: 'strCampo3'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '96%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'displayfield',
                                fieldLabel: 'Filtro',
                                value: 'Desde:'
                            },
                            {
                                xtype: 'datefield',
                                width: 90,
                                allowBlank: false,
                                id: 'fecDesdeFacturacion'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Hasta:'
                            },
                            {
                                xtype: 'datefield',
                                width: 90,
                                allowBlank: false,
                                id: 'fecHastaFacturacion'
                            },
                            {
                                xtype: 'displayfield',
                                value: '# Pac:'
                            },
                            {
                                xtype: 'numberfield',
                                minValue: 0,
                                decimalPrecision: 0,
                                allowBlank: false,
                                width: 30,
                                value: 0,
                                id: 'intCantidadPacientesFacturacion'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Por Paciente:'
                            },
                            {
                                xtype: 'combo',
                                width: 60,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: 'StoreSiNo',
                                triggerAction: 'all',
                                mode: 'local',
                                emptyText: 'Seleccione...!',
                                allowBlank: false,
                                id: 'strPorPaciente'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Fec.Radicación:'
                            },
                            {
                                xtype: 'combo',
                                width: 60,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: 'StoreSiNo',
                                triggerAction: 'all',
                                mode: 'local',
                                emptyText: 'Seleccione...!',
                                allowBlank: false,
                                id: 'strPorFechaEstudioFacturacion'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Capitación:'
                            },
                            {
                                xtype: 'combo',
                                width: 60,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: 'StoreSiNo',
                                triggerAction: 'all',
                                mode: 'local',
                                emptyText: 'Seleccione...!',
                                allowBlank: false,
                                value: 'NO',
                                id: 'strCapitacionFacturacion'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Capitación',
                        width: 750,
                        id: 'infoCapitaFacturacion',
                        collapsible: true,
                        autoHeight: true,
                        layout: 'table',
                        layoutConfig: {
                            columns: 2
                        },
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: 430,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        width: 150,
                                        value: 0,
                                        fieldLabel: 'Valor Promedio UPC',
                                        id: 'intValorUPCCapitaFacturacion',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var vlr = (Ext.getCmp('intValorUPCCapitaFacturacion').getValue() * Ext.getCmp('intAfiliadosCapitaFacturacion').getValue()) * (Ext.getCmp('intPorcentajeUPCCapitaFacturacion').getValue()/100);  
                                                    Ext.getCmp('intValorTotalCapitaFacturacion').setValue(vlr);
                                                    var vlrneto = vlr - Ext.getCmp('intCMCapitaFacturacion').getValue() - Ext.getCmp('intCopagosCapitaFacturacion').getValue();
                                                    Ext.getCmp('intNetoCapitaFacturacion').setValue(vlrneto);
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: 430,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "%",
                                        useThousandSeparator: false,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        maxValue: 100,
                                        decimalPrecision: 5,
                                        allowBlank: true,
                                        width: 150,
                                        value: 0,
                                        fieldLabel: '% UPC',
                                        id: 'intPorcentajeUPCCapitaFacturacion',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var vlr = (Ext.getCmp('intValorUPCCapitaFacturacion').getValue() * Ext.getCmp('intAfiliadosCapitaFacturacion').getValue()) * (Ext.getCmp('intPorcentajeUPCCapitaFacturacion').getValue()/100);  
                                                    Ext.getCmp('intValorTotalCapitaFacturacion').setValue(vlr);
                                                    var vlrneto = vlr - Ext.getCmp('intCMCapitaFacturacion').getValue() - Ext.getCmp('intCopagosCapitaFacturacion').getValue();
                                                    Ext.getCmp('intNetoCapitaFacturacion').setValue(vlrneto);
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: 430,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: false,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        width: 150,
                                        value: 0,
                                        fieldLabel: 'Nro Afiliados',
                                        id: 'intAfiliadosCapitaFacturacion',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var vlr = (Ext.getCmp('intValorUPCCapitaFacturacion').getValue() * Ext.getCmp('intAfiliadosCapitaFacturacion').getValue()) * (Ext.getCmp('intPorcentajeUPCCapitaFacturacion').getValue()/100);  
                                                    Ext.getCmp('intValorTotalCapitaFacturacion').setValue(vlr);
                                                    var vlrneto = vlr - Ext.getCmp('intCMCapitaFacturacion').getValue() - Ext.getCmp('intCopagosCapitaFacturacion').getValue();
                                                    Ext.getCmp('intNetoCapitaFacturacion').setValue(vlrneto);
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: 430,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        width: 150,
                                        value: 0,
                                        fieldLabel: 'Valor Total',
                                        readOnly: true,
                                        id: 'intValorTotalCapitaFacturacion'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: 430,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        width: 150,
                                        value: 0,
                                        fieldLabel: 'Cuota Moderadora',
                                        id: 'intCMCapitaFacturacion',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var vlr = (Ext.getCmp('intValorUPCCapitaFacturacion').getValue() * Ext.getCmp('intAfiliadosCapitaFacturacion').getValue()) * (Ext.getCmp('intPorcentajeUPCCapitaFacturacion').getValue()/100);  
                                                    Ext.getCmp('intValorTotalCapitaFacturacion').setValue(vlr);
                                                    var vlrneto = vlr - Ext.getCmp('intCMCapitaFacturacion').getValue() - Ext.getCmp('intCopagosCapitaFacturacion').getValue();
                                                    Ext.getCmp('intNetoCapitaFacturacion').setValue(vlrneto);
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: 430,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        width: 150,
                                        value: 0,
                                        fieldLabel: 'Copagos',
                                        id: 'intCopagosCapitaFacturacion',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var vlr = (Ext.getCmp('intValorUPCCapitaFacturacion').getValue() * Ext.getCmp('intAfiliadosCapitaFacturacion').getValue()) * (Ext.getCmp('intPorcentajeUPCCapitaFacturacion').getValue()/100);  
                                                    Ext.getCmp('intValorTotalCapitaFacturacion').setValue(vlr);
                                                    var vlrneto = vlr - Ext.getCmp('intCMCapitaFacturacion').getValue() - Ext.getCmp('intCopagosCapitaFacturacion').getValue();
                                                    Ext.getCmp('intNetoCapitaFacturacion').setValue(vlrneto);
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: 430,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        width: 150,
                                        value: 0,
                                        fieldLabel: 'Neto',
                                        readOnly: true,
                                        id: 'intNetoCapitaFacturacion'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        allowBlank: false,
                        anchor: '96%',
                        style: 'text-transform:uppercase;',
                        fieldLabel: 'Concepto Factura',
                        id: 'memConceptoFacturacion'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        fbar: {
                            xtype: 'toolbar',
                            width: 760,
                            buttonAlign: 'center',
                            items: [
                                {
                                    xtype: 'button',
                                    iconCls: 'btnImprimir',
                                    text: 'Imprimir Resumen Prefactura',
                                    id: 'btnGenerarPrefa'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnImprimir',
                                    text: 'Imprimir Detalle Prefactura',
                                    id: 'btnImprimirDetaPrefa'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnExcel',
                                    text: 'Exportar Detalle Prefactura',
                                    id: 'btnDetallePrefa'
                                }
                            ]
                        }
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        fbar: {
                            xtype: 'toolbar',
                            width: 760,
                            buttonAlign: 'center',
                            items: [
                                {
                                    xtype: 'displayfield',
                                    value: 'Fecha Factura:'
                                },
                                {
                                    xtype: 'datefield',
                                    width: 120,
                                    allowBlank: true,
                                    readOnly: true,
                                    emptyText: '(dia/mes/año)',
                                    value: new Date().format('d/m/Y'),
                                    id: 'fecFacturaFacturacion'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnReport',
                                    text: 'Generar Factura',
                                    id: 'btnGenerarFactura'
                                },
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Factura',
                                    width: 150,
                                    forceSelection: true,
                                    typeAhead: true,
                                    typeAheadDelay: 50,
                                    listEmptyText: '',
                                    title: '',
                                    valueField: 'Codigo',
                                    displayField: 'Descripcion',
                                    store: 'StoreFacturasIns',
                                    triggerAction: 'all',
                                    mode: 'local',
                                    emptyText: 'Nro Factura',
                                    allowBlank: true,
                                    id: 'sysNroFactura'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnImprimir',
                                    text: 'Imprimir Factura',
                                    id: 'btnImprimirFactura'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnImprimir',
                                    text: 'Imprimir Soporte Factura',
                                    id: 'btnImprimirDetaFactura'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnExcel',
                                    text: 'Exportar Soporte Factura',
                                    id: 'btnDetalleFacturaExcel'
                                }
                            ]
                        }
                    },
                    {
                        fbar: {
                            xtype: 'toolbar',
                            width: 760,
                            buttonAlign: 'center',
                            items: [
                                {
                                    xtype: 'displayfield',
                                    value: 'Nro. Factura Desde:'
                                },
                                {
                                    xtype: 'textfield',
                                    width: 120,
                                    allowBlank: true,
                                    id: 'strFacturaDesde'
                                },
                                {
                                    xtype: 'displayfield',
                                    value: 'Nro. Factura Hasta:'
                                },
                                {
                                    xtype: 'textfield',
                                    width: 120,
                                    allowBlank: true,
                                    id: 'strFacturaHasta'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnImprimir',
                                    text: 'Imprimir Bloque de Facturas x Paciente',
                                    id: 'btnImprimirBloqueFactura'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnImprimir',
                                    text: 'Imprimir Facturas x Plan',
                                    id: 'btnImprimirFacturaxPlan'
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        }
                    }
                ],
                tbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnLimpiar',
                            text: 'Limpiar Formulario',
                            id: 'btnLimpiar'
                        }
                    ]
                }
            }
        ];
        winFrmUnificarPacienteUi.superclass.initComponent.call(this);
    }
});
