/*
* @category    Formulario Notas Factura
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmNotasFacUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Notas Factura ::.',
    id: 'winFrmNotasFac',
    closable:false,
    width:980,
    autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    //autoScroll: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.bbar = mybbar;
        
        var dataTipoNota = [
            ['D','DEBITO'],
            ['C','CREDITO']
        ];
        var stTipoNota = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stTipoNota.loadData(dataTipoNota);
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmNotas',
                border: false,
                autoHeight: true,
                padding: 3,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'sysPuedeAnular',
                        value: 0
                    },
                    {
                        xtype: 'combo',
                        anchor: '96%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreCliente',
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: false,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteFacturacion'
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '96%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Factura',
                                emptyText: 'Seleccione...!',
                                name: 'cbFactura',
                                width: 265,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                valueField: 'idLegalizacion',
                                displayField: 'NroFactura',
                                store: 'StoreRelacionFacturas',
                                triggerAction: 'all',
                                mode: 'local',
                                allowBlank: false,
                                tpl: '<tpl for="."><div class="cbFactura"><h3>{NroFactura}</h3><p style="font-size: 12;">Fecha Factura: {FechaDocumento}</p><tpl if="Anulada==\'1\'"><p style="font-size:11; color:red;">Fecha Anulacion: {FechaAnula}</p><p style="font-size: 10; color:red;">{MotivoAnula}</p></tpl><hr /></div></tpl>',
                                itemSelector: 'div.cbFactura',
                                id: 'sysNroFactura'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '96%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Notas Aplicadas',
                                emptyText: 'Seleccione...!',
                                name: 'cbNotasAplicadas',
                                width: 265,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                valueField: 'idLegalizacion',
                                displayField: 'NroNota',
                                store: 'StoreRelacionNotaFacturas',
                                triggerAction: 'all',
                                mode: 'local',
                                allowBlank: true,
                                tpl: '<tpl for="."><div class="cbNotasAplicadas"><h3>{NroNota}</h3><p style="font-size: 12;">{TipoLegalizacion}</p><p style="font-size: 12;">Fecha Nota: {FechaDocumento}</p><tpl if="Anulada==\'1\'"><p style="font-size:11; color:red;">Fecha Anulacion: {FechaAnula}</p><p style="font-size: 10; color:red;">{MotivoAnula}</p></tpl><hr /></div></tpl>',
                                itemSelector: 'div.cbNotasAplicadas',
                                id: 'sysNroNota'
                            },
                            {
                                html: 'Fecha Nota:'
                            },
                            {
                                xtype: 'datefield',
                                width: 110,
                                allowBlank: false,
                                id: 'sysAnulaFactura',
                                listeners:{
                                    change : function(f,pNew, pOld){
                                        /*if(pNew < FechaFactura){
                                            Ext.MessageBox.show({
                                                title: 'Notas Credito / Debito',
                                                msg: 'La fecha de aplicacion de la nota no es valida',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                            Ext.getCmp('sysAnulaFactura').setValue(null);
                                        }*/
                                    }
                                }
                            },
                            {
                                html: 'Tipo Nota:'
                            },
                            {
                                xtype: 'combo',
                                width: 100,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: stTipoNota,
                                triggerAction: 'all',
                                mode: 'local',
                                emptyText: 'Seleccione...!',
                                allowBlank: false,
                                id: 'sysTipoNotaFacturacion'
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Motivo',
                        name: 'Motivo',
                        width: 800,
                        allowBlank: false,
                        id: 'sysMotivoAnulacion'
                    },
                    {
                        xtype: 'numericfield',
                        fieldLabel: 'Valor Total',
                        name: 'Valor Total',
                        currencySymbol: "$",
                        useThousandSeparator: true,
                        alwaysDisplayDecimals: true,
                        thousandSeparator: ',',
                        minValue: 0,
                        decimalPrecision: 2,
                        allowBlank: false,
                        id: 'intVlrNotaValorTotal',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew > ValorTotal){
                                    Ext.MessageBox.show({
                                        title: 'Notas Credito / Debito',
                                        msg: 'El valor no puede ser superior al valor total de la factura',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    Ext.getCmp('intVlrNotaValorTotal').setValue(ValorTotal);
                                }
                                Ext.getCmp('intVlrNotaValorNeto').setValue(parseInt(Ext.getCmp('intVlrNotaValorTotal').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorCM').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorCOP').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorDescuentos').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorDescuentos').getValue()));
                            }
                        }
                    },
                    {
                        xtype: 'numericfield',
                        fieldLabel: 'Cuota Moderadora',
                        name: 'Cuota Moderadora',
                        currencySymbol: "$",
                        useThousandSeparator: true,
                        alwaysDisplayDecimals: true,
                        thousandSeparator: ',',
                        minValue: 0,
                        decimalPrecision: 2,
                        allowBlank: false,
                        id: 'intVlrNotaValorCM',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew > ValorCM){
                                    Ext.MessageBox.show({
                                        title: 'Notas Credito / Debito',
                                        msg: 'El valor no puede ser superior al valor de las cuotas moderadoras de la factura',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    Ext.getCmp('intVlrNotaValorCM').setValue(ValorCM);
                                }
                                Ext.getCmp('intVlrNotaValorNeto').setValue(parseInt(Ext.getCmp('intVlrNotaValorTotal').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorCM').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorCOP').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorDescuentos').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorDescuentos').getValue()));
                            }
                        }
                    },
                    {
                        xtype: 'numericfield',
                        fieldLabel: 'Copagos',
                        name: 'Copagos',
                        currencySymbol: "$",
                        useThousandSeparator: true,
                        alwaysDisplayDecimals: true,
                        thousandSeparator: ',',
                        minValue: 0,
                        decimalPrecision: 2,
                        allowBlank: false,
                        id: 'intVlrNotaValorCOP',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew > ValorCOP){
                                    Ext.MessageBox.show({
                                        title: 'Notas Credito / Debito',
                                        msg: 'El valor no puede ser superior al valor de copagos de la factura',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    Ext.getCmp('intVlrNotaValorCOP').setValue(ValorCOP);
                                }
                                Ext.getCmp('intVlrNotaValorNeto').setValue(parseInt(Ext.getCmp('intVlrNotaValorTotal').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorCM').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorCOP').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorDescuentos').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorDescuentos').getValue()));
                            }
                        }
                    },
                    {
                        xtype: 'numericfield',
                        fieldLabel: 'Descuentos',
                        name: 'Descuentos',
                        currencySymbol: "$",
                        useThousandSeparator: true,
                        alwaysDisplayDecimals: true,
                        thousandSeparator: ',',
                        minValue: 0,
                        decimalPrecision: 2,
                        allowBlank: false,
                        id: 'intVlrNotaValorDescuentos',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew > ValorDesc){
                                    Ext.MessageBox.show({
                                        title: 'Notas Credito / Debito',
                                        msg: 'El valor no puede ser superior al valor de descuentos de la factura',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    Ext.getCmp('intVlrNotaValorDescuentos').setValue(ValorDesc);
                                }
                                Ext.getCmp('intVlrNotaValorNeto').setValue(parseInt(Ext.getCmp('intVlrNotaValorTotal').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorCM').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorCOP').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorDescuentos').getValue()) - parseInt(Ext.getCmp('intVlrNotaValorDescuentos').getValue()));
                            }
                        }
                    },
                    {
                        xtype: 'numericfield',
                        fieldLabel: 'Valor Neto',
                        name: 'Valor Neto',
                        currencySymbol: "$",
                        useThousandSeparator: true,
                        alwaysDisplayDecimals: true,
                        thousandSeparator: ',',
                        minValue: 0,
                        decimalPrecision: 2,
                        allowBlank: false,
                        id: 'intVlrNotaValorNeto',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew > ValorFactura){
                                    Ext.MessageBox.show({
                                        title: 'Notas Credito / Debito',
                                        msg: 'El valor no puede ser superior al valor de la factura',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    Ext.getCmp('intVlrNotaValorNeto').setValue(ValorFactura);
                                }
                            }
                        }
                    },
                    {
                        fbar: {
                            xtype: 'toolbar',
                            width: 760,
                            buttonAlign: 'center',
                            items: [
                                {
                                    xtype: 'button',
                                    iconCls: 'btnAnularFactura',
                                    text: 'Aplicar Nota a Factura',
                                    id: 'btnAnularFactura'
                                }
                            ]
                        }
                    }
                ],
                tbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnImprimir',
                            text: 'Imprimir Nota',
                            id: 'btnImprimirAnulada'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnLimpiar',
                            text: 'Limpiar Formulario',
                            id: 'btnLimpiar'
                        }
                    ]
                }
            }
        ];
        winFrmNotasFacUi.superclass.initComponent.call(this);
    }
});
