/*
* @category    Funcion Buscar Cie10
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function viewHistorialFarmacologico(wPaciente){
    var DGDataStoreHistorialFarma;
    var DGColumnModel;
    var DGListingEditorGridHistorialFarma;
    var DGListingWindowHistorialFarma;
    var DGListingSelectedRow;
    var DGListingContextMenu;
    var anchoPantalla;
    var MargenIzquierdo;
    var xg = Ext.grid;

    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    anchoPantalla = screen.width;
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }
    
    var chkColumnSeleccionarMx = new xg.CheckColumn({
        header: ' ',
        dataIndex: 'Seleccionar',
        id: 'chkColumnSeleccionarMx',
        value: false,
        width: 20
     });
        
    var btnSalir = new Ext.Button({
        text: 'Salir',
        icon: '../../../resources/botones/salir.png',
        iconCls: 'x-btn-text-icon',
        minWidth: 80,
        handler:function(){
            DGListingWindowHistorialFarma.close();
        }
    });

    DGDataStoreHistorialFarma = new Ext.data.Store({
        id: 'DGDataStoreHistorialFarma',
        proxy: new Ext.data.HttpProxy({
            url: '../../controlador/solmx/controlador_solmx.php',
            method: 'POST'
        }),
        loadMask: {msg:"Cargando Registros, por favor espere..."},
        autoLoad: false,
        params: {
            task: 'VER_HISTORIAL_FARMACOLOGICO',
            pPaciente: wPaciente
        },
        reader: new Ext.data.JsonReader({
            root: 'results',
            totalProperty: 'total',
            id: 'id'
          },[
            {name: 'idConsecutivoSolicitud'},
            {name: 'Tipo'},
            {name: 'Empresa'},
            {name: 'IPS'},
            {name: 'Paciente'},
            {name: 'CAS'},
            {name: 'ConsecutivoHC'},
            {name: 'Origen'},
            {name: 'idConceptoOfimedical'},
            {name: 'idConceptoOfiClinic'},
            {name: 'idEspecialidad'},
            {name: 'Remision'},
            {name: 'fecReporte'},
            {name: 'nomEntidad'},
            {name: 'Reporte'},
            {name: 'valorReferencia'},
            {name: 'Resultado'},
            {name: 'Cantidad'},
            {name: 'Posologia'},
            {name: 'dosisDia'},
            {name: 'notasProveedor'},
            {name: 'fecSolicitud'},
            {name: 'Proveedor'},
            {name: 'fecRealizacion'},
            {name: 'salidaConsulta'},
            {name: 'PyP'},
            {name: 'Finalidad'},
            {name: 'Diagnostico'},
            {name: 'ServiciosIngreso'},
            {name: 'NOPOS'},
            {name: 'TipoServicio'},
            {name: 'Ambito'},
            {name: 'ResumenDx'},
            {name: 'DescripcionCasoClinico'},
            {name: 'TratamientosRealizados'},
            {name: 'Caracter'},
            {name: 'CaracterCantidad'},
            {name: 'CaracterDias'},
            {name: 'Homologo'},
            {name: 'HomologoSustituto'},
            {name: 'Justificacion'},
            {name: 'MiembroParte'},
            {name: 'Prioritario'},
            {name: 'ExplicaConsentimiento'},
            {name: 'ConsentimientoInformado'},
            {name: 'Usuario'},
            {name: 'FechaAct'},
            {name: 'DesProced'},
            {name: 'FechaAtencion'},
            {name: 'Seleccionar'}
         ])
    });

    
    doMsgBoxAlert = function(record) {
        //alert(pCampo);
    };

    doRowDblClick = function(thisGrid, rowIndex)  {
       var record = thisGrid.getStore().getAt(rowIndex);
       //doMsgBoxAlert(record);
    };

    doRowCtxMenu = function(thisGrid, rowIndex, evtObj)
    {
        /*evtObj.stopEvent();
        var record = thisGrid.getStore().getAt(rowIndex);
        if (!thisGrid.rowCtxMenu)
        {
            thisGrid.rowCtxMenu = new Ext.menu.Menu({
                items : {
                    text    : 'Seleccionar Diagnostico',
                    handler : function() {
                        doMsgBoxAlert(record);
                    }
                }
            });
       }
       thisGrid.rowCtxMenu.showAt(evtObj.getXY());
       */
    };
    
    DGListingEditorGridHistorialFarma =  new Ext.grid.EditorGridPanel({
        id: 'DGListingEditorGridHistorialFarma',
        store: DGDataStoreHistorialFarma,
        clicksToEdit: 1,
        cm: new xg.ColumnModel([
            chkColumnSeleccionarMx,
            {
                header: 'Descripcion',
                dataIndex: 'DesProced',
                sortable: true,
                width: 560
            },
            {
                header: 'Cantidad',
                dataIndex: 'Cantidad',
                sortable: true,
                width: 80
            },
            {
                header: 'Posologia',
                dataIndex: 'Posologia',
                sortable: true,
                width: 200
            },
            {
                header: 'Fecha',
                dataIndex: 'FechaAtencion',
                sortable: true,
                width: 110
            }
        ]),
        plugins: [chkColumnSeleccionarMx],
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        viewConfig: {
            forceFit:true
        },
        columnLines: true,
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        listeners: {
           rowdblclick: doRowDblClick,
           rowcontextmenu: doRowCtxMenu,
           destroy: function(thisGrid) {
               if (thisGrid.rowCtxMenu) {
                   thisGrid.rowCtxMenu.destroy();
               }
           }
        },
        bbar: new Ext.PagingToolbar({
            pageSize: 15,
            store: DGDataStoreHistorialFarma,
            displayInfo: true
        }),
        tbar:[
            '->',
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Cargar Medicamentos',
                iconCls: 'btnSelect',
                id: 'btnSelectMedicamentosHistorial',
                listeners:{
                    click : function(){
                        if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                            var mxseleccionados = false;
                            var parametrosMxSeleccionados = "";
                            Ext.getCmp('DGListingEditorGridHistorialFarma').store.filterBy(function(record,id){
                                return record.get('Seleccionar') == true;
                            });
                            Ext.getCmp('DGListingEditorGridHistorialFarma').store.each(function(record){
                                mxseleccionados = true;
                                parametrosMxSeleccionados = parametrosMxSeleccionados + Ext.getCmp('sysCASHC').getValue() + "^" + record.get('idConsecutivoSolicitud') + "¬";
                            });
                            if(mxseleccionados == true){
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea cargar los medicamentos seleccionados?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn){
                                        if(btn=="yes"){
                                            Ext.Ajax.request({
                                                waitMsg: 'Por favor Espere...',
                                                url: "../../controlador/solmx/controlador_solmx.php",
                                                params: {
                                                    task: "CARGAR_MX_SELECCIONADOS",
                                                    pEmpresa: ID_EMPRESA,
                                                    pSEDE: ID_SEDE, 
                                                    pIPS: ID_IPS, 
                                                    pMedicamentos: parametrosMxSeleccionados
                                                },
                                                success: function(response)
                                                {
                                                    var result = response.responseText.split("^");
                                                    Ext.getCmp('gridMedicamentosHC').store.reload();
                                                    DGListingWindowHistorialFarma.close();
                                                },
                                                failure: function(response){
                                                    var result = response.responseText;
                                                    Ext.MessageBox.show({
                                                        title: 'Error Base Datos',
                                                        msg: 'Error de conexión - No podemos adicionar los medicamentos en estos momentos',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                    DGListingWindowHistorialFarma.close();
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }else{
                            Ext.MessageBox.show({
                                title: 'Medicamentos',
                                msg: 'Debe Guardar la historia clinica para poder adicionar los medicamentos seleccionados.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ]
    });

   DGListingWindowHistorialFarma = new Ext.Window({
        id: 'DGListingWindowHistorialFarma',
        title: 'Historial Farmacologico',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        modal: true,
        x: MargenIzquierdo,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGridHistorialFarma,
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3005703911',
            xtype : 'tbtext'
        },'-',btnSalir]
    });
    DGListingWindowHistorialFarma.show();
    DGListingEditorGridHistorialFarma.store.setBaseParam("task", "VER_HISTORIAL_FARMACOLOGICO");
    DGListingEditorGridHistorialFarma.store.setBaseParam("pPaciente", wPaciente);
    DGListingEditorGridHistorialFarma.store.load();
    /*{
        params: {
            task: 'VER_HISTORIAL_FARMACOLOGICO',
            
        }
    });*/
    
   
}