/*
* @category    Funcion Buscar Cie10
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function viewHistorialOrdenamientos(wPaciente,wCargarReporteParaclinicos){
    var DGDataStoreHistorialExamenes;
    var DGColumnModel;
    var DGListingEditorGridHistorialExamenes;
    var DGListingWindowHistorialExamenes;
    var DGListingSelectedRow;
    var DGListingContextMenu;
    var anchoPantalla;
    var MargenIzquierdo;
    var xg = Ext.grid;

    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    anchoPantalla = screen.width;
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }
    
    var chkColumnSeleccionarExa = new xg.CheckColumn({
        header: ' ',
        dataIndex: 'Seleccionar',
        id: 'chkColumnSeleccionarExa',
        value: false,
        width: 20
     });
        
    var btnSalir = new Ext.Button({
        text: 'Salir',
        icon: '../../../resources/botones/salir.png',
        iconCls: 'x-btn-text-icon',
        minWidth: 80,
        handler:function(){
            DGListingWindowHistorialExamenes.close();
        }
    });

    DGDataStoreHistorialExamenes = new Ext.data.Store({
        id: 'DGDataStoreHistorialExamenes',
        proxy: new Ext.data.HttpProxy({
            url: '../../controlador/solexa/controlador_solexa.php',
            method: 'POST'
        }),
        loadMask: {msg:"Cargando Registros, por favor espere..."},
        autoLoad: false,
        params: {
            task: 'VER_HISTORIAL_ORDENAMIENTOS',
            pPaciente: wPaciente
        },
        reader: new Ext.data.JsonReader({
            root: 'results',
            totalProperty: 'total',
            id: 'id'
          },[
            {name: 'idConsecutivoSolicitud'},
            {name: 'Tipo'},
            {name: 'Empresa'},
            {name: 'IPS'},
            {name: 'Paciente'},
            {name: 'CAS'},
            {name: 'ConsecutivoHC'},
            {name: 'Origen'},
            {name: 'idConceptoOfimedical'},
            {name: 'idConceptoOfiClinic'},
            {name: 'idEspecialidad'},
            {name: 'Remision'},
            {name: 'fecReporte'},
            {name: 'nomEntidad'},
            {name: 'Reporte'},
            {name: 'valorReferencia'},
            {name: 'Resultado'},
            {name: 'Cantidad'},
            {name: 'Posologia'},
            {name: 'dosisDia'},
            {name: 'notasProveedor'},
            {name: 'fecSolicitud'},
            {name: 'Proveedor'},
            {name: 'fecRealizacion'},
            {name: 'salidaConsulta'},
            {name: 'PyP'},
            {name: 'Finalidad'},
            {name: 'Diagnostico'},
            {name: 'ServiciosIngreso'},
            {name: 'NOPOS'},
            {name: 'TipoServicio'},
            {name: 'Ambito'},
            {name: 'ResumenDx'},
            {name: 'DescripcionCasoClinico'},
            {name: 'TratamientosRealizados'},
            {name: 'Caracter'},
            {name: 'CaracterCantidad'},
            {name: 'CaracterDias'},
            {name: 'Homologo'},
            {name: 'HomologoSustituto'},
            {name: 'Justificacion'},
            {name: 'MiembroParte'},
            {name: 'Prioritario'},
            {name: 'ExplicaConsentimiento'},
            {name: 'ConsentimientoInformado'},
            {name: 'Usuario'},
            {name: 'FechaAct'},
            {name: 'DesProced'},
            {name: 'FechaAtencion'},
            {name: 'Seleccionar'}
         ])
    });

    
    doMsgBoxAlert = function(record) {
        //alert(pCampo);
    };

    doRowDblClick = function(thisGrid, rowIndex)  {
       var record = thisGrid.getStore().getAt(rowIndex);
       //doMsgBoxAlert(record);
    };

    doRowCtxMenu = function(thisGrid, rowIndex, evtObj)
    {
        /*evtObj.stopEvent();
        var record = thisGrid.getStore().getAt(rowIndex);
        if (!thisGrid.rowCtxMenu)
        {
            thisGrid.rowCtxMenu = new Ext.menu.Menu({
                items : {
                    text    : 'Seleccionar Diagnostico',
                    handler : function() {
                        doMsgBoxAlert(record);
                    }
                }
            });
       }
       thisGrid.rowCtxMenu.showAt(evtObj.getXY());
       */
    };
    
    DGListingEditorGridHistorialExamenes =  new Ext.grid.EditorGridPanel({
        id: 'DGListingEditorGridHistorialExamenes',
        store: DGDataStoreHistorialExamenes,
        clicksToEdit: 1,
        cm: new xg.ColumnModel([
            chkColumnSeleccionarExa,
            {
                header: 'Descripcion',
                dataIndex: 'DesProced',
                sortable: true,
                width: 560
            },
            {
                header: 'Cantidad',
                dataIndex: 'Cantidad',
                sortable: true,
                width: 80
            },
            {
                header: 'Notas',
                dataIndex: 'notasProveedor',
                sortable: true,
                width: 200
            },
            {
                header: 'Fecha',
                dataIndex: 'FechaAtencion',
                sortable: true,
                width: 110
            }
        ]),
        plugins: [chkColumnSeleccionarExa],
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        viewConfig: {
            forceFit:true
        },
        columnLines: true,
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        listeners: {
           rowdblclick: doRowDblClick,
           rowcontextmenu: doRowCtxMenu,
           destroy: function(thisGrid) {
               if (thisGrid.rowCtxMenu) {
                   thisGrid.rowCtxMenu.destroy();
               }
           }
        },
        bbar: new Ext.PagingToolbar({
            pageSize: 15,
            store: DGDataStoreHistorialExamenes,
            displayInfo: true
        }),
        tbar:[
            '->',
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Cargar Servicio',
                iconCls: 'btnSelect',
                id: 'btnSelectOrdenamientosHistorial',
                listeners:{
                    click : function(){
                        if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                            var Exaseleccionados = false;
                            var parametrosExaSeleccionados = "";
                            Ext.getCmp('DGListingEditorGridHistorialExamenes').store.filterBy(function(record,id){
                                return record.get('Seleccionar') == true;
                            });
                            Ext.getCmp('DGListingEditorGridHistorialExamenes').store.each(function(record){
                                Exaseleccionados = true;
                                parametrosExaSeleccionados = parametrosExaSeleccionados + Ext.getCmp('sysCASHC').getValue() + "^" + record.get('idConsecutivoSolicitud') + "¬";
                            });
                            if(Exaseleccionados == true){
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea cargar los servicios seleccionados?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn){
                                        if(btn=="yes"){
                                            Ext.Ajax.request({
                                                waitMsg: 'Por favor Espere...',
                                                url: "../../controlador/solexa/controlador_solexa.php",
                                                params: {
                                                    task: "CARGAR_EXA_SELECCIONADOS",
                                                    pEmpresa: ID_EMPRESA,
                                                    pSEDE: ID_SEDE, 
                                                    pIPS: ID_IPS, 
                                                    pCargarReporteParaclinicos: wCargarReporteParaclinicos,
                                                    pOrdenamientos: parametrosExaSeleccionados
                                                },
                                                success: function(response)
                                                {
                                                    var result = response.responseText.split("^");
                                                    Ext.getCmp('gridExamenesHC').store.reload();
                                                    try {
                                                        var campo = Ext.getCmp('gridReporteParaclinicos');
                                                        if ( campo != null ) {
                                                            Ext.getCmp("gridReporteParaclinicos").store.reload();
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    DGListingWindowHistorialExamenes.close();
                                                },
                                                failure: function(response){
                                                    var result = response.responseText;
                                                    Ext.MessageBox.show({
                                                        title: 'Error Base Datos',
                                                        msg: 'Error de conexión - No podemos adicionar los ordenamientos en estos momentos',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                    DGListingWindowHistorialExamenes.close();
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }else{
                            Ext.MessageBox.show({
                                title: 'Ordenamientos',
                                msg: 'Debe Guardar la historia clinica para poder adicionar los servicios seleccionados.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ]
    });

   DGListingWindowHistorialExamenes = new Ext.Window({
        id: 'DGListingWindowHistorialExamenes',
        title: 'Historial Ordenamientos de Servicios',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        modal: true,
        x: MargenIzquierdo,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGridHistorialExamenes,
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3005703911',
            xtype : 'tbtext'
        },'-',btnSalir]
    });
    DGListingWindowHistorialExamenes.show();
    DGListingEditorGridHistorialExamenes.store.setBaseParam("task", "VER_HISTORIAL_ORDENAMIENTOS");
    DGListingEditorGridHistorialExamenes.store.setBaseParam("pPaciente", wPaciente);
    DGListingEditorGridHistorialExamenes.store.load();
   
}