/*
* @category    Formulario kardex de Pacientes 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmMovimientosUi = Ext.extend(Ext.Window, {
    layout: 'fit',
    title: '.:: Movimientos de Inventario ::.',
    width: 1000,
    autoHeight: true,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    closable: false,
    draggable: false,
    resizable: false,
    id: 'winFrmMovimientos',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        wPaciente = 0;
        wCAS = 0;
        
        var stBodegasAddInv = new StoreBodegas();
        var stBodegasZonasAddInv = new StoreBodegasZonas();
        var stGrid = new StoreGridMovimientosDetalle();
        
        //Store Local
        
        var dataTipoMovimiento = [
            [4,'COMPRAS'],
            /*[5,'RECEPCION TRASLADO'],
            [6,'TRASLADO'],*/
            [8,'BAJA DE INVENTARIO'],
            [9,'AJUSTE POR INVENTARIO'],
            [10,'CONSUMO']
        ];
        var stTipoMovimiento = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stTipoMovimiento.loadData(dataTipoMovimiento);
        
        var dataTipoAjuste = [
            ['AJUSTE INVENTARIO POR SOBRANTE'],
            ['AJUSTE INVENTARIO POR FALTANTE']
        ];
        var stTipoAjuste = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoAjuste.loadData(dataTipoAjuste);

        this.items = [
            {
                xtype: 'form',
                frame: true,
                autoHeight: true,
                anchor: '100%',
                autoScroll: true,
                id: 'frmMovimientos',
                items: [
                    {
                        xtype: 'hidden',
                        flex: 1,
                        readOnly: true,
                        width: 96,
                        id: 'intidConceptoItemConteo'
                    },
                    {
                        xtype: 'hidden',
                        readOnly: true,
                        width: 96,
                        value: 'A',
                        id: 'strEstado'
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Tipo Movimiento',
                        anchor: '100%',
                        allowBlank: false,
                        store: stTipoMovimiento,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intTipoMovimiento',
                        listeners: {
                            change : function(f,pNew, pOld){
                                Ext.getCmp('intBodegasAddInv').store.load({
                                    params: { 
                                        pIPS: ID_IPS ,
                                        pUsuario: ID_USUARIO
                                    }
                                });
                                Ext.getCmp('intBodegasDestino').store.load({
                                    params: { 
                                        pIPS: ID_IPS ,
                                        pUsuario: ID_USUARIO
                                    }
                                });
                                if(pNew == 4){
                                    Ext.getCmp('fsAjusteInventario').setVisible(false);
                                    Ext.getCmp('fsBajaInventario').setVisible(false);
                                    Ext.getCmp('fsBodegaDestino').setVisible(false);
                                    Ext.getCmp('fsCompras').setVisible(true);
                                    Ext.getCmp('strEstado').setValue("A");
                                }else{
                                    if(pNew == 6){
                                        Ext.getCmp('fsAjusteInventario').setVisible(false);
                                        Ext.getCmp('fsBajaInventario').setVisible(false);
                                        Ext.getCmp('fsBodegaDestino').setVisible(true);
                                        Ext.getCmp('fsCompras').setVisible(false);
                                        Ext.getCmp('strEstado').setValue("A");
                                    }else{
                                        if(pNew == 8){
                                            Ext.getCmp('fsAjusteInventario').setVisible(false);
                                            Ext.getCmp('fsBajaInventario').setVisible(true);
                                            Ext.getCmp('fsBodegaDestino').setVisible(false);
                                            Ext.getCmp('fsCompras').setVisible(false);
                                            Ext.getCmp('strEstado').setValue("A");
                                        }else{
                                            if(pNew == 9){
                                                Ext.getCmp('fsAjusteInventario').setVisible(true);
                                                Ext.getCmp('fsBajaInventario').setVisible(false);
                                                Ext.getCmp('fsBodegaDestino').setVisible(false);
                                                Ext.getCmp('fsCompras').setVisible(false);
                                                Ext.getCmp('strEstado').setValue("A");
                                            }else{
                                                if(pNew == 5){
                                                    Ext.getCmp('fsAjusteInventario').setVisible(false);
                                                    Ext.getCmp('fsBajaInventario').setVisible(false);
                                                    Ext.getCmp('fsBodegaDestino').setVisible(false);
                                                    Ext.getCmp('fsCompras').setVisible(false);
                                                    Ext.getCmp('strEstado').setValue("P");
                                                }else{
                                                    if(pNew == 10){
                                                        Ext.getCmp('fsAjusteInventario').setVisible(false);
                                                        Ext.getCmp('fsBajaInventario').setVisible(false);
                                                        Ext.getCmp('fsBodegaDestino').setVisible(false);
                                                        Ext.getCmp('fsCompras').setVisible(false);
                                                        Ext.getCmp('strEstado').setValue("A");
                                                    }else{
                                                        Ext.getCmp('fsAjusteInventario').setVisible(false);
                                                        Ext.getCmp('fsBajaInventario').setVisible(false);
                                                        Ext.getCmp('fsBodegaDestino').setVisible(false);
                                                        Ext.getCmp('fsCompras').setVisible(false);
                                                        Ext.getCmp('strEstado').setValue("A");
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Bodega',
                                width: 250,
                                allowBlank: false,
                                store: stBodegasAddInv,
                                valueField: 'IdBodega',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intBodegasAddInv',
                                listeners: {
                                    select: function(cmb, rec, idx) {
                                        Ext.getCmp('intZonasAddInv').clearValue();
                                        Ext.getCmp('intZonasAddInv').store.removeAll(true);

                                        Ext.getCmp('intZonasAddInv').store.load({
                                            params: { 
                                                pIPS: ID_IPS ,
                                                pBodega: cmb.getValue() 
                                            }
                                        });
                                    }
                                }
                            },
                            {
                                html: 'Zona:'
                            },
                            {
                                xtype: 'combo',
                                width: 250,
                                allowBlank: false,
                                store: stBodegasZonasAddInv,
                                valueField: 'IdZona',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intZonasAddInv'
                            },
                            {
                                html: 'Fecha:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha',
                                allowBlank: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecFechaMovimiento'
                            },
                            {
                                xtype: 'numberfield',
                                hidden: true,
                                width: 96,
                                id: 'intIdMovimiento'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Compras',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        width: 949,
                        autoHeight: true,
                        id: 'fsCompras',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        name: 'N.Factura',
                                        fieldLabel: 'Factura Compra',
                                        width: 200,
                                        allowBlank: true,
                                        id: 'strFacturaCompra'
                                    },
                                    {
                                        html: 'Proveedor:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Proveedor',
                                        width: 350,
                                        allowBlank: true,
                                        store: 'StoreClienteProveedor',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strProveedorCompra'
                                    },
                                    {
                                        html: 'FechaFac:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'FechaFac',
                                        allowBlank: true,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFechaCompra'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Bodega Destino',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        width: 949,
                        autoHeight: true,
                        id: 'fsBodegaDestino',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Bodega',
                                        width: 250,
                                        allowBlank: true,
                                        store: stBodegasAddInv,
                                        valueField: 'IdBodega',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'intBodegasDestino',
                                        listeners: {
                                            select: function(cmb, rec, idx) {
                                                Ext.getCmp('intZonasDestino').clearValue();
                                                Ext.getCmp('intZonasDestino').store.removeAll(true);

                                                Ext.getCmp('intZonasDestino').store.load({
                                                    params: { 
                                                        pIPS: ID_IPS ,
                                                        pBodega: cmb.getValue() 
                                                    }
                                                });
                                            }
                                        }
                                    },
                                    {
                                        html: 'Zona:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 250,
                                        allowBlank: true,
                                        store: stBodegasZonasAddInv,
                                        valueField: 'IdZona',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'intZonasDestino'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Baja Inventario',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        width: 949,
                        autoHeight: true,
                        id: 'fsBajaInventario',
                        items: [
                            {
                                xtype: 'textarea',
                                anchor: '100%',
                                fieldLabel: 'Motivo Baja',
                                name: 'Motivo Baja',
                                allowBlank: true,
                                id: 'memMotivoBaja'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Ajuste Inventario',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        width: 949,
                        autoHeight: true,
                        id: 'fsAjusteInventario',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Tipo Ajuste',
                                anchor: '100%',
                                allowBlank: true,
                                store: stTipoAjuste,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strTipoAjuste'
                            },
                            {
                                xtype: 'textarea',
                                anchor: '100%',
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                allowBlank: true,
                                id: 'memObservaciones'
                            }
                        ]
                    }
                ],
                tbar: {
                    xtype: 'toolbar',
                    anchor:'100%',
                    items:[
                        {
                            xtype: 'button',
                            text: 'Nuevo',
                            iconCls: 'btnNuevo',
                            id: 'btnNuevo'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Movimiento',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarMovimiento',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                        title: 'eOfiClinic',
                                        msg: 'Esta seguro que desea Crear el Movimiento al Inventario?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn === "yes")
                                            {
                                                fnGuardarMovimiento();
                                            }
                                        }
                                    });
                                }
                            }
                        },
                        {
                            xtype: 'button',
                            text: 'Aplicar Movimiento',
                            iconCls: 'btnEditRow',
                            id: 'btnAplicarMov'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'displayfield',
                            value: 'Sin Registrar',
                            name: 'txtNroMovimientos',
                            style: 'color: darkblue; font-size: large; font-weight: bold;',
                            ref: '../fNroMovimientos',
                            id: 'fNroMovimientos'
                        }
                    ]
                }
        
            },
            {
                xtype: 'tabpanel',
                anchor: '99%',
                autoHeight: true,
                border: false,
                enableTabScroll: true,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Conceptos',
                        autoHeight: true,
                        autoScroll: true,
                        anchor: '98%',
                        frame: true,
                        border: false,
                        id: 'fichaMovimientos',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'grid',
                                id: 'gridMovimientos',
                                store: stGrid,
                                autoWidth: true,
                                height: 250,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        header: 'Codigo',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'CodProced',
                                        align: 'center',
                                        width: 150,
                                        hideable: false
                                    },
                                    {
                                        header: 'Item',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'DesProced',
                                        align: 'left',
                                        width: 405,
                                        hideable: false
                                    },
                                    {
                                        header: 'Entrada',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Entrada',
                                        align: 'center',
                                        width: 100,
                                        hideable: false
                                    },
                                    {
                                        header: 'Salida',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Salida',
                                        align: 'center',
                                        width: 100,
                                        hideable: false
                                    },
                                    {
                                        header: 'Saldo',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Saldo',
                                        align: 'center',
                                        width: 100,
                                        hideable: false
                                    },
                                    {
                                        header: 'VlrCompra',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'VlrCompra',
                                        align: 'center',
                                        width: 100,
                                        hideable: false
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                view: new Ext.ux.grid.LockingGridView(),
                                columnLines: true,
                                tbar: {
                                    xtype: 'toolbar',
                                    anchor:'100%',
                                    items:[
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar',
                                            iconCls: 'btnActualizarGrid',
                                            id: 'btnActualizar'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Adicionar Item',
                                            iconCls: 'btnAddRow',
                                            id: 'btnCrearRegistro'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Eliminar Item',
                                            iconCls: 'btnDelRow',
                                            id: 'btnEliminarItem'
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    Ext.getCmp('fsAjusteInventario').setVisible(false);
                    Ext.getCmp('fsBajaInventario').setVisible(false);
                    Ext.getCmp('fsBodegaDestino').setVisible(false);
                    Ext.getCmp('fsCompras').setVisible(false);
                }
            }
        });
        winFrmMovimientosUi.superclass.initComponent.call(this);
    }
});


function fnGuardarMovimiento(){
    if(Ext.getCmp('intIdMovimiento').getValue() === "" || Ext.getCmp('intIdMovimiento').getValue() === null || Ext.getCmp('intIdMovimiento').getValue() === 0){
        var frm = Ext.getCmp('frmMovimientos').getForm();
        if (frm.isValid()){
            Ext.Ajax.request({
                waitMsg: 'Por favor Espere...',                                                
                url: '../../controlador/inventario/controlador_inventario.php',
                params:{
                    task: 'ADD_MOVIMIENTO',
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pTipoMovimiento: Ext.getCmp('intTipoMovimiento').getValue(),
                    pBodega: Ext.getCmp('intBodegasAddInv').getValue(),
                    pZona: Ext.getCmp('intZonasAddInv').getValue(),
                    pFechaMovimiento: Ext.getCmp('fecFechaMovimiento').getValue(),
                    pFechaCompra: Ext.getCmp('fecFechaCompra').getValue(),
                    pProveedor: Ext.getCmp('strProveedorCompra').getValue(),
                    pFacturaCompra: Ext.getCmp('strFacturaCompra').getValue(),
                    pBodegaDestino: Ext.getCmp('intBodegasDestino').getValue(),
                    pZonaDestino: Ext.getCmp('intZonasDestino').getValue(),
                    pMotivoBaja: Ext.getCmp('memMotivoBaja').getValue(),
                    pTipoAjuste: Ext.getCmp('strTipoAjuste').getValue(),
                    pMotivoAjuste: Ext.getCmp('memObservaciones').getValue(),
                    pUsuario: ID_USUARIO,
                    pEstado: Ext.getCmp('strEstado').getValue()
                },
                success: function(response,options){
                    var Respuesta1 = response.responseText;
                    var Contenido1 = Respuesta1.split('^');
                    if(Contenido1[0] === "" || Contenido1[0] === "{success:false}" || Contenido1[0] === null){
                        Ext.getCmp('intIdMovimiento').setValue(0);
                        Ext.Msg.hide();
                        Ext.MessageBox.show({
                            title: 'Error Movimiento Inventario',
                            msg: 'Ocurrio un error al generar el numero de CAS o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    } else {
                        Ext.Msg.hide();
                        Ext.Msg.show({
                            title: 'Movimiento Inventario',
                            msg: 'Se Genero el Movimiento de Inventario Nro: ' + Contenido1[0],
                            buttons: Ext.Msg.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('intIdMovimiento').setValue(Contenido1[0]);
                        Ext.getCmp('fNroMovimientos').setValue("MOV Nro: " + Contenido1[0]);

                        //DEBE BORRAR EL STORE
                        Ext.getCmp('gridMovimientos').store.removeAll();
                    }
                },
                failure: function(response,options){
                    Ext.Msg.hide();
                    Ext.getCmp('intIdMovimiento').setValue(0);
                    Ext.MessageBox.show({
                        title: 'Movimiento Inventario Error',
                        msg: 'Ocurrio un error al generar el numero de CAS o no se pudo establecer conexión con el servidor.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                },
                scope:this
            });
        }else{
            Ext.MessageBox.show({
                title: 'Guardar',
                msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    }else{
        Ext.MessageBox.show({
                title: 'Movimiento Inventario Error',
                msg: 'El Movimiento ya fue guardado.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
    }
}
