/*
* @category    Formulario Adicionar Inventario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winCrearInventarioUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Crear Inventario ::.',
    width: 600,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winCrearInventarioUi',
    initComponent: function() {
        var stBodegasAddInv = new StoreBodegas();
        stBodegasAddInv.load({
            params: {
                pIPS: ID_IPS
            }
        });
        
        var stBodegasZonasAddInv = new StoreBodegasZonas();
        var stTipoInventarioAddInv = new StoreTipoMovimientoINV();
        stTipoInventarioAddInv.load({
            params: {
                pTipo: "Inventario"
            }
        });
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmCrearInventario',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Bodega',
                                anchor: '100%',
                                allowBlank: false,
                                store: stBodegasAddInv,
                                valueField: 'IdBodega',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intBodegasAddInv',
                                listeners: {
                                    select: function(cmb, rec, idx) {
                                        Ext.getCmp('intZonasAddInv').clearValue();
                                        Ext.getCmp('intZonasAddInv').store.removeAll(true);

                                        Ext.getCmp('intZonasAddInv').store.load({
                                            params: { 
                                                pIPS: ID_IPS ,
                                                pBodega: cmb.getValue() 
                                            }
                                        });
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Zona',
                                anchor: '100%',
                                allowBlank: false,
                                store: stBodegasZonasAddInv,
                                valueField: 'IdZona',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intZonasAddInv'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Tipo Inventario',
                                anchor: '100%',
                                allowBlank: false,
                                store: stTipoInventarioAddInv,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strTipoInventarioAddInv'
                            },
                            {
                                xtype: 'timefield',
                                fieldLabel: 'Hora Apertura',
                                width: 90,
                                allowBlank: false,
                                forceSelection: false,
                                minValue: '06:00 AM',
                                maxValue: '09:00 PM',
                                emptyText: 'p.e. 07:00',
                                id: 'strHoraAperturaAddInv'
                            },        
                            {
                                xtype: 'textarea',
                                anchor: '100%',
                                fieldLabel: 'Acta Apertura',
                                allowBlank: false,
                                id: 'strActaAperturaAddInv'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AdicionarLote',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmCrearInventario').getForm();
                                    if (frm.isValid()){
                                        Ext.Msg.show({
                                            title: 'Inventarios',
                                            msg: 'Esta Seguro que Desea Crear el Inventario?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    frm.submit({
                                                        url: '../../controlador/inventario/controlador_inventario.php',
                                                        params: {
                                                            task: 'ADD_INVENTARIO',
                                                            pEmpresa: ID_EMPRESA,
                                                            pIPS: ID_IPS,
                                                            pUsuario: ID_USUARIO,
                                                            pBodega: Ext.getCmp('intBodegasAddInv').getValue(),
                                                            pZona: Ext.getCmp('intZonasAddInv').getValue(),
                                                            pTipoInventario: Ext.getCmp('strTipoInventarioAddInv').getValue(),
                                                            pHoraApertura: Ext.getCmp('strHoraAperturaAddInv').getValue(),
                                                            pActaApertura: Ext.getCmp('strActaAperturaAddInv').getValue()
                                                        },
                                                        success: function(res,req)
                                                        {
                                                            switch(req.result.requestedId){
                                                                case "1":
                                                                    LimpiarCamposINV();
                                                                    Ext.getCmp('treeHistiricoInventarios').root.reload();
                                                                    Ext.getCmp('winCrearInventarioUi').close();
                                                                    Ext.MessageBox.show({
                                                                        title: 'Inventario',
                                                                        msg: 'Se creo el Inventario con exito, por favor busquelo en el historico de inventarios para continuar con el proceso.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.INFO
                                                                    });
                                                                    break;

                                                                default:
                                                                    Ext.MessageBox.show({
                                                                        title: 'Inventario',
                                                                        msg: 'Ocurrio un error al crear el inventario o no se pudo establecer conexión con el servidor.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                    break;
                                                            }
                                                        },
                                                        failure: function(response,options)
                                                        {
                                                            Ext.MessageBox.show({
                                                                title: 'Error Base Datos',
                                                                msg: 'No podemos crear el inventario en estos momentos',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }
                                                    });
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Los campos son Requeridos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirAddInv',
                            listeners: {
                                click: function(){
                                    Ext.getCmp('winCrearInventarioUi').close();
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winCrearInventarioUi.superclass.initComponent.call(this);
    }
});
