/*
* @category    Formulario Inventarios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

//Generamos el viewport

winFrmInventariosUi = Ext.extend( Ext.Viewport,{
    title: 'OfiClinic© Web..! ... Inventarios ...',
    id: 'winFrmInventariosUi',
    closable: true,
    layout:'border',
    defaults: {
        split: true
    },
    initComponent: function() {
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        
        function DescripcionConceptoMvto(val, x, store){
            var html = '<table><tr><td>'+val+'</td></tr></table>';
            return html;
        }
        
        function MostarCantidadInventario(val, x, store){
            //return Ext.util.Format,numberRenderer(val,"0,000");
        }
        
        var LoaderTreeInventarios = new Ext.tree.TreeLoader({      //Paso 1
            url: '../../controlador/inventario/arbol_inventario.php'
        });
        
        LoaderTreeInventarios.on("beforeload", function(t,n){
            LoaderTreeInventarios.baseParams.qryBodega = Ext.getCmp('sysBtnBodegaINV').getValue();
            LoaderTreeInventarios.baseParams.qryZona = Ext.getCmp('sysBtnZonaINV').getValue();
            LoaderTreeInventarios.baseParams.qryInventario = Ext.getCmp('sysBtnIdConsecutivoINV').getValue();
        });
        
        var stBodegas = new StoreBodegas();
        stBodegas.load({
            params: {
                pIPS: ID_IPS
            }
        });
        
        var stBodegasZonas = new StoreBodegasZonas();
        var stGridDetalleInventario = new StoreGridDetalleInventario();
        
        this.items = [
            {
                xtype: 'panel',
                title: '<center>GESION DE INVENTARIOS</center>',
                region: 'center',
                autoScroll: true,
                frame: true,
                tbar: {
                    items: [
                        {
                            html: 'Bodega:'
                        },
                        {
                            xtype: 'combo',
                            width: 110,
                            allowBlank: true,
                            store: stBodegas,
                            valueField: 'IdBodega',
                            displayField: 'Descripcion',
                            mode: 'local',
                            forceSelection: true,
                            typeAhead: true,
                            typeAheadDelay: 10,
                            triggerAction: 'all',
                            id: 'sysBtnBodegaINV',
                            listeners: {
                                select: function(cmb, rec, idx) {
                                    Ext.getCmp('sysBtnZonaINV').clearValue();
                                    Ext.getCmp('sysBtnZonaINV').store.removeAll(true);

                                    Ext.getCmp('sysBtnZonaINV').store.load({
                                        params: { 
                                            pIPS: ID_IPS ,
                                            pBodega: cmb.getValue() 
                                        }
                                    });
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            html: 'Zona:'
                        },
                        {
                            xtype: 'combo',
                            width: 110,
                            allowBlank: true,
                            store: stBodegasZonas,
                            valueField: 'IdZona',
                            displayField: 'Descripcion',
                            mode: 'local',
                            forceSelection: true,
                            typeAhead: true,
                            typeAheadDelay: 10,
                            triggerAction: 'all',
                            id: 'sysBtnZonaINV'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            html: 'Nro Inventario:'
                        },
                        {
                            xtype: 'numberfield',
                            width: 90,
                            allowBlank: true,
                            id: 'sysBtnIdConsecutivoINV'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnActualizarGrid',
                            tooltip: 'Consultar',
                            listeners: {
                                click: function() {
                                    Ext.getCmp('treeHistiricoInventarios').root.reload();
                                }
                            }
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnLimpiar',
                            tooltip: 'Limpiar',
                            listeners: {
                                click: function() {
                                    Ext.getCmp('sysBtnBodegaINV').setValue(null);
                                    Ext.getCmp('sysBtnZonaINV').setValue(null);
                                    Ext.getCmp('sysBtnIdConsecutivoINV').setValue(null);
                                    Ext.getCmp('treeHistiricoInventarios').root.reload();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            html: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Crear Inventario',
                            iconCls: 'btnAddRow',
                            tooltip: 'Crear Inventario',
                            listeners: {
                                click: function() {
                                    winAddINV = new winCrearInventarioUi();
                                    winAddINV.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                },
                bbar: {
                    items: [
                        '->',
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            tooltip: 'Salir',
                            listeners: {
                                click: function() {
                                    window.close();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                },
                items:[
                    {
                        xtype: 'hidden',
                        value: 0,
                        id: 'sysIdConsecutivoInventario'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysEstadoInventario'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysEstadoCoteo'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysConteoActualInventario'
                    },
                    {
                        xtype: 'panel',
                        width: 740,
                        frame: true,
                        autoHeight: true,
                        title: 'RESUMEN INVENTARIO',
                        autoScroll: true,
                        id: 'pnInventario001',
                        tbar: {
                            anchor: '99%',
                            items: [
                                '->',
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Anular',
                                    iconCls: 'btnAnular',
                                    tooltip: 'Anular Inventario',
                                    listeners: {
                                        click: function() {
                                            if(Ext.getCmp('sysIdConsecutivoInventario').getValue() !== 0 && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== "0" && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== null){
                                                if(Ext.getCmp('sysConteoActualInventario').getValue() === 0 && Ext.getCmp('sysEstadoInventario').getValue() === "A"){
                                                    alert("Anular Inventario");
                                                }else{
                                                    if(Ext.getCmp('sysEstadoInventario').getValue() !== "A"){
                                                        alert("Anular Inventario");
                                                    }else{
                                                        Ext.MessageBox.show({
                                                            title: 'Inventarios',
                                                            msg: 'El inventario seleccionado no esta cerrado y tiene conteos en proceso.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                }
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Inventarios',
                                                    msg: 'Debe seleccionar un inventario.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }    
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Imprimir',
                                    iconCls: 'btnImprimir',
                                    tooltip: 'Imprimir Inventario',
                                    listeners: {
                                        click: function() {
                                            alert("imprimir inventario");
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Exportar',
                                    iconCls: 'btnExcel',
                                    tooltip: 'Exportar Inventario',
                                    listeners: {
                                        click: function() {
                                            if(Ext.getCmp('sysIdConsecutivoInventario').getValue() !== 0 && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== "0" && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== null){
                                                window.open ("../../controlador/inventario/exportar_inventario.php?pInventario=" + Ext.getCmp('sysIdConsecutivoInventario').getValue(),"Inventario");
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Inventarios',
                                                    msg: 'Debe seleccionar un inventario.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {    
                                xtype:'fieldset',
                                title: 'INFORMACION GENERAL',
                                collapsible: true,
                                anchor:'90%',
                                autoHeight:true,
                                items:[ 
                                    {
                                        xtype: 'compositefield',
                                        frame: true,
                                        fieldLabel: 'Bodega',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 250,
                                                readOnly: true,
                                                id: 'pn001Bodega'
                                            },
                                            {
                                                html: ' Zona: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 250,
                                                readOnly: true,
                                                id: 'pn001Zona'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        frame: true,
                                        fieldLabel: 'Tipo Inventario',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 250,
                                                readOnly: true,
                                                id: 'pn001TipoInv'
                                            },
                                            {
                                                html: ' Nro Doc:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                readOnly: true,
                                                id: 'pn001NroInv'
                                            },
                                            {
                                                html: ' Fecha:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 110,
                                                readOnly: true,
                                                id: 'pn001FecInv'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        frame: true,
                                        fieldLabel: 'Apertura',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 110,
                                                readOnly: true,
                                                id: 'pn001HoraInicio'
                                            },
                                            {
                                                html: ' Acta:'
                                            },
                                            {
                                                xtype: 'textarea',
                                                width: 450,
                                                readOnly: true,
                                                id: 'pn001ActaApertura'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        frame: true,
                                        fieldLabel: 'Cierre',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 110,
                                                readOnly: true,
                                                id: 'pn001HoraCierre'
                                            },
                                            {
                                                html: ' Acta:'
                                            },
                                            {
                                                xtype: 'textarea',
                                                width: 450,
                                                readOnly: true,
                                                id: 'pn001ActaCierre'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textarea',
                                        fieldLabel: 'Anulado',
                                        width: 600,
                                        readOnly: true,
                                        id: 'pn001MotivoAnulado'
                                    }
                                ]
                            }
                        ]
                    }, // Modelo Panel Inventario
                    {
                        xtype: 'panel',
                        layout: 'form',
                        title: '<center>Detalle Iventario</center>',
                        width: 740,
                        autoHeight: true,
                        tbar:{
                            items: [
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    html: 'Codigo Barras:'
                                },
                                {
                                    xtype: 'textfield',
                                    width: 130,
                                    allowBlank: true,
                                    id: 'sysFilterCodBarrasInv',
                                    listeners:{
                                        specialkey: function(f,e){
                                            if (e.getKey() === e.ENTER || e.getKey() === e.TAB){
                                                var wConteos = "N";
                                                if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) > 1){
                                                    wConteos = "S";
                                                }
                                                CargarStoreDetalleInv(Ext.getCmp('sysIdConsecutivoInventario').getValue(),Ext.getCmp('sysFilterCodBarrasInv').getValue(),Ext.getCmp('sysFilterDesConceptoInv').getValue(),wConteos);
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnLimpiar',
                                    tooltip: 'Limpiar',
                                    listeners: {
                                        click: function() {
                                            Ext.getCmp('sysFilterCodBarrasInv').setValue(null);
                                            var wConteos = "N";
                                            if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) > 1){
                                                wConteos = "S";
                                            }
                                            CargarStoreDetalleInv(Ext.getCmp('sysIdConsecutivoInventario').getValue(),Ext.getCmp('sysFilterCodBarrasInv').getValue(),Ext.getCmp('sysFilterDesConceptoInv').getValue(),wConteos);
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    html: 'Concepto:'
                                },
                                {
                                    xtype: 'textfield',
                                    width: 210,
                                    allowBlank: true,
                                    id: 'sysFilterDesConceptoInv',
                                    listeners:{
                                        specialkey: function(f,e){
                                            if (e.getKey() === e.ENTER || e.getKey() === e.TAB){
                                                var wConteos = "N";
                                                if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) > 1){
                                                    wConteos = "S";
                                                }
                                                CargarStoreDetalleInv(Ext.getCmp('sysIdConsecutivoInventario').getValue(),Ext.getCmp('sysFilterCodBarrasInv').getValue(),Ext.getCmp('sysFilterDesConceptoInv').getValue(),wConteos);
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnLimpiar',
                                    tooltip: 'Limpiar',
                                    listeners: {
                                        click: function() {
                                            Ext.getCmp('sysFilterDesConceptoInv').setValue(null);
                                            var wConteos = "N";
                                            if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) > 1){
                                                wConteos = "S";
                                            }
                                            CargarStoreDetalleInv(Ext.getCmp('sysIdConsecutivoInventario').getValue(),Ext.getCmp('sysFilterCodBarrasInv').getValue(),Ext.getCmp('sysFilterDesConceptoInv').getValue(),wConteos);
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        bbar:{
                            items: [
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Crear Conteo',
                                    iconCls: 'btnAddRow',
                                    tooltip: 'Crear Conteo',
                                    listeners: {
                                        click: function() {
                                            if(Ext.getCmp('sysIdConsecutivoInventario').getValue() !== 0 && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== "0" && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== null){
                                                if((Ext.getCmp('sysConteoActualInventario').getValue() === 0 || Ext.getCmp('sysConteoActualInventario').getValue() === "0") && Ext.getCmp('sysEstadoInventario').getValue() === "A"){
                                                    Ext.Msg.show({
                                                        title: 'Inventarios',
                                                        msg: 'Esta Seguro que Desea Crear el Conteo?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn){
                                                            if(btn === "yes"){
                                                                Ext.Ajax.request({
                                                                    url: '../../controlador/inventario/controlador_inventario.php',
                                                                    params:{
                                                                        task: 'ADD_CONTEO_1',
                                                                        pInventario: Ext.getCmp('sysIdConsecutivoInventario').getValue()
                                                                    },
                                                                    success: function(response,options)
                                                                    {
                                                                        var Respuesta = response.responseText;
                                                                        var Contenido = Respuesta.split('^');
                                                                        if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                            Ext.MessageBox.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Ocurrio un error al crear el conteo para este inventario.',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        } else {
                                                                            var wConteos = "N";
                                                                            if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) > 1){
                                                                                wConteos = "S";
                                                                            }
                                                                            CargarStoreDetalleInv();
                                                                            Ext.MessageBox.show({
                                                                                title: 'Inventarios',
                                                                                msg: 'Se creó el Conteo Nro 1 para el inventario, por favor agregue los ítems que desee.',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.INFO
                                                                            });
                                                                            Ext.getCmp('sysConteoActualInventario').setValue(1);
                                                                            Ext.getCmp('sysEstadoCoteo').setValue("A");
                                                                        }
                                                                    },
                                                                    failure: function(response,options){
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error Conexión',
                                                                            msg: 'No podemos realizar la accion del inventario y/o No se pudo establecer conexión con el servidor',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    },
                                                                    scope:this 
                                                                });
                                                            }
                                                        }
                                                    });
                                                }else{
                                                    if(Ext.getCmp('sysEstadoInventario').getValue() === "A"){
                                                        if(Ext.getCmp('sysEstadoCoteo').getValue() === "C"){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/inventario/controlador_inventario.php',
                                                                params:{
                                                                    task: 'CHECK_CONTEO',
                                                                    pInventario: Ext.getCmp('sysIdConsecutivoInventario').getValue()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                        Ext.MessageBox.show({
                                                                            title: 'eOfiClinic',
                                                                            msg: 'Ocurrio un error al crear el conteo para este inventario.',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    } else {
                                                                        var wRegistros = parseInt(Contenido[0]);
                                                                        if(wRegistros > 0){
                                                                            Ext.Msg.show({
                                                                                title: 'Inventarios',
                                                                                msg: 'Esta Seguro que Desea Crear el Conteo?',
                                                                                buttons: Ext.Msg.YESNO,
                                                                                icon: Ext.Msg.QUESTION,
                                                                                fn: function(btn){
                                                                                    if(btn === "yes"){
                                                                                        Ext.Ajax.request({
                                                                                            url: '../../controlador/inventario/controlador_inventario.php',
                                                                                            params:{
                                                                                                task: 'ADD_CONTEO_N',
                                                                                                pInventario: Ext.getCmp('sysIdConsecutivoInventario').getValue()
                                                                                            },
                                                                                            success: function(response,options)
                                                                                            {
                                                                                                var Respuesta = response.responseText;
                                                                                                var Contenido = Respuesta.split('^');
                                                                                                if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                                                    Ext.MessageBox.show({
                                                                                                        title: 'eOfiClinic',
                                                                                                        msg: 'Ocurrio un error al crear el conteo para este inventario.',
                                                                                                        buttons: Ext.MessageBox.OK,
                                                                                                        icon: Ext.MessageBox.ERROR
                                                                                                    });
                                                                                                } else {
                                                                                                    var wConteos = "N";
                                                                                                    if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) > 1){
                                                                                                        wConteos = "S";
                                                                                                    }
                                                                                                    CargarStoreDetalleInv(Ext.getCmp('sysIdConsecutivoInventario').getValue(),Ext.getCmp('sysFilterCodBarrasInv').getValue(),Ext.getCmp('sysFilterDesConceptoInv').getValue(),wConteos);
                                                                                                    Ext.MessageBox.show({
                                                                                                        title: 'Inventarios',
                                                                                                        msg: 'Se creó el Conteo Nro ' + Contenido[0] + ' para el inventario, por favor agregue los ítems que desee.',
                                                                                                        buttons: Ext.MessageBox.OK,
                                                                                                        icon: Ext.MessageBox.INFO
                                                                                                    });
                                                                                                    Ext.getCmp('sysConteoActualInventario').setValue(Contenido[0]);
                                                                                                    Ext.getCmp('sysEstadoCoteo').setValue("A");
                                                                                                }
                                                                                            },
                                                                                            failure: function(response,options){
                                                                                                Ext.MessageBox.show({
                                                                                                    title: 'Error Conexión',
                                                                                                    msg: 'No podemos realizar la accion del inventario y/o No se pudo establecer conexión con el servidor',
                                                                                                    buttons: Ext.MessageBox.OK,
                                                                                                    icon: Ext.MessageBox.ERROR
                                                                                                });
                                                                                            },
                                                                                            scope:this 
                                                                                        });
                                                                                    }
                                                                                }
                                                                            });
                                                                        }else{
                                                                            Ext.MessageBox.show({
                                                                                title: 'Inventarios',
                                                                                msg: 'Todos los conteos estan correctos, no necesita crear mas conteos para este inventario.<br><br>Por favor aplique los conteos para finalizar el proceso.',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.WARNING
                                                                            });
                                                                        }
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error Conexión',
                                                                        msg: 'No podemos realizar la accion del inventario y/o No se pudo establecer conexión con el servidor',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                },
                                                                scope:this 
                                                            });
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'Inventarios',
                                                                msg: 'El conteo actual esta abierto y no se puede realizar ninguna operacion.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }
                                                    }else{
                                                        Ext.MessageBox.show({
                                                            title: 'Inventarios',
                                                            msg: 'El inventario se encuentra Cerrado y no se puede realizar ninguna operacion.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                }
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Inventarios',
                                                    msg: 'Debe seleccionar un inventario.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Eliminar Conteo',
                                    iconCls: 'btnDelRow',
                                    tooltip: 'Eliminar Conteo',
                                    listeners: {
                                        click: function() {
                                            if(Ext.getCmp('sysIdConsecutivoInventario').getValue() !== 0 && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== "0" && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== null){
                                                if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) > 0 && Ext.getCmp('sysEstadoInventario').getValue() === "A" && Ext.getCmp('sysEstadoCoteo').getValue() === "A"){
                                                    Ext.Msg.show({
                                                        title: 'Inventarios',
                                                        msg: 'Esta seguro que desea eliminar el <span style="color:#3102EE;"><b>Conteo Nro: ' + parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) + '</b></span>, si hace esto se perdera toda la informacion ingresada para este conteo?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn){
                                                            if(btn === "yes"){
                                                                Ext.Ajax.request({
                                                                    url: '../../controlador/inventario/controlador_inventario.php',
                                                                    params:{
                                                                        task: 'DEL_CONTEO',
                                                                        pInventario: Ext.getCmp('sysIdConsecutivoInventario').getValue(),
                                                                        pConteo: parseInt(Ext.getCmp('sysConteoActualInventario').getValue())
                                                                    },
                                                                    success: function(response,options)
                                                                    {
                                                                        var Respuesta = response.responseText;
                                                                        var Contenido = Respuesta.split('^');
                                                                        if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                            Ext.MessageBox.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Ocurrio un error al eliminar el conteo para este inventario.',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        } else {
                                                                            CargarStoreDetalleInv();
                                                                            Ext.MessageBox.show({
                                                                                title: 'Inventarios',
                                                                                msg: 'Se elimino el conteo con exito. Por favor vuelva a seleccionar el inventario para para seguir con el proceso deseado.',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.INFO
                                                                            });
                                                                            LimpiarCamposINV();
                                                                            Ext.getCmp('treeHistiricoInventarios').root.reload();
                                                                        }
                                                                    },
                                                                    failure: function(response,options){
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error Conexión',
                                                                            msg: 'No podemos realizar la accion del inventario y/o No se pudo establecer conexión con el servidor',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    },
                                                                    scope:this 
                                                                });
                                                            }
                                                        }
                                                    });
                                                }else{
                                                    Ext.MessageBox.show({
                                                        title: 'Inventarios',
                                                        msg: 'El inventario se encuentra cerrado y/o el conteo no esta disponible para realizar esta operacion.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                }
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Inventarios',
                                                    msg: 'Debe seleccionar un inventario.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Cerrar Conteo',
                                    iconCls: 'btnCerrar',
                                    tooltip: 'Cerrar Conteo',
                                    listeners: {
                                        click: function() {
                                            if(Ext.getCmp('sysIdConsecutivoInventario').getValue() !== 0 && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== "0" && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== null && Ext.getCmp('sysEstadoInventario').getValue() === "A"){
                                                if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) > 0 && Ext.getCmp('sysEstadoCoteo').getValue() === "A"){
                                                    Ext.Msg.show({
                                                        title: 'Inventarios',
                                                        msg: 'Esta Seguro que Desea Cerrar el <span style="color:#3102EE;"><b>Conteo Nro: ' + parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) + '</b></span>, si hace esto se cerrara definitivamente y tendra que aplicar los conteos y/o abrir un conteo nuevo?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn){
                                                            if(btn === "yes"){
                                                                Ext.Ajax.request({
                                                                    url: '../../controlador/inventario/controlador_inventario.php',
                                                                    params:{
                                                                        task: 'CLOSE_CONTEO',
                                                                        pInventario: Ext.getCmp('sysIdConsecutivoInventario').getValue()
                                                                    },
                                                                    success: function(response,options)
                                                                    {
                                                                        var Respuesta = response.responseText;
                                                                        var Contenido = Respuesta.split('^');
                                                                        if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                            Ext.MessageBox.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Ocurrio un error al cerrar el conteo para este inventario.',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        } else {
                                                                            //CargarStoreDetalleInv();
                                                                            Ext.MessageBox.show({
                                                                                title: 'Inventarios',
                                                                                msg: 'Se Cerro el Conteo Nro ' + parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) + ', con exito',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.INFO
                                                                            });
                                                                            Ext.getCmp('sysEstadoCoteo').setValue("C");
                                                                        }
                                                                    },
                                                                    failure: function(response,options){
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error Conexión',
                                                                            msg: 'No podemos realizar la accion del inventario y/o No se pudo establecer conexión con el servidor',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    },
                                                                    scope:this 
                                                                });
                                                            }
                                                        }
                                                    });
                                                }else{
                                                    Ext.MessageBox.show({
                                                        title: 'Inventarios',
                                                        msg: 'El Conteo Nro. ' + parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) + ', ya esta cerrado.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                }
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Inventarios',
                                                    msg: 'Debe seleccionar un inventario.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                '->',
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Aplicar Conteos',
                                    iconCls: 'btnAceptar',
                                    tooltip: 'Aplicar Conteos al Inventario',
                                    listeners: {
                                        click: function() {
                                            if(Ext.getCmp('sysIdConsecutivoInventario').getValue() !== 0 && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== "0" && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== null){
                                                if((Ext.getCmp('sysConteoActualInventario').getValue() === 0 || Ext.getCmp('sysConteoActualInventario').getValue() === "0") && Ext.getCmp('sysEstadoInventario').getValue() === "A"){
                                                    Ext.Msg.show({
                                                        title: 'Inventarios',
                                                        msg: 'Esta Seguro que Desea Cerrar el Inventario Sin Conteos?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn){
                                                            if(btn === "yes"){
                                                                winCloseINV = new winCerrarInventarioUi();
                                                                Ext.getCmp('intIdInventarioCloseInv').setValue(Ext.getCmp('sysIdConsecutivoInventario').getValue());
                                                                Ext.getCmp('strTaskCloseInv').setValue('CLOSE_INVENTARIO_SINCONTEOS');
                                                                Ext.getCmp('sysBodegasCloseInv').setValue(Ext.getCmp('pn001Bodega').getValue());
                                                                Ext.getCmp('sysZonasCloseInv').setValue(Ext.getCmp('pn001Zona').getValue());
                                                                Ext.getCmp('sysTipoInventarioCloseInv').setValue(Ext.getCmp('pn001TipoInv').getValue());
                                                                Ext.getCmp('sysHoraAperturaAddInv').setValue(Ext.getCmp('pn001HoraInicio').getValue());
                                                                Ext.getCmp('sysActaAperturaCloseInv').setValue(Ext.getCmp('pn001ActaApertura').getValue());
                                                                winCloseINV.show();
                                                            }
                                                        }
                                                    });
                                                }else{
                                                    if(Ext.getCmp('sysEstadoInventario').getValue() === "A"){
                                                        if(Ext.getCmp('sysEstadoCoteo').getValue() === "C"){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/inventario/controlador_inventario.php',
                                                                params:{
                                                                    task: 'CHECK_CONTEO',
                                                                    pInventario: Ext.getCmp('sysIdConsecutivoInventario').getValue()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                        Ext.MessageBox.show({
                                                                            title: 'eOfiClinic',
                                                                            msg: 'Ocurrio un error al validar los conteos para este inventario.',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    } else {
                                                                        var wRegistros = parseInt(Contenido[0]);
                                                                        if(wRegistros === 0){
                                                                            Ext.Msg.show({
                                                                                title: 'Inventarios',
                                                                                msg: 'Esta Seguro que Desea Cerrar el Inventario?',
                                                                                buttons: Ext.Msg.YESNO,
                                                                                icon: Ext.Msg.QUESTION,
                                                                                fn: function(btn){
                                                                                    if(btn === "yes"){
                                                                                        winCloseINV = new winCerrarInventarioUi();
                                                                                        Ext.getCmp('intIdInventarioCloseInv').setValue(Ext.getCmp('sysIdConsecutivoInventario').getValue());
                                                                                        Ext.getCmp('strTaskCloseInv').setValue('CLOSE_INVENTARIO');
                                                                                        Ext.getCmp('sysBodegasCloseInv').setValue(Ext.getCmp('pn001Bodega').getValue());
                                                                                        Ext.getCmp('sysZonasCloseInv').setValue(Ext.getCmp('pn001Zona').getValue());
                                                                                        Ext.getCmp('sysTipoInventarioCloseInv').setValue(Ext.getCmp('pn001TipoInv').getValue());
                                                                                        Ext.getCmp('sysHoraAperturaAddInv').setValue(Ext.getCmp('pn001HoraInicio').getValue());
                                                                                        Ext.getCmp('sysActaAperturaCloseInv').setValue(Ext.getCmp('pn001ActaApertura').getValue());
                                                                                        winCloseINV.show();
                                                                                    }
                                                                                }
                                                                            });
                                                                        }else{
                                                                            Ext.MessageBox.show({
                                                                                title: 'Inventarios',
                                                                                msg: 'Existen Items que no coinciden en los conteos, por favor abra un nuevo conteo para continuar con el proceso.',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.WARNING
                                                                            });
                                                                        }
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error Conexión',
                                                                        msg: 'No podemos realizar la accion del inventario y/o No se pudo establecer conexión con el servidor',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                },
                                                                scope:this 
                                                            });
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'Inventarios',
                                                                msg: 'El conteo actual esta abierto y no se puede realizar ninguna operacion.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }
                                                    }else{
                                                        Ext.MessageBox.show({
                                                            title: 'Inventarios',
                                                            msg: 'El inventario se encuentra Cerrado y no se puede realizar ninguna operacion.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                }
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Inventarios',
                                                    msg: 'Debe seleccionar un inventario.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'grid',
                                layout: 'fit',
                                id: 'gridDetalleInventario',
                                store: stGridDetalleInventario,
                                anchor: "100%",
                                height: 430,
                                border: false,
                                frame: true,
                                loadMask: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        xtype: 'gridcolumn', //0
                                        header: 'Concepto',
                                        sortable: false,
                                        hideable: false,
                                        width: 390,
                                        dataIndex: 'DesProced',
                                        renderer: DescripcionConceptoMvto,
                                        id: 'DesProced'
                                    },
                                    {
                                        xtype: 'gridcolumn', //1
                                        header: 'Lote',
                                        sortable: false,
                                        hideable: false,
                                        width: 110,
                                        dataIndex: 'NroLote',
                                        id: 'NroLote'
                                    },
                                    {
                                        xtype: 'gridcolumn', //2
                                        header: 'Vencimiento',
                                        sortable: false,
                                        hideable: false,
                                        width: 110,
                                        dataIndex: 'FecVencimiento',
                                        id: 'FecVencimiento'
                                    },
                                    {
                                        xtype: 'gridcolumn', //3
                                        header: 'Cantidad',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'ConteoFinal',
                                        id: 'ConteoFinal'
                                    },
                                    {
                                        xtype: 'gridcolumn', //4
                                        header: 'Conteo Nro 1',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo1',
                                        id: 'Conteo1'
                                    },
                                    {
                                        xtype: 'gridcolumn', //5
                                        header: 'Conteo Nro 2',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo2',
                                        id: 'Conteo2'
                                    },
                                    {
                                        xtype: 'gridcolumn', //6
                                        header: 'Conteo Nro 3',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo3',
                                        id: 'Conteo3'
                                    },
                                    {
                                        xtype: 'gridcolumn', //7
                                        header: 'Conteo Nro 4',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo4',
                                        id: 'Conteo4'
                                    },
                                    {
                                        xtype: 'gridcolumn', //8
                                        header: 'Conteo Nro 5',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo5',
                                        id: 'Conteo5'
                                    },
                                    {
                                        xtype: 'gridcolumn', //9
                                        header: 'Conteo Nro 6',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo6',
                                        id: 'Conteo6'
                                    },
                                    {
                                        xtype: 'gridcolumn', //10
                                        header: 'Conteo Nro 7',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo7',
                                        id: 'Conteo7'
                                    },
                                    {
                                        xtype: 'gridcolumn', //11
                                        header: 'Conteo Nro 8',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo8',
                                        id: 'Conteo8'
                                    },
                                    {
                                        xtype: 'gridcolumn', //12
                                        header: 'Conteo Nro 9',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo9',
                                        id: 'Conteo9'
                                    },
                                    {
                                        xtype: 'gridcolumn', //13
                                        header: 'Conteo Nro 10',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo10',
                                        id: 'Conteo10'
                                    },
                                    {
                                        xtype: 'gridcolumn', //14
                                        header: 'Conteo Nro 11',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo11',
                                        id: 'Conteo11'
                                    },
                                    {
                                        xtype: 'gridcolumn', //15
                                        header: 'Conteo Nro 12',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo12',
                                        id: 'Conteo12'
                                    },
                                    {
                                        xtype: 'gridcolumn', //16
                                        header: 'Conteo Nro 13',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo13',
                                        id: 'Conteo13'
                                    },
                                    {
                                        xtype: 'gridcolumn', //17
                                        header: 'Conteo Nro 14',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo14',
                                        id: 'Conteo14'
                                    },
                                    {
                                        xtype: 'gridcolumn', //18
                                        header: 'Conteo Nro 15',
                                        sortable: false,
                                        hideable: false,
                                        hidden: true,
                                        width: 100,
                                        renderer: Ext.util.Format.numberRenderer("0,000"),//MostarCantidadInventario,
                                        align: 'right',
                                        dataIndex: 'Conteo15',
                                        id: 'Conteo15'
                                    }
                                ]),
                                stripeRows : true,
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                viewConfig: {
                                    getRowClass: function(record, rowIndex, rp, ds){
                                        if(Ext.getCmp('sysEstadoInventario').getValue() === "C"){
                                            return;
                                        }else{
                                            switch(record.get('ConteoRealizado')){
                                                case "1":
                                                    return 'Apto';
                                                    break;
                                                default:
                                                    return 'NoApto';
                                                    break;
                                            }
                                        }
                                    }
                                },
                                tbar: {
                                    anchor: '99%',
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Adicionar Item',
                                            iconCls: 'btnAddRow',
                                            tooltip: 'Adicionar Item',
                                            listeners: {
                                                click: function() {
                                                    if(Ext.getCmp('sysIdConsecutivoInventario').getValue() !== 0 && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== "0" && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== null){
                                                        if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) > 0 && Ext.getCmp('sysEstadoInventario').getValue() === "A" && Ext.getCmp('sysEstadoCoteo').getValue() === "A"){
                                                            if(Ext.getCmp('pn001TipoInv').setValue() !== "INVENTARIO CONTROL"){
                                                                var AddEditItem = new winAddEditItemConteoUi();
                                                                Ext.getCmp('intidInventarioItemConteo').setValue(Ext.getCmp('sysIdConsecutivoInventario').getValue());
                                                                Ext.getCmp('intidConteoItemConteo').setValue(Ext.getCmp('sysConteoActualInventario').getValue());
                                                                AddEditItem.show();
                                                                Ext.getCmp('sysFilterCodBarrasItemConteo').focus();
                                                            }else{
                                                                if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) === 1){
                                                                    var AddEditItem = new winAddEditItemConteoUi();
                                                                    Ext.getCmp('intidInventarioItemConteo').setValue(Ext.getCmp('sysIdConsecutivoInventario').getValue());
                                                                    Ext.getCmp('intidConteoItemConteo').setValue(Ext.getCmp('sysConteoActualInventario').getValue());
                                                                    AddEditItem.show();
                                                                    Ext.getCmp('sysFilterCodBarrasItemConteo').focus();
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Inventarios',
                                                                        msg: 'la opcion de adicionar item no esta disponible.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'Inventarios',
                                                                msg: 'la opcion de adicionar item no esta disponible.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }
                                                    }else{
                                                        Ext.MessageBox.show({
                                                            title: 'Inventarios',
                                                            msg: 'Debe seleccionar un inventario.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }    
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Modificar Item',
                                            iconCls: 'btnEditRow',
                                            tooltip: 'Modificar Item',
                                            listeners: {
                                                click: function() {
                                                    if(Ext.getCmp('sysIdConsecutivoInventario').getValue() !== 0 && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== "0" && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== null){
                                                        if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) > 0 && Ext.getCmp('sysEstadoInventario').getValue() === "A" && Ext.getCmp('sysEstadoCoteo').getValue() === "A"){
                                                            if(Ext.getCmp('gridDetalleInventario').selModel.getCount() === 1){
                                                                var selections = Ext.getCmp('gridDetalleInventario').selModel.getSelections();
                                                                var AddEditItem = new winAddEditItemConteoUi();
                                                                Ext.getCmp('intidConsecutivoItemConteo').setValue(selections[0].json.IdRegistroConteo);
                                                                Ext.getCmp('intidInventarioItemConteo').setValue(Ext.getCmp('sysIdConsecutivoInventario').getValue());
                                                                Ext.getCmp('intidConteoItemConteo').setValue(Ext.getCmp('sysConteoActualInventario').getValue());
                                                                if(selections[0].json.IdConceptoLoteVencimiento !== 0 && selections[0].json.IdConceptoLoteVencimiento !== "0" && selections[0].json.IdConceptoLoteVencimiento !== "" && selections[0].json.IdConceptoLoteVencimiento !== null){
                                                                    Ext.getCmp('intUsaLoteItemConteo').setValue(1);
                                                                    Ext.getCmp('intLoteConceptoItemConteo').setVisible(true);
                                                                    Ext.getCmp('intLoteConceptoItemConteo').allowBlank = false;
                                                                    Ext.getCmp('intLoteConceptoItemConteo').store.load({
                                                                        params:{
                                                                            pConcepto: selections[0].json.IdConcepto
                                                                        },
                                                                        callback: function(){
                                                                            Ext.getCmp('intLoteConceptoItemConteo').setValue(selections[0].json.IdConceptoLoteVencimiento);
                                                                        }
                                                                    });
                                                                }else{
                                                                    Ext.getCmp('intUsaLoteItemConteo').setValue(0);
                                                                    Ext.getCmp('intLoteConceptoItemConteo').setValue(null);
                                                                    Ext.getCmp('intLoteConceptoItemConteo').setVisible(false);
                                                                    Ext.getCmp('intLoteConceptoItemConteo').allowBlank = true;
                                                                }
                                                                Ext.getCmp('intidConceptoItemConteo').setValue(selections[0].json.IdConcepto);
                                                                Ext.getCmp('strCodConceptoItemConteo').setValue(selections[0].json.CodProced);
                                                                Ext.getCmp('strDesConceptoItemConteo').setValue(selections[0].json.DesProced);
                                                                //Ext.getCmp('intCantidadItemConteo').setValue(selections[0].json.ConteoFinal);
                                                                Ext.getCmp('intCantidadItemConteo').setValue(0);
                                                                Ext.getCmp('sysFilterCodBarrasItemConteo').setDisabled(true);
                                                                Ext.getCmp('btnSearchConceptoItemConteo').setDisabled(true);
                                                                 
                                                                AddEditItem.show();
                                                                Ext.getCmp('sysFilterCodBarrasItemConteo').focus();
                                                            }else{
                                                                Ext.MessageBox.show({
                                                                    title: 'Inventarios',
                                                                    msg: 'Debe seleccionar un item.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'Inventarios',
                                                                msg: 'la opcion de modificar item no esta disponible.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }
                                                    }else{
                                                        Ext.MessageBox.show({
                                                            title: 'Inventarios',
                                                            msg: 'Debe seleccionar un inventario.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        '->',
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Eliminar Item',
                                            iconCls: 'btnDelRow',
                                            tooltip: 'Eliminar Item',
                                            listeners: {
                                                click: function() {
                                                    if(Ext.getCmp('sysIdConsecutivoInventario').getValue() !== 0 && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== "0" && Ext.getCmp('sysIdConsecutivoInventario').getValue() !== null){
                                                        if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) === 1 && Ext.getCmp('sysEstadoInventario').getValue() === "A" && Ext.getCmp('sysEstadoCoteo').getValue() === "A"){
                                                            if(Ext.getCmp('gridDetalleInventario').selModel.getCount() === 1 && Ext.getCmp('pn001TipoInv').setValue() !== "INVENTARIO GENERAL"){
                                                                var selections = Ext.getCmp('gridDetalleInventario').selModel.getSelections();
                                                                Ext.Msg.show({
                                                                    title: 'Inventarios',
                                                                    msg: 'Esta Seguro que Desea Eliminar el Item: ' + selections[0].json.DesProced + '?',
                                                                    buttons: Ext.Msg.YESNO,
                                                                    icon: Ext.Msg.QUESTION,
                                                                    fn: function(btn){
                                                                        if(btn === "yes"){
                                                                            Ext.Ajax.request({
                                                                                url: '../../controlador/inventario/controlador_inventario.php',
                                                                                params:{
                                                                                    task: 'DEL_ITEM_CONTEO',
                                                                                    pItemConteo: selections[0].json.IdRegistroConteo
                                                                                },
                                                                                success: function(response,options)
                                                                                {
                                                                                    var Respuesta = response.responseText;
                                                                                    var Contenido = Respuesta.split('^');
                                                                                    if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                                        Ext.MessageBox.show({
                                                                                            title: 'eOfiClinic',
                                                                                            msg: 'Ocurrio un error al eliminar el item para este conteo.',
                                                                                            buttons: Ext.MessageBox.OK,
                                                                                            icon: Ext.MessageBox.ERROR
                                                                                        });
                                                                                    } else {
                                                                                        Ext.MessageBox.show({
                                                                                            title: 'Inventarios',
                                                                                            msg: 'Se elimino el item con exito.',
                                                                                            buttons: Ext.MessageBox.OK,
                                                                                            icon: Ext.MessageBox.INFO
                                                                                        });
                                                                                        var wConteos = "N";
                                                                                        if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) > 1){
                                                                                            wConteos = "S";
                                                                                        }
                                                                                        CargarStoreDetalleInv(Ext.getCmp('sysIdConsecutivoInventario').getValue(),"","",wConteos);
                                                                                    }
                                                                                },
                                                                                failure: function(response,options){
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'Error Conexión',
                                                                                        msg: 'No podemos realizar la accion del inventario y/o No se pudo establecer conexión con el servidor',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                },
                                                                                scope:this 
                                                                            });
                                                                        }
                                                                    }
                                                                });
                                                            }else{
                                                                Ext.MessageBox.show({
                                                                    title: 'Inventarios',
                                                                    msg: 'Debe seleccionar un item y/o el inventario no permite eliminar el item.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'Inventarios',
                                                                msg: 'la opcion de eliminar item no esta disponible.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }
                                                    }else{
                                                        Ext.MessageBox.show({
                                                            title: 'Inventarios',
                                                            msg: 'Debe seleccionar un inventario.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                bbar: new Ext.PagingToolbar({
                                    pageSize: 15,
                                    store: stGridDetalleInventario,
                                    displayInfo: true
                                })
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'panel',
                region: 'west',
                width: 250,
                items: [
                    {
                        xtype: 'treepanel',
                        id: 'treeHistiricoInventarios',
                        title: '<center>HISTORIAL INVENTARIO</center>',
                        rootVisible: false,
                        lines: false,
                        anchor: '100%',
                        autoHeight: true,
                        root: {
                            nodeType: 'async',
                            text: 'IPS',
                            id:'nodeROT-'
                        },
                        loader: LoaderTreeInventarios,
                        listeners: {
                            render: function() {
                                this.getRootNode().expand();
                            },
                            click : {
                                scope  : this,
                                fn     : function( n, e ) {
                                    if (!n.hasChildNodes()){
                                        LimpiarCamposINV();
                                        Ext.getCmp('sysEstadoInventario').setValue(n.attributes.estadoInventario);
                                        Ext.getCmp('sysIdConsecutivoInventario').setValue(n.attributes.idInventario);
                                        Ext.getCmp('sysConteoActualInventario').setValue(n.attributes.idConteo);
                                        Ext.getCmp('sysEstadoCoteo').setValue(n.attributes.estadoConteo);
                                        Ext.getCmp('pn001Bodega').setValue(PonerAcentosMayusculas(n.attributes.nomBodega));
                                        Ext.getCmp('pn001Zona').setValue(PonerAcentosMayusculas(n.attributes.nomZona));
                                        Ext.getCmp('pn001TipoInv').setValue(PonerAcentosMayusculas(n.attributes.tipoInventario));
                                        Ext.getCmp('pn001NroInv').setValue(PonerAcentosMayusculas(n.attributes.idInventario));
                                        Ext.getCmp('pn001FecInv').setValue(PonerAcentosMayusculas(n.attributes.fechaInventario));
                                        Ext.getCmp('pn001HoraInicio').setValue(PonerAcentosMayusculas(n.attributes.horaInicio));
                                        Ext.getCmp('pn001ActaApertura').setValue(PonerAcentosMayusculas(n.attributes.actaApertura));
                                        Ext.getCmp('pn001HoraCierre').setValue(PonerAcentosMayusculas(n.attributes.horaFin));
                                        Ext.getCmp('pn001ActaCierre').setValue(PonerAcentosMayusculas(n.attributes.actaCierre));
                                        Ext.getCmp('pn001MotivoAnulado').setValue(PonerAcentosMayusculas(n.attributes.motivoAnulado));
                                        //Ext.getCmp('pnInventario001').setVisible(true);
                                        //Ext.getCmp('pnInventario001').show(); 
                                        var wConteos = "N";
                                        if(parseInt(Ext.getCmp('sysConteoActualInventario').getValue()) > 1){
                                            wConteos = "S";
                                            if(Ext.getCmp('sysEstadoInventario').getValue() === "C"){
                                                wConteos = "N";
                                            }
                                        }
                                        CargarStoreDetalleInv(n.attributes.idInventario,Ext.getCmp('sysFilterCodBarrasInv').getValue(),Ext.getCmp('sysFilterDesConceptoInv').getValue(),wConteos);
                                    }else{
                                        if (n.isExpanded()){
                                            n.collapse();
                                            LimpiarCamposINV();
                                        }else{
                                            n.expand();
                                            LimpiarCamposINV();
                                        }
                                    }
                                }
                            }
                        }
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                //LimpiarCamposINV();
                //Ext.getCmp('pnInventario001').setVisible(false);
            }}
        });
        winFrmInventariosUi.superclass.initComponent.call(this);
    }
});

function LimpiarCamposINV(){
    Ext.getCmp('gridDetalleInventario').store.removeAll();
    //Ext.getCmp('pnInventario001').hide(); 
    //Ext.getCmp('pnInventario001').setVisible(false);
    Ext.getCmp('sysIdConsecutivoInventario').setValue(0);
    Ext.getCmp('sysEstadoInventario').setValue(null);
    Ext.getCmp('sysConteoActualInventario').setValue(null);
    Ext.getCmp('sysEstadoCoteo').setValue(null);
    
    Ext.getCmp('pn001Bodega').setValue(null);
    Ext.getCmp('pn001Zona').setValue(null);
    Ext.getCmp('pn001TipoInv').setValue(null);
    Ext.getCmp('pn001NroInv').setValue(null);
    Ext.getCmp('pn001FecInv').setValue(null);
    Ext.getCmp('pn001HoraInicio').setValue(null);
    Ext.getCmp('pn001ActaApertura').setValue(null);
    Ext.getCmp('pn001HoraCierre').setValue(null);
    Ext.getCmp('pn001ActaCierre').setValue(null);
    Ext.getCmp('pn001MotivoAnulado').setValue(null);
}

function CargarStoreDetalleInv(wInventario, wBarras, wDescripcion, wConteos){
    if(wConteos === "" || wConteos === null){
        wConteos = "N";
    }
    Ext.getCmp('gridDetalleInventario').store.load({
        params: {
            pInventario: wInventario,
            pDesConcepto: wDescripcion,
            pBarras: wBarras,
            pConteos: wConteos
        },
        callback: function(){
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(3, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(4, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(5, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(6, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(7, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(8, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(9, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(10, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(11, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(12, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(13, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(14, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(15, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(16, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(17, true);
            Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(18, true);
            if(Ext.getCmp('sysEstadoInventario').getValue() === "C"){
                Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(3, false);
            }else{
                switch(Ext.getCmp('sysConteoActualInventario').getValue()){
                    case "1":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(4, false);
                        break;
                    case "2":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(5, false);
                        break;
                    case "3":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(6, false);
                        break;
                    case "4":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(7, false);
                        break;
                    case "5":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(8, false);
                        break;
                    case "6":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(9, false);
                        break;
                    case "7":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(10, false);
                        break;
                    case "8":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(11, false);
                        break;
                    case "9":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(12, false);
                        break;
                    case "10":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(13, false);
                        break;
                    case "11":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(14, false);
                        break;
                    case "12":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(15, false);
                        break;
                    case "13":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(16, false);
                        break;
                    case "14":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(17, false);
                        break;
                    case "15":
                        Ext.getCmp('gridDetalleInventario').getColumnModel().setHidden(18, false);
                        break;
                    default:
                        break;
                }
            }
        }
    });
}