/*
* @category    Formulario Verificacion Listado de Atencion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

function verListadoAtencion(wPrestador, wSede, wIPS, wTdoc, wDoc, wActualiza, wPaciente, wPantalla)
{

    var HTML = "";
    var classbody = "";
    var winListadoAtencion;
    var Contenido;
    var ID_PACIENTE = wPaciente;
    if (wActualiza)
        switch (wPantalla)
        {
            case "Radicacion":
                Ext.getCmp('fPacienteValido').setValue(0);
                break;
            case "BarraServicios":
                Ext.getCmp('sysPacienteValido').setValue(0);
                break;
            default:
                break;
        }
        Ext.Ajax.request({
        url: '../../controlador/listadoatencion/verificalistadoatencion.php',
        params:{
            pPrestador: wPrestador,
            pSede: wSede,
            pIPS: wIPS,
            pTdoc: wTdoc,
            pDocumento: wDoc
        },
        success: function(response,options)
        {
            var el = Ext.get('response');
            var Respuesta = response.responseText;
            Contenido = Respuesta.split('^');
            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                Ext.Msg.show({
                    title: 'Verificación del Listado de Atención',
                    msg: 'El Paciente No Existe en el Listado de Atención',
                    buttons: Ext.Msg.OK,
                    icon: Ext.MessageBox.ERROR
                });
                switch (wPantalla)
                {
                    case "Radicacion":
                        Ext.getCmp('fClienteLA').setValue(0);
                        Ext.getCmp('fPlanLA').setValue(0);
                        Ext.getCmp('fSubPlanLA').setValue(0);
                        if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                            Ext.getCmp('fPacienteValido').setValue(1);
                        break;
                    case "BarraServicios":
                        Ext.getCmp('sysClienteLA').setValue(0);
                        Ext.getCmp('sysPlanLA').setValue(0);
                        Ext.getCmp('sysSubPlanLA').setValue(0);
                        if (Ext.getCmp('sysAtenderFueraListado').getValue() == 1)
                            Ext.getCmp('sysPacienteValido').setValue(1);
                        break;
                    default:
                        break;
                }
            } else{
                HTML = "<div class = \"fondoPanel\">";
                HTML += "<br/>";
                HTML += "<br/>";
                HTML += "<br/>";
                HTML += "<table border=\"0\" cellpadding=\"1\" cellspacing=\"1\" width=\"350\">";
                if (Contenido[6] == "no" || Contenido[6] == "No" )
                {
                    switch (wPantalla)
                    {
                        case "Radicacion":
                            Ext.getCmp('fEstado').setValue(3);
                            break;
                        case "BarraServicios":
                            Ext.getCmp('strEstado_citas').setValue(3);
                            break;
                        default:
                            break;
                    }
                    classbody = "usr_noactivo-image";
                    HTML += "<tr>";
                    HTML += "<td colspan=\"2\" class = \"USR_INACTIVO\">INACTIVO<td>";
                    HTML += "</tr>";
                } else {
                    switch (wPantalla)
                    {
                        case "Radicacion":
                            Ext.getCmp('fEstado').setValue(1);
                            break;
                        case "BarraServicios":
                            Ext.getCmp('strEstado_citas').setValue(1);
                            break;
                        default:
                            break;
                    }
                    classbody = "usr_activo-image"
                    HTML += "<tr>";
                    HTML += "<td colspan=\"2\" class = \"USR_ACTIVO\">ACTIVO<td>";
                    HTML += "</tr>";
                }
                HTML += "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
                HTML += "<tbody>";
                HTML += "<tr>";
                HTML += "<td class = \"TitFila_1\" width = \"130\">Documento:</td>";
                HTML += "<td class = \"DetFila_1\">" + Contenido[0] + " - " + Contenido[1] + "</td>";
                HTML += "</tr>";
                HTML += "<tr>";
                HTML += "<td class = \"TitFila_1\">Nombres:</td>";
                HTML += "<td class = \"DetFila_1\">" + Contenido[4] + " " + Contenido[5] + "</td>";
                HTML += "</tr>";
                HTML += "<tr>";
                HTML += "<td class = \"TitFila_1\">Apellidos:</td>";
                HTML += "<td class = \"DetFila_1\">" + Contenido[2] + " " + Contenido[3] + "</td>";
                HTML += "</tr>";
                HTML += "<tr>";
                HTML += "<td class = \"TitFila_1\">Tipo Afiliado:</td>";
                if (Contenido[7] == "C")
                    HTML += "<td class = \"DetFila_1\">Cotizante - <b style=\"color:darkblue;\">Rango [" + Contenido[8] + "]</b></td>";
                else
                    HTML += "<td class = \"DetFila_1\">Beneficiario(a) - <b style=\"color:darkblue;\">Rango [" + Contenido[8] + "]</b></td>";
                HTML += "</tr>";
                HTML += "<tr>";
                HTML += "<td class = \"TitFila_1\">Marca Especial:</td>";
                if (Contenido[14] == "t" || Contenido[14] == "T")
                    HTML += "<td class = \"DetFila_1_2\">PACIENTE TUTELA</td>";
                else
                    HTML += "<td class = \"DetFila_1\">Ninguna</td>";
                HTML += "</tr>";
                HTML += "</tr><tr><td>&nbsp;</td><td>&nbsp;</td></tr>";
                HTML += "<tr>";
                HTML += "<td class = \"TitFila_1\">Cliente:</td>";
                HTML += "<td class = \"DetFila_1\">" + Contenido[18] + "</td>";
                HTML += "</tr>";
                HTML += "<tr>";
                HTML += "<td class = \"TitFila_1\">Plan:</td>";
                HTML += "<td class = \"DetFila_1\">" + Contenido[19] + "</td>";
                HTML += "</tr>";
                HTML += "<tr>";
                HTML += "<td class = \"TitFila_1\">SubPlan:</td>";
                HTML += "<td class = \"DetFila_1\">" + Contenido[20] + "</td>";
                HTML += "</tr>";
                HTML += "</tbody>";
                HTML += "</table>";
                HTML += "</div>";
                switch (wPantalla)
                {
                    case "Radicacion":
                        Ext.getCmp('fPacienteValido').setValue(1);
                        break;
                    case "BarraServicios":
                        Ext.getCmp('sysPacienteValido').setValue(1);
                        break;
                    default:
                        break;
                }
                winListadoAtencion = new Ext.Window({
                    title: 'eOfiClinic ©      .:: Verificación en Listado de Atención ::.',
                    width: 550,
                    height: 350,
                    closable: false,
                    modal: true,
                    resizable: false,
                    draggable: false,
                    id: 'winListadoAtencion',
                    defaults: { border: false },
                    bodyCssClass: classbody,
                    items: {
                        html: HTML,border: false}
                    ,
                    bbar: ['->',btnSalir]
                });
                winListadoAtencion.show();
            }
        },failure: function(response,options){
                Ext.Msg.show({
                    title: 'Verificación del Listado de Atención',
                    msg: 'Error del sistema, por favor comuniquese con el proveedor del software!',
                    buttons: Ext.Msg.OK,
                    icon: Ext.MessageBox.ERROR
                });
        },
        scope:this 
    });


    var btnSalir = new Ext.Button({
        id: 'btnSalir',
        text: 'Salir',
        iconCls: 'btnSalir',
        minWidth: 80,
        handler:function(){
            winListadoAtencion.close();
            if (wActualiza)
            {
                switch (wPantalla)
                {
                    case "Radicacion":
                        Ext.getCmp('fCliente').clearValue();
                        Ext.getCmp('fPlan').clearValue();
                        Ext.getCmp('fSubPlan').clearValue();
                        break;
                    case "BarraServicios":
                        Ext.getCmp('sysCliente').clearValue();
                        Ext.getCmp('sysPlan').clearValue();
                        Ext.getCmp('sysSubPlan').clearValue();
                        break;
                    default:
                        break;
                }
                if (ID_PACIENTE == 0)
                {
                    switch (wPantalla)
                    {
                        case "Radicacion":
                            Ext.getCmp('fTdoc').setValue(Contenido[0]);
                            Ext.getCmp('fDocID').setValue(Contenido[1]);
                            Ext.getCmp('fGenero').setValue(Contenido[10]);
                            Ext.getCmp('fApe1').setValue(Contenido[2]);
                            Ext.getCmp('fApe2').setValue(Contenido[3]);
                            Ext.getCmp('fNom1').setValue(Contenido[4]);
                            Ext.getCmp('fNom2').setValue(Contenido[5]);
                            Ext.getCmp('fDeptoMuni').setValue(Contenido[21]);
                            Ext.getCmp('fDireccion').setValue(Contenido[12]);
                            Ext.getCmp('fTel1').setValue(Contenido[11]);
                            var xfecnac = Contenido[9].split('-');
                            var dianac = xfecnac[0];
                            var mesnac = (xfecnac[1].length < 2)?'0':'';
                            mesnac += xfecnac[1];
                            var anonac = xfecnac[2];
                            Ext.getCmp('fFecNac').setValue(dianac + "-" + mesnac + "-" + anonac);
                            Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fFecNac').getValue().format('Y/m/d')));
                            break;
                        case "BarraServicios":
                            Ext.getCmp('strTdoc_citas').setValue(Contenido[0]);
                            Ext.getCmp('strdocpac_citas').setValue(Contenido[1]);
                            Ext.getCmp('strgenero_citas').setValue(Contenido[10]);
                            Ext.getCmp('strApe1_citas').setValue(Contenido[2]);
                            Ext.getCmp('strApe2_citas').setValue(Contenido[3]);
                            Ext.getCmp('strNom1_citas').setValue(Contenido[4]);
                            Ext.getCmp('strNom2_citas').setValue(Contenido[5]);
                            Ext.getCmp('strDeptoMuni_citas').setValue(Contenido[21]);
                            Ext.getCmp('strDireccion_citas').setValue(Contenido[12]);
                            Ext.getCmp('strTel1_citas').setValue(Contenido[11]);
                            var xfecnac = Contenido[9].split('-');
                            var dianac = xfecnac[0];
                            var mesnac = (xfecnac[1].length < 2)?'0':'';
                            mesnac += xfecnac[1];
                            var anonac = xfecnac[2];
                            Ext.getCmp('fecFecNac_citas').setValue(dianac + "-" + mesnac + "-" + anonac);
                            Ext.getCmp('strEdad_citas').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fecFecNac_citas').getValue().format('Y/m/d')));
                            break;
                        case "RadicarCitasEsp":
                            Ext.getCmp('strTdoc').setValue(Contenido[0]);
                            Ext.getCmp('strGenero').setValue(Contenido[10]);
                            Ext.getCmp('strApe1').setValue(Contenido[2]);
                            Ext.getCmp('strApe2').setValue(Contenido[3]);
                            Ext.getCmp('strNom1').setValue(Contenido[4]);
                            Ext.getCmp('strNom2').setValue(Contenido[5]);
                            Ext.getCmp('strDeptoMuni').setValue(Contenido[21]);
                            Ext.getCmp('strDireccion').setValue(Contenido[12]);
                            //Ext.getCmp('strTel1').setValue(Contenido[11]);
                            var xfecnac = Contenido[9].split('-');
                            var dianac = xfecnac[0];
                            var mesnac = (xfecnac[1].length < 2)?'0':'';
                            mesnac += xfecnac[1];
                            var anonac = xfecnac[2];
                            Ext.getCmp('fecFecNac').setValue(dianac + "-" + mesnac + "-" + anonac);
                            Ext.getCmp('strEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fecFecNac').getValue().format('Y/m/d')));
                            break;
                        default:
                            break;
                    }
                }
                switch (wPantalla)
                {
                    case "Radicacion":
                        Ext.getCmp('fTafiliado').setValue(Contenido[7]);
                        if (Contenido[7] != "C" && Contenido[7] != "N"){
                            Ext.getCmp('fParentesco').enable();
                            Ext.getCmp('fParentesco').allowBlank = false;
                        }else{
                            Ext.getCmp('fParentesco').clearValue();
                            Ext.getCmp('fParentesco').clearInvalid();
                            Ext.getCmp('fParentesco').allowBlank = true;
                            Ext.getCmp('fParentesco').disable();
                        }
                        Ext.getCmp('fRango').setValue(Contenido[8]);
                        if(Contenido[6] == "Si")
                            Ext.getCmp('fEstado').setValue(1);
                        else
                            Ext.getCmp('fEstado').setValue(3);
                        //var stcliente = Ext.getCmp('fCliente').store;
                        //stcliente.load({
                        ///    params: {
                        //        'pEmpresa': wPrestador,
                        //        'pSede': wSede,
                        //        'pCliente': Contenido[15]
                        //    }
                        //});
                        //Ext.getCmp('fClienteLA').setValue(Contenido[15]);
                        //if(Contenido[16] != "" || Contenido[16] != null)
                        //{
                        //    Ext.getCmp('fPlan').store.load({
                        //        params: {
                        //            'pCliente': Contenido[15],
                        //            'pPlan': Contenido[16]
                        //        }
                        //    });
                        //    Ext.getCmp('fPlanLA').setValue(Contenido[16]);

                        //}
                        //if(Contenido[17] != "" && Contenido[17] != null)
                        //{
                        //    Ext.getCmp('fSubPlan').store.load({
                        //        params: {
                        //            'pPlan': Contenido[16],
                        //            'pSubPlan': Contenido[17]
                        //        }
                        //    });
                        //    Ext.getCmp('fSubPlanLA').setValue(Contenido[17]);
                        //}
                        Ext.getCmp('fExento').setValue(Contenido[13]);
                        Ext.getCmp('fTutela').setValue(Contenido[14]);
                        break;
                    case "BarraServicios":
                        Ext.getCmp('strTafiliado_citas').setValue(Contenido[7]);
                        if (Contenido[7] != "C" && Contenido[7] != "N"){
                            Ext.getCmp('strParentesco_citas').enable();
                            Ext.getCmp('strParentesco_citas').allowBlank = false;
                        }else{
                            Ext.getCmp('strParentesco_citas').clearValue();
                            Ext.getCmp('strParentesco_citas').clearInvalid();
                            Ext.getCmp('strParentesco_citas').allowBlank = true;
                            Ext.getCmp('strParentesco_citas').disable();
                        }
                        Ext.getCmp('strRango_citas').setValue(Contenido[8]);
                        if(Contenido[6] == "Si")
                            Ext.getCmp('strRango_citas').setValue(1);
                        else
                            Ext.getCmp('strEstado_citas').setValue(3);
                        var stcliente = Ext.getCmp('sysCliente').store;
                        stcliente.load({
                            params: {
                                'pEmpresa': wPrestador,
                                'pSede': wSede,
                                'pCliente': Contenido[15]
                            }
                        });
                        /*Ext.getCmp('sysClienteLA').setValue(Contenido[15]);
                        if(Contenido[16] != "" || Contenido[16] != null)
                        {
                            Ext.getCmp('sysPlan').store.load({
                                params: {
                                    'pCliente': Contenido[15],
                                    'pPlan': Contenido[16]
                                }
                            });
                            Ext.getCmp('sysPlanLA').setValue(Contenido[16]);

                        }
                        if(Contenido[17] != "" && Contenido[17] != null)
                        {
                            Ext.getCmp('sysSubPlan').store.load({
                                params: {
                                    'pPlan': Contenido[16],
                                    'pSubPlan': Contenido[17]
                                }
                            });
                            Ext.getCmp('sysSubPlanLA').setValue(Contenido[17]);
                        }*/
                        Ext.getCmp('sysExento').setValue(Contenido[13]);
                        Ext.getCmp('sysTutela').setValue(Contenido[14]);
                        break;
                    default:
                        break;
                }
                
            }
            switch (wPantalla)
            {
                case "Radicacion":
                    Ext.getCmp('fRango').setValue(Contenido[8]);
                    break;
                case "BarraServicios":
                    Ext.getCmp('strRango_citas').setValue(Contenido[8]);
                    break;
                default:
                    break;
            }
        }
    });
}
