/*
* @category    Modelo LogOn Sistema
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


Ext.ns('com.oficlinic');
Ext.BLANK_IMAGE_URL = "../lib/extjs/resources/images/default/s.gif";
Ext.SSL_SECURE_URL = "../lib/extjs/resources/images/default/s.gif";
com.oficlinic.frmLogOn = {
	init:function(){
                var AltoPantalla = screen.height;
                if(AltoPantalla > 768){
                    AltoPantalla = ((screen.height - 215)/2)-60;
                }else{
                    AltoPantalla = ((screen.height - 105)/2);
                }
                Ext.QuickTips.init();
                Ext.form.Field.prototype.msgTarget = 'side';
                var dsEmpresa = new Ext.data.JsonStore({
                    proxy: new Ext.data.HttpProxy ({
                        url: 'controlador/combobox/cbempresa.php',
                        method: 'POST'
                    }),
                    id: 'dsEmpresaJsonStore',
                    idProperty: 'Codigo',
                    root: 'rows',
                    fields:[
                       {name: 'Codigo'},
                       {name: 'Descripcion'},
                       {name: 'TipoDocumento'},
                       {name: 'Documento'},
                       {name: 'Especialidad'},
                       {name: 'ciudad'},
                       {name: 'Direccion'},
                       {name: 'Telefono'},
                       {name: 'Regimen'},
                       {name: 'Contribuyentes'},
                       {name: 'RetenedoresICA'},
                       {name: 'RetenedoresIVA'},
                       {name: 'EsLabAnatomopatologia'},
                       {name: 'EsLabClinico'},
                       {name: 'codMultiprestador'},
                       {name: 'ImprimeMCTirilla'},
                       {name: 'ImprimeRCTirilla'},
                       {name: 'ImprimeFVPARTTirilla'},
                       {name: 'ImprimeOrdenamientosTirilla'},
                       {name: 'ImprimeFacPacienteMediaCarta'}
                    ]
                });
                dsEmpresa.load();
                var dsClienteSedeStore=new Ext.data.JsonStore({
                        url: 'controlador/combobox/cbsedexempresa.php',
                        root: 'rows',
                        fields: ['Codigo', 'Descripcion']
                });
                var dsIpsSedeStore=new Ext.data.JsonStore({
                        url: 'controlador/combobox/cbipsxsedexempresa.php',
                        root: 'rows',
                        fields: ['Codigo', 'Descripcion']
                });
                var cbEmpresa = new Ext.form.ComboBox({
                    id: 'fEmpresa',
                    name: 'fEmpresa',
                    hiddenName: 'vEmpresa',
                    forceSelection: true,
                    triggerAction: 'all',
                    allowBlank: false,
                    fieldLabel: 'Empresa',
                    store: dsEmpresa,
                    loadingText: 'Cargando Empresas...!',
                    valueField: 'Codigo',
                    displayField: 'Descripcion',
                    emptyText: 'Seleccione una Empresa',
                    width: 330,
                    mode: 'local',
                    listeners:
                    {
                        'select': function(cmb, rec, idx) {
                            cbSede.clearValue();
                            cbSede.store.load({
                                params: { 'pEmpresa': this.getValue() }
                            });
                            Ext.getCmp('pEmpresaTdoc').setValue(rec.data.TipoDocumento);
                            Ext.getCmp('pEmpresaDoc').setValue(rec.data.Documento);
                            Ext.getCmp('pEmpresaDir').setValue(rec.data.Direccion);
                            Ext.getCmp('pEmpresaTel').setValue(rec.data.Telefono);
                            Ext.getCmp('pEmpresaCiu').setValue(rec.data.ciudad);
                            Ext.getCmp('pEmpresaEsp').setValue(rec.data.Especialidad);
                            Ext.getCmp('pEmpresaRegimen').setValue(rec.data.Regimen);
                            Ext.getCmp('pEmpresaContribuyente').setValue(rec.data.Contribuyentes);
                            Ext.getCmp('pEmpresaReteICA').setValue(rec.data.RetenedoresICA);
                            Ext.getCmp('pEmpresaReteIVA').setValue(rec.data.RetenedoresIVA);
                            Ext.getCmp('pEsLabAnatomopatologia').setValue(rec.data.EsLabAnatomopatologia);
                            Ext.getCmp('pEsLabClinico').setValue(rec.data.EsLabClinico);
                            Ext.getCmp('pcodMultiprestador').setValue(rec.data.codMultiprestador);
                            Ext.getCmp('pImprimeMCTirilla').setValue(rec.data.ImprimeMCTirilla);
                            Ext.getCmp('pImprimeRCTirilla').setValue(rec.data.ImprimeRCTirilla);
                            Ext.getCmp('pImprimeFVPARTTirilla').setValue(rec.data.ImprimeFVPARTTirilla);
                            Ext.getCmp('pImprimeOrdenamientosTirilla').setValue(rec.data.ImprimeOrdenamientosTirilla);
                            Ext.getCmp('pImprimeFacPacienteMediaCarta').setValue(rec.data.ImprimeFacPacienteMediaCarta);
                            cbSede.enable();
                        }
                    }
                });
                var cbSede = new Ext.form.ComboBox({
                    id: 'fSede',
                    name: 'fSede',
                    hiddenName: 'vSede',
                    forceSelection: true,
                    triggerAction: 'all',
                    allowBlank: false,
                    fieldLabel: 'Sede',
                    store: dsClienteSedeStore,
                    loadingText: 'Cargando Sedes del Cliente...!',
                    valueField: 'Codigo',
                    displayField: 'Descripcion',
                    emptyText: 'Seleccione una Sede',
                    width: 330,
                    mode: 'local',
                    listeners:
                    {
                        'select': function(cmb, rec, idx) {
                            cbIps.clearValue();
                            cbIps.store.load({
                                params: { 'pSede': this.getValue() }
                            });
                            cbIps.enable();
                        }
                    }
                });
                var cbIps = new Ext.form.ComboBox({
                    id: 'fIps',
                    name: 'fIps',
                    hiddenName: 'vIps',
                    forceSelection: true,
                    triggerAction: 'all',
                    allowBlank: false,
                    fieldLabel: 'IPS',
                    store: dsIpsSedeStore,
                    loadingText: 'Cargando IPS de la Empresa y Sede...!',
                    valueField: 'Codigo',
                    displayField: 'Descripcion',
                    emptyText: 'Seleccione una IPS',
                    width: 330,
                    mode: 'local'
                });
                
		LoginWindow = function (config) {
			this.id = 'main';
			this.name = 'main';
			this.width = 500;
			this.height = 215;
			this.loadMask = true,
			this.closable  = false;
                        this.resizable  = false;
			this.title = "Inicio de Sesión..! ";
			Ext.apply(this,config);
			LoginWindow.superclass.constructor.call(this);
		}
		Ext.extend(LoginWindow,Ext.Window,{
                        x: (screen.width - 500)/2,
                        y: AltoPantalla,
                        draggable: false,
			onActionComplete : function (f, a){
                            if(a && a.result && a.result.success){
                                Ext.Ajax.request(
                                {
                                    url: '../app/controlador/agendas/controlador_asignarcitas.php',
                                    params:{
                                        task: "AGENDAS_DESBLOQUEAR",
                                        pUsuario: a.result.pUsuario,
                                        pIPS: a.result.pIPS
                                    },
                                    scope:this
                                });
                                this.close();
                                location.href='frm/frmPrincipal.php';
                            }
			},
			onActionFailed : function(f,a){
                            var form = this.loginPanel.getForm();
                            Ext.Msg.show(
                            {  
                                title: 'Verificacion del Usuario..!',
                                msg: a.result.errors.msg, 
                                buttons: Ext.Msg.OK, 
                                icon: Ext.Msg.ERROR 
                            });  
			},
			initComponent : function () {
				this.submitUrl = "func/validarusuario.php";
				this.loginPanel = new Ext.form.FormPanel({
					frame:true,
					height: 100,
					region : 'center',
					id: 'loginpanel',
					baseParams : {
						task : 'login'
					},
					bodyStyle:'padding:10px',
					buttons : [
						{
							text : 'Aceptar',
							handler: onSubmit
						}
					],items: [
                                        cbEmpresa,
                                        cbSede,
                                        cbIps,
                                        {
						fieldLabel: 'Usuario ',
						name: 'user',
						xtype : 'textfield',
						allowBlank: false, 
						emptyText: 'ID Usuario...!',
						width: 160
					},{
						fieldLabel: 'Contraseña ',
						name: 'code',
						xtype : 'textfield',
						inputType: 'password',
						allowBlank: false,
						emptyText: 'Contraseña',
						width: 160
					},{
                                                xtype : 'hidden',
						name: 'pEmpresaTdoc',
                                                id: 'pEmpresaTdoc'
                                        },{
                                                xtype : 'hidden',
						name: 'pEmpresaDoc',
                                                id: 'pEmpresaDoc'
                                        },{
                                                xtype : 'hidden',
						name: 'pEmpresaDir',
                                                id: 'pEmpresaDir'
                                        },{
                                                xtype : 'hidden',
						name: 'pEmpresaTel',
                                                id: 'pEmpresaTel'
                                        },{
                                                xtype : 'hidden',
						name: 'pEmpresaCiu',
                                                id: 'pEmpresaCiu'
                                        },{
                                                xtype : 'hidden',
						name: 'pEmpresaEsp',
                                                id: 'pEmpresaEsp'
                                        },{
                                                xtype : 'hidden',
						name: 'pEmpresaRegimen',
                                                id: 'pEmpresaRegimen'
                                        },{
                                                xtype : 'hidden',
						name: 'pEmpresaContribuyente',
                                                id: 'pEmpresaContribuyente'
                                        },{
                                                xtype : 'hidden',
						name: 'pEmpresaReteICA',
                                                id: 'pEmpresaReteICA'
                                        },{
                                                xtype : 'hidden',
						name: 'pEmpresaReteIVA',
                                                id: 'pEmpresaReteIVA'
                                        },{
                                                xtype : 'hidden',
						name: 'pEsLabAnatomopatologia',
                                                id: 'pEsLabAnatomopatologia'
                                        },{
                                                xtype : 'hidden',
						name: 'pEsLabClinico',
                                                id: 'pEsLabClinico'
                                        },{
                                                xtype : 'hidden',
						name: 'pcodMultiprestador',
                                                id: 'pcodMultiprestador'
                                        },{
                                                xtype : 'hidden',
						name: 'pImprimeMCTirilla',
                                                id: 'pImprimeMCTirilla'
                                        },{
                                                xtype : 'hidden',
						name: 'pImprimeRCTirilla',
                                                id: 'pImprimeRCTirilla'
                                        },{
                                                xtype : 'hidden',
						name: 'pImprimeFVPARTTirilla',
                                                id: 'pImprimeFVPARTTirilla'
                                        },{
                                                xtype : 'hidden',
						name: 'pImprimeOrdenamientosTirilla',
                                                id: 'pImprimeOrdenamientosTirilla'
                                        },{
                                                xtype : 'hidden',
						name: 'pImprimeFacPacienteMediaCarta',
                                                id: 'pImprimeFacPacienteMediaCarta'
                                        }],
					listeners: {
						'actioncomplete': {
							fn: this.onActionComplete,
							scope: this
						},
						'actionfailed': {
							fn: this.onActionFailed,
							scope: this
						}
					},
					url: this.submitUrl
				});		
				var form = this.loginPanel.getForm();
				function onSubmit() {
                                    form.submit({
                                        reset : true
                                    });
				};
				this.layout = "border";
				this.items = [this.loginPanel];
				LoginWindow.superclass.initComponent.call(this);
			}
		});
		var loginwindow = new LoginWindow();
		loginwindow.show();
	}
};
Ext.onReady(com.oficlinic.frmLogOn.init,com.oficlinic.frmLogOn);
