/*
* @category    Modelo LogOn Sistema
* @package     OfiClinic Web
* @author      Jorge Ancizar GAleano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.desarrollo@ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

Ext.ns('com.oficlinic.auditor');
Ext.BLANK_IMAGE_URL = "../lib/extjs/resources/images/default/s.gif";
Ext.SSL_SECURE_URL = "../lib/extjs/resources/images/default/s.gif";
com.oficlinic.auditor.frmLogOn = {
	init:function(){
                Ext.QuickTips.init();
                Ext.form.Field.prototype.msgTarget = 'side';
                //***************************************************************************
                // Creacion de Data JSON
                //***************************************************************************
                var dsEmpresa = new Ext.data.JsonStore({
                    proxy: new Ext.data.HttpProxy ({
                        url: 'controlador/empresa.php',
                        method: 'POST'
                    }),
                    id: 'dsEmpresaJsonStore',
                    idProperty: 'Codigo',
                    root: 'rows',
                    fields:[
                       {name: 'Codigo'},
                       {name: 'Descripcion'}
                    ]
                });
                dsEmpresa.load();

                var dsCliente = new Ext.data.JsonStore({
                    url: 'controlador/empresa_cliente.php',
                    root: 'rows',
                    fields: ['Codigo', 'Descripcion']
                });

                var dsClienteSedeStore=new Ext.data.JsonStore({
                        url: 'controlador/empresa_cliente_sede.php',
                        root: 'rows',
                        fields: ['Codigo', 'Descripcion']
                });

                var cbEmpresa = new Ext.form.ComboBox({
                    id: 'fEmpresa',
                    name: 'fEmpresa',
                    hiddenName: 'vEmpresa',
                    forceSelection: true,
                    triggerAction: 'all',
                    allowBlank: false,
                    fieldLabel: 'Empresa',
                    store: dsEmpresa,
                    loadingText: 'Cargando Empresas...!',
                    valueField: 'Codigo',
                    displayField: 'Descripcion',
                    emptyText: 'Seleccione una Empresa',
                    width: 330,
                    mode: 'local',
                    listeners:
                    {
                        'select': function(cmb, rec, idx) {
                            cbCliente.clearValue();
                            cbSede.clearValue();
                            cbCliente.store.load({
                                params: { 'pEmpresa': this.getValue() }
                            });
                            cbCliente.enable();
                        }
                    }
                });

                var cbCliente = new Ext.form.ComboBox({
                    id: 'fCliente',
                    name: 'fCliente',
                    hiddenName: 'vCliente',
                    forceSelection: true,
                    triggerAction: 'all',
                    allowBlank: false,
                    fieldLabel: 'Cliente',
                    store: dsCliente,
                    loadingText: 'Cargando Clientes...!',
                    valueField: 'Codigo',
                    displayField: 'Descripcion',
                    emptyText: 'Seleccione un Cliente',
                    width: 330,
                    mode: 'local',
                    listeners:
                    {
                        'select': function(cmb, rec, idx) {
                            cbSede.clearValue();
                            cbSede.store.load({
                                params: { 'pCliente': this.getValue() }
                            });
                            cbSede.enable();
                        }
                    }
                });

                var cbSede = new Ext.form.ComboBox({
                    id: 'fSede',
                    name: 'fSede',
                    hiddenName: 'vSede',
                    forceSelection: true,
                    triggerAction: 'all',
                    allowBlank: false,
                    fieldLabel: 'Sede',
                    store: dsClienteSedeStore,
                    loadingText: 'Cargando Sedes del Cliente...!',
                    valueField: 'Codigo',
                    displayField: 'Descripcion',
                    emptyText: 'Seleccione una Sede',
                    width: 330,
                    mode: 'local'
                });

		LoginWindow = function (config) {
			this.id = 'main';
			this.name = 'main';
			this.width = 500;
			this.height = 215;
			this.loadMask = true,
			this.closable  = false;
                        this.resizable  = false;
			this.title = "Inicio de Sesión..!";
			Ext.apply(this,config);
			LoginWindow.superclass.constructor.call(this);
		}

		Ext.extend(LoginWindow,Ext.Window,{
			onActionComplete : function (f, a){
				if(a && a.result && a.result.success){
					this.close();
					location.href='frm/frmPrincipal.php';
				}
			},
			
			onActionFailed : function(f,a){
				var form = this.loginPanel.getForm();
				Ext.Msg.show(
				{  
					title: 'Verificacion del Usuario..!', //<- el t�tulo del di�logo
					msg: a.result.errors.msg, //<- El mensaje  
					buttons: Ext.Msg.OK, //<- Botones OK
					icon: Ext.Msg.ERROR // <- un �cono de error  
				});  
				//alert(a.result.errors.msg);
				//Do Action when Login Failed
			},
			initComponent : function () {
				this.submitUrl = "controlador/validarusuario.php";
				this.loginPanel = new Ext.form.FormPanel({
					frame:true,
					height: 100,
					region : 'center',
					id: 'loginpanel',
					baseParams : {
						task : 'login'
					},
					bodyStyle:'padding:10px',
					buttons : [
						{
							text : 'Aceptar',
							handler: onSubmit
						}
					],items: [
                                        cbEmpresa,
                                        cbCliente,
                                        cbSede,
                                        {
						fieldLabel: 'Usuario ',
						name: 'user',
						xtype : 'textfield',
						allowBlank: false, 
						emptyText: 'ID Usuario...!',
						width: 160
					},{
						fieldLabel: 'Contraseña ',
						name: 'code',
						xtype : 'textfield',
						inputType: 'password',
						allowBlank: false,
						emptyText: 'Contraseña',
						width: 160
					}],
					listeners: {
						'actioncomplete': {
							fn: this.onActionComplete,
							scope: this
						},
						'actionfailed': {
							fn: this.onActionFailed,
							scope: this
						}
					},
					url: this.submitUrl
				});		
				
				var form = this.loginPanel.getForm();
				function onSubmit() {
					form.submit({
						reset : true
					});
				};
		
				this.layout = "border";
				this.items = [this.loginPanel];
				LoginWindow.superclass.initComponent.call(this);
			}
		});
		var loginwindow = new LoginWindow();
		loginwindow.show();
	}
};

Ext.onReady(com.oficlinic.auditor.frmLogOn.init,com.oficlinic.auditor.frmLogOn);
