/*
* @category    Formulario Grid Manual Tarifario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmManualTarifarioUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Matriz Tarifas ::.',
    id: 'winFrmManualTarifario',
    closable:false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    layout: 'form',
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
               
        function renderEstado(value, p, record){
            switch (value){
                case "0":
                    return 'Negado';
                    break;
                default:
                    break;
            }
        }

        function DescripcionConcepto(val, x, store){
            var html = '<table><tr><td>'+val+'</td></tr></table>';
            return html;
        }
        
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };
        
        var st = new StoreGridManualTarifario();
        st.load();
        var stGridConcepto = new StoreGridConceptosxManual();
        
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'combo',
                fieldLabel: 'Cliente',
                anchor: '100%',
                allowBlank: false,
                store: 'StoreCliente',
                typeAhead: true,
                typeAheadDelay: 50,
                valueField: 'Codigo',
                displayField: 'Descripcion',
                emptyText: 'Seleccione Cliente....',
                mode: 'local',
                triggerAction: 'all',
                forceSelection: true,
                id: 'sysIdCliente',
                listeners: {
                    select: function(cmb, rec, idx) {
                        if(cmb.getValue() == null || cmb.getValue() == ""){
                            Ext.getCmp('sysIdPlan').store.removeAll(true);
                            Ext.getCmp('sysIdSubPlan').store.removeAll(true);
                            Ext.getCmp('sysIdPlan').setValue(null);
                            Ext.getCmp('sysIdSubPlan').setValue(null);
                            Ext.getCmp('sysIdPlan').disable();
                            Ext.getCmp('sysIdSubPlan').disable();

                        }else{
                            Ext.getCmp('sysIdPlan').store.removeAll(true);
                            Ext.getCmp('sysIdSubPlan').store.removeAll(true);
                            Ext.getCmp('sysIdPlan').setValue(null);
                            Ext.getCmp('sysIdSubPlan').setValue(null);
                            Ext.getCmp('sysIdSubPlan').disable();
                            Ext.getCmp('sysIdPlan').store.load({
                                params:{
                                    pCliente: cmb.getValue()
                                },
                                callback: function(){
                                    Ext.getCmp('sysIdPlan').enable();
                                }
                            });
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                fieldLabel: 'Plan',
                anchor: '100%',
                listWidth: 250,
                allowBlank: false,
                disabled: true,
                store: 'StoreClientesPlan',
                typeAhead: true,
                typeAheadDelay: 50,
                valueField: 'IdPlan',
                displayField: 'Descripcion',
                emptyText: 'Seleccione Plan....',
                mode: 'local',
                triggerAction: 'all',
                forceSelection: true,
                id: 'sysIdPlan',
                listeners: {
                    select: function(cmb, rec, idx) {
                        if(cmb.getValue() == null || cmb.getValue() == ""){
                            Ext.getCmp('sysIdSubPlan').store.removeAll(true);
                            Ext.getCmp('sysIdSubPlan').setValue(null);
                            Ext.getCmp('sysIdSubPlan').disable();
                        }else{
                            Ext.getCmp('sysIdSubPlan').store.removeAll(true);
                            Ext.getCmp('sysIdSubPlan').store.load({
                                params:{
                                    pPlan: cmb.getValue()
                                },
                                callback: function(){
                                    Ext.getCmp('sysIdSubPlan').enable();
                                }
                            });
                        }
                    }
                }
            },
            {
                xtype: 'combo',
                fieldLabel: 'SubPlan',
                anchor: '100%',
                listWidth: 250,
                allowBlank: false,
                disabled: true,
                store: 'StoreClienteSubplan',
                typeAhead: true,
                typeAheadDelay: 50,
                valueField: 'IdSubPlan',
                displayField: 'Descripcion',
                emptyText: 'Seleccione Plan....',
                mode: 'local',
                triggerAction: 'all',
                forceSelection: true,
                id: 'sysIdSubPlan'
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        fieldLabel: 'Concepto',
                        style: 'text-transform:uppercase;',
                        allowBlank: false,
                        readOnly: true,
                        width: 120,
                        id: 'fCodConcepto'
                    },
                    {
                        html: '-'
                    },
                    {
                        xtype: 'textfield',
                        width: 657,
                        allowBlank: true,
                        readOnly: true,
                        disabled: true,
                        id: 'fDesConcepto'
                    },
                    {
                        xtype: 'button',
                        tooltip: 'Buscar',
                        iconCls: 'btnBuscar',
                        id: 'btnSearchConcepto_Citas'
                    },
                    {
                        xtype: 'hidden',
                        flex: 1,
                        readOnly: true,
                        width: 120,
                        style: 'color: #0000cc; font-weight: bold;',
                        id: 'fVlrUnitario'
                    },
                    {
                        xtype: 'hidden',
                        flex: 1,
                        readOnly: true,
                        width: 120,
                        id: 'fidConcepto'
                    },
                    {
                        xtype: 'hidden',
                        flex: 1,
                        readOnly: true,
                        width: 120,
                        id: 'strTipoRegistroDetalle'
                    }
                ]
            },
            {
                xtype: 'grid',
                id: 'gridManualTarifario',
                store: st,
                anchor: "100%",
                border: false,
                frame: true,
                height: 340,
                columns: [
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdManualTarifario',
                        id: 'IdManualTarifario'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 930,
                        dataIndex: 'Descripcion',
                        id: 'Descripcion'
                    }
                ],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                viewConfig: {
                    getRowClass: function(record, index) {
                        if (record.get('Activo') == '0')
                            return 'Negado';
                        else
                            return;
                    }
                },
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar Concepto',
                                iconCls: 'btnAddRow',
                                ref: '../btnAddTipoHorario',
                                id: 'btnAddTipoHorario'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Concepto',
                                iconCls: 'btnDelRow',
                                ref: '../btnEditTipoHorario',
                                id: 'btnEditTipoHorario'
                            },
                            '->',
                            new Ext.app.SearchField({
                                id: 'qryManualTarifario',
                                store: st,
                                params: {pEmpresa: Ext.get('idempresa').getValue(), start: 0, limit: 15},
                                ValparamP1: ID_EMPRESA,
                                emptyText: 'Escriba el criterio que desea buscar',
                                width: 120,
                                pLoadGrid: true,
                                pGrid: 'gridManualTarifario',
                                parrParam: {params:{pManual:0}}
                            })
                        ]
                    }
            }
        ];
        winFrmManualTarifarioUi.superclass.initComponent.call(this);
    }
});
