/*
* @category    Programacion Eventos Formulario Radicacion de Servicios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
var CodFrm = "BS00001";
var ID_EMPRESA;
var ID_SEDE;
var ID_IPS;
var ID_USUARIO;
var gCAS;
var paso1 = false;
var paso2 = false;
var paso3 = false;
var paso4 = false;
var paso5 = false;
pRdoAutomaticoPart = 1;
pRCxSede = '0';
MaximizarVentana();
winRadicacionServicios = Ext.extend(winRadicacionServiciosUi, {
    initComponent: function() {
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        el = Ext.get('impFACTURAPAC_MC');
        FACTURAPAC_MC = el.getValue();     
        el = Ext.get('IdMunicipio');
        ID_MUNICIPIO = el.getValue();
        
        stCliente = new StoreCliente();
        //stCliente.load({params:{pSede:ID_SEDE,pEmpresa:ID_EMPRESA}});
        stCliente.load({params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}});
        winRadicacionServicios.superclass.initComponent.call(this);
        Ext.getCmp('fClienteLA').setValue(0);
        Ext.getCmp('fPlanLA').setValue(0);
        Ext.getCmp('fSubPlanLA').setValue(0);
        Ext.getCmp('fPacienteValido').setValue(0);
        Ext.getCmp('fIdEmpresa').setValue(ID_EMPRESA);
        Ext.getCmp('fIdSede').setValue(ID_SEDE);
        Ext.getCmp('fIdIPS').setValue(ID_IPS);
        this.setPagePosition((screen.width - 1004)/2, 5);
        this.fNomEmpresa.setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        this.fNomSede.setValue("SEDE: " + Ext.get('nomsede').getValue());
        this.fNomIPS.setValue("IPS: " + Ext.get('nomips').getValue());
        this.fNomUSR.setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        this.title = Ext.get('ofiversion').getValue() + " - [Modificación de Servicios]";
        el = Ext.get('FecSistema');
        //this.fFecNac.setMaxValue(el.getValue());
        //this.fFecSol.setMaxValue(el.getValue());
        el = Ext.get('FecControl');
        //this.fFecSol.setMinValue(el.getValue());
        Ext.getCmp('fPlan').store.removeAll(true);
        Ext.getCmp('fSubPlan').store.removeAll(true);
        Ext.getCmp('fContrato').store.removeAll(true);
        var fCliente = this.fCliente.on("select",this.CargaCbPlan,this);
        var fCliente1 = this.fCliente.on("change",this.ChangeCargaCbPlan,this);
        var fPlan = this.fPlan.on("select",this.CargaCbSubPlan,this);
        var fPlan1 = this.fPlan.on("change",this.ChangeCargaCbSubPlan,this);
        var fRegimen = this.fRegimen.on("select",this.ValidarRegimen,this);
        var fTafiliado = this.fTafiliado.on("select",this.ValidarParentesco,this);
        var fFecNac = this.fFecNac.on("Blur",this.MostrarEdad,this);
        var fPrograma = this.fPrograma.on("select",this.ValidarPrograma,this);
        var btnAddProfeSol = Ext.getCmp('btnAddProfeSol').on("click",this.CrearProfesionalSolicitante,this);
        var btnActualizaPac  = Ext.getCmp('btnActualizaPac').on("click",this.ActualizaInfoPaciente,this);
        var btnAyuda = this.btnAyuda.on("click",this.LlamarAyuda,this);
        var btnNuevo = this.btnNuevo.on("click",this.NuevoServicio, this);
        var btnSalir = this.btnSalir.on("click",this.Salir, this);
        var btnVerificaPacienteListado = Ext.getCmp('btnVerificaPacienteListado').on("click",this.VerificaListado,this);
        var btnRadicar = this.btnRadicar.on("click",this.GuardarDatosBasicos, this);
        var btnBuscarIPSSolicita = Ext.getCmp('btnBuscarIPSSolicita').on("click",this.BuscarIPSSol,this);
        
        
        var strdocpac_citas_special = Ext.getCmp('fDocID').on("specialkey",this.ValidarNumeroDocumentoPacSK,this);
        var btnResumenHC = this.btnResumenHC.on("click",this.GuardarResumenHC, this);
        var btnSearchDiagPpal = Ext.getCmp('btnSearchDiagPpal').on("click",this.BuscarDiagPpal,this);
        var btnSearchDiagRel1 = Ext.getCmp('btnSearchDiagRel1').on("click",this.BuscarDiagRel1,this);
        var btnSearchDiagRel2 = Ext.getCmp('btnSearchDiagRel2').on("click",this.BuscarDiagRel2,this);
        var fRango =  Ext.getCmp('fRango').on("select",this.SelectRangoSalarial,this);
        var btnPtesxAutorizar = this.btnPtesxAutorizar.on("click",this.AddConceptoPteAutorizarDetalle, this);
        var btnAddServicio = this.btnAddServicio.on("click",this.AddConceptoDetalle, this);
        var btnDelServicio = this.btnDelServicio.on("click",this.DelConceptoDetalle, this);
        var btnEditServicio = this.btnEditServicio.on("click",this.EditConceptoDetalle, this);
        var btnVerHistorialLegalizacion_citas = Ext.getCmp('btnHistorialLegalizaciones_citas').on("click",this.HistorialCitasLegalizadas,this);
        var btnVerHistorialLegalizacion_citas1 = Ext.getCmp('btnHistorialLegalizaciones_citas1').on("click",this.HistorialCitasLegalizadas,this);
        var btnLiquidarOrden = Ext.getCmp('btnLiquidarOrden').on("click",this.LiquidarOrden,this);
        var btnLegalizarOrden = Ext.getCmp('btnLegalizarOrden').on("click",this.LegalizarOrden,this);
        var btnBuscarPacienteRadica = Ext.getCmp('btnBuscarPacienteRadica').on("click",this.BuscarPaciente,this);
        var btnBuscarRadica = Ext.getCmp('btnBuscarRadica').on("click",this.BuscarRadicacionEstudios,this);
        var btnImprimirDocumentoFac = Ext.getCmp('btnImprimirDocumentoFac').on("click",this.ImprimirDocumentoFac,this);
        var btnAnularExcenta = Ext.getCmp('btnAnularExcenta').on("click",this.AnularLegalizacionExcenta,this);
        var btnAnularDocumentoFac = Ext.getCmp('btnAnularDocumentoFac').on("click",this.AnularDocumentoFac,this);
        var btnBorrarCAS = Ext.getCmp('btnBorrarCAS').on("click",this.BorrarCAS,this);
        var btnReactivarCAS = Ext.getCmp('btnReactivarCAS').on("click",this.ReactivarCAS,this);
        var btnImprimirOrdenamientos = Ext.getCmp('btnImprimirOrdenamientos').on("click",this.ImprimirAutorizacionProveedor,this);
        var btnImprimirStiker = Ext.getCmp('btnImprimirStiker').on("click",this.ImprimirStiker,this);
        var btnFacturaxPaciente = Ext.getCmp('btnFacturaxPaciente').on("click",this.GenerarFacturaPaciente,this);
        
        var sm_gridservicios = Ext.getCmp('gridServicios').getSelectionModel();
        sm_gridservicios.on("rowselect",this.UpdateDetalleSolServicio,this);
        Ext.getCmp('btnHistorialPac').setVisible(false);
        Ext.getCmp('btnHistorialLegalizaciones_citas').setVisible(false);
        Ext.getCmp('btnVerHistorialServicios').setVisible(false);
        Ext.getCmp('btnImprimirNegacion').setVisible(false);
        
        Ext.getCmp('gridServicios').getView().getRowClass = function(record, index, rowParams, store)
        {
            var estado = record.data.Estado;
            switch (estado)
            {
                case "Negado":
                    return 'Negado';
                    break;
                case "Autorizado":
                    return 'Autorizado';
                    break;
                case "Auditoria":
                    return 'Auditoria';
                    break;
                default:
                    break;
            }
        };
        
        Ext.getCmp('btnReactivarCAS').setVisible(false);
        Ext.getCmp('fDeptoMuni').setValue(ID_MUNICIPIO);
    },
    BuscarIPSSol:function(){
        buscaripsreps();
    },
    GenerarFacturaPaciente: function(){
        if (Ext.getCmp('fCas').getValue() != 0 && Ext.getCmp('fYaFacturadoEnt').getValue() == 0 && Ext.getCmp('fYaLiquidado').getValue() == 1){
            Ext.Ajax.request({
                waitMsg: 'Por favor Espere...',
                url: "../../controlador/clientes/controlador_clientes.php",
                params: {
                    task: "BUSCAR_FACTURAPORPACIENTE",
                    pEmpresa: ID_EMPRESA,
                    pCliente: Ext.getCmp('fCliente').getValue()
                },
                success: function(response){
                    var result = response.responseText;
                    if (result == "1" || result == 1){
                        Ext.Msg.show({
                            title: 'Facturación',
                            msg: 'Esta seguro que desea generar la factura por paciente?',
                            buttons: Ext.Msg.YESNO,
                            icon: Ext.Msg.QUESTION,
                            fn: function(btn){
                                if(btn=="yes"){
                                    if(Ext.getCmp('btnFacturaFacturacion').isValid() && Ext.getCmp('btnFacturaFacturacion').getValue() != ""){
                                        Ext.Msg.wait('Generando Factura de Venta... por favor espere!');
                                        Ext.Ajax.request({
                                            waitMsg: 'Por favor Espere...',
                                            url: "../../controlador/facturacion/facturacion.php",
                                            params: {
                                                task: "GENERAR_FACTURA_PACIENTE",
                                                pEmpresa: ID_EMPRESA,
                                                pIPS: ID_IPS,
                                                pUsuario: ID_USUARIO,
                                                pPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                                pCAS: Ext.getCmp('fCas').getValue(),
                                                pFechaFac: Ext.getCmp('btnFacturaFacturacion').getValue().format("Y-m-d"),
                                                pPorPaciente: "SI"
                                            },
                                            success: function(response)
                                            {
                                                var result = response.responseText;
                                                if (result != "0" && result != "{failure:true}")
                                                {
                                                    Ext.Msg.hide();
                                                    Ext.getCmp('fYaFacturadoEnt').setValue(1);
                                                    Ext.getCmp('fYaLegalizado').setValue(1);
                                                    Ext.getCmp('fModificaCAS').setValue(0);
                                                    Ext.getCmp('sysTipoLegalizacion_estudios').setValue("FACTURA DE VENTA POR PACIENTE");
                                                    Ext.getCmp('sysResponsableLegalizacion_estudios').setValue(Ext.get('nomusuario').getValue() + ' - ' + new Date());
                                                    EstblecerCamposDisabled();
                                                    Ext.getCmp('gridFacturacionOrden').store.load({
                                                        params: {
                                                            pEmpresa: ID_EMPRESA,
                                                            pCAS: Ext.getCmp('fCas').getValue()
                                                        }
                                                    });
                                                    var html = '<table><tr><td width="50"><img src="../../../resources/varios/money.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #2E2EFE; font-size: 14px;">Facturación:</h1><br/><p style="color: #003333;font-weight: bold;">Se Genero la Factura de Venta Institucional Nro. ' + result  + '</p></br>';
                                                    html += '</td><td width="70">&nbsp</td></tr></table>';
                                                    Sexy.info(html);
                                                }else{
                                                    Ext.MessageBox.show({
                                                        title: 'Error',
                                                        msg: 'Ocurrio un error al generar la factura',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                }
                                            },
                                            failure: function(response){
                                                var result = response.responseText;
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'Ocurrio un error al generar la factura',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'La Fecha de Facturación es Requerida',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        });
                    }else{
                        Ext.MessageBox.show({
                            title: 'Factura por Paciente',
                            msg: 'El Cliente asociado al servicio no esta disponible para realizar factura por paciente',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Este servicio ya fue facturado y/o no esta disponible y/o debe liquidar primero la orden',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ImprimirStiker: function(){
        if(parseInt(Ext.getCmp('fYaLegalizado').getValue()) === 1){
            window.open ("../../controlador/transcribirlabo/imprimirmarcacion.php?pCAS=" + Ext.getCmp('fCas').getValue(),"Stiker Laboratorio");
        }else{
            Ext.MessageBox.show({
                title: 'ofiClinic',
                msg: 'La orden no se ha legalizado, por favor realize la legalizacion de los servicios.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ImprimirAutorizacionProveedor: function(){
        if(parseInt(Ext.getCmp('fYaLegalizado').getValue()) === 1){
            window.open ("../../controlador/modificacionservicios/infautorizacionproveedor001.php?pCAS=" + Ext.getCmp('fCas').getValue(),"Autorizacion a Proveedor");
        }else{
            Ext.MessageBox.show({
                title: 'ofiClinic',
                msg: 'La orden no se ha legalizado, por favor realize la legalizacion de los servicios.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ChangeCargaCbPlan:function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('fPlan').store.removeAll(true);
            Ext.getCmp('fSubPlan').store.removeAll(true);
            Ext.getCmp('fContrato').store.removeAll(true);
            Ext.getCmp('fPlan').setValue(null);
            Ext.getCmp('fSubPlan').setValue(null);
            Ext.getCmp('fContrato').setValue(null);
            Ext.getCmp('fContrato').disable();
        }
    },
    ChangeCargaCbSubPlan:function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('fSubPlan').store.removeAll(true);
            Ext.getCmp('fSubPlan').setValue(null);
            Ext.getCmp('fSubPlan').disable();
        }
    },
    BorrarCAS: function(){
        if (Ext.getCmp('fCas').getValue() != 0 && Ext.getCmp('fModificaCAS').getValue() == 1 && Ext.getCmp('fYaFacturadoEnt').getValue() == 0 && Ext.getCmp('fYaRealizado').getValue() == 0){
            var winBorrarCAS = new winBorrarCASUi();
            Ext.getCmp('sysBorraEmpresa').setValue(ID_EMPRESA);
            Ext.getCmp('sysBorraIPS').setValue(ID_IPS);
            Ext.getCmp('sysBorraUsuario').setValue(ID_USUARIO);
            Ext.getCmp('sysBorraCAS').setValue(Ext.getCmp('fCas').getValue());
            winBorrarCAS.show();
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'La Orden de Servicio no esta disponible y/o ya se facturo o se evoluciono la historia clinica',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ReactivarCAS: function(){
        if (Ext.getCmp('sysTextoEliminado').getValue() === "ELIMINADO"){
            var winBorrarCAS = new winBorrarCASUi();
            Ext.getCmp('sysBorraEmpresa').setValue(ID_EMPRESA);
            Ext.getCmp('sysBorraIPS').setValue(ID_IPS);
            Ext.getCmp('sysBorraUsuario').setValue(ID_USUARIO);
            Ext.getCmp('sysBorraCAS').setValue(Ext.getCmp('fCas').getValue());
            Ext.getCmp('sysProcesoCAS').setValue("REACTIVAR");
            winBorrarCAS.title = "eOfiClinic .:: Reactivar Orden Servicios - CAS ::.";
            Ext.getCmp('btnProcesoCAS').text = "Reactivar CAS";
            Ext.getCmp('btnProcesoCAS').iconCls = 'btnAceptar';
            winBorrarCAS.show();
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'La Orden de Servicio no esta disponible',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    AnularDocumentoFac: function(){
        //alert("CAS: " + Ext.getCmp('fCas').getValue() + " ModificaCAS: " + Ext.getCmp('fModificaCAS').getValue() + " Ya FacturadoEnt: " + Ext.getCmp('fYaFacturadoEnt').getValue() + " Tipo Legaliza: " + Ext.getCmp('sysTipoLegalizacion_estudios').getValue());
        if (Ext.getCmp('fCas').getValue() != 0 && Ext.getCmp('fModificaCAS').getValue() == 1 && Ext.getCmp('fYaFacturadoEnt').getValue() == 0 && Ext.getCmp('sysTipoLegalizacion_estudios').getValue() != "EXENTA DE PAGO")
        {
            if(Ext.getCmp('gridFacturacionOrden').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridFacturacionOrden').selModel.getSelections();
                if (selections[0].json.Anulada == 0)
                {
                    switch (selections[0].json.TipoDocumento){
                        case "MC":
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Esta seguro que desea anular el documento Nro: ' + selections[0].json.Prefijo + '-' + selections[0].json.NroDocumento + '?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn)
                                {
                                    if(btn=="yes")
                                    {
                                        var winAnularMC = new winAnularMCUi();
                                        Ext.getCmp('sysEmpresa').setValue(ID_EMPRESA);
                                        Ext.getCmp('sysIPS').setValue(ID_IPS);
                                        Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                                        Ext.getCmp('sysIdLegalizacion').setValue(selections[0].json.idLegalizacion);
                                        Ext.getCmp('sysNroMC').setValue(selections[0].json.Prefijo + '-' + selections[0].json.NroDocumento);
                                        winAnularMC.show();
                                    }
                                }
                            });
                            break;

                        case "FV":
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Esta seguro que desea anular el documento Nro: ' + selections[0].json.Prefijo + '-' + selections[0].json.NroDocumento + '?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn)
                                {
                                    if(btn=="yes")
                                    {
                                        var winAnularFV = new winAnularFVUi();
                                        Ext.getCmp('sysEmpresa').setValue(ID_EMPRESA);
                                        Ext.getCmp('sysIPS').setValue(ID_IPS);
                                        Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                                        Ext.getCmp('sysIdLegalizacion').setValue(selections[0].json.idLegalizacion);
                                        Ext.getCmp('sysNroMC').setValue(selections[0].json.Prefijo + '-' + selections[0].json.NroDocumento);
                                        winAnularFV.show();
                                    }
                                }
                            });
                            break;
                            
                        default:
                            break;
                    }
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'El documento Nro: ' + selections[0].json.Prefijo + '-' + selections[0].json.NroDocumento + ', Ya esta anulado',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'Debe Seleccionar un documento',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'La Orden de Servicio no esta disponible y no podemos realizar la anulación de las documentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    
    AnularLegalizacionExcenta: function(){
        if (Ext.getCmp('fCas').getValue() != 0 && Ext.getCmp('fModificaCAS').getValue() == 1 && Ext.getCmp('fYaFacturadoEnt').getValue() == 0 && Ext.getCmp('sysTipoLegalizacion_estudios').getValue() == "EXENTA DE PAGO")
        {
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea anular la legalización de la orden?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        Ext.Ajax.request(
                        {
                            url: '../../controlador/radicacionservicios/legalizacioncas.php',
                            params:{
                                PROCESO: 'ANULAR_LEGALIZACION_EXENTA',
                                pEmpresa: ID_EMPRESA,
                                pIPS: ID_IPS,
                                pUsuario: ID_USUARIO,
                                pCAS: Ext.getCmp('fCas').getValue()
                            },
                            success: function(response,options)
                            {
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                    Ext.MessageBox.show({
                                        title: 'eOfiClinic',
                                        msg: 'Ocurrio un error al anular la legalizacion de la orden de servicios.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                } else {
                                    Ext.getCmp('fYaLiquidado').setValue(0);
                                    Ext.getCmp('fYaLegalizado').setValue(0);
                                    Ext.getCmp('sysTipoLegalizacion_estudios').setValue(null);
                                    Ext.getCmp('sysResponsableLegalizacion_estudios').setValue(null);
                                    Ext.MessageBox.show({
                                        title: 'eOfiClinic',
                                        msg: 'Se Anulo con Exito la Legalización Exenta de la Orden de Servicios.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                }
                            },
                            failure: function(response,options){
                                Ext.MessageBox.show({
                                    title: 'Error Conexión',
                                    msg: 'No podemos realizar la anulación de la legalización y/o No se pudo establecer conexión con el servidor',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            },
                            scope:this 
                        });
                    }
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'La Orden de Servicio no esta disponible y no podemos realizar la anulación de la legalización',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ImprimirDocumentoFac: function(){
        if(Ext.getCmp('gridFacturacionOrden').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFacturacionOrden').selModel.getSelections();
            switch (selections[0].json.TipoDocumento){
                case "MC":
                    window.open('../../../app/controlador/legalizaciones/print_mc_copago.php?pCAS='+selections[0].json.CAS+'&pPaciente='+selections[0].json.Paciente+'&pCliente='+selections[0].json.Cliente+'&pPlan='+selections[0].json.Plan+'&pSubPlan='+selections[0].json.SubPlan+'&pTipoLegalizacion='+selections[0].json.TipoLegalizacion+'&pPrefijo='+selections[0].json.Prefijo+'&pNroDocumento='+selections[0].json.NroDocumento+'&pFechaDocumento='+selections[0].json.FechaDocumento+'&pNroResolucion='+selections[0].json.NroResolucion+'&pFechaVencimiento='+selections[0].json.FechaVencimiento+'&pConcepto='+selections[0].json.Concepto+'&pVlrTotal='+selections[0].json.VlrTotal+'&pVlrIVA='+selections[0].json.VlrIVA+'&pVlrCuotaModeradora='+selections[0].json.VlrCuotaModeradora+'&pVlrCopagos='+selections[0].json.VlrCopagos+'&pVlrDescuentos='+selections[0].json.VlrDescuentos+'&pVlrNeto='+selections[0].json.VlrNeto+'&pAnulada='+selections[0].json.Anulada+'&pUsuarioAnula='+selections[0].json.UsuarioAnula+'&pMotivoAnula='+selections[0].json.MotivoAnula+'&pFechaAnula='+selections[0].json.FechaAnula+'&pUsuarioFactura='+selections[0].json.UsuarioFactura,"MOVIMIENTO DE CAJA");
                    break;
                case "FV":
                    window.open('../../../app/controlador/legalizaciones/print_fv_particular.php?pCAS='+selections[0].json.CAS+'&pPaciente='+selections[0].json.Paciente+'&pCliente='+selections[0].json.Cliente+'&pPlan='+selections[0].json.Plan+'&pSubPlan='+selections[0].json.SubPlan+'&pTipoLegalizacion='+selections[0].json.TipoLegalizacion+'&pPrefijo='+selections[0].json.Prefijo+'&pNroDocumento='+selections[0].json.NroDocumento+'&pFechaDocumento='+selections[0].json.FechaDocumento+'&pNroResolucion='+selections[0].json.NroResolucion+'&pFechaVencimiento='+selections[0].json.FechaVencimiento+'&pConcepto='+selections[0].json.Concepto+'&pVlrTotal='+selections[0].json.VlrTotal+'&pVlrIVA='+selections[0].json.VlrIVA+'&pVlrCuotaModeradora='+selections[0].json.VlrCuotaModeradora+'&pVlrCopagos='+selections[0].json.VlrCopagos+'&pVlrDescuentos='+selections[0].json.VlrDescuentos+'&pVlrNeto='+selections[0].json.VlrNeto+'&pAnulada='+selections[0].json.Anulada+'&pUsuarioAnula='+selections[0].json.UsuarioAnula+'&pMotivoAnula='+selections[0].json.MotivoAnula+'&pFechaAnula='+selections[0].json.FechaAnula+'&pUsuarioFactura='+selections[0].json.UsuarioFactura,"FACTURA DE VENTA");
                    break;
                case "RCPART":
                    window.open('../../../app/controlador/legalizaciones/print_rc_particular.php?pCAS='+selections[0].json.CAS+'&pPaciente='+selections[0].json.Paciente+'&pCliente='+selections[0].json.Cliente+'&pPlan='+selections[0].json.Plan+'&pSubPlan='+selections[0].json.SubPlan+'&pTipoLegalizacion='+selections[0].json.TipoLegalizacion+'&pPrefijo='+selections[0].json.Prefijo+'&pNroDocumento='+selections[0].json.NroDocumento+'&pFechaDocumento='+selections[0].json.FechaDocumento+'&pNroResolucion='+selections[0].json.NroResolucion+'&pFechaVencimiento='+selections[0].json.FechaVencimiento+'&pConcepto='+selections[0].json.Concepto+'&pVlrTotal='+selections[0].json.VlrTotal+'&pVlrIVA='+selections[0].json.VlrIVA+'&pVlrCuotaModeradora='+selections[0].json.VlrCuotaModeradora+'&pVlrCopagos='+selections[0].json.VlrCopagos+'&pVlrDescuentos='+selections[0].json.VlrDescuentos+'&pVlrNeto='+selections[0].json.VlrNeto+'&pAnulada='+selections[0].json.Anulada+'&pUsuarioAnula='+selections[0].json.UsuarioAnula+'&pMotivoAnula='+selections[0].json.MotivoAnula+'&pFechaAnula='+selections[0].json.FechaAnula+'&pUsuarioFactura='+selections[0].json.UsuarioFactura,"RECIBO DE CAJA");
                    break;
                default:
                    break;
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar solo un documento.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    BuscarRadicacionEstudios: function(){
        buscarestudios("Modificacion");
    },
    BuscarPaciente: function(){
        buscarpaciente("Radicacion");
    },
    HistorialCitasLegalizadas: function(){
        var winFrmHistorialLegalizaciones = new winFrmHistorialLegalizacionesUi();
        winFrmHistorialLegalizaciones.setTitle("OfiClinic© Web..! .:: Historial de Legalizaciones ::.");
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("task", "HISTORIAL_CITAS_LEGALIZADAS");
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pEmpresa", ID_EMPRESA);
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pIPS", ID_IPS);
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pSede", ID_SEDE);
        Ext.getCmp('gridHistorialCitas').store.setBaseParam("pPaciente", Ext.getCmp('fIdPaciente').getValue());
        Ext.getCmp('gridHistorialCitas').store.load({
            params: {
                start: 0,
                limit: 15
            }
        });
        winFrmHistorialLegalizaciones.show();
    },
    LegalizarOrden: function(){
        if(parseInt(Ext.getCmp('fCas').getValue()) !== 0 && parseInt(Ext.getCmp('fModificaCAS').getValue()) === 1 && parseInt(Ext.getCmp('fYaLiquidado').getValue()) === 1 && (parseInt(Ext.getCmp('fYaFacturadoEnt').getValue()) === 0 || Ext.getCmp('fYaFacturadoEnt').getValue() === null || Ext.getCmp('fYaFacturadoEnt').getValue() === "")){
            if (parseInt(Ext.getCmp('fYaActalizado').getValue()) === 0){
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'Debe gaurdar y actualizar los datos basicos de la orden de servicio.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }else{
                pRdoAutomaticoPart = 1;
                pRCxSede = '0';
                if (parseInt(Ext.getCmp('fFacturarParticular').getValue()) === 1){
                    var stliquida = new StoreLiquidacionCAS();
                    stliquida.load({
                        params: {
                            pCAS: Ext.getCmp('fCas').getValue(),
                            PROCESO: "VerLiquidacion"
                        },
                        callback: function(r,o,s){
                            Ext.getCmp('sysVlrTotal_estudios').setValue(stliquida.getAt(0).get('vlrTotal'));
                            Ext.getCmp('sysVlrIVA_estudios').setValue(stliquida.getAt(0).get('vlrIVA'));
                            Ext.getCmp('sysVlrCM_estudios').setValue(stliquida.getAt(0).get('vlrCM'));
                            Ext.getCmp('sysVlrCopago_estudios').setValue(stliquida.getAt(0).get('vlrCOP'));
                            Ext.getCmp('sysVlrDescuentos_estudios').setValue(stliquida.getAt(0).get('vlrDescuentos'));
                            Ext.getCmp('sysVlrNeto_estudios').setValue(stliquida.getAt(0).get('vlrNeto'));
                            Ext.getCmp('fYaLiquidado').setValue(1);

                            //----------------
                            var xvlr = 0;
                            xvlr = Ext.getCmp('sysVlrNeto_estudios').getValue();
                            if(xvlr > 0){
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea legalizar la orden por valor a pagar de: $ ' + xvlr,
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                            Ext.Ajax.request(
                                            {
                                                url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                                params:{
                                                    PROCESO: 'LegalizarParticulares',
                                                    pCAS: Ext.getCmp('fCas').getValue(),
                                                    pEmpresa: ID_EMPRESA,
                                                    pIPS: ID_IPS,
                                                    pUsuario: ID_USUARIO,
                                                    pVltTotal: Ext.getCmp('sysVlrTotal_estudios').getValue(),
                                                    pVlrIVA: Ext.getCmp('sysVlrIVA_estudios').getValue(),
                                                    pVlrCM: Ext.getCmp('sysVlrCM_estudios').getValue(),
                                                    pVlrCOP: Ext.getCmp('sysVlrCopago_estudios').getValue(),
                                                    pVlrDescuentos: Ext.getCmp('sysVlrDescuentos_estudios').getValue(),
                                                    pVlrNeto: Ext.getCmp('sysVlrNeto_estudios').getValue(),
                                                    pCliente: Ext.getCmp('fCliente').getValue(),
                                                    pPlan: Ext.getCmp('fPlan').getValue(),
                                                    pSubPlan: Ext.getCmp('fSubPlan').getValue(),
                                                    pContrato: Ext.getCmp('fContrato').getValue()
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); 
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    var NroDocumento = Contenido[0];
                                                    pRdoAutomaticoPart = Contenido[7];
                                                    pRCxSede = Contenido[8];
                                                    if (NroDocumento > 0)
                                                    {
                                                        Ext.Ajax.request(
                                                        {
                                                            url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                                            params:{
                                                                PROCESO: 'GenerarDocumentoFV',
                                                                pDocumentoFac: NroDocumento,
                                                                pCAS: Ext.getCmp('fCas').getValue(),
                                                                pEmpresa: ID_EMPRESA,
                                                                pIPS: ID_IPS,
                                                                pUsuario: ID_USUARIO,
                                                                pVltTotal: Ext.getCmp('sysVlrTotal_estudios').getValue(),
                                                                pVlrIVA: Ext.getCmp('sysVlrIVA_estudios').getValue(),
                                                                pVlrCM: Ext.getCmp('sysVlrCM_estudios').getValue(),
                                                                pVlrCOP: Ext.getCmp('sysVlrCopago_estudios').getValue(),
                                                                pVlrDescuentos: Ext.getCmp('sysVlrDescuentos_estudios').getValue(),
                                                                pVlrNeto: Ext.getCmp('sysVlrNeto_estudios').getValue(),
                                                                pPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                                                pCliente: Ext.getCmp('fCliente').getValue(),
                                                                pPlan: Ext.getCmp('fPlan').getValue(),
                                                                pSubPlan: Ext.getCmp('fSubPlan').getValue(),
                                                                pContrato: Ext.getCmp('fContrato').getValue(),
                                                                pConsecutivoFac: Contenido[0],
                                                                pPrefijoFac: Contenido[1],
                                                                pResolucionFac: Contenido[2],
                                                                pNumeracionDesdeFac: Contenido[3],
                                                                pNumeracionHastaFac: Contenido[4],
                                                                pPrefijoReciboCaja: Contenido[5],
                                                                pNumeroReciboCaja: Contenido[6]
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                if(pRdoAutomaticoPart == 1){
                                                                    var NroDocumentoCruce = response.responseText;
                                                                    if (NroDocumentoCruce > 0)
                                                                    {
                                                                        Ext.Ajax.request({
                                                                            url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                                                            params:{
                                                                                PROCESO: 'GenerarDocumentoFVCruce',
                                                                                pEmpresa: ID_EMPRESA,
                                                                                pIPS: ID_IPS,
                                                                                pRCxIPS: pRCxSede,
                                                                                pDocumentoCruce: NroDocumentoCruce
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'eOfiClinic',
                                                                                        msg: 'Ocurrio un error al legalizar la orden de servicios.',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                } else {
                                                                                    Ext.getCmp('fYaLegalizado').setValue(1);
                                                                                    Ext.getCmp('fModificaCAS').setValue(0);
                                                                                    Ext.getCmp('sysTipoLegalizacion_estudios').setValue("FACTURA DE VENTA");
                                                                                    Ext.getCmp('sysResponsableLegalizacion_estudios').setValue(Ext.get('nomusuario').getValue() + ' - ' + new Date());
                                                                                    EstblecerCamposDisabled();
                                                                                    Ext.getCmp('gridFacturacionOrden').store.load({
                                                                                        params: {
                                                                                            pEmpresa: ID_EMPRESA,
                                                                                            pCAS: Ext.getCmp('fCas').getValue()
                                                                                        }
                                                                                    });
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'eOfiClinic',
                                                                                        msg: 'Se Legalizo con Exito la Orden de Servicios.',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.INFO
                                                                                    });
                                                                                }
                                                                            },scope:this
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.getCmp('fYaLegalizado').setValue(1);
                                                                    Ext.getCmp('fModificaCAS').setValue(0);
                                                                    Ext.getCmp('sysTipoLegalizacion_estudios').setValue("FACTURA DE VENTA");
                                                                    Ext.getCmp('sysResponsableLegalizacion_estudios').setValue(Ext.get('nomusuario').getValue() + ' - ' + new Date());
                                                                    EstblecerCamposDisabled();
                                                                    Ext.getCmp('gridFacturacionOrden').store.load({
                                                                        params: {
                                                                            pEmpresa: ID_EMPRESA,
                                                                            pCAS: Ext.getCmp('fCas').getValue()
                                                                        }
                                                                    });
                                                                    Ext.MessageBox.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'Se Legalizo con Exito la Orden de Servicios.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.INFO
                                                                    });
                                                                }
                                                            },scope:this
                                                        });
                                                    }
                                                },
                                                failure: function(response,options){
                                                    Ext.MessageBox.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Ocurrio un error al legalizar la orden de servicios o no se pudo establecer conexión con el servidor.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                },
                                                scope:this
                                            });
                                        }
                                    }
                                });
                            }
                            //________________
                        }
                    });
                    
            }else{
                if (parseInt(Ext.getCmp('fExento').getValue()) === 1){
                    Ext.Msg.show({
                        title: 'eOfiClinic',
                        msg: 'Esta seguro que desea legalizar la orden exenta de pago?',
                        buttons: Ext.Msg.YESNO,
                        icon: Ext.Msg.QUESTION,
                        fn: function(btn)
                        {
                            if(btn=="yes")
                            {
                                Ext.Ajax.request(
                                {
                                    url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                    params:{
                                        PROCESO: 'LegalizarExenta',
                                        pCAS: Ext.getCmp('fCas').getValue(),
                                        pEmpresa: ID_EMPRESA,
                                        pIPS: ID_IPS,
                                        pUsuario: ID_USUARIO,
                                        pVltTotal: Ext.getCmp('sysVlrTotal_estudios').getValue(),
                                        pVlrIVA: Ext.getCmp('sysVlrIVA_estudios').getValue(),
                                        pVlrCM: Ext.getCmp('sysVlrCM_estudios').getValue(),
                                        pVlrCOP: Ext.getCmp('sysVlrCopago_estudios').getValue(),
                                        pVlrDescuentos: Ext.getCmp('sysVlrDescuentos_estudios').getValue(),
                                        pVlrNeto: Ext.getCmp('sysVlrNeto_estudios').getValue()
                                    },
                                    success: function(response,options)
                                    {
                                        var Respuesta = response.responseText;
                                        var Contenido = Respuesta.split('^');
                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                            Ext.MessageBox.show({
                                                title: 'eOfiClinic',
                                                msg: 'Ocurrio un error al legalizar la orden de servicios.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        } else {
                                            Ext.getCmp('fYaLegalizado').setValue(1);
                                            Ext.getCmp('fModificaCAS').setValue(0);
                                            Ext.getCmp('sysTipoLegalizacion_estudios').setValue("EXENTA DE PAGO");
                                            Ext.getCmp('sysResponsableLegalizacion_estudios').setValue(Ext.get('nomusuario').getValue() + ' - ' + new Date());
                                            EstblecerCamposDisabled();
                                            Ext.MessageBox.show({
                                                title: 'eOfiClinic',
                                                msg: 'Se Legalizo con Exito la Orden de Servicios.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.INFO
                                            });
                                        }
                                    },
                                    failure: function(response,options){
                                        Ext.MessageBox.show({
                                            title: 'eOfiClinic',
                                            msg: 'Ocurrio un error al legalizar la orden de servicios o no se pudo establecer conexión con el servidor.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    },
                                    scope:this
                                });
                            }
                        }
                    });
                }else{
                    if (parseInt(Ext.getCmp('fFacturarCopagos').getValue()) === 1){
                        var xvlr = 0;
                        xvlr = Ext.getCmp('sysVlrCM_estudios').getValue() + Ext.getCmp('sysVlrCopago_estudios').getValue();
                        if(xvlr > 0){
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Esta seguro que desea legalizar la orden por valor a pagar de: $ ' + xvlr,
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn)
                                {
                                    if(btn=="yes")
                                    {
                                        Ext.Ajax.request(
                                        {
                                            url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                            params:{
                                                PROCESO: 'LegalizarCopagos',
                                                pCAS: Ext.getCmp('fCas').getValue(),
                                                pEmpresa: ID_EMPRESA,
                                                pIPS: ID_IPS,
                                                pUsuario: ID_USUARIO,
                                                pVltTotal: Ext.getCmp('sysVlrTotal_estudios').getValue(),
                                                pVlrIVA: Ext.getCmp('sysVlrIVA_estudios').getValue(),
                                                pVlrCM: Ext.getCmp('sysVlrCM_estudios').getValue(),
                                                pVlrCOP: Ext.getCmp('sysVlrCopago_estudios').getValue(),
                                                pVlrDescuentos: Ext.getCmp('sysVlrDescuentos_estudios').getValue(),
                                                pVlrNeto: Ext.getCmp('sysVlrNeto_estudios').getValue(),
                                                pCliente: Ext.getCmp('fCliente').getValue(),
                                                pPlan: Ext.getCmp('fPlan').getValue(),
                                                pSubPlan: Ext.getCmp('fSubPlan').getValue(),
                                                pContrato: Ext.getCmp('fContrato').getValue()
                                            },
                                            success: function(response,options)
                                            {
                                                var NroDocumento = response.responseText;
                                                if (NroDocumento > 0)
                                                {
                                                    Ext.Ajax.request(
                                                    {
                                                        url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                                        params:{
                                                            PROCESO: 'GenerarDocumentoCopago',
                                                            pDocumentoFac: NroDocumento,
                                                            pCAS: Ext.getCmp('fCas').getValue(),
                                                            pEmpresa: ID_EMPRESA,
                                                            pIPS: ID_IPS,
                                                            pUsuario: ID_USUARIO,
                                                            pVltTotal: Ext.getCmp('sysVlrTotal_estudios').getValue(),
                                                            pVlrIVA: Ext.getCmp('sysVlrIVA_estudios').getValue(),
                                                            pVlrCM: Ext.getCmp('sysVlrCM_estudios').getValue(),
                                                            pVlrCOP: Ext.getCmp('sysVlrCopago_estudios').getValue(),
                                                            pVlrDescuentos: Ext.getCmp('sysVlrDescuentos_estudios').getValue(),
                                                            pVlrNeto: Ext.getCmp('sysVlrNeto_estudios').getValue(),
                                                            pPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                                            pCliente: Ext.getCmp('fCliente').getValue(),
                                                            pPlan: Ext.getCmp('fPlan').getValue(),
                                                            pSubPlan: Ext.getCmp('fSubPlan').getValue(),
                                                            pContrato: Ext.getCmp('fContrato').getValue()
                                                        },
                                                        success: function(response,options)
                                                        {
                                                            var NroDocumentoCruce = response.responseText;
                                                            if (NroDocumentoCruce > 0)
                                                            {
                                                                Ext.Ajax.request({
                                                                    url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                                                    params:{
                                                                        PROCESO: 'GenerarDocumentoCopagoCruce',
                                                                        pDocumentoCruce: NroDocumentoCruce
                                                                    },
                                                                    success: function(response,options)
                                                                    {
                                                                        var Respuesta = response.responseText;
                                                                        var Contenido = Respuesta.split('^');
                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                            Ext.MessageBox.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Ocurrio un error al legalizar la orden de servicios.',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        } else {
                                                                            Ext.getCmp('fYaLegalizado').setValue(1);
                                                                            Ext.getCmp('fModificaCAS').setValue(0);
                                                                            Ext.getCmp('sysTipoLegalizacion_estudios').setValue("RECAUDO DE COPAGOS Y/O CUOTAS MODERADORAS");
                                                                            Ext.getCmp('sysResponsableLegalizacion_estudios').setValue(Ext.get('nomusuario').getValue() + ' - ' + new Date());
                                                                            EstblecerCamposDisabled();
                                                                            Ext.getCmp('gridFacturacionOrden').store.load({
                                                                                params: {
                                                                                    pEmpresa: ID_EMPRESA,
                                                                                    pCAS: Ext.getCmp('fCas').getValue()
                                                                                }
                                                                            });
                                                                            Ext.MessageBox.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Se Legalizo con Exito la Orden de Servicios.',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.INFO
                                                                            });
                                                                        }
                                                                    },scope:this
                                                                });
                                                            }
                                                        },scope:this
                                                    });
                                                }
                                            },
                                            failure: function(response,options){
                                                Ext.MessageBox.show({
                                                    title: 'eOfiClinic',
                                                    msg: 'Ocurrio un error al legalizar la orden de servicios o no se pudo establecer conexión con el servidor.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            },
                                            scope:this
                                        });
                                    }
                                }
                            });
                        }else{
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Esta seguro que desea legalizar la orden exenta de pago?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn)
                                {
                                    if(btn=="yes")
                                    {
                                        Ext.Ajax.request(
                                        {
                                            url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                            params:{
                                                PROCESO: 'LegalizarExenta',
                                                pCAS: Ext.getCmp('fCas').getValue(),
                                                pEmpresa: ID_EMPRESA,
                                                pIPS: ID_IPS,
                                                pUsuario: ID_USUARIO,
                                                pVltTotal: Ext.getCmp('sysVlrTotal_estudios').getValue(),
                                                pVlrIVA: Ext.getCmp('sysVlrIVA_estudios').getValue(),
                                                pVlrCM: Ext.getCmp('sysVlrCM_estudios').getValue(),
                                                pVlrCOP: Ext.getCmp('sysVlrCopago_estudios').getValue(),
                                                pVlrDescuentos: Ext.getCmp('sysVlrDescuentos_estudios').getValue(),
                                                pVlrNeto: Ext.getCmp('sysVlrNeto_estudios').getValue()
                                            },
                                            success: function(response,options)
                                            {
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                    Ext.MessageBox.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Ocurrio un error al legalizar la orden de servicios.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                } else {
                                                    Ext.getCmp('fYaLegalizado').setValue(1);
                                                    Ext.getCmp('fModificaCAS').setValue(0);
                                                    Ext.getCmp('sysTipoLegalizacion_estudios').setValue("EXENTA DE PAGO");
                                                    Ext.getCmp('sysResponsableLegalizacion_estudios').setValue(Ext.get('nomusuario').getValue() + ' - ' + new Date());
                                                    EstblecerCamposDisabled();
                                                    Ext.MessageBox.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Se Legalizo con Exito la Orden de Servicios.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.INFO
                                                    });
                                                }
                                            },
                                            failure: function(response,options){
                                                Ext.MessageBox.show({
                                                    title: 'eOfiClinic',
                                                    msg: 'Ocurrio un error al legalizar la orden de servicios o no se pudo establecer conexión con el servidor.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            },
                                            scope:this
                                        });
                                    }
                                }
                            });
                        }
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'No Existe una Opción de Legalizacion Parametrizada, Por Favor Comuniquese con el Administrador del Sistema.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
                }
            }
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'La Orden de Servicio no esta disponible y/o Debe liquidar primero la orden',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    LiquidarOrden: function(){
        if (parseInt(Ext.getCmp('fCas').getValue()) !== 0 && parseInt(Ext.getCmp('fModificaCAS').getValue()) === 1 && (parseInt(Ext.getCmp('fYaFacturadoEnt').getValue()) === 0 || Ext.getCmp('fYaFacturadoEnt').getValue() === null || Ext.getCmp('fYaFacturadoEnt').getValue() === ""))
        {
            var stliquida = new StoreLiquidacionCAS();
            stliquida.load({
                params: {
                    pCAS: Ext.getCmp('fCas').getValue(),
                    PROCESO: "VerLiquidacion"
                },
                callback: function(r,o,s){
                    Ext.getCmp('sysVlrTotal_estudios').setValue(stliquida.getAt(0).get('vlrTotal'));
                    Ext.getCmp('sysVlrIVA_estudios').setValue(stliquida.getAt(0).get('vlrIVA'));
                    Ext.getCmp('sysVlrCM_estudios').setValue(stliquida.getAt(0).get('vlrCM'));
                    Ext.getCmp('sysVlrCopago_estudios').setValue(stliquida.getAt(0).get('vlrCOP'));
                    Ext.getCmp('sysVlrDescuentos_estudios').setValue(stliquida.getAt(0).get('vlrDescuentos'));
                    Ext.getCmp('sysVlrNeto_estudios').setValue(stliquida.getAt(0).get('vlrNeto'));
                    Ext.getCmp('fYaLiquidado').setValue(1);
                    
                    //Ext.getCmp('fExento').setValue(1);
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'La Orden de Servicio no esta disponible y no podemos realizar la liquidación',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    SelectRangoSalarial: function(cmb, rec, idx) {
        Ext.getCmp('fPorCopagos').setValue(rec.data.Porcentaje);
        Ext.getCmp('fMaxCopago').setValue(rec.data.TopeEvento);
        Ext.getCmp('fvlrCuotaModeradoraIndicada').setValue(rec.data.VlrCuotaModeradora);
    },
    ValidarNumeroDocumentoPacSK: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            Ext.getCmp('fPacienteValido').setValue(0);
            Ext.getCmp('fGenero').setValue("");
            Ext.getCmp('fApe1').setValue("");
            Ext.getCmp('fApe2').setValue("");
            Ext.getCmp('fNom1').setValue("");
            Ext.getCmp('fNom2').setValue("");
            Ext.getCmp('fEdad').setValue("");
            Ext.getCmp('fDeptoMuni').setValue("");
            Ext.getCmp('fDireccion').setValue("");
            Ext.getCmp('fZona').setValue("");
            Ext.getCmp('fTel1').setValue("");
            Ext.getCmp('fTel2').setValue("");
            Ext.getCmp('fEmail').setValue("");
            Ext.getCmp('fFecNac').setValue("");
            Ext.getCmp('fEdad').setValue("");
            Ext.getCmp('fRegimen').setValue(1);
            Ext.getCmp('fTafiliado').setValue("");
            Ext.getCmp('fParentesco').setValue("");
            Ext.getCmp('fRango').setValue("");
            Ext.getCmp('fEstado').setValue("");
            Ext.getCmp('fPacienteValido').setValue(0);
            Ext.Msg.wait('Cargando Información del Paciente... por favor espere!');
            Ext.Ajax.request(
            {
                url: '../../controlador/pacientes/pacientes_cargardatos.php',
                params:{
                    pTdoc: Ext.getCmp('fTdoc').getValue(),
                    pDocumento: Ext.getCmp('fDocID').getValue()
                },
                success: function(response,options)
                {
                    var el = Ext.get('response'); 
                    var Respuesta = response.responseText;
                    var Contenido = Respuesta.split('^');
                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                        Ext.Msg.hide();
                        Ext.getCmp('fIdPaciente').setValue(0);
                        verListadoAtencion(Ext.getCmp('fIdEmpresa').getValue(),Ext.getCmp('fIdSede').getValue(),Ext.getCmp('fIdIPS').getValue(), Ext.getCmp('fTdoc').getValue(),Ext.getCmp('fDocID').getValue(),true,Ext.getCmp('fIdPaciente').getValue(),"Radicacion");
                        if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                            Ext.getCmp('fPacienteValido').setValue(1);
                    } else {
                        Ext.getCmp('fIdPaciente').setValue(Contenido[0]);
                        Ext.getCmp('fTdoc').setValue(Contenido[1]);
                        Ext.getCmp('fGenero').setValue(Contenido[9]);
                        Ext.getCmp('fApe1').setValue(Contenido[3]);
                        Ext.getCmp('fApe2').setValue(Contenido[4]);
                        Ext.getCmp('fNom1').setValue(Contenido[5]);
                        Ext.getCmp('fNom2').setValue(Contenido[6]);
                        Ext.getCmp('fEdad').setValue(Contenido[8]);
                        Ext.getCmp('fDeptoMuni').setValue(Contenido[15]);
                        Ext.getCmp('fDireccion').setValue(Contenido[10]);
                        Ext.getCmp('fZona').setValue(Contenido[11]);
                        Ext.getCmp('fTel1').setValue(Contenido[12]);
                        Ext.getCmp('fTel2').setValue(Contenido[13]);
                        Ext.getCmp('fEmail').setValue(Contenido[14]);
                        if(Contenido[7] != null && Contenido[7] != ""){
                            var xfecnac = Contenido[7].split('-');
                            var dianac = xfecnac[0];
                            var mesnac = (xfecnac[1].length < 2)?'0':'';
                            mesnac += xfecnac[1];
                            var anonac = xfecnac[2];
                            Ext.getCmp('fFecNac').setValue(dianac + "-" + mesnac + "-" + anonac);
                            Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fFecNac').getValue().format('Y/m/d')));
                        }
                        Ext.Ajax.request(
                        {
                            url: '../../controlador/pacientes/pacientes_sedeips.php',
                            params:{
                                pPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                pIPS: Ext.getCmp('fIdIPS').getValue()
                            },
                            success: function(response,options)
                            {
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null)
                                    if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                                        Ext.getCmp('fPacienteValido').setValue(1);
                                else
                                    Ext.getCmp('fPacienteValido').setValue(1);
                            },
                            failure: function(response,options){
                                if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                                    Ext.getCmp('fPacienteValido').setValue(1);
                            },
                            scope:this 
                        });
                        Ext.Msg.hide();
                        verListadoAtencion(Ext.getCmp('fIdEmpresa').getValue(),Ext.getCmp('fIdSede').getValue(),Ext.getCmp('fIdIPS').getValue(), Ext.getCmp('fTdoc').getValue(),Ext.getCmp('fDocID').getValue(),true,Ext.getCmp('fIdPaciente').getValue(),"Radicacion");
                    }
                },
                failure: function(response,options){
                    var el = Ext.get('response');
                    alert("error al comunicarse con el servidor.");
                },
                scope:this 
            });       
        }
    },
    DelConceptoDetalle:function(){
        if (Ext.getCmp('fCas').getValue() != 0 && Ext.getCmp('fModificaCAS').getValue() == 1)
        {
            if(Ext.getCmp('gridServicios').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridServicios').selModel.getSelections();
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea eliminar el concepto ' + selections[0].json.Descripcion + ' ?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnBorrarConcepto(selections[0].json.ConsecutivoDetalle);
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'La Orden de Servicio no esta disponible y no podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    EditConceptoDetalle:function(){
        if(parseInt(Ext.getCmp('fCas').getValue()) !== 0 && parseInt(Ext.getCmp('fModificaCAS').getValue()) === 1 && (parseInt(Ext.getCmp('fYaLegalizado').getValue()) === 0 || parseInt(Ext.getCmp('fYaLegalizado').getValue()) === "") && (parseInt(Ext.getCmp('fYaFacturadoEnt').getValue()) === 0 || Ext.getCmp('fYaFacturadoEnt').getValue() === null || Ext.getCmp('fYaFacturadoEnt').getValue() === "")){
            if (Ext.getCmp('fCas').getValue() != 0 && Ext.getCmp('fModificaCAS').getValue() == 1)
                if(Ext.getCmp('gridServicios').selModel.getCount() == 1){
                    var selections = Ext.getCmp('gridServicios').selModel.getSelections();
                    if(selections[0].json.IdSolicitudServicio == 0 || selections[0].json.IdSolicitudServicio == "" || selections[0].json.IdSolicitudServicio == "null"){
                        if(selections[0].json.YaFacturadoEnt==1){
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'El concepto ya esta facturado y no se puede modificar.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }else{
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Esta seguro que desea modificar el concepto ' + selections[0].json.Descripcion + ' ?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn){
                                    if(btn=="yes"){
                                        AddEditConcepto('edit', Ext.getCmp('fCas').getValue(), ID_USUARIO, selections[0].json.ConsecutivoDetalle, selections[0].json.idConcepto,selections[0].json.Codigo,selections[0].json.Descripcion,selections[0].json.Cantidad,selections[0].json.VlrTarifa,selections[0].json.VlrTotal,selections[0].json.VlrCuotaModeradora,selections[0].json.VlrIVA,selections[0].json.VlrNeto, selections[0].json.VlrCopago, selections[0].json.PorIVA, selections[0].json.PorAplicacion, selections[0].json.VlrDescuentos, selections[0].json.Observaciones, selections[0].json.TipoRegistroDetalle,selections[0].json.IdProveedor,selections[0].json.NotasProveedor,selections[0].json.FechaRealizado,selections[0].json.YaRealizado,selections[0].json.FecProgramacionProveedor,selections[0].json.FecProveedor,selections[0].json.HoraProgramacionProveedor,selections[0].json.YaProgramadoProveedor,selections[0].json.GenerarAutizacionProveedor,selections[0].json.nomProveedor,selections[0].json.YaFacturadoEnt,selections[0].json.NroFactura, selections[0].json.TarifaProveedor, selections[0].json.OrganoProveedor, selections[0].json.TipoRegProced, selections[0].json.DiagPpal, selections[0].json.NomDiagPpal, selections[0].json.DiagRel1, selections[0].json.NomDiagRel1, selections[0].json.DiagRel2, selections[0].json.NomDiagRel2, selections[0].json.DiagRel3, selections[0].json.NomDiagRel3, selections[0].json.TipDagnostico, selections[0].json.CausaExterna, selections[0].json.Ambito, selections[0].json.FinalidadConsulta, selections[0].json.Finalidad, selections[0].json.PersonaAtiende, selections[0].json.FormaActo);
                                        Ext.getCmp('fsRIPSAC').setVisible(false);
                                        Ext.getCmp('fsRIPSAP').setVisible(false);
                                        Ext.getCmp('fsAutorizaProveedores').setVisible(true);
                                        Ext.getCmp('memObservaciones_conceptos').setValue(null);
                                        Ext.getCmp('memObservaciones_conceptos').setVisible(false);
                                        Ext.getCmp('intProveedor_conceptosOrgano').setValue(null);
                                        Ext.getCmp('intProveedor_conceptosOrgano').setVisible(false);
                                        Ext.getCmp('fecProveedor_conceptosFechaAtencion').setVisible(false);
                                        Ext.getCmp('fecProveedor_conceptosFechaRealiza').setVisible(false);
                                        Ext.getCmp('bolProveedor_conceptosYaRealiza').setVisible(false);
                                    }
                                }
                            });
                        }
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'El concepto no se puede modificar porque es solicitado por un profesional de la IPS.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'Debe guardar primero los datos básicos de la orden de servicios. y/o la Orden de Servicios No Esta Disponible para Modificarla',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Debe guardar primero los datos básicos de la orden de servicios. y/o la Orden de Servicios No Esta Disponible para Modificarla',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    AddConceptoPteAutorizarDetalle:function(){
        if(parseInt(Ext.getCmp('fCas').getValue()) !== 0 && parseInt(Ext.getCmp('fModificaCAS').getValue()) === 1 && (parseInt(Ext.getCmp('fYaLegalizado').getValue()) === 0 || parseInt(Ext.getCmp('fYaLegalizado').getValue()) === "") && (parseInt(Ext.getCmp('fYaFacturadoEnt').getValue()) === 0 || Ext.getCmp('fYaFacturadoEnt').getValue() === null || Ext.getCmp('fYaFacturadoEnt').getValue() === "")){
            if (Ext.getCmp('fCas').getValue() != 0 && Ext.getCmp('fModificaCAS').getValue() == 1){
                verPendientesxAutorizarxPaciente(Ext.getCmp('fIdPaciente').getValue(),PonerAcentosMayusculas(Ext.getCmp('fTdoc').getValue() + " " + Ext.getCmp('fDocID').getValue() + " - " + Ext.getCmp('fNom1').getValue() + " " + Ext.getCmp('fNom1').getValue() + " " + Ext.getCmp('fApe1').getValue() + " " + Ext.getCmp('fApe2').getValue()) + " - Genero: " + Ext.getCmp('fGenero').getValue() + " - Edad: " + Ext.getCmp('fEdad').getValue(),Ext.getCmp('fCas').getValue());
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'Debe guardar primero los datos básicos de la orden de servicios. y/o la Orden de Servicios No Esta Disponible para Modificarla',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Debe guardar primero los datos básicos de la orden de servicios. y/o la Orden de Servicios No Esta Disponible para Modificarla',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    AddConceptoDetalle:function(){
        if(parseInt(Ext.getCmp('fCas').getValue()) !== 0 && parseInt(Ext.getCmp('fModificaCAS').getValue()) === 1 && (parseInt(Ext.getCmp('fYaLegalizado').getValue()) === 0 || parseInt(Ext.getCmp('fYaLegalizado').getValue()) === "") && (parseInt(Ext.getCmp('fYaFacturadoEnt').getValue()) === 0 || Ext.getCmp('fYaFacturadoEnt').getValue() === null || Ext.getCmp('fYaFacturadoEnt').getValue() === "")){
            if (Ext.getCmp('fCas').getValue() != 0 && Ext.getCmp('fModificaCAS').getValue() == 1){
                AddEditConcepto('add', Ext.getCmp('fCas').getValue(), ID_USUARIO);
                Ext.getCmp('fsAutorizaProveedores').setVisible(true);
                Ext.getCmp('memObservaciones_conceptos').setValue(null);
                Ext.getCmp('memObservaciones_conceptos').setVisible(false);
                Ext.getCmp('intProveedor_conceptosOrgano').setValue(null);
                Ext.getCmp('intProveedor_conceptosOrgano').setVisible(false);
                Ext.getCmp('fecProveedor_conceptosFechaAtencion').setVisible(false);
                Ext.getCmp('fecProveedor_conceptosFechaRealiza').setVisible(false);
                Ext.getCmp('bolProveedor_conceptosYaRealiza').setVisible(false);
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'Debe guardar primero los datos básicos de la orden de servicios. y/o la Orden de Servicios No Esta Disponible para Modificarla',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Debe guardar primero los datos básicos de la orden de servicios. y/o la Orden de Servicios No Esta Disponible para Modificarla',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    BuscarDiagPpal:function(){
        ScriptMgr.loadJs({
            scripts : '../../frm_js/searchcie10/searchcie10.js',
            callback : function(){
                buscarcie10('fDiagPpal');
            }
        });
    },
    BuscarDiagRel1:function(){
        buscarcie10('fDiagRel1');
    },
    BuscarDiagRel2:function(){
        buscarcie10('fDiagRel2');
    },
    GuardarResumenHC: function(){
        if (Ext.getCmp('fCas').getValue() != 0 && Ext.getCmp('fModificaCAS').getValue() == 1)
        {
            var frm = Ext.getCmp('frmResumenHC').getForm();
            if ( frm.isValid() )
            {
                Ext.Msg.show({
                    title: 'Radicar Servicios',
                    msg: 'Esta seguro que desea guardar la información del Resumen de HC',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            Ext.Msg.wait('Guardando Resumen de HC... por favor espere!');
                            Ext.Ajax.request(
                            {
                                url: '../../controlador/radicacionservicios/guardar_resumenhc.php',
                                params:{
                                    pCAS: Ext.getCmp('fCas').getValue(),
                                    pResumenHC: QuitarAcentosTxt(Ext.getCmp('fResumenHC').getValue()),
                                    pDiagPpal: Ext.getCmp('fDiagPpal').getValue(),
                                    pDiagRel1: Ext.getCmp('fDiagRel1').getValue(),
                                    pDiagRel2: Ext.getCmp('fDiagRel2').getValue()
                                },
                                success: function(response,options)
                                {
                                    var Respuesta = response.responseText;
                                    var Contenido = Respuesta.split('^');
                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                        Ext.MessageBox.show({
                                            title: 'Guardar Resumen HC',
                                            msg: 'Ocurrio un error al actualizar la información del resumen de HC o no se pudo establecer conexión con el servidor.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    } else {
                                        paso2 = true;
                                        Ext.MessageBox.show({
                                            title: 'Guardar Resumen HC',
                                            msg: 'Se guardo con exito la información del resumen de HC.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.INFO
                                        });
                                    }
                                },
                                failure: function(response,options){
                                    Ext.MessageBox.show({
                                        title: 'Guardar Resumen HC',
                                        msg: 'Ocurrio un error al actualizar la información del resumen de HC o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                },
                                scope:this
                            });
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Resumen HC',
                    msg: 'Por favor verifique los datos que son requeridos.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'Resumen HC',
                msg: 'Debe guardar primero los datos básicos de la orden de servicios. y/o la Orden de Servicios No Esta Disponible para Modificarla',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ActualizaInfoPaciente: function(){
        if (Ext.getCmp('fIdPaciente').getValue() != 0 && Ext.getCmp('fApe1').isValid() && Ext.getCmp('fNom1').isValid() && Ext.getCmp('fRegimen').isValid() && Ext.getCmp('fGenero').isValid() && Ext.getCmp('fFecNac').isValid() && Ext.getCmp('fDeptoMuni').isValid() && Ext.getCmp('fDireccion').isValid() && Ext.getCmp('fTel1').isValid() && Ext.getCmp('fZona').isValid() && Ext.getCmp('fTafiliado').isValid() && Ext.getCmp('fRango').isValid())
        {
            Ext.Msg.show({
                title: 'Actualizar Paciente',
                msg: 'Esta seguro que desea actualizar la información del paciente',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        Ext.Ajax.request(
                        {
                            url: '../../controlador/pacientes/controlador_pacientes.php',
                            params:{
                                task: 'ACTUALIZAR',
                                pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                pTDoc: Ext.getCmp('fTdoc').getValue(),
                                pDocID: Ext.getCmp('fDocID').getValue(),
                                pRegimen: Ext.getCmp('fRegimen').getValue(),
                                pGenero: Ext.getCmp('fGenero').getValue(),
                                pApe1: QuitarAcentosTxt(Ext.getCmp('fApe1').getValue().toUpperCase()),
                                pApe2: QuitarAcentosTxt(Ext.getCmp('fApe2').getValue().toUpperCase()),
                                pNom1: QuitarAcentosTxt(Ext.getCmp('fNom1').getValue().toUpperCase()),
                                pNom2: QuitarAcentosTxt(Ext.getCmp('fNom2').getValue().toUpperCase()),
                                pFecNac: Ext.getCmp('fFecNac').getValue().format("Y-m-d"),
                                pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                pDireccion: QuitarAcentosTxt(Ext.getCmp('fDireccion').getValue().toUpperCase()),
                                pTel1: QuitarAcentosTxt(Ext.getCmp('fTel1').getValue().toUpperCase()),
                                pTel2: QuitarAcentosTxt(Ext.getCmp('fTel2').getValue().toUpperCase()),
                                pZona: Ext.getCmp('fZona').getValue(),
                                pEmail: QuitarAcentosTxt(Ext.getCmp('fEmail').getValue()),
                                pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                pParentesco: Ext.getCmp('fParentesco').getValue(),
                                pRango: Ext.getCmp('fRango').getValue(),
                                pEstado: Ext.getCmp('fEstado').getValue(),
                                pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                pIdSede: Ext.getCmp('fIdSede').getValue(),
                                pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                pUsuario: Ext.get('idusuario').getValue()
                            },
                            success: function(response,options)
                            {
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                    Ext.MessageBox.show({
                                        title: 'Actualizando Paciente',
                                        msg: 'Ocurrio un error al actualizar la información del paciente o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                } else {
                                    Ext.MessageBox.show({
                                        title: 'Actualizando Paciente',
                                        msg: 'Se actualizo la información del paciente con exito...!',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                }
                            },
                            failure: function(response,options){
                                Ext.MessageBox.show({
                                    title: 'Actualizando Paciente',
                                    msg: 'Ocurrio un error al actualizar la información del paciente o no se pudo establecer conexión con el servidor.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            },
                            scope:this
                        });
                    }
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Actualizando Paciente',
                msg: 'El Paciente no ha sido creado o por favor verifique los datos que son requeridos para actualizar el paciente.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    GuardarDatosBasicos: function(){
        if (Ext.getCmp('fModificaCAS').getValue() == 1)
        {
            var frm = Ext.getCmp('frmRadica').getForm();
            if ( frm.isValid() )
            {
                //if (Ext.getCmp('fPacienteValido').getValue() == 1)
                //{
                    Ext.Msg.show({
                        title: 'Radicar Servicios',
                        msg: 'Esta seguro que desea Radicar la información básica del servicio',
                        buttons: Ext.Msg.YESNO,
                        icon: Ext.Msg.QUESTION,
                        fn: function(btn)
                        {
                            if(btn=="yes")
                            {
                                Ext.Msg.wait('Guardando Radicación de Servicios... por favor espere!');
                                if (Ext.getCmp('fCas').getValue() == 0)
                                {
                                    Ext.Ajax.request(
                                    {
                                        url: '../../controlador/radicacionservicios/guardar_datosbasicos.php',
                                        params:{
                                            PROCESO: 'GuardarDatosBasicos',
                                            pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                            pTDoc: Ext.getCmp('fTdoc').getValue(),
                                            pDocID: Ext.getCmp('fDocID').getValue(),
                                            pRegimen: Ext.getCmp('fRegimen').getValue(),
                                            pGenero: Ext.getCmp('fGenero').getValue(),
                                            pApe1: QuitarAcentosTxt(Ext.getCmp('fApe1').getValue().toUpperCase()),
                                            pApe2: QuitarAcentosTxt(Ext.getCmp('fApe2').getValue().toUpperCase()),
                                            pNom1: QuitarAcentosTxt(Ext.getCmp('fNom1').getValue().toUpperCase()),
                                            pNom2: QuitarAcentosTxt(Ext.getCmp('fNom2').getValue().toUpperCase()),
                                            pFecNac: Ext.getCmp('fFecNac').getValue().format("Y-m-d"),
                                            pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                            pDireccion: QuitarAcentosTxt(Ext.getCmp('fDireccion').getValue().toUpperCase()),
                                            pTel1: QuitarAcentosTxt(Ext.getCmp('fTel1').getValue().toUpperCase()),
                                            pTel2: QuitarAcentosTxt(Ext.getCmp('fTel2').getValue().toUpperCase()),
                                            pZona: Ext.getCmp('fZona').getValue(),
                                            pEmail: QuitarAcentosTxt(Ext.getCmp('fEmail').getValue()),
                                            pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                            pParentesco: Ext.getCmp('fParentesco').getValue(),
                                            pRango: Ext.getCmp('fRango').getValue(),
                                            pEstado: Ext.getCmp('fEstado').getValue(),
                                            pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                            pIdSede: Ext.getCmp('fIdSede').getValue(),
                                            pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                            pUsuario: Ext.get('idusuario').getValue()
                                        },
                                        success: function(response,options)
                                        {
                                            var Respuesta = response.responseText;
                                            var Contenido = Respuesta.split('^');
                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                Ext.getCmp('fIdPaciente').setValue(0);
                                                Ext.Msg.hide();
                                                Ext.MessageBox.show({
                                                    title: 'Guardando Paciente',
                                                    msg: 'Ocurrio un error al guardar la información del paciente o no se pudo establecer conexión con el servidor.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            } else {
                                                Ext.getCmp('fIdPaciente').setValue(Contenido[0]);
                                                Ext.Ajax.request(
                                                {
                                                    url: '../../controlador/radicacionservicios/guardar_datosbasicos.php',
                                                    params:{
                                                        PROCESO: 'AsociarPacienteIPS',
                                                        pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                                        pIdIPS: Ext.getCmp('fIdIPS').getValue()
                                                    },
                                                    success: function(response,options){
                                                        var Respuesta1 = response.responseText;
                                                        var Contenido1 = Respuesta.split('^');
                                                        if(Contenido1[0]=="" || Contenido1[0]== "{success:false}" || Contenido1[0]== null){
                                                            Ext.getCmp('fIdPaciente').setValue(0);
                                                            Ext.Msg.hide();
                                                            Ext.MessageBox.show({
                                                                title: 'Guardando Paciente',
                                                                msg: 'Ocurrio un error al asociar el paciente a la IPS o no se pudo establecer conexión con el servidor.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        } else {
                                                            Ext.Ajax.request(
                                                            {
                                                                url: '../../controlador/radicacionservicios/guardar_datosbasicosipsbas1901.php',
                                                                params:{
                                                                    PROCESO: 'GenerarCAS',
                                                                    pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                                                    pRegimen: Ext.getCmp('fRegimen').getValue(),
                                                                    pEdad: Ext.getCmp('fEdad').getValue(),
                                                                    pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                                                    pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                                                    pParentesco: Ext.getCmp('fParentesco').getValue(),
                                                                    pRango: Ext.getCmp('fRango').getValue(),
                                                                    pEstado: Ext.getCmp('fEstado').getValue(),
                                                                    pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                                                    pIdSede: Ext.getCmp('fIdSede').getValue(),
                                                                    pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                                                    pExento: Ext.getCmp('fExento').getValue(),
                                                                    pTutela: Ext.getCmp('fTutela').getValue(),
                                                                    pCliente: Ext.getCmp('fCliente').getValue(),
                                                                    pPlan: Ext.getCmp('fPlan').getValue(),
                                                                    pSubPlan: Ext.getCmp('fSubPlan').getValue(),
                                                                    pContrato: Ext.getCmp('fContrato').getValue(),
                                                                    pUsaListado: Ext.getCmp('fUsaListado').getValue(),
                                                                    pAtenderFueraListado: Ext.getCmp('fAtenderFueraListado').getValue(),
                                                                    pRequiereAutorizacion: Ext.getCmp('fRequiereAutorizacion').getValue(),
                                                                    pFacturarParticular: Ext.getCmp('fFacturarParticular').getValue(),
                                                                    pFacturarCopagos: Ext.getCmp('fFacturarCopagos').getValue(),
                                                                    pCopagoDigitado: Ext.getCmp('fCopagoDigitado').getValue(),
                                                                    pPorCopagos: Ext.getCmp('fPorCopagos').getValue(),
                                                                    pMaxCopago: Ext.getCmp('fMaxCopago').getValue(),
                                                                    pvlrCuotaModeradoraIndicada: Ext.getCmp('fvlrCuotaModeradoraIndicada').getValue(),
                                                                    pFecSol: Ext.getCmp('fFecSol').getValue().format("Y-m-d"),
                                                                    pPrograma: Ext.getCmp('fPrograma').getValue(),
                                                                    pAutorizacion: Ext.getCmp('fAutorizacion').getValue().toUpperCase(),
                                                                    pProfeSol: Ext.getCmp('fProfeSol').getValue(),
                                                                    pIPSSol: Ext.getCmp('fIPSSolicita').getValue(),
                                                                    pEspecialidadSol: Ext.getCmp('fEspecialidadSol').getValue(),
                                                                    pDxSol: Ext.getCmp('fDiagPpal').getValue(),
                                                                    pFinalidad: Ext.getCmp('fFinalidad').getValue(),
                                                                    pExentoPrograma: Ext.getCmp('fExentoPrograma').getValue(),
                                                                    pOrigenAtencion: Ext.getCmp('fOrigenAtencion').getValue(),
                                                                    pEsLaboratorio: Ext.getCmp('fEsLaboratorio').getValue(),
                                                                    pUsuario: Ext.get('idusuario').getValue()
                                                                },
                                                                success: function(response,options){
                                                                    var Respuesta1 = response.responseText;
                                                                    var Contenido1 = Respuesta1.split('^');
                                                                    if(Contenido1[0]=="" || Contenido1[0]== "{success:false}" || Contenido1[0]== null){
                                                                        Ext.getCmp('fIdPaciente').setValue(0);
                                                                        Ext.Msg.hide();
                                                                        Ext.MessageBox.show({
                                                                            title: 'Guardando Estudio',
                                                                            msg: 'Ocurrio un error al generar el numero de CAS o no se pudo establecer conexión con el servidor.',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    } else {
                                                                        Ext.Msg.hide();
                                                                        Ext.getCmp('fYaActalizado').setValue(1);
                                                                        Ext.Msg.show({
                                                                            title: 'Generar Radicación de Servicios',
                                                                            msg: 'Se Genero la Radicacón de Servicios Nro: ' + Contenido1[0],
                                                                            buttons: Ext.Msg.OK,
                                                                            icon: Ext.MessageBox.INFO
                                                                        });
                                                                        Ext.getCmp('fCas').setValue(Contenido1[0]);
                                                                        Ext.getCmp('fNroCAS').setValue("CAS Nro: " + Contenido1[0]);
                                                                        Ext.getCmp('fFecRadicado').setValue(Contenido1[1]);
                                                                        paso1 = true;
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.Msg.hide();
                                                                    Ext.MessageBox.show({
                                                                        title: 'Guardando Estudio',
                                                                        msg: 'Ocurrio un error al generar el numero de CAS o no se pudo establecer conexión con el servidor.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                },
                                                                scope:this
                                                            });
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        Ext.Msg.hide();
                                                        Ext.MessageBox.show({
                                                            title: 'Guardando Paciente',
                                                            msg: 'Ocurrio un error al asociar el paciente a la IPS o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    },
                                                    scope:this
                                                });
                                            }
                                        },
                                        failure: function(response,options){
                                            Ext.Msg.hide();
                                            Ext.MessageBox.show({
                                                title: 'Generar Radicación de Servicios',
                                                msg: 'Error al Generar Nro de Radicación de Servicios, los campos son requeridos o no se pudo establecer conexión con el servidor.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        },
                                        scope:this
                                    });
                                }else{
                                    // Modificar CAS
                                    Ext.Ajax.request(
                                    {
                                        url: '../../controlador/pacientes/controlador_pacientes.php',
                                        params:{
                                            task: 'ACTUALIZAR',
                                            pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                            pTDoc: Ext.getCmp('fTdoc').getValue(),
                                            pDocID: Ext.getCmp('fDocID').getValue(),
                                            pRegimen: Ext.getCmp('fRegimen').getValue(),
                                            pGenero: Ext.getCmp('fGenero').getValue(),
                                            pApe1: QuitarAcentosTxt(Ext.getCmp('fApe1').getValue().toUpperCase()),
                                            pApe2: QuitarAcentosTxt(Ext.getCmp('fApe2').getValue().toUpperCase()),
                                            pNom1: QuitarAcentosTxt(Ext.getCmp('fNom1').getValue().toUpperCase()),
                                            pNom2: QuitarAcentosTxt(Ext.getCmp('fNom2').getValue().toUpperCase()),
                                            pFecNac: Ext.getCmp('fFecNac').getValue().format("Y-m-d"),
                                            pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                            pDireccion: QuitarAcentosTxt(Ext.getCmp('fDireccion').getValue().toUpperCase()),
                                            pTel1: QuitarAcentosTxt(Ext.getCmp('fTel1').getValue().toUpperCase()),
                                            pTel2: QuitarAcentosTxt(Ext.getCmp('fTel2').getValue().toUpperCase()),
                                            pZona: Ext.getCmp('fZona').getValue(),
                                            pEmail: QuitarAcentosTxt(Ext.getCmp('fEmail').getValue()),
                                            pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                            pParentesco: Ext.getCmp('fParentesco').getValue(),
                                            pRango: Ext.getCmp('fRango').getValue(),
                                            pEstado: Ext.getCmp('fEstado').getValue(),
                                            pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                            pIdSede: Ext.getCmp('fIdSede').getValue(),
                                            pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                            pUsuario: Ext.get('idusuario').getValue()
                                        },
                                        scope:this
                                    });
                                    Ext.Ajax.request(
                                    {
                                        url: '../../controlador/radicacionservicios/guardar_datosbasicosipsbas1901.php',
                                        params:{
                                            PROCESO: 'ModificarCAS',
                                            pCAS: Ext.getCmp('fCas').getValue(),
                                            pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                            pRegimen: Ext.getCmp('fRegimen').getValue(),
                                            pEdad: Ext.getCmp('fEdad').getValue(),
                                            pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                            pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                            pParentesco: Ext.getCmp('fParentesco').getValue(),
                                            pRango: Ext.getCmp('fRango').getValue(),
                                            pEstado: Ext.getCmp('fEstado').getValue(),
                                            pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                            pIdSede: Ext.getCmp('fIdSede').getValue(),
                                            pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                            pExento: Ext.getCmp('fExento').getValue(),
                                            pTutela: Ext.getCmp('fTutela').getValue(),
                                            pCliente: Ext.getCmp('fCliente').getValue(),
                                            pPlan: Ext.getCmp('fPlan').getValue(),
                                            pSubPlan: Ext.getCmp('fSubPlan').getValue(),
                                            pContrato: Ext.getCmp('fContrato').getValue(),
                                            pUsaListado: Ext.getCmp('fUsaListado').getValue(),
                                            pAtenderFueraListado: Ext.getCmp('fAtenderFueraListado').getValue(),
                                            pRequiereAutorizacion: Ext.getCmp('fRequiereAutorizacion').getValue(),
                                            pFacturarParticular: Ext.getCmp('fFacturarParticular').getValue(),
                                            pFacturarCopagos: Ext.getCmp('fFacturarCopagos').getValue(),
                                            pCopagoDigitado: Ext.getCmp('fCopagoDigitado').getValue(),
                                            pPorCopagos: Ext.getCmp('fPorCopagos').getValue(),
                                            pMaxCopago: Ext.getCmp('fMaxCopago').getValue(),
                                            pvlrCuotaModeradoraIndicada: Ext.getCmp('fvlrCuotaModeradoraIndicada').getValue(),
                                            pFecSol: Ext.getCmp('fFecSol').getValue().format("Y-m-d"),
                                            pPrograma: Ext.getCmp('fPrograma').getValue(),
                                            pAutorizacion: Ext.getCmp('fAutorizacion').getValue().toUpperCase(),
                                            pProfeSol: Ext.getCmp('fProfeSol').getValue(),
                                            pIPSSol: Ext.getCmp('fIPSSolicita').getValue(),
                                            pEspecialidadSol: Ext.getCmp('fEspecialidadSol').getValue(),
                                            pDxSol: Ext.getCmp('fDiagPpal').getValue(),
                                            pFinalidad: Ext.getCmp('fFinalidad').getValue(),
                                            pExentoPrograma: Ext.getCmp('fExentoPrograma').getValue(),
                                            pUsuario: Ext.get('idusuario').getValue()
                                        },
                                        success: function(response,options){
                                            var Respuesta1 = response.responseText;
                                            var Contenido1 = Respuesta1.split('^');
                                            if(Contenido1[0]=="" || Contenido1[0]== "{success:false}" || Contenido1[0]== null){
                                                Ext.getCmp('fIdPaciente').setValue(0);
                                                Ext.Msg.hide();
                                                Ext.MessageBox.show({
                                                    title: 'Guardando Estudio',
                                                    msg: 'Ocurrio un error al modificar el numero de CAS o no se pudo establecer conexión con el servidor.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            } else {
                                                Ext.Msg.hide();
                                                Ext.getCmp('fYaActalizado').setValue(1);
                                                Ext.Msg.show({
                                                    title: 'Generar Radicación de Servicios',
                                                    msg: 'Se Modifico la Radicacón de Servicios Nro: ' + Contenido1[0],
                                                    buttons: Ext.Msg.OK,
                                                    icon: Ext.MessageBox.INFO
                                                });
                                                paso1 = true;
                                            }
                                        },
                                        failure: function(response,options){
                                            Ext.Msg.hide();
                                            Ext.MessageBox.show({
                                                title: 'Guardando Estudio',
                                                msg: 'Ocurrio un error al modificar el numero de CAS o no se pudo establecer conexión con el servidor.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        },
                                        scope:this
                                    });
                                    // fin modifica cas
                                }                                   
                            }
                        }
                    });
                /*}else{
                    Ext.Msg.show({
                        title: 'Radicar Servicios - [Datos Básicos]',
                        msg: 'El paciente selccionado no pertenece a la IPS y no esta autorizado para este cliente atender fuera del listado de atención!',
                        buttons: Ext.Msg.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }*/
            }else{
                Ext.Msg.show({
                    title: 'Radicar Servicios - [Datos Básicos]',
                    msg: 'Existen campos obligatorios que están vacios..!',
                    buttons: Ext.Msg.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'La Orden de Servicio no esta disponible en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    VerificaListado: function(){
        if (Ext.getCmp('fTdoc').getValue() == "" || Ext.getCmp('fTdoc').getValue() == null || Ext.getCmp('fDocID').getValue() == "" || Ext.getCmp('fDocID').getValue() == null)
        {
            Ext.Msg.show({
                title: 'Verificación del Listado de Atención',
                msg: 'Debe ingresar los datos de tipo de documento y numero de documento del paciente.',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        } else {
            verListadoAtencion(Ext.getCmp('fIdEmpresa').getValue(),Ext.getCmp('fIdSede').getValue(),Ext.getCmp('fIdIPS').getValue(), Ext.getCmp('fTdoc').getValue(), Ext.getCmp('fDocID').getValue(),false,Ext.getCmp('fIdPaciente').getValue(),"Radicacion");
        }
    },
    Salir: function(){
        Ext.Msg.show({
            title: 'Salir',
            msg: 'Esta seguro que desea salir del sistema de radicación de servicios',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    NuevoServicio: function(){
        EsValido = false;
        Ext.Msg.show({
            title: 'Nuevo Registro',
            msg: 'Esta seguro que desea hacer un nuevo registro, si hace este se perdera la información ingresada hasta ahora',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmRadica').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    
                    frm = Ext.getCmp('frmResumenHC').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    frm = Ext.getCmp('frmLegalizar').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    Ext.getCmp('fIdPaciente').setValue(0);
                    Ext.getCmp('fCliente').clearValue();
                    Ext.getCmp('fPlan').clearValue();
                    Ext.getCmp('fSubPlan').clearValue();
                    Ext.getCmp('fContrato').clearValue();
                    Ext.getCmp('fCliente').setValue(null);
                    Ext.getCmp('fPlan').setValue(null);
                    Ext.getCmp('fSubPlan').setValue(null);
                    Ext.getCmp('fContrato').setValue(null);
                    Ext.getCmp('fPlan').store.removeAll(true);
                    Ext.getCmp('fSubPlan').store.removeAll(true);
                    Ext.getCmp('fContrato').store.removeAll(true);
                    Ext.getCmp('fYaActalizado').setValue(0);
                    Ext.getCmp('gridServicios').store.load({
                        params: {
                            pCAS: 0
                        }
                    });
                    Ext.getCmp('gridFacturacionOrden').store.load({
                        params: {
                            pEmpresa: ID_EMPRESA,
                            pCAS: 0
                        }
                    });
                    Ext.getCmp('gridServicios').store.removeAll();
                    Ext.getCmp('gridFacturacionOrden').store.removeAll();
                    Ext.getCmp('fClienteLA').setValue(0);
                    Ext.getCmp('fPlanLA').setValue(0);
                    Ext.getCmp('fSubPlanLA').setValue(0);
                    Ext.getCmp('fCliente').store.load({
                        params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}
                    });
                    Ext.getCmp('fPlan').disable();
                    Ext.getCmp('fSubPlan').disable();
                    Ext.getCmp('fNroCAS').setValue("Sin Registrar");
                    Ext.getCmp('fEstadoCAS').setValue("");
                    Ext.getCmp('fFecRadicado').setValue("");
                    Ext.getCmp('fPacienteValido').setValue(0);
                    paso1 = false;
                    paso2 = false;
                    paso3 = false;
                    paso4 = false;
                    paso5 = false;
                    Ext.getCmp('fYaLegalizado').setValue(0);
                    Ext.getCmp('fYaLiquidado').setValue(0);
                    Ext.getCmp('fCas').setValue(0);
                    Ext.getCmp('fModificaCAS').setValue(1);
                    Ext.getCmp('sysTipoLegalizacion_estudios').setValue("");
                    Ext.getCmp('sysResponsableLegalizacion_estudios').setValue("");
                    EstblecerCamposEnabled();
                    Ext.getCmp('gridServicios').store.removeAll();
                    Ext.getCmp('sysTextoEliminado').setValue("");
                    Ext.getCmp('btnReactivarCAS').setVisible(false);
                    Ext.getCmp('fDeptoMuni').setValue(ID_MUNICIPIO);
                }
            }
        });
    },
    LlamarAyuda : function(){
        MostrarAyuda(CodFrm);
    },
    UpdateDetalleSolMx: function(sm, rowIdx, r) {
        this.pnDetalleMx.update(r.data);
    },
    UpdateDetalleSolServicio: function(sm, rowIdx, r) {
        this.pnDetalleServicio.update(r.data);
    },
    CrearProfesionalSolicitante: function() {
        var winProfeSol = new winProfeSolUi();
        winProfeSol.title = 'eOfiClinic .::Adicionar Profesional Solicitante::.';
        Ext.getCmp('btn_AdicionarProfeSol').setVisible(true);
        Ext.getCmp('btn_ModificarProfeSol').setVisible(false);
        Ext.getCmp('sysUsuario').setVisible(false);
        Ext.getCmp('sysFechaAct').setVisible(false);
        Ext.getCmp('intUsuario').setValue(ID_USUARIO);
        winProfeSol.show();
    },
    ValidarPrograma: function(cmb, rec, idx) {
        this.fFinalidad.setValue(rec.data.Finalidad);
        this.fExentoPrograma.setValue(rec.data.Exento);
    },
    MostrarEdad: function(f) {
        Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),f.getValue().format('Y/m/d')));
    },
    ValidarParentesco: function(cmb, rec, idx) {
        if (cmb.getValue() != "C" && cmb.getValue() != "N"){
            this.fParentesco.enable();
            this.fParentesco.allowBlank = false;
        }else{
            this.fParentesco.clearValue();
            this.fParentesco.allowBlank = true;
            this.fParentesco.disable();
        }
    },
    ValidarRegimen: function(cmb, rec, idx) {
        this.fTafiliado.clearValue();
        this.fTafiliado.store.load({
            params: { 'pRegimen': cmb.getValue() }
        });
        this.fRango.clearValue();
        this.fRango.store.load({
            params: { 'pRegimen': cmb.getValue() }
        });
    },
    CargaCbPlan: function(cmb, rec, idx) {
        this.fUsaListado.setValue(rec.data.UsaListadoAtencion);
        this.fAtenderFueraListado.setValue(rec.data.AtenderFueraListado);
        this.fRequiereAutorizacion.setValue(rec.data.RequiereAutorizacion);
        if (Ext.getCmp('fAtenderFueraListado').getValue() == 1 && Ext.getCmp('fPacienteValido').getValue() == 0)
            Ext.getCmp('fPacienteValido').setValue(1);
        if (rec.data.RequiereAutorizacion == "1"){
            this.fAutorizacion.enable();
            this.fAutorizacion.allowBlank = false;
        }else{
            this.fAutorizacion.allowBlank = true;
            this.fAutorizacion.setValue(null);
            this.fAutorizacion.clearInvalid();
            this.fAutorizacion.disable();
        }
        this.fFacturarParticular.setValue(rec.data.FacturarParticular);
        Ext.getCmp('fFacturarCopagos').setValue(rec.data.FacturarCopagos);
        Ext.getCmp('fCopagoDigitado').setValue(rec.data.CopagoDigitado);
        this.fUsaAuditoria.setValue(rec.data.UsaAuditoria);
        Ext.Ajax.request(
        {
            url: '../../controlador/conceptos/matrizconceptosxcliente.php',
            params:{
                pIdTabla: "USR_" + ID_USUARIO,
                pCliente: cmb.getValue(),
                pIPS: ID_IPS,
                pEsParticular: rec.data.FacturarParticular,
                pUsaAuditoria: rec.data.UsaAuditoria
            },
            success: function(response,options){
                //alert("otro");
                if(Ext.getCmp('fCas').getValue() != 0)
                {
                    Ext.Ajax.request(
                    {
                        url: '../../controlador/radicacionservicios/liquidarorden.php',
                        params:{
                            pCAS: Ext.getCmp('fCas').getValue(),
                            pIdTabla: "USR_" + ID_USUARIO
                        },
                        success: function(response,options){
                            //alert(Ext.getCmp('fCopagoDigitado').getValue());
                            if (Ext.getCmp('fCopagoDigitado').getValue() == 0)
                            {
                                Ext.Ajax.request(
                                {
                                    url: '../../controlador/radicacionservicios/calcularcopagos.php',
                                    params:{
                                        pCAS: Ext.getCmp('fCas').getValue(),
                                        pPorcentajeCopago: Ext.getCmp('fPorCopagos').getValue(),
                                        pMaxCopago: Ext.getCmp('fMaxCopago').getValue(),
                                        pVlrRango: Ext.getCmp('fvlrCuotaModeradoraIndicada').getValue(),
                                        pTipoAfiliado: Ext.getCmp('fTafiliado').getValue(),
                                        pFacturarPart: Ext.getCmp('fFacturarParticular').getValue(),
                                        pFacturaCopago: Ext.getCmp('fFacturarCopagos').getValue(),
                                        pExento: Ext.getCmp('fExentoPrograma').getValue()
                                    },
                                    success: function(response,options){
                                        Ext.getCmp('gridServicios').store.load({
                                            params: {
                                                pCAS: Ext.getCmp('fCas').getValue()
                                            }
                                        });
                                    },
                                    scope:this 
                                });
                            }
                        },
                        scope:this 
                    });
                }
            },
            failure: function(response,options){
                Ext.MessageBox.show({
                    title: 'Cargando Matriz de Conceptos',
                    msg: 'Ocurrio un error al al cargar la matriz de conceptos o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            },
            scope:this
        });
        //jorge
        this.fPlan.clearValue();
        this.fSubPlan.clearValue();
        this.fContrato.clearValue();
        Ext.getCmp('fPlan').store.removeAll(true);
        Ext.getCmp('fSubPlan').store.removeAll(true);
        Ext.getCmp('fContrato').store.removeAll(true);
        this.fPlan.store.load({
            params: { 'pCliente': cmb.getValue() }
        });
        this.fPlan.enable();
        this.fContrato.store.load({
            params: { 'pCliente': cmb.getValue() }
        });
        this.fContrato.enable();
        if (Ext.getCmp('fClienteLA').getValue() == 0)
            this.fEstado.clearValue();
        if (this.fUsaListado.getValue() == "1"){
            this.fEstado.enable();
            this.fEstado.allowBlank = false;
        } else {
            this.fEstado.disable();
            this.fEstado.allowBlank = true;
        }
        
    },
    CargaCbSubPlan: function(cmb, rec, idx) {
        this.fSubPlan.clearValue();
        Ext.getCmp('fSubPlan').store.removeAll(true);
        //alert(Ext.getCmp('fSubPlanLA').getValue());
        //if (Ext.getCmp('fSubPlanLA').getValue() == 0)
        //{
            this.fSubPlan.store.load({
                params: { 'pPlan': cmb.getValue() }
            });
        //}
        this.fSubPlan.enable();
    }
});

function EstblecerCamposEnabled(){
    Ext.getCmp('fTdoc').enable();
    Ext.getCmp('fDocID').enable();
    Ext.getCmp('fRegimen').enable();
    Ext.getCmp('fGenero').enable();
    Ext.getCmp('fApe1').enable();
    Ext.getCmp('fApe2').enable();
    Ext.getCmp('fNom1').enable();
    Ext.getCmp('fNom2').enable();
    Ext.getCmp('fFecNac').enable();
    Ext.getCmp('fDeptoMuni').enable();
    Ext.getCmp('fDireccion').enable();
    Ext.getCmp('fTel1').enable();
    Ext.getCmp('fTel2').enable();
    Ext.getCmp('fZona').enable();
    Ext.getCmp('fEmail').enable();
    Ext.getCmp('fTafiliado').enable();
    Ext.getCmp('fRango').enable();
    Ext.getCmp('fCliente').enable();
    Ext.getCmp('fFecSol').enable();
    Ext.getCmp('fPrograma').enable();
    Ext.getCmp('fOrigenAtencion').enable();
    Ext.getCmp('fEsLaboratorio').enable();
    Ext.getCmp('fProfeSol').enable();
    Ext.getCmp('fEspecialidadSol').enable();
    Ext.getCmp('fDiagPpal').enable();
    if(Ext.getCmp('fProfeSol').getValue() == "0"){
        Ext.getCmp('fProfeSol').setValue(null);
    }
    if(Ext.getCmp('fEspecialidadSol').getValue() == "0"){
        Ext.getCmp('fEspecialidadSol').setValue(null);
    }
    if(Ext.getCmp('fIPSSolicita').getValue() == null || Ext.getCmp('fEspecialidadSol').getValue() == ""){
        Ext.getCmp('fIPSSolicita').setValue(0);
    }
    
    
}

function EstblecerCamposDisabled(){
    Ext.getCmp('fTdoc').disable();
    Ext.getCmp('fDocID').disable();
    Ext.getCmp('fRegimen').disable();
    Ext.getCmp('fGenero').disable();
    Ext.getCmp('fApe1').disable();
    Ext.getCmp('fApe2').disable();
    Ext.getCmp('fNom1').disable();
    Ext.getCmp('fNom2').disable();
    Ext.getCmp('fFecNac').disable();
    Ext.getCmp('fDeptoMuni').disable();
    Ext.getCmp('fDireccion').disable();
    Ext.getCmp('fTel1').disable();
    Ext.getCmp('fTel2').disable();
    Ext.getCmp('fZona').disable();
    Ext.getCmp('fEmail').disable();
    Ext.getCmp('fTafiliado').disable();
    Ext.getCmp('fRango').disable();
    Ext.getCmp('fCliente').disable();
    Ext.getCmp('fFecSol').disable();
    Ext.getCmp('fPrograma').disable();
    Ext.getCmp('fProfeSol').disable();
    Ext.getCmp('fEspecialidadSol').disable();
    Ext.getCmp('fDiagPpal').disable();
}

function fnBorrarConcepto(wConsecutivoDetale)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: '../../controlador/radicacionservicios/guardar_datosbasicos.php',
        params:{
            PROCESO: 'EliminarConcepto',
            pConsecutivoDetalle: wConsecutivoDetale
        },
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    Ext.getCmp('gridServicios').store.removeAll();
                    Ext.getCmp('gridServicios').store.load({
                        params: {
                            pCAS: Ext.getCmp('fCas').getValue()
                        }
                    });
                    Ext.MessageBox.show({
                        title: 'eOfiClinic',
                        msg: 'Se elimino con exito el concepto seleccionado',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar los registros en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnBorrarCAS(wCAS)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: '../../controlador/radicacionservicios/legalizacioncas.php',
        params:{
            PROCESO: 'BORRAR_CAS',
            pEmpresa: ID_EMPRESA,
            pIPS: ID_IPS,
            pUsuario: ID_USUARIO,
            pCAS: wCAS
        },
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    var frm = Ext.getCmp('frmRadica').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    frm = Ext.getCmp('frmResumenHC').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    frm = Ext.getCmp('frmLegalizar').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    Ext.getCmp('fIdPaciente').setValue(0);
                    Ext.getCmp('fCliente').clearValue();
                    Ext.getCmp('fPlan').clearValue();
                    Ext.getCmp('fSubPlan').clearValue();
                    Ext.getCmp('fContrato').clearValue();
                    Ext.getCmp('fCliente').setValue(null);
                    Ext.getCmp('fPlan').setValue(null);
                    Ext.getCmp('fSubPlan').setValue(null);
                    Ext.getCmp('fContrato').setValue(null);
                    Ext.getCmp('gridServicios').store.load({
                        params: {
                            pCAS: 0
                        }
                    });
                    Ext.getCmp('gridFacturacionOrden').store.load({
                        params: {
                            pEmpresa: ID_EMPRESA,
                            pCAS: 0
                        }
                    });
                    Ext.getCmp('gridServicios').store.removeAll();
                    Ext.getCmp('gridFacturacionOrden').store.removeAll();
                    Ext.getCmp('fClienteLA').setValue(0);
                    Ext.getCmp('fPlanLA').setValue(0);
                    Ext.getCmp('fSubPlanLA').setValue(0);
                    Ext.getCmp('fCliente').store.load({
                        params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}
                    });
                    Ext.getCmp('fPlan').disable();
                    Ext.getCmp('fSubPlan').disable();
                    Ext.getCmp('fNroCAS').setValue("Sin Registrar");
                    Ext.getCmp('fEstadoCAS').setValue("");
                    Ext.getCmp('fFecRadicado').setValue("");
                    Ext.getCmp('fPacienteValido').setValue(0);
                    paso1 = false;
                    paso2 = false;
                    paso3 = false;
                    paso4 = false;
                    paso5 = false;
                    Ext.getCmp('fYaLegalizado').setValue(0);
                    Ext.getCmp('fYaLiquidado').setValue(0);
                    Ext.getCmp('fCas').setValue(0);
                    Ext.getCmp('fModificaCAS').setValue(1);
                    Ext.getCmp('sysTipoLegalizacion_estudios').setValue("");
                    Ext.getCmp('sysResponsableLegalizacion_estudios').setValue("");
                    EstblecerCamposEnabled();
                    Ext.MessageBox.show({
                        title: 'eOfiClinic',
                        msg: 'Se elimino la orden de servicio con exito',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar la orden de servicio en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar la orden de servicio en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}