/*
* @category    Formulario RIPS Hospitalizacion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winRIPSHospitaliza001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: RIPS AH ::.',
    width: 927,
    autoHeight: true, //670,
    autoScroll: true,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winRIPSAH',
    initComponent: function() {
        var dataViaIngresoAH = [
            [1,'1 - Urgencias'],
            [2,'2 - Consulta externa o Programada'],
            [3,'3 - Remitido'],
            [4,'4 - Nacido en la Institucion']
        ];
        var stViaIngresoAH = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stViaIngresoAH.loadData(dataViaIngresoAH);
        var dataEstadoSalidaAH = [
            [1,'1 - Vivo'],
            [2,'2 - Muerto']
        ];
        var stEstadoSalidaAH = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stEstadoSalidaAH.loadData(dataEstadoSalidaAH);    
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmRIPSAHIngreso',
                padding: 2,
                labelSeparator: '',
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'DATOS DEL INGRESO',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        tbar:{
                            items: [
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Guardar',
                                    iconCls: 'btnGuardar',
                                    listeners:{
                                        click : function(){
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Esta seguro que desea Guardar los datos del Ingreso del RIPS?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn === "yes"){
                                                        fnGuardarRegistrosRIPSAH("Ingreso");
                                                    }
                                                }
                                            });
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                value: 0,
                                id: 'sysYaGuardoRIPSAH'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuarioRIPSAH'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 130,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'CAS',
                                        id: 'sysCASRIPSAH'
                                    },
                                    {
                                        html: 'Paciente:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 575,
                                        allowBlank: true,
                                        readOnly: true,
                                        //fieldLabel: 'Paciente',
                                        //value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteRIPSAH'
                                    }
                                ]
                            },
                            {
                                html: '<hr>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Via Ingreso',
                                        width: 220,
                                        name: 'Via Ingreso',
                                        allowBlank: false,
                                        store: stViaIngresoAH,
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'strViaIngresoRIPSAH'
                                    },
                                    {
                                        html: 'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Ingreso',
                                        allowBlank: false,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFechaIngresoRIPSAH',
                                        listeners: {
                                            change: function(t, newValue, oldValue){
                                                if (Date.parse(Ext.getCmp('fecFechaIngresoRIPSAH').getValue()) > Date.parse(Ext.getCmp('fecFechaSalidaRIPSAH').getValue())){
                                                    Ext.MessageBox.show({
                                                        title: 'RIPS AH',
                                                        msg: 'La fecha de ingreso no puede ser mayor a la fecha de egreso.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                    Ext.getCmp('fecFechaIngresoRIPSAH').setValue(null);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Hora'
                                    },
                                    {
                                        xtype: 'timefield',
                                        width: 95,
                                        allowBlank: false,
                                        forceSelection: false,
                                        emptyText: '(hh:mm)',
                                        format: 'H:i',
                                        altFormats:'H:i',
                                        id: 'strHoraIngresoRIPSAH',
                                        listeners: {
                                            change: function(t, newValue, oldValue){
                                                if (Date.parse(Ext.getCmp('fecFechaIngresoRIPSAH').getValue()) === Date.parse(Ext.getCmp('fecFechaSalidaRIPSAH').getValue())){
                                                    if (Ext.getCmp('strHoraIngresoRIPSAH').getValue() !== "" && Ext.getCmp('strHoraIngresoRIPSAH').getValue() !== null && Ext.getCmp('strHoraSalidaRIPSAH').getValue() !== "" && Ext.getCmp('strHoraSalidaRIPSAH').getValue() !== null){
                                                        var HoraIni;
                                                        var MinIni;
                                                        var HoraFin;
                                                        var MinFin;
                                                        HoraIni = parseInt(Ext.getCmp('strHoraIngresoRIPSAH').getValue().substring(0, 2));
                                                        MinIni = parseInt(Ext.getCmp('strHoraIngresoRIPSAH').getValue().substring(3, 5));
                                                        HoraFin = parseInt(Ext.getCmp('strHoraSalidaRIPSAH').getValue().substring(0, 2));
                                                        MinFin = parseInt(Ext.getCmp('strHoraSalidaRIPSAH').getValue().substring(3, 5));
                                                        if(HoraIni <= HoraFin){
                                                            if(HoraIni === HoraFin){
                                                                if(MinIni > MinFin){
                                                                    Ext.MessageBox.show({
                                                                        title: 'RIPS AH',
                                                                        msg: 'La hora de ingreso no puede ser mayor a la hora de egreso.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                    Ext.getCmp('strHoraIngresoRIPSAH').setValue(null);
                                                                }
                                                            }
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'RIPS AH',
                                                                msg: 'La hora de ingreso no puede ser mayor a la hora de egreso.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                            Ext.getCmp('strHoraIngresoRIPSAH').setValue(null);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Autorizacion'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Autorizacion',
                                        width: 160,
                                        allowBlank: true,
                                        id: 'strAutorizacionRIPSAH'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Causa Externa',
                                anchor: '100%',
                                name: 'Causa Externa',
                                allowBlank: false,
                                store: 'StoreCausaExterna',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                value: 13,
                                id: 'strCausaExternaRIPSAH'/*,
                                listeners: {
                                    focus: function(t){
                                        html = '<table><tr><td width="470">Del 1 al 12 son las causas externas que mas interesan para la vigilancia de la salud pública.<br>Si  hubieren  otras  causas  externas  no contempladas en estas 12, deben seleccionar el  valor:  15  otra;  y  si  se  requiere  una  mayor precisión en  la  causa que  originó la  atención pueden  hacerlo  en  el  campo  de  diagnóstico relacionado,  con  los  diagnósticos  de  los capítulo XX, letras V a la Y.<br><br>Si algún diagnóstico empieza con S, T no se acepta Causa Externa = 13 ó 15</td></tr></table>';
                                        Sexy.info(html);
                                    }
                                }*/
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: false,
                                        fieldLabel: 'Dx Ingreso',
                                        name: 'Diagnostico Ingreso',
                                        id: 'strDiagIngresoRIPSAH',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagIngresoRIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagIngresoRIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagIngresoRIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagIngresoRIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagIngresoRIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagIngresoRIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagIngresoRIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagIngresoRIPSAHNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagIngresoRIPSAHNom').getValue() === null || Ext.getCmp('sysDiagIngresoRIPSAHNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagIngresoRIPSAH').getValue() !== "" && Ext.getCmp('strDiagIngresoRIPSAH').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagIngresoRIPSAH').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagIngresoRIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagIngresoRIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagIngresoRIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagIngresoRIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagIngresoRIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagIngresoRIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagIngresoRIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagIngresoRIPSAHNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagIngresoRIPSAHNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Ingreso',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagIngresoRIPSAH','sysDiagIngresoRIPSAHNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                anchor: '100%',
                                fieldLabel: 'Profesional',
                                allowBlank: false,
                                store: 'StoreProfesionales',
                                forceSelection: true,
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                emptyText: 'Seleccione Profesional Ingeso....',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                id: 'intProfesionalIngresoRIPSAH'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Nro Habitacion',
                                        name: 'Nro Habitacion',
                                        width: 100,
                                        allowBlank: true,
                                        id: 'strHabitacionRIPSAH'
                                    },
                                    {
                                        html: 'Cama:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Nro Cama',
                                        width: 100,
                                        allowBlank: true,
                                        id: 'strCamaRIPSAH'
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmRIPSAHEgreso',
                labelSeparator: '',
                padding: 2,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'DATOS DEL EGRESO',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        tbar:{
                            items: [
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Guardar',
                                    iconCls: 'btnGuardar',
                                    listeners:{
                                        click : function(){
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Esta seguro que desea Guardar los datos del Egreso del RIPS?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn === "yes"){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/asistencial/evolucionhc2013.php',
                                                            waitMsg: 'Cargando Información...',
                                                            params:{
                                                                task: 'RIPSAH_INGRESO_VERIFICA',
                                                                pCAS: Ext.getCmp('sysCASRIPSAH').getValue()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}" || Contenido[0] === null){
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'Debe guardar primero los datos del ingreso del RIPS.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                } else {
                                                                    fnGuardarRegistrosRIPSAH("Egreso");
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                Ext.MessageBox.show({
                                                                    title: 'Error',
                                                                    msg: 'Debe guardar primero los datos del ingreso del RIPS y/o No se pudo establecer conexion con el servidor.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            },
                                                            scope: this 
                                                        });
                                                        
                                                    }
                                                }
                                            });
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: false,
                                        fieldLabel: 'Diagnostico Salida',
                                        name: 'Diagnostico Salida',
                                        id: 'strDiagSalidaRIPSAH',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalidaRIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagSalidaRIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalidaRIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalidaRIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalidaRIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagSalidaRIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalidaRIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagSalidaRIPSAHNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagSalidaRIPSAHNom').getValue() === null || Ext.getCmp('sysDiagSalidaRIPSAHNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagSalidaRIPSAH').getValue() !== "" && Ext.getCmp('strDiagSalidaRIPSAH').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagSalidaRIPSAH').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalidaRIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagSalidaRIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalidaRIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalidaRIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalidaRIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagSalidaRIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalidaRIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagSalidaRIPSAHNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagSalidaRIPSAHNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Salida',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagSalidaRIPSAH','sysDiagSalidaRIPSAHNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Rel1',
                                        name: 'Diagnostico Salida1',
                                        id: 'strDiagSalida1RIPSAH',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida1RIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida1RIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida1RIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida1RIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida1RIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagSalida1RIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida1RIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagSalida1RIPSAHNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagSalida1RIPSAHNom').getValue() === null || Ext.getCmp('sysDiagSalida1RIPSAHNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagSalida1RIPSAH').getValue() !== "" && Ext.getCmp('strDiagSalida1RIPSAH').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagSalida1RIPSAH').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida1RIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida1RIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida1RIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida1RIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida1RIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagSalida1RIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida1RIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagSalida1RIPSAHNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagSalida1RIPSAHNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Salida Rel1',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagSalida1RIPSAH','sysDiagSalida1RIPSAHNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Rel2',
                                        name: 'Diagnostico Salida2',
                                        id: 'strDiagSalida2RIPSAH',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida2RIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida2RIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida2RIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida2RIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida2RIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagSalida2RIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida2RIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagSalida2RIPSAHNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagSalida2RIPSAHNom').getValue() === null || Ext.getCmp('sysDiagSalida2RIPSAHNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagSalida2RIPSAH').getValue() !== "" && Ext.getCmp('strDiagSalida2RIPSAH').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagSalida2RIPSAH').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida2RIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida2RIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida2RIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida2RIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida2RIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagSalida2RIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida2RIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagSalida2RIPSAHNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagSalida2RIPSAHNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Salida Rel2',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagSalida2RIPSAH','sysDiagSalida2RIPSAHNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Rel3',
                                        name: 'Diagnostico Salida3',
                                        id: 'strDiagSalida3RIPSAH',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida3RIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida3RIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida3RIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida3RIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida3RIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagSalida3RIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida3RIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagSalida3RIPSAHNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagSalida3RIPSAHNom').getValue() === null || Ext.getCmp('sysDiagSalida3RIPSAHNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagSalida3RIPSAH').getValue() !== "" && Ext.getCmp('strDiagSalida3RIPSAH').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagSalida3RIPSAH').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida3RIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida3RIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida3RIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida3RIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida3RIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagSalida3RIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida3RIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagSalida3RIPSAHNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagSalida3RIPSAHNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Salida Rel3',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagSalida3RIPSAH','sysDiagSalida3RIPSAHNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Dx Complicacion',
                                        name: 'Diagnostico Salida4',
                                        id: 'strDiagSalida4RIPSAH',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida4RIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida4RIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida4RIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida4RIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida4RIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagSalida4RIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida4RIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagSalida4RIPSAHNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagSalida4RIPSAHNom').getValue() === null || Ext.getCmp('sysDiagSalida4RIPSAHNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagSalida4RIPSAH').getValue() !== "" && Ext.getCmp('strDiagSalida4RIPSAH').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagSalida4RIPSAH').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida4RIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida4RIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida4RIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida4RIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida4RIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagSalida4RIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida4RIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagSalida4RIPSAHNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagSalida4RIPSAHNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Salida Complicacion',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagSalida4RIPSAH','sysDiagSalida4RIPSAHNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Estado',
                                anchor: '100%',
                                name: 'Estado',
                                allowBlank: false,
                                store: stEstadoSalidaAH,
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                id: 'strEstadoRIPSAH',
                                listeners: {
                                    select: function(cmb, rec, idx) {
                                        if(parseInt(cmb.getValue()) === 2){
                                            Ext.getCmp('strDiagCausaMuerteRIPSAH').allowBlank = false;
                                            Ext.getCmp('strDiagCausaMuerteRIPSAH').setDisabled(false);
                                            Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').setDisabled(false);
                                            Ext.getCmp('btnDiagCausaMuerteRIPSAH').setDisabled(false);
                                        }else{
                                            Ext.getCmp('strDiagCausaMuerteRIPSAH').allowBlank = true;
                                            Ext.getCmp('strDiagCausaMuerteRIPSAH').setDisabled(true);
                                            Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').setDisabled(true);
                                            Ext.getCmp('btnDiagCausaMuerteRIPSAH').setDisabled(true);
                                            Ext.getCmp('strDiagCausaMuerteRIPSAH').setValue(null);
                                            Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').setValue(null);
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        disabled: true,
                                        fieldLabel: 'Causa Muerte',
                                        id: 'strDiagCausaMuerteRIPSAH',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagCausaMuerteRIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagCausaMuerteRIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagCausaMuerteRIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagCausaMuerteRIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').getValue() === null || Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagCausaMuerteRIPSAH').getValue() !== "" && Ext.getCmp('strDiagCausaMuerteRIPSAH').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagCausaMuerteRIPSAH').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagCausaMuerteRIPSAH').setValue(null);
                                                                    Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagCausaMuerteRIPSAH').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagCausaMuerteRIPSAH').setValue(null);
                                                                Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagCausaMuerteRIPSAH').setValue(null);
                                                        Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        disabled: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagCausaMuerteRIPSAHNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        disabled: true,
                                        tooltip: 'Buscar Diagnostico Causa Muerte',
                                        id: 'btnDiagCausaMuerteRIPSAH',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagCausaMuerteRIPSAH','sysDiagCausaMuerteRIPSAHNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'Fecha Salida',
                                        name: 'Fecha Salida',
                                        allowBlank: false,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFechaSalidaRIPSAH',
                                        listeners: {
                                            change: function(t, newValue, oldValue){
                                                if (Date.parse(Ext.getCmp('fecFechaSalidaRIPSAH').getValue()) < Date.parse(Ext.getCmp('fecFechaIngresoRIPSAH').getValue())){
                                                    Ext.MessageBox.show({
                                                        title: 'RIPS AH',
                                                        msg: 'La fecha de egreso no puede ser menor a la fecha de ingreso.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                    Ext.getCmp('fecFechaSalidaRIPSAH').setValue(null);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Hora'
                                    },
                                    {
                                        xtype: 'timefield',
                                        width: 95,
                                        allowBlank: false,
                                        forceSelection: false,
                                        emptyText: '(hh:mm)',
                                        format: 'H:i',
                                        altFormats:'H:i',
                                        id: 'strHoraSalidaRIPSAH',
                                        listeners: {
                                            change: function(t, newValue, oldValue){
                                                if (Date.parse(Ext.getCmp('fecFechaIngresoRIPSAH').getValue()) === Date.parse(Ext.getCmp('fecFechaSalidaRIPSAH').getValue())){
                                                    if (Ext.getCmp('strHoraIngresoRIPSAH').getValue() !== "" && Ext.getCmp('strHoraIngresoRIPSAH').getValue() !== null && Ext.getCmp('strHoraSalidaRIPSAH').getValue() !== "" && Ext.getCmp('strHoraSalidaRIPSAH').getValue() !== null){
                                                        var HoraIni;
                                                        var MinIni;
                                                        var HoraFin;
                                                        var MinFin;
                                                        HoraIni = parseInt(Ext.getCmp('strHoraIngresoRIPSAH').getValue().substring(0, 2));
                                                        MinIni = parseInt(Ext.getCmp('strHoraIngresoRIPSAH').getValue().substring(3, 5));
                                                        HoraFin = parseInt(Ext.getCmp('strHoraSalidaRIPSAH').getValue().substring(0, 2));
                                                        MinFin = parseInt(Ext.getCmp('strHoraSalidaRIPSAH').getValue().substring(3, 5));
                                                        if(HoraFin >= HoraIni){
                                                            if(HoraIni === HoraFin){
                                                                if(MinFin < MinIni){
                                                                    Ext.MessageBox.show({
                                                                        title: 'RIPS AH',
                                                                        msg: 'La hora de egreso no puede ser menor a la hora de ingreso.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                    Ext.getCmp('strHoraSalidaRIPSAH').setValue(null);
                                                                }
                                                            }
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'RIPS AH',
                                                                msg: 'La hora de egreso no puede ser menor a la hora de ingreso.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                            Ext.getCmp('strHoraSalidaRIPSAH').setValue(null);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Profesional',
                                allowBlank: false,
                                store: 'StoreProfesionales',
                                forceSelection: true,
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                emptyText: 'Seleccione Profesional Salida....',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                anchor: '100%',
                                id: 'intProfesionalSalidaRIPSAH'
                            }
                        ]
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                Ext.Ajax.request({
                    url: '../../controlador/asistencial/evolucionhc2013.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        task: 'RIPSAH_INGRESO_LOAD',
                        pCAS: Ext.getCmp('sysCASRIPSAH').getValue()
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); // get the LOG
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                            // No Encontro Registros
                        } else {
                            if(Contenido[1] !== "" && Contenido[1] !== null)
                                Ext.getCmp('strViaIngresoRIPSAH').setValue(Contenido[1]);
                            if(Contenido[2] !== "" && Contenido[2] !== null)
                                Ext.getCmp('fecFechaIngresoRIPSAH').setValue(Contenido[2]);
                            if(Contenido[3] !== "" && Contenido[3] !== null)
                                Ext.getCmp('strHoraIngresoRIPSAH').setValue(Contenido[3]);
                            if(Contenido[4] !== "" && Contenido[4] !== null)
                                Ext.getCmp('strAutorizacionRIPSAH').setValue(Contenido[4]);
                            if(Contenido[5] !== "" && Contenido[5] !== null)
                                Ext.getCmp('strCausaExternaRIPSAH').setValue(Contenido[5]);
                            if(Contenido[6] !== "" && Contenido[6] !== null)
                                Ext.getCmp('strDiagIngresoRIPSAH').setValue(Contenido[6]);
                            if(Contenido[7] !== "" && Contenido[7] !== null)
                                Ext.getCmp('intProfesionalIngresoRIPSAH').setValue(Contenido[7]);
                            if(Contenido[8] !== "" && Contenido[8] !== null)
                                Ext.getCmp('strHabitacionRIPSAH').setValue(Contenido[8]);
                            if(Contenido[9] !== "" && Contenido[9] !== null)
                                Ext.getCmp('strCamaRIPSAH').setValue(Contenido[9]);
                            if(Contenido[10] !== "" && Contenido[10] !== null)
                                Ext.getCmp('strDiagSalidaRIPSAH').setValue(Contenido[10]);
                            if(Contenido[11] !== "" && Contenido[11] !== null)
                                Ext.getCmp('strDiagSalida1RIPSAH').setValue(Contenido[11]);
                            if(Contenido[12] !== "" && Contenido[11] !== null)
                                Ext.getCmp('strDiagSalida2RIPSAH').setValue(Contenido[12]);
                            if(Contenido[13] !== "" && Contenido[12] !== null)
                                Ext.getCmp('strDiagSalida3RIPSAH').setValue(Contenido[13]);
                            if(Contenido[14] !== "" && Contenido[13] !== null)
                                Ext.getCmp('strDiagSalida4RIPSAH').setValue(Contenido[14]);
                            if(Contenido[15] !== "" && Contenido[15] !== null){
                                Ext.getCmp('strEstadoRIPSAH').setValue(Contenido[15]);
                                if(parseInt(Contenido[15]) === 2){
                                    Ext.getCmp('strDiagCausaMuerteRIPSAH').allowBlank = false;
                                    Ext.getCmp('strDiagCausaMuerteRIPSAH').setDisabled(false);
                                    Ext.getCmp('sysDiagCausaMuerteRIPSAHNom').setDisabled(false);
                                    Ext.getCmp('btnDiagCausaMuerteRIPSAH').setDisabled(false);
                                    if(Contenido[16] !== "" && Contenido[16] !== null)
                                        Ext.getCmp('strDiagCausaMuerteRIPSAH').setValue(Contenido[16]);
                                }
                            }
                            if(Contenido[17] !== "" && Contenido[17] !== null)
                                Ext.getCmp('fecFechaSalidaRIPSAH').setValue(Contenido[17]);
                            if(Contenido[18] !== "" && Contenido[18] !== null)
                                Ext.getCmp('strHoraSalidaRIPSAH').setValue(Contenido[18]);
                            if(Contenido[19] !== "" && Contenido[19] !== null)
                                Ext.getCmp('intProfesionalSalidaRIPSAH').setValue(Contenido[19]);
                        }
                    },
                    failure: function(response,options){
                        var el = Ext.get('response');
                    },
                    scope: this 
                });
            }}
        });
        winRIPSHospitaliza001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosRIPSAH(wOpcion){
    var frm;
    var wTask;
    if(wOpcion === "Ingreso"){
        frm = Ext.getCmp('frmRIPSAHIngreso').getForm();
        wTask = 'RIPSAH_INGRESO_GUARDAR';
    }else{
        frm = Ext.getCmp('frmRIPSAHEgreso').getForm();
        wTask = 'RIPSAH_EGRESO_GUARDAR';
    }
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: wTask,
                CAMPOS: listacampos,
                pCAS: Ext.getCmp('sysCASRIPSAH').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioRIPSAH').getValue()
            },
            success: function(res,req){
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}