/*
* @category    Formulario RIPS Urgencias
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winRIPSUrgencias001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: RIPS AU ::.',
    width: 927,
    autoHeight: true, //670,
    autoScroll: true,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winRIPSAU',
    initComponent: function() {
        var dataDestinoSalidaAU = [
            [1,'1 - Alta de Urgencias'],
            [2,'2 - Remision a Otro Nivel de Complejidad'],
            [3,'3 - Hospitalizacion']
        ];
        var stDestinoSalidaAU = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stDestinoSalidaAU.loadData(dataDestinoSalidaAU);
        var dataEstadoSalidaAU = [
            [1,'1 - Vivo'],
            [2,'2 - Muerto']
        ];
        var stEstadoSalidaAU = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stEstadoSalidaAU.loadData(dataEstadoSalidaAU);    
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmRIPSAUIngreso',
                padding: 2,
                labelSeparator: '',
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'DATOS DEL INGRESO',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        tbar:{
                            items: [
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Guardar',
                                    iconCls: 'btnGuardar',
                                    listeners:{
                                        click : function(){
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Esta seguro que desea Guardar los datos del Ingreso del RIPS?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn === "yes"){
                                                        fnGuardarRegistrosRIPSAU("Ingreso");
                                                    }
                                                }
                                            });
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                value: 0,
                                id: 'sysYaGuardoRIPSAU'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuarioRIPSAU'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 130,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'CAS',
                                        id: 'sysCASRIPSAU'
                                    },
                                    {
                                        html: 'Paciente:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 575,
                                        allowBlank: true,
                                        readOnly: true,
                                        //fieldLabel: 'Paciente',
                                        //value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteRIPSAU'
                                    }
                                ]
                            },
                            {
                                html: '<hr>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'Fecha Ingreso',
                                        name: 'Fecha Ingreso',
                                        allowBlank: false,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFechaIngresoRIPSAU',
                                        listeners: {
                                            change: function(t, newValue, oldValue){
                                                if (Date.parse(Ext.getCmp('fecFechaIngresoRIPSAU').getValue()) > Date.parse(Ext.getCmp('fecFechaSalidaRIPSAU').getValue())){
                                                    Ext.MessageBox.show({
                                                        title: 'RIPS AU',
                                                        msg: 'La fecha de ingreso no puede ser mayor a la fecha de egreso.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                    Ext.getCmp('fecFechaIngresoRIPSAU').setValue(null);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Hora'
                                    },
                                    {
                                        xtype: 'timefield',
                                        width: 95,
                                        allowBlank: false,
                                        forceSelection: false,
                                        emptyText: '(hh:mm)',
                                        format: 'H:i',
                                        altFormats:'H:i',
                                        id: 'strHoraIngresoRIPSAU',
                                        listeners: {
                                            change: function(t, newValue, oldValue){
                                                if (Date.parse(Ext.getCmp('fecFechaIngresoRIPSAU').getValue()) === Date.parse(Ext.getCmp('fecFechaSalidaRIPSAU').getValue())){
                                                    if (Ext.getCmp('strHoraIngresoRIPSAU').getValue() !== "" && Ext.getCmp('strHoraIngresoRIPSAU').getValue() !== null && Ext.getCmp('strHoraSalidaRIPSAU').getValue() !== "" && Ext.getCmp('strHoraSalidaRIPSAU').getValue() !== null){
                                                        var HoraIni;
                                                        var MinIni;
                                                        var HoraFin;
                                                        var MinFin;
                                                        HoraIni = parseInt(Ext.getCmp('strHoraIngresoRIPSAU').getValue().substring(0, 2));
                                                        MinIni = parseInt(Ext.getCmp('strHoraIngresoRIPSAU').getValue().substring(3, 5));
                                                        HoraFin = parseInt(Ext.getCmp('strHoraSalidaRIPSAU').getValue().substring(0, 2));
                                                        MinFin = parseInt(Ext.getCmp('strHoraSalidaRIPSAU').getValue().substring(3, 5));
                                                        if(HoraIni <= HoraFin){
                                                            if(HoraIni === HoraFin){
                                                                if(MinIni > MinFin){
                                                                    Ext.MessageBox.show({
                                                                        title: 'RIPS AU',
                                                                        msg: 'La hora de ingreso no puede ser mayor a la hora de egreso.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                    Ext.getCmp('strHoraIngresoRIPSAU').setValue(null);
                                                                }
                                                            }
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'RIPS AU',
                                                                msg: 'La hora de ingreso no puede ser mayor a la hora de egreso.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                            Ext.getCmp('strHoraIngresoRIPSAU').setValue(null);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Autorizacion'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Autorizacion',
                                        width: 200,
                                        allowBlank: true,
                                        id: 'strAutorizacionRIPSAU'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Causa Externa',
                                anchor: '100%',
                                name: 'Causa Externa',
                                allowBlank: false,
                                store: 'StoreCausaExterna',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                value: 13,
                                id: 'strCausaExternaRIPSAU'/*,
                                listeners: {
                                    focus: function(t){
                                        html = '<table><tr><td width="470">Del 1 al 12 son las causas externas que mas interesan para la vigilancia de la salud pública.<br>Si  hubieren  otras  causas  externas  no contempladas en estas 12, deben seleccionar el  valor:  15  otra;  y  si  se  requiere  una  mayor precisión en  la  causa que  originó la  atención pueden  hacerlo  en  el  campo  de  diagnóstico relacionado,  con  los  diagnósticos  de  los capítulo XX, letras V a la Y.<br><br>Si algún diagnóstico empieza con S, T no se acepta Causa Externa = 13 ó 15</td></tr></table>';
                                        Sexy.info(html);
                                    }
                                }*/
                            },
                            {
                                xtype: 'combo',
                                anchor: '100%',
                                fieldLabel: 'Profesional',
                                allowBlank: false,
                                store: 'StoreProfesionales',
                                forceSelection: true,
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                emptyText: 'Seleccione Profesional Ingeso....',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                id: 'intProfesionalIngresoRIPSAU'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmRIPSAUEgreso',
                labelSeparator: '',
                padding: 2,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'DATOS DEL EGRESO',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        tbar:{
                            items: [
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Guardar',
                                    iconCls: 'btnGuardar',
                                    listeners:{
                                        click : function(){
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Esta seguro que desea Guardar los datos del Egreso del RIPS?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn === "yes"){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/asistencial/evolucionhc2013.php',
                                                            waitMsg: 'Cargando Información...',
                                                            params:{
                                                                task: 'RIPSAU_INGRESO_VERIFICA',
                                                                pCAS: Ext.getCmp('sysCASRIPSAU').getValue()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}" || Contenido[0] === null){
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'Debe guardar primero los datos del ingreso del RIPS.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                } else {
                                                                    fnGuardarRegistrosRIPSAU("Egreso");
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                Ext.MessageBox.show({
                                                                    title: 'Error',
                                                                    msg: 'Debe guardar primero los datos del ingreso del RIPS y/o No se pudo establecer conexion con el servidor.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            },
                                                            scope: this 
                                                        });
                                                        
                                                    }
                                                }
                                            });
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: false,
                                        fieldLabel: 'Diagnostico Salida',
                                        name: 'Diagnostico Salida',
                                        id: 'strDiagSalidaRIPSAU',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalidaRIPSAU').setValue(null);
                                                                    Ext.getCmp('sysDiagSalidaRIPSAUNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalidaRIPSAU').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalidaRIPSAUNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalidaRIPSAU').setValue(null);
                                                                Ext.getCmp('sysDiagSalidaRIPSAUNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalidaRIPSAU').setValue(null);
                                                        Ext.getCmp('sysDiagSalidaRIPSAUNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagSalidaRIPSAUNom').getValue() === null || Ext.getCmp('sysDiagSalidaRIPSAUNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagSalidaRIPSAU').getValue() !== "" && Ext.getCmp('strDiagSalidaRIPSAU').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagSalidaRIPSAU').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalidaRIPSAU').setValue(null);
                                                                    Ext.getCmp('sysDiagSalidaRIPSAUNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalidaRIPSAU').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalidaRIPSAUNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalidaRIPSAU').setValue(null);
                                                                Ext.getCmp('sysDiagSalidaRIPSAUNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalidaRIPSAU').setValue(null);
                                                        Ext.getCmp('sysDiagSalidaRIPSAUNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagSalidaRIPSAUNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Salida',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagSalidaRIPSAU','sysDiagSalidaRIPSAUNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Salida Rel1',
                                        name: 'Diagnostico Salida1',
                                        id: 'strDiagSalida1RIPSAU',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida1RIPSAU').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida1RIPSAUNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida1RIPSAU').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida1RIPSAUNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida1RIPSAU').setValue(null);
                                                                Ext.getCmp('sysDiagSalida1RIPSAUNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida1RIPSAU').setValue(null);
                                                        Ext.getCmp('sysDiagSalida1RIPSAUNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagSalida1RIPSAUNom').getValue() === null || Ext.getCmp('sysDiagSalida1RIPSAUNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagSalida1RIPSAU').getValue() !== "" && Ext.getCmp('strDiagSalida1RIPSAU').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagSalida1RIPSAU').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida1RIPSAU').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida1RIPSAUNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida1RIPSAU').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida1RIPSAUNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida1RIPSAU').setValue(null);
                                                                Ext.getCmp('sysDiagSalida1RIPSAUNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida1RIPSAU').setValue(null);
                                                        Ext.getCmp('sysDiagSalida1RIPSAUNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagSalida1RIPSAUNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Salida Rel1',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagSalida1RIPSAU','sysDiagSalida1RIPSAUNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Salida Rel2',
                                        name: 'Diagnostico Salida2',
                                        id: 'strDiagSalida2RIPSAU',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida2RIPSAU').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida2RIPSAUNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida2RIPSAU').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida2RIPSAUNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida2RIPSAU').setValue(null);
                                                                Ext.getCmp('sysDiagSalida2RIPSAUNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida2RIPSAU').setValue(null);
                                                        Ext.getCmp('sysDiagSalida2RIPSAUNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagSalida2RIPSAUNom').getValue() === null || Ext.getCmp('sysDiagSalida2RIPSAUNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagSalida2RIPSAU').getValue() !== "" && Ext.getCmp('strDiagSalida2RIPSAU').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagSalida2RIPSAU').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida2RIPSAU').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida2RIPSAUNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida2RIPSAU').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida2RIPSAUNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida2RIPSAU').setValue(null);
                                                                Ext.getCmp('sysDiagSalida2RIPSAUNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida2RIPSAU').setValue(null);
                                                        Ext.getCmp('sysDiagSalida2RIPSAUNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagSalida2RIPSAUNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Salida Rel2',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagSalida2RIPSAU','sysDiagSalida2RIPSAUNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Salida Rel3',
                                        name: 'Diagnostico Salida3',
                                        id: 'strDiagSalida3RIPSAU',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida3RIPSAU').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida3RIPSAUNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida3RIPSAU').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida3RIPSAUNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida3RIPSAU').setValue(null);
                                                                Ext.getCmp('sysDiagSalida3RIPSAUNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida3RIPSAU').setValue(null);
                                                        Ext.getCmp('sysDiagSalida3RIPSAUNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagSalida3RIPSAUNom').getValue() === null || Ext.getCmp('sysDiagSalida3RIPSAUNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagSalida3RIPSAU').getValue() !== "" && Ext.getCmp('strDiagSalida3RIPSAU').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagSalida3RIPSAU').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagSalida3RIPSAU').setValue(null);
                                                                    Ext.getCmp('sysDiagSalida3RIPSAUNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagSalida3RIPSAU').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagSalida3RIPSAUNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagSalida3RIPSAU').setValue(null);
                                                                Ext.getCmp('sysDiagSalida3RIPSAUNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagSalida3RIPSAU').setValue(null);
                                                        Ext.getCmp('sysDiagSalida3RIPSAUNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagSalida3RIPSAUNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Salida Rel3',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagSalida3RIPSAU','sysDiagSalida3RIPSAUNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Destino',
                                anchor: '100%',
                                name: 'Destino',
                                allowBlank: false,
                                store: stDestinoSalidaAU,
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                id: 'strDestinoRIPSAU'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Estado',
                                anchor: '100%',
                                name: 'Estado',
                                allowBlank: false,
                                store: stEstadoSalidaAU,
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                id: 'strEstadoRIPSAU',
                                listeners: {
                                    select: function(cmb, rec, idx) {
                                        if(parseInt(cmb.getValue()) === 2){
                                            Ext.getCmp('strDiagCausaMuerteRIPSAU').allowBlank = false;
                                            Ext.getCmp('strDiagCausaMuerteRIPSAU').setDisabled(false);
                                            Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').setDisabled(false);
                                            Ext.getCmp('btnDiagCausaMuerteRIPSAU').setDisabled(false);
                                        }else{
                                            Ext.getCmp('strDiagCausaMuerteRIPSAU').allowBlank = true;
                                            Ext.getCmp('strDiagCausaMuerteRIPSAU').setDisabled(true);
                                            Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').setDisabled(true);
                                            Ext.getCmp('btnDiagCausaMuerteRIPSAU').setDisabled(true);
                                            Ext.getCmp('strDiagCausaMuerteRIPSAU').setValue(null);
                                            Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').setValue(null);
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        disabled: true,
                                        fieldLabel: 'Diagnostico Causa Muerte',
                                        id: 'strDiagCausaMuerteRIPSAU',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagCausaMuerteRIPSAU').setValue(null);
                                                                    Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagCausaMuerteRIPSAU').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagCausaMuerteRIPSAU').setValue(null);
                                                                Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagCausaMuerteRIPSAU').setValue(null);
                                                        Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').getValue() === null || Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagCausaMuerteRIPSAU').getValue() !== "" && Ext.getCmp('strDiagCausaMuerteRIPSAU').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagCausaMuerteRIPSAU').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagCausaMuerteRIPSAU').setValue(null);
                                                                    Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagCausaMuerteRIPSAU').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagCausaMuerteRIPSAU').setValue(null);
                                                                Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagCausaMuerteRIPSAU').setValue(null);
                                                        Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        disabled: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagCausaMuerteRIPSAUNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        disabled: true,
                                        tooltip: 'Buscar Diagnostico Causa Muerte',
                                        id: 'btnDiagCausaMuerteRIPSAU',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagCausaMuerteRIPSAU','sysDiagCausaMuerteRIPSAUNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'Fecha Salida',
                                        name: 'Fecha Salida',
                                        allowBlank: false,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFechaSalidaRIPSAU',
                                        listeners: {
                                            change: function(t, newValue, oldValue){
                                                if (Date.parse(Ext.getCmp('fecFechaSalidaRIPSAU').getValue()) < Date.parse(Ext.getCmp('fecFechaIngresoRIPSAU').getValue())){
                                                    Ext.MessageBox.show({
                                                        title: 'RIPS AU',
                                                        msg: 'La fecha de egreso no puede ser menor a la fecha de ingreso.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                    Ext.getCmp('fecFechaSalidaRIPSAU').setValue(null);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Hora'
                                    },
                                    {
                                        xtype: 'timefield',
                                        width: 95,
                                        allowBlank: false,
                                        forceSelection: false,
                                        emptyText: '(hh:mm)',
                                        format: 'H:i',
                                        altFormats:'H:i',
                                        id: 'strHoraSalidaRIPSAU',
                                        listeners: {
                                            change: function(t, newValue, oldValue){
                                                if (Date.parse(Ext.getCmp('fecFechaIngresoRIPSAU').getValue()) === Date.parse(Ext.getCmp('fecFechaSalidaRIPSAU').getValue())){
                                                    if (Ext.getCmp('strHoraIngresoRIPSAU').getValue() !== "" && Ext.getCmp('strHoraIngresoRIPSAU').getValue() !== null && Ext.getCmp('strHoraSalidaRIPSAU').getValue() !== "" && Ext.getCmp('strHoraSalidaRIPSAU').getValue() !== null){
                                                        var HoraIni;
                                                        var MinIni;
                                                        var HoraFin;
                                                        var MinFin;
                                                        HoraIni = parseInt(Ext.getCmp('strHoraIngresoRIPSAU').getValue().substring(0, 2));
                                                        MinIni = parseInt(Ext.getCmp('strHoraIngresoRIPSAU').getValue().substring(3, 5));
                                                        HoraFin = parseInt(Ext.getCmp('strHoraSalidaRIPSAU').getValue().substring(0, 2));
                                                        MinFin = parseInt(Ext.getCmp('strHoraSalidaRIPSAU').getValue().substring(3, 5));
                                                        if(HoraFin >= HoraIni){
                                                            if(HoraIni === HoraFin){
                                                                if(MinFin < MinIni){
                                                                    Ext.MessageBox.show({
                                                                        title: 'RIPS AU',
                                                                        msg: 'La hora de egreso no puede ser menor a la hora de ingreso.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                    Ext.getCmp('strHoraSalidaRIPSAU').setValue(null);
                                                                }
                                                            }
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'RIPS AU',
                                                                msg: 'La hora de egreso no puede ser menor a la hora de ingreso.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                            Ext.getCmp('strHoraSalidaRIPSAU').setValue(null);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Profesional',
                                allowBlank: false,
                                store: 'StoreProfesionales',
                                forceSelection: true,
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                emptyText: 'Seleccione Profesional Salida....',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                anchor: '100%',
                                id: 'intProfesionalSalidaRIPSAU'
                            }
                        ]
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                Ext.Ajax.request({
                    url: '../../controlador/asistencial/evolucionhc2013.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        task: 'RIPSAU_INGRESO_LOAD',
                        pCAS: Ext.getCmp('sysCASRIPSAU').getValue()
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); // get the LOG
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                            // No Encontro Registros
                        } else {
                            if(Contenido[1] !== "" && Contenido[1] !== null)
                                Ext.getCmp('fecFechaIngresoRIPSAU').setValue(Contenido[1]);
                            if(Contenido[2] !== "" && Contenido[2] !== null)
                                Ext.getCmp('strHoraIngresoRIPSAU').setValue(Contenido[2]);
                            if(Contenido[3] !== "" && Contenido[3] !== null)
                                Ext.getCmp('strAutorizacionRIPSAU').setValue(Contenido[3]);
                            if(Contenido[4] !== "" && Contenido[4] !== null)
                                Ext.getCmp('strCausaExternaRIPSAU').setValue(Contenido[4]);
                            if(Contenido[5] !== "" && Contenido[5] !== null)
                                Ext.getCmp('intProfesionalIngresoRIPSAU').setValue(Contenido[5]);
                            if(Contenido[6] !== "" && Contenido[6] !== null)
                                Ext.getCmp('strDiagSalidaRIPSAU').setValue(Contenido[6]);
                            if(Contenido[7] !== "" && Contenido[7] !== null)
                                Ext.getCmp('strDiagSalida1RIPSAU').setValue(Contenido[7]);
                            if(Contenido[8] !== "" && Contenido[8] !== null)
                                Ext.getCmp('strDiagSalida2RIPSAU').setValue(Contenido[8]);
                            if(Contenido[9] !== "" && Contenido[9] !== null)
                                Ext.getCmp('strDiagSalida3RIPSAU').setValue(Contenido[9]);
                            if(Contenido[10] !== "" && Contenido[10] !== null)
                                Ext.getCmp('strDestinoRIPSAU').setValue(Contenido[10]);
                            if(Contenido[11] !== "" && Contenido[11] !== null){
                                Ext.getCmp('strEstadoRIPSAU').setValue(Contenido[11]);
                                if(parseInt(Contenido[11]) === 2){
                                    Ext.getCmp('strDiagCausaMuerteRIPSAU').allowBlank = false;
                                    Ext.getCmp('strDiagCausaMuerteRIPSAU').setDisabled(false);
                                    Ext.getCmp('sysDiagCausaMuerteRIPSAUNom').setDisabled(false);
                                    Ext.getCmp('btnDiagCausaMuerteRIPSAU').setDisabled(false);
                                    if(Contenido[12] !== "" && Contenido[12] !== null)
                                        Ext.getCmp('strDiagCausaMuerteRIPSAU').setValue(Contenido[12]);
                                }
                            }
                            if(Contenido[13] !== "" && Contenido[13] !== null)
                                Ext.getCmp('fecFechaSalidaRIPSAU').setValue(Contenido[13]);
                            if(Contenido[14] !== "" && Contenido[14] !== null)
                                Ext.getCmp('strHoraSalidaRIPSAU').setValue(Contenido[14]);
                            if(Contenido[15] !== "" && Contenido[15] !== null)
                                Ext.getCmp('intProfesionalSalidaRIPSAU').setValue(Contenido[15]);
                        }
                    },
                    failure: function(response,options){
                        var el = Ext.get('response');
                    },
                    scope: this 
                });
            }}
        });
        winRIPSUrgencias001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosRIPSAU(wOpcion){
    var frm;
    var wTask;
    if(wOpcion === "Ingreso"){
        frm = Ext.getCmp('frmRIPSAUIngreso').getForm();
        wTask = 'RIPSAU_INGRESO_GUARDAR';
    }else{
        frm = Ext.getCmp('frmRIPSAUEgreso').getForm();
        wTask = 'RIPSAU_EGRESO_GUARDAR';
    }
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: wTask,
                CAMPOS: listacampos,
                pCAS: Ext.getCmp('sysCASRIPSAU').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioRIPSAU').getValue()
            },
            success: function(res,req){
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}