/*
* @category    Formulario Anular MC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAnularMCUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Anular Documento MC ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAnularM',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAnularMC',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        html: '<img src="../../../resources/varios/no.png" align="left" alt=""/>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    },
                    {
                        xtype: 'textfield',
                        fieldLabel: 'Documento Nro.',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysNroMC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysIdLegalizacion'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPS'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuario'
                    },
                    {
                        xtype: 'displayfield',
                        value: ' '
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'Motivo',
                        name: 'strMotivo',
                        maxLength: 250,
                        allowBlank: false,
                        emptyText: 'Digite el Motivo de la Anulación...!',
                        id: 'strMotivo'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Anular MC',
                            iconCls: 'btnBorrar',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmAnularMC').getForm();
                                    if (frm.isValid())
                                    {
                                        frm.submit({
                                            url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                            params:{
                                                PROCESO: 'ANULAR_LEGALIZACION_MC',
                                                pConsecutivoDetalle: Ext.getCmp('sysIdLegalizacion').getValue(),
                                                pEmpresa: Ext.getCmp('sysEmpresa').getValue(),
                                                pIPS: Ext.getCmp('sysIPS').getValue(),
                                                pMotivo: QuitarAcentosTxt(Ext.getCmp('strMotivo').getValue()),
                                                pUsuario: Ext.getCmp('sysUsuario').getValue(),
                                                pNroDocumento: Ext.getCmp('sysNroMC').getValue()
                                            },
                                            success: function(res,req)
                                            {
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        Ext.getCmp('gridFacturacionOrden').store.reload();
                                                        Ext.getCmp('fYaLiquidado').setValue(0);
                                                        Ext.getCmp('fYaLegalizado').setValue(0);
                                                        Ext.getCmp('sysTipoLegalizacion_estudios').setValue(null);
                                                        Ext.getCmp('sysResponsableLegalizacion_estudios').setValue(null);
                                                        Ext.getCmp('winAnularM').close();
                                                        Ext.MessageBox.show({
                                                            title: 'Anulación Documentos',
                                                            msg: 'Se Anulo con exito el documento seleccionado',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'Anulación Documentos',
                                                            msg: 'Ocurrio un error al anular el documento o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos anular el documento en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'El Motivo de la Anulación es Requerido',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAnularMCUi.superclass.initComponent.call(this);
    }
});
