/*
* @category    Formulario Borrar CAS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winBorrarCASUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Borrar Orden Servicios - CAS ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winBorrarCAS',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmBorrarCAS',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        html: '<img src="../../../resources/varios/no.png" align="left" alt=""/>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    },
                    {
                        xtype: 'textfield',
                        fieldLabel: 'CAS',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysBorraCAS'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysBorraEmpresa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysBorraIPS'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysBorraUsuario'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 'NA',
                        fieldLabel: 'Proceso',
                        id: 'sysProcesoCAS'
                    },
                    {
                        xtype: 'displayfield',
                        value: ' '
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'Motivo',
                        name: 'strBorraMotivo',
                        maxLength: 250,
                        allowBlank: false,
                        emptyText: 'Digite el Motivo...!',
                        id: 'strBorraMotivo'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Borrar CAS',
                            iconCls: 'btnBorrar',
                            id: 'btnProcesoCAS',
                            listeners:{
                                click : function(){
                                    var RUN_PROCESO;
                                    if(Ext.getCmp('sysProcesoCAS').getValue()==="NA"){
                                        RUN_PROCESO = 'BORRAR_CAS';
                                    }else{
                                        RUN_PROCESO = 'REACTIVAR_CAS';
                                    }
                                    var frm = Ext.getCmp('frmBorrarCAS').getForm();
                                    if (frm.isValid())
                                    {
                                        frm.submit({
                                            url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                            params:{
                                                PROCESO: RUN_PROCESO,
                                                pCAS: Ext.getCmp('sysBorraCAS').getValue(),
                                                pEmpresa: Ext.getCmp('sysBorraEmpresa').getValue(),
                                                pIPS: Ext.getCmp('sysBorraIPS').getValue(),
                                                pMotivo: QuitarAcentosTxt(Ext.getCmp('strBorraMotivo').getValue()),
                                                pUsuario: Ext.getCmp('sysBorraUsuario').getValue()
                                            },
                                            success: function(res,req)
                                            {
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        var frm = Ext.getCmp('frmRadica').getForm();
                                                        frm.reset();
                                                        frm.clearInvalid();
                                                        frm = Ext.getCmp('frmResumenHC').getForm();
                                                        frm.reset();
                                                        frm.clearInvalid();
                                                        frm = Ext.getCmp('frmLegalizar').getForm();
                                                        frm.reset();
                                                        frm.clearInvalid();
                                                        Ext.getCmp('fIdPaciente').setValue(0);
                                                        Ext.getCmp('fCliente').clearValue();
                                                        Ext.getCmp('fPlan').clearValue();
                                                        Ext.getCmp('fSubPlan').clearValue();
                                                        Ext.getCmp('fContrato').clearValue();
                                                        Ext.getCmp('fCliente').setValue(null);
                                                        Ext.getCmp('fPlan').setValue(null);
                                                        Ext.getCmp('fSubPlan').setValue(null);
                                                        Ext.getCmp('fContrato').setValue(null);
                                                        Ext.getCmp('gridServicios').store.load({
                                                            params: {
                                                                pCAS: 0
                                                            }
                                                        });
                                                        Ext.getCmp('gridFacturacionOrden').store.load({
                                                            params: {
                                                                pEmpresa: ID_EMPRESA,
                                                                pCAS: 0
                                                            }
                                                        });
                                                        Ext.getCmp('gridServicios').store.removeAll();
                                                        Ext.getCmp('gridFacturacionOrden').store.removeAll();
                                                        Ext.getCmp('fClienteLA').setValue(0);
                                                        Ext.getCmp('fPlanLA').setValue(0);
                                                        Ext.getCmp('fSubPlanLA').setValue(0);
                                                        Ext.getCmp('fCliente').store.load({
                                                            params:{pSede:ID_SEDE,pEmpresa:ID_EMPRESA}
                                                        });
                                                        Ext.getCmp('fPlan').disable();
                                                        Ext.getCmp('fSubPlan').disable();
                                                        Ext.getCmp('fNroCAS').setValue("Sin Registrar");
                                                        Ext.getCmp('fEstadoCAS').setValue("");
                                                        Ext.getCmp('fFecRadicado').setValue("");
                                                        Ext.getCmp('fPacienteValido').setValue(0);
                                                        paso1 = false;
                                                        paso2 = false;
                                                        paso3 = false;
                                                        paso4 = false;
                                                        paso5 = false;
                                                        Ext.getCmp('fYaLegalizado').setValue(0);
                                                        Ext.getCmp('fYaLiquidado').setValue(0);
                                                        Ext.getCmp('fCas').setValue(0);
                                                        Ext.getCmp('fModificaCAS').setValue(1);
                                                        Ext.getCmp('sysTipoLegalizacion_estudios').setValue("");
                                                        Ext.getCmp('sysResponsableLegalizacion_estudios').setValue("");
                                                        EstblecerCamposEnabled();
                                                        Ext.getCmp('sysTextoEliminado').setValue("");
                                                        Ext.getCmp('btnReactivarCAS').setVisible(false);
                                                        if(RUN_PROCESO === 'BORRAR_CAS'){
                                                            Ext.MessageBox.show({
                                                                title: 'eOfiClinic',
                                                                msg: 'Se borro la orden de servicio con exito',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.INFO
                                                            });
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'eOfiClinic',
                                                                msg: 'Se Reactivo la orden de servicio con exito',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.INFO
                                                            });
                                                        }
                                                        Ext.getCmp('winBorrarCAS').close();
                                                        break;

                                                    default:
                                                        if(RUN_PROCESO === 'BORRAR_CAS'){
                                                            Ext.MessageBox.show({
                                                                title: 'Borrar CAS',
                                                                msg: 'Ocurrio un error al borrar la orden de servicio o no se pudo establecer conexión con el servidor.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }else{
                                                            Ext.MessageBox.show({
                                                                title: 'Reactivar CAS',
                                                                msg: 'Ocurrio un error al reactivar la orden de servicio o no se pudo establecer conexión con el servidor.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos borrar el documento en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'El Motivo es Requerido',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                if(Ext.getCmp('sysProcesoCAS').getValue() ===  "BITACORA_CAS"){
                    var frm = Ext.getCmp('frmBorrarCAS').getForm();
                    frm.doAction('load', {
                        url: '../../controlador/radicacionservicios/legalizacioncas.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pCAS: Ext.getCmp('sysBorraCAS').getValue(),
                            PROCESO: 'BITACORA_CAS'
                        },
                        success:function(form, action) {
                            //CargarDataHC(action.result.data.sysEvolucion);
                        }
                    });
                }
            }}
        }); 
        winBorrarCASUi.superclass.initComponent.call(this);
    }
});
