/*
* @category    Formulario Crear Nuevo Periodo Resolucion 4505
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddPeriodo4505Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Crear Nuevo Periodo Resolucion 4505 ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddPeriodo4505Ui',
    initComponent: function() {
        
        var dataMes = [
            [1,'Enero'],
            [2,'Febrero'],
            [3,'Marzo'],
            [4,'Abril'],
            [5,'Mayo'],
            [6,'Junio'],
            [7,'Julio'],
            [8,'Agosto'],
            [9,'Septiembre'],
            [10,'Octubre'],
            [11,'Noviembre'],
            [12,'Diciembre']
        ];
        var stMes = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stMes.loadData(dataMes);
        
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddPeriodo4505',
                labelWidth: 90,
                padding: 10,
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Cliente',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreCliente',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione Cliente....',
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection: true,
                        id: 'sysIdCliente'
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Periodo',
                                allowBlank: false,
                                emptyText: 'Año (1900)',
                                id: 'strPeriodoAno'
                            },
                            {
                                html: '/'
                            },
                            {
                                xtype: 'combo',
                                name: 'Mes',
                                width: 150,
                                allowBlank: true,
                                store: stMes,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                emptyText: 'Mes',
                                id: 'strPeriodoMes'
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarNuevoPeriodo',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                    title: 'Nuevo Periodo Resolucion 4505....!',
                                    msg: 'Esta seguro que desea Crear un Nuevo Periodo para la Resolucion 4505?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                          var frm = Ext.getCmp('frmAddPeriodo4505').getForm();
                                            if (frm.isValid())
                                            {
                                                frm.submit({
                                                    url: '../../controlador/pacientes/controlador_pacientes_4505.php',
                                                    params: {
                                                        task: 'GUARDAR_PERIODO',
                                                        pEmpresa: ID_EMPRESA,
                                                        pIPS: ID_IPS,
                                                        pCliente: Ext.getCmp('sysIdCliente').getValue(),
                                                        pPeriodoAnio: Ext.getCmp('strPeriodoAno').getValue(),
                                                        pPeriodoMes: Ext.getCmp('strPeriodoMes').getValue()
                                                    },
                                                    success: function(res,req)
                                                    {
                                                        switch(req.result.requestedId){
                                                            case "1":
                                                                Ext.MessageBox.show({
                                                                    title: 'Nuevo Periodo Resolucion 4505',
                                                                    msg: 'Se Creo el Nuevo Periodo para la Resolucion 4505 con Exito.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.INFO
                                                                });
                                                                Ext.getCmp('winAddPeriodo4505Ui').close();
                                                                break;

                                                            default:
                                                                Ext.MessageBox.show({
                                                                    title: 'Nuevo Periodo Resolucion 4505',
                                                                    msg: 'Ocurrio un error al Crear un Nuevo Periodo para la Resolucion 4505 o no se pudo establecer conexión con el servidor.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                                break;
                                                        }
                                                    },
                                                    failure: function(response,options)
                                                    {
                                                        Ext.MessageBox.show({
                                                            title: 'Error Base Datos',
                                                            msg: 'No podemos Crear un Nuevo Periodo para la Resolucion 4505 en estos momentos',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                });
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'El Usuario es Requerido',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }   
                                        }
                                    }
                                });
                            }
                        }
                    }
                    ]
                }
            }
        ];
        winAddPeriodo4505Ui.superclass.initComponent.call(this);
    }
});
