/*
* @category    Formulario Seguimiento Pacientes Resolucion 4505
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmAdministracion4505Ui = Ext.extend(Ext.Window, {
    layout: 'fit',
    title: '.:: Administracion Resolucion 4505 ::.',
    width: 1000,
    height: 190,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    closable: false,
    draggable: false,
    resizable: false,
    id: 'winFrmAdministracion4505',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        wPaciente = 0;
        wCAS = 0;
        
        //Store Local
        var dataMes = [
            ['01','Enero',31],
            ['02','Febrero',28],
            ['03','Marzo',31],
            ['04','Abril',30],
            ['05','Mayo',31],
            ['06','Junio',30],
            ['07','Julio',31],
            ['08','Agosto',31],
            ['09','Septiembre',30],
            ['10','Octubre',31],
            ['11','Noviembre',30],
            ['12','Diciembre',31]
        ];
        var stMes = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'},
                {name: 'DiaHasta'}
            ]
        });
        stMes.loadData(dataMes);
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                autoHeight: true,
                anchor: '100%',
                autoScroll: true,
                id: 'frmAdministracion4505',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intPacienteLegalizacion',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIdEmpresa'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIPS'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysTipDoc'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysDoc'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPrimer_Nombre'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSegundo_Nombre'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPrimer_Apellido'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSegundo_Apellido'
                    },
                    {
                        xtype: 'datefield',
                        hidden: true,
                        id: 'sysFecNac'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSexo'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysDiaHasta'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysMes00'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysMes01'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysAno01'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysDiaDesde01'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysDiaHasta01'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Cliente',
                                width: 550,
                                allowBlank: true,
                                store: 'StoreCliente',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Cliente....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysCliente',
                                listeners:{
                                    select : function(cmb, rec, idx){
                                        Ext.getCmp('sysId_4505').store.removeAll();
                                        Ext.getCmp('sysId_4505').store.load({
                                            params:{
                                                pIPS: Ext.getCmp('sysIPS').getValue(),
                                                pCliente: cmb.getValue()
                                            }
                                        });
                                        Ext.getCmp('sysId_4505').setValue(null);
                                    }
                                }
                            },
                            {
                                html: 'Periodo - Año:'
                            },
                            new Ext.ux.form.Spinner({
                                id: 'sysAnio_4505',
                                width: 60,
                                value: new Date().getFullYear(),
                                strategy: new Ext.ux.form.Spinner.NumberStrategy({minValue:(new Date().getFullYear()-1), maxValue: (new Date().getFullYear()+1)})
                            }),
                            {
                                html: ' - Mes:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Mes',
                                width: 120,
                                allowBlank: true,
                                store: stMes,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                emptyText: 'Mes',
                                id: 'sysMes_4505',
                                listeners:{
                                    select : function(cmb, rec, idx){
                                        if(Ext.getCmp('sysAnio_4505').getValue() == 0 || Ext.getCmp('sysAnio_4505').getValue() == null || Ext.getCmp('sysAnio_4505').getValue() == ""){
                                            Ext.getCmp('sysAnio_4505').setValue(new Date().getFullYear());
                                        }
                                        bisiesto = (Ext.getCmp('sysAnio_4505').getValue()%4==0) && ((Ext.getCmp('sysAnio_4505').getValue()%100!= 0) || (Ext.getCmp('sysAnio_4505').getValue()%400==0));
                                        if(rec.data.Codigo == 2 && bisiesto){
                                            Ext.getCmp('sysDiaHasta').setValue(29);
                                        }else{
                                            Ext.getCmp('sysDiaHasta').setValue(rec.data.DiaHasta);
                                        }
                                        Ext.getCmp('sysMes00').setValue(rec.data.Codigo);
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'Periodo',
                                fieldLabel: 'Periodo',
                                anchor: '50%',
                                store: 'StoreId4505',
                                valueField: 'Id4505',
                                displayField: 'Descripcion',
                                mode: 'local',
                                allowBlank: true,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                triggerAction: 'all',
                                id: 'sysId_4505',
                                listeners: {
                                    select : function(cmb, rec, idx){
                                        Ext.getCmp('sysAno01').setValue(rec.data.PeriodoAnio);
                                        Ext.getCmp('sysMes01').setValue(rec.data.PeriodoMes);
                                        Ext.getCmp('sysDiaDesde01').setValue(rec.data.PeriodoDesde);
                                        Ext.getCmp('sysDiaHasta01').setValue(rec.data.PeriodoHasta);
                                    }
                                }
                            }
                        ]
                    },
                    {
                        html: '<hr>'
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 800,
                                fieldLabel: 'Paciente',
                                readOnly: true,
                                allowBlank: true,
                                emptyText: 'Debe Buscar Paciente....',
                                id: 'sysPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                tooltip: 'Limpiar Datos del Paciente',
                                iconCls: 'btnLimpiar',
                                id: 'btnLimpiarPacienteLegalizacion'
                            }
                        ]
                    }
                ]
            },
            {
                tbar:
                {
                    xtype: 'toolbar',
                    anchor:'100%',
                    items:[
                        {
                            xtype: 'button',
                            text: 'Crear Periodo',
                            iconCls: 'btnAddRow',
                            id: 'btnCrearPeriodo'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Cerrar Periodo',
                            iconCls: 'btnCerrar',
                            id: 'btnCerrarPeriodo'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnReport',
                            text: 'Generar Archivos',
                            id: 'btnGenerar4505'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnGuardar',
                            text: 'Descargar Archivos',
                            id: 'btnDescargar4505'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Crear Registro Paciente 4505',
                            iconCls: 'btnAsociarsUsr',
                            id: 'btnAsociarPaciente'
                        }
                    ]
                }
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winFrmAdministracion4505Ui.superclass.initComponent.call(this);
    }
});