/*
* @category    Formulario Seguimiento Pacientes Resolucion 4505
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmPacientes4505Ui = Ext.extend(Ext.Window, {
    layout: 'fit',
    title: '.:: Seguimiento Pacientes Resolucion 4505 ::.',
    width: 1000,
    height: 650,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    closable: false,
    draggable: false,
    resizable: false,
    id: 'winFrmPacientes4505',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        wPaciente = 0;
        wCAS = 0;
        
        var stGrid = new StoreGridPacientes4505();
        var stGridInformes = new StoreMacroInformesDetalle4505();
        
        
        //Store Local
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                autoHeight: true,
                anchor: '100%',
                autoScroll: true,
                id: 'frmPacientes4505',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intPacienteLegalizacion',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIdEmpresa',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIPS',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysTipDoc',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysDoc',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPrimer_Nombre',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSegundo_Nombre',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPrimer_Apellido',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSegundo_Apellido',
                        value: 0
                    },
                    {
                        xtype: 'datefield',
                        hidden: true,
                        id: 'sysFecNac',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSexo',
                        value: 0
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 815,
                                fieldLabel: 'Paciente',
                                readOnly: true,
                                allowBlank: true,
                                emptyText: 'Debe Buscar Paciente....',
                                id: 'sysPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                tooltip: 'Limpiar Datos del Paciente',
                                iconCls: 'btnLimpiar',
                                id: 'btnLimpiarPacienteLegalizacion'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Cliente',
                                width: 565,
                                allowBlank: true,
                                store: 'StoreCliente',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Cliente....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'sysCliente',
                                listeners:{
                                    select : function(cmb, rec, idx){
                                        Ext.getCmp('sysId_4505').store.removeAll();
                                        Ext.getCmp('sysId_4505').store.load({
                                            params:{
                                                pIPS: Ext.getCmp('sysIPS').getValue(),
                                                pCliente: cmb.getValue()
                                            }
                                        });
                                        Ext.getCmp('sysId_4505').setValue(null);
                                    }
                                }
                            },
                            {
                                html: 'Periodo:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Periodo',
                                width: 250,
                                store: 'StoreId4505',
                                valueField: 'Id4505',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Periodo....',
                                mode: 'local',
                                allowBlank: true,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                triggerAction: 'all',
                                id: 'sysId_4505'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'grid',
                id: 'gridSeguimientoPacientes4505',
                store: stGrid,
                autoWidth: true,
                height: 350,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        header: 'Cliente',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'ClienteNom',
                        align: 'center',
                        width: 150,
                        hideable: false
                    },
                    {
                        header: 'TipoDoc',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'TipoDoc',
                        align: 'center',
                        width: 55,
                        hideable: false
                    },
                    {
                        header: 'Documento',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Documento',
                        align: 'center',
                        width: 90,
                        hideable: false
                    },
                    {
                        header: 'PrimerApellido',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'PrimerApellido',
                        align: 'center',
                        width: 115,
                        hideable: false
                    },
                    {
                        header: 'SegundoApellido',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'SegundoApellido',
                        align: 'center',
                        width: 115,
                        hideable: false
                    },
                    {
                        header: 'PrimerNombre',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'PrimerNombre',
                        align: 'center',
                        width: 115,
                        hideable: false
                    },
                    {
                        header: 'SegundoNombre',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'SegundoNombre',
                        align: 'center',
                        width: 115,
                        hideable: false
                    },
                    {
                        header: 'Fec Nac',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'FecNac',
                        width: 85,
                        align: 'center',
                        hideable: false
                    },
                    {
                        header: 'Sexo',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Genero',
                        align: 'center',
                        width: 50,
                        hideable: false
                    },
                    {
                        header: 'Estado',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Estado',
                        align: 'center',
                        width: 60,
                        hideable: false
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                view: new Ext.ux.grid.LockingGridView({
                    getRowClass: function(record, index, rowParams, store){
                        var estado = record.data.EstadoPaciente;
                        switch (estado){
                            case "X":
                                return 'NoApto';
                                break;
                            default:
                                return; 
                                break;
                        }
                    }
                }),
                //view: new Ext.ux.grid.LockingGridView(),
                columnLines: true,
                tbar: {
                    xtype: 'toolbar',
                    anchor:'100%',
                    items:[
                        {
                            xtype: 'button',
                            text: 'Actualizar Lista de Pacientes',
                            iconCls: 'btnActualizarGrid',
                            id: 'btnPacientes'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Crear Registro',
                            hidden: true,
                            iconCls: 'btnAsignarCita',
                            id: 'btnCrearRegistro'
                        },
                        {
                            xtype: 'button',
                            text: 'Editar Registro',
                            iconCls: 'btnEditRow',
                            id: 'btnRegistro'
                        }
                    ]
                },
                bbar: new Ext.PagingToolbar({
                    pageSize: 15,
                    store: 'StoreGridPacientes4505',
                    displayInfo: true
                })
            },
            {
                xtype: 'grid',
                id: 'gridGestionPacientes4505',
                store: stGridInformes,
                autoWidth: true,
                height: 180,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        header: 'Descripcion del Informe',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'nomOpcion',
                        width: 950,
                        hideable: false
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                view: new Ext.ux.grid.LockingGridView(),
                columnLines: true,
                tbar: {
                    xtype: 'toolbar',
                    anchor:'100%',
                    items:[
                        {
                            html: '<b>Generador de Informes de Seguimiento</b>'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Generar Informe',
                            iconCls: 'btnReport'
                        }
                    ]
                }
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winFrmPacientes4505Ui.superclass.initComponent.call(this);
    }
});
