/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmPacientes4505 = Ext.extend(winFrmPacientes4505Ui, {
    initComponent: function() {
        winFrmPacientes4505.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";

        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        
        Ext.getCmp('sysIdEmpresa').setValue(ID_EMPRESA);
        Ext.getCmp('sysIPS').setValue(ID_IPS);
        
        var btnBuscarPacienteLegalizacion = Ext.getCmp('btnBuscarPacienteLegalizacion').on("click",this.BuscarPacienteLegaliza,this);
        var btnLimpiarPacienteLegalizacion = Ext.getCmp('btnLimpiarPacienteLegalizacion').on("click",this.LimpiarDatosPaciente,this);
        var btnRegistro = Ext.getCmp('btnRegistro').on("click",this.AbrirSeguimientoPaciente,this);
        var btnCrearRegistro = Ext.getCmp('btnCrearRegistro').on("click",this.NuevoSeguimientoPaciente,this);
        var btnPacientes = Ext.getCmp('btnPacientes').on("click",this.ListarPacientes,this);
        var btnSalir = Ext.getCmp('btnSalir').on("click",this.SalirOpcion,this);
    },
    
    AbrirSeguimientoPaciente: function(){
        if(Ext.getCmp('gridSeguimientoPacientes4505').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridSeguimientoPacientes4505').selModel.getSelections();
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea Modificar el Registro?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn=="yes"){
                        var winSeguimientoPacientes4505 = new winSeguimientoPacientes4505Ui();
                        Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                        Ext.getCmp('sysId4505').setValue(selections[0].json.Id4505);
                        Ext.getCmp('sysIdPaciente').setValue(selections[0].json.Paciente);
                        Ext.getCmp('sysIdCliente').setValue(selections[0].json.Cliente);
                        Ext.getCmp('sysConsecutivoRegistro').setValue(selections[0].json.ConsecutivoRegistro);
                        Ext.getCmp('sysTipoDoc').setValue(selections[0].json.TipoDoc);
                        Ext.getCmp('sysDocumento').setValue(selections[0].json.Documento);
                        Ext.getCmp('sysPrimerApellido').setValue(selections[0].json.PrimerApellido);
                        Ext.getCmp('sysSegundoApellido').setValue(selections[0].json.SegundoApellido);
                        Ext.getCmp('sysPrimerNombre').setValue(selections[0].json.PrimerNombre);
                        Ext.getCmp('sysSegundoNombre').setValue(selections[0].json.SegundoNombre);
                        Ext.getCmp('sysFechaNac').setValue(selections[0].json.FecNac);
                        Ext.getCmp('sysGenero').setValue(selections[0].json.Genero);
                        Ext.getCmp('sysEtniaHC').setValue(selections[0].json.CodigoEtnia);
                        Ext.getCmp('strOcupacionHC').setValue(selections[0].json.CodigoOcupacion);
                        Ext.getCmp('sysEscolaridadHC').setValue(selections[0].json.CodigoNivelEducativo);
                        Ext.getCmp('intGestacion').setValue(selections[0].json.Gestacion);
                        Ext.getCmp('intSifilisGestacional').setValue(selections[0].json.SifilisGestacional);
                        Ext.getCmp('intHipertencionGestacional').setValue(selections[0].json.HipertensionGestacional);
                        Ext.getCmp('intHipotiroidismoCongenito').setValue(selections[0].json.HipotiroidismoCongenito);
                        Ext.getCmp('intSintomaticoRespiratorio').setValue(selections[0].json.SintomaticoRespiratorio);
                        Ext.getCmp('intTuberculosisMultidrogoresistente').setValue(selections[0].json.TuberculosisMultidrogoresistente);
                        Ext.getCmp('intLepra').setValue(selections[0].json.Lepra);
                        Ext.getCmp('intObesidadDesnutricion').setValue(selections[0].json.ObesidadDesnutricion);
                        Ext.getCmp('intVictimaMaltrato').setValue(selections[0].json.VictimaMaltrato);
                        Ext.getCmp('intViolenciaSexual').setValue(selections[0].json.VictimaViolenciaSexual);
                        Ext.getCmp('intInfeccionesTrasmisionSexual').setValue(selections[0].json.InfeccionesTrasmisionSexual);
                        Ext.getCmp('intEnfermedadMental').setValue(selections[0].json.EnfermedadMental);
                        Ext.getCmp('intCancerCervix').setValue(selections[0].json.CancerCervix);
                        Ext.getCmp('intCancerSeno').setValue(selections[0].json.CancerSeno);
                        Ext.getCmp('intFluorosisDental').setValue(selections[0].json.FluorosisDental);
                        Ext.getCmp('fecPeso').setValue(selections[0].json.FechaPeso);
                        Ext.getCmp('intPeso').setValue(selections[0].json.Peso);
                        Ext.getCmp('fecTalla').setValue(selections[0].json.FechaTalla);
                        Ext.getCmp('intTalla').setValue(selections[0].json.Talla);
                        Ext.getCmp('fecProbableParto').setValue(selections[0].json.FechaProbableParto);
                        Ext.getCmp('intEdadGestacionalNacer').setValue(selections[0].json.EdadGestacionalNacer);
                        Ext.getCmp('intBCG').setValue(selections[0].json.VacunaBCG);
                        Ext.getCmp('intHepatitisB').setValue(selections[0].json.VacunaHepatitisB);
                        Ext.getCmp('intPentavalente').setValue(selections[0].json.VacunaPentavalente);
                        Ext.getCmp('intPolio').setValue(selections[0].json.VacunaPolio);
                        Ext.getCmp('intDPT').setValue(selections[0].json.VacunaDPT);
                        Ext.getCmp('intRotavirus').setValue(selections[0].json.VacunaRotavirus);
                        Ext.getCmp('intNeumococo').setValue(selections[0].json.VacunaNeumococo);
                        Ext.getCmp('intInfluenza').setValue(selections[0].json.VacunaInfluenciaNinos);
                        Ext.getCmp('intFiebreAmarilla').setValue(selections[0].json.VacunaFiebreAmarilla);
                        Ext.getCmp('intHepatitisA').setValue(selections[0].json.VacunaHepatitisA);
                        Ext.getCmp('intTripleViral').setValue(selections[0].json.VacunaTripleViral);
                        Ext.getCmp('intVPH').setValue(selections[0].json.VacunaPapiloma);
                        Ext.getCmp('intTD').setValue(selections[0].json.VacunaTD);
                        Ext.getCmp('intControlPlacaBacteriana').setValue(selections[0].json.ControlPlaca);
                        Ext.getCmp('fecAtencionParto').setValue(selections[0].json.FechaParto);
                        Ext.getCmp('fecSalidaAtencionParto').setValue(selections[0].json.FechaSalidaParto);
                        Ext.getCmp('fecConcejeriaLactancia').setValue(selections[0].json.FechaConcejeriaLactancia);
                        Ext.getCmp('fecControlRecienNacido').setValue(selections[0].json.FechaControlRN);
                        Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').setValue(selections[0].json.FechaPlanificacionFamiliar);
                        Ext.getCmp('intSuministroMetodoPlanificacion').setValue(selections[0].json.SuministroMetodoAnticonceptivo);
                        Ext.getCmp('fecSuministroMetodo').setValue(selections[0].json.FechaSuministroMetodoAnticonceptivo);
                        Ext.getCmp('fecControlPrenatalPrimeraVez').setValue(selections[0].json.FechaPrenatalPrimeraVez);
                        Ext.getCmp('intControlPrenatal').setValue(selections[0].json.NumeroControlPrenatal);
                        Ext.getCmp('fecUltimoControlPrenatal').setValue(selections[0].json.FechaultimoControlPrenatal);
                        Ext.getCmp('intSuministroAcidoFolico').setValue(selections[0].json.SuministroAcidoFolicoPrenatal);
                        Ext.getCmp('intSuministroSulfatoFerroso').setValue(selections[0].json.SuministroSulfatoFerrosoPrenatal);
                        Ext.getCmp('intSuministroCarbonatoCalcio').setValue(selections[0].json.SuministroCarbonatoCalcioPrenatal);
                        Ext.getCmp('fecValoracionAgudezaVisual').setValue(selections[0].json.FechaAgudezaVisual);
                        Ext.getCmp('fecConsultaOfitalmologia').setValue(selections[0].json.FechaConsultaOftalmologia);
                        Ext.getCmp('fecFechaDxDesnutricion').setValue(selections[0].json.FechaDiagnosticoDesnutricion);
                        Ext.getCmp('fecConsultaMujerVictimaMaltrato').setValue(selections[0].json.FechaConsultaMujerMaltrato);
                        Ext.getCmp('fecConsultaViolenciaSexual').setValue(selections[0].json.FechaConsultaViolenciaSexual);
                        Ext.getCmp('fecConsultaNutricion').setValue(selections[0].json.FechaConsultaNutricion);
                        Ext.getCmp('fecConsultaPsicologia').setValue(selections[0].json.FechaConsultaPsicologia);
                        Ext.getCmp('fecConsultaCyDPrimeraVez').setValue(selections[0].json.FechaConsultaCyDPrimeraVez);
                        Ext.getCmp('intSuministroSulfatoFerroso1ano').setValue(selections[0].json.SuministroSulfatoFerrosoMenores);
                        Ext.getCmp('intSuministroVitaminaA').setValue(selections[0].json.SuministroVitaminaAMenores);
                        Ext.getCmp('fecConsultaJovenPrimeraVez').setValue(selections[0].json.FechaConsultaJovenPrimeraVez);
                        Ext.getCmp('fecConsultaAdultoPrimeraVez').setValue(selections[0].json.FechaConsultaAdultoPrimeraVez);
                        Ext.getCmp('intPreservativosEntregadosITS').setValue(selections[0].json.PreservativosITS);
                        Ext.getCmp('fecAsesoriaPreTestVIH').setValue(selections[0].json.FechaPreTestVIH);
                        Ext.getCmp('fecAsesoriaPosTestVIH').setValue(selections[0].json.FechaPostTestVIH);
                        Ext.getCmp('intEnfMentalTratamientoUlt6Meses').setValue(selections[0].json.DiagnosticoEnfermedadMental);
                        Ext.getCmp('fecAntigenoHepatitisB').setValue(selections[0].json.FechaAntigenoHepatitisBGestantes);
                        Ext.getCmp('intResultadoAntigenoHepatitisB').setValue(selections[0].json.ResultadoAntigenoHepatitisBGestantes);
                        Ext.getCmp('fecSerologia').setValue(selections[0].json.FechaSifilis);
                        Ext.getCmp('intResultadoSerologia').setValue(selections[0].json.ResultadoSifilis);
                        Ext.getCmp('fecTomaElisaVIH').setValue(selections[0].json.FechaElisaVIH);
                        Ext.getCmp('intResultadoElisaVIH').setValue(selections[0].json.ResultadoElisaVIH);
                        Ext.getCmp('fecTSHNeonatal').setValue(selections[0].json.FechaTSHNeonatal);
                        Ext.getCmp('intResultadoTSHNeonatal').setValue(selections[0].json.ResultadoTSHNeonatal);
                        Ext.getCmp('intTamizajeCancerCuelloUterino').setValue(selections[0].json.TamizajeCancerCuelloUterino);
                        Ext.getCmp('fecTomaCitologia').setValue(selections[0].json.FechaCitologia);
                        Ext.getCmp('intResultadoCitologia').setValue(selections[0].json.ResultadoCitologia);
                        Ext.getCmp('intCalidadMuestraCitologia').setValue(selections[0].json.CalidadMuestraCitologia);
                        Ext.getCmp('intCodIPSTomaCitologia').setValue(selections[0].json.CodigoHabilitacionIPSCitologia);
                        Ext.getCmp('fecTomaColposcopia').setValue(selections[0].json.FechaColposcopia);
                        Ext.getCmp('intCodIPSTomaColposcopia').setValue(selections[0].json.CodigoHabilitacionIPSColposcopia);
                        Ext.getCmp('fecBiopsiaCervical').setValue(selections[0].json.FechaBiosiaCervical);
                        Ext.getCmp('intResultadoBiopsiaCervical').setValue(selections[0].json.ResultadoBiopsiaCervical);
                        Ext.getCmp('intCodIPSTomaBiopsiaCervical').setValue(selections[0].json.CodigoHabilitacionIPSBiosiaCervical);
                        Ext.getCmp('fecMamografia').setValue(selections[0].json.FechaMamografia);
                        Ext.getCmp('intResultadoMamografia').setValue(selections[0].json.ResultadoMamografia);
                        Ext.getCmp('intCodIPSTomaMamografia').setValue(selections[0].json.CodigoHabilitacionIPSMamografia);
                        Ext.getCmp('fecTomaBiopsiaSenoBACAF').setValue(selections[0].json.FechaTomaBiopsiaSenoBACAF);
                        Ext.getCmp('fecResultadoBiopsiaSeno').setValue(selections[0].json.FechaResultadoBiosiaSeno);
                        Ext.getCmp('intResultadoBiopsiaSeno').setValue(selections[0].json.ResultadoBiopsiaSeno);
                        Ext.getCmp('intCodIPSTomaBiopsiaSeno').setValue(selections[0].json.CodigoHabilitacionIPSBiopsiaSeno);
                        Ext.getCmp('fecTomaHemoglobina').setValue(selections[0].json.FechaHemoglogina);
                        Ext.getCmp('intResultadoHemoglobina').setValue(selections[0].json.ResultadoHemoglobina);
                        Ext.getCmp('fecTomaGlicemia').setValue(selections[0].json.FechaGlicemia);
                        Ext.getCmp('fecTomaCreatinina').setValue(selections[0].json.FechaCreatinina);
                        Ext.getCmp('intResultadoCreatinina').setValue(selections[0].json.ResultadoCreatinina);
                        Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue(selections[0].json.FechaHemoglobinaGlicosilada);
                        Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(selections[0].json.ResultadoHemoglobinaGlicosilada);
                        Ext.getCmp('fecTomaMicroalbuminuria').setValue(selections[0].json.FechaMicroalbuminuria);
                        Ext.getCmp('fecTomaHDL').setValue(selections[0].json.FechaColesterolHDL);
                        Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue(selections[0].json.FechaBaciloscopiaDiagnostica);
                        Ext.getCmp('intResultadoBaciloscopiaDiagnostica').setValue(selections[0].json.ResultadoBaciloscopiaDiagnostica);
                        Ext.getCmp('intTratamientoHipotiroidismoCongenito').setValue(selections[0].json.TtoHipotiroidismoCongenito);
                        Ext.getCmp('intTratamientoSifilisGestacional').setValue(selections[0].json.TtoSifilisGestacional);
                        Ext.getCmp('intTratamientoSifilisCongenita').setValue(selections[0].json.TtoSifilisCongenito);
                        Ext.getCmp('intTratamientoLepra').setValue(selections[0].json.TtoLepra);
                        Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').setValue(selections[0].json.FechaTerminacionTtoLeishmaniasis);
                        winSeguimientoPacientes4505.show();
                    }
                }
            });
        }
    },
    NuevoSeguimientoPaciente: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea Crear un Registro Nuevo?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if(Ext.getCmp('intPacienteLegalizacion').getValue() == 0 || Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == ""){
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Seleccione un Paciente',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }else{
                        if(Ext.getCmp('sysId_4505').getValue() == "" || Ext.getCmp('sysId_4505').getValue() == null){
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'Seleccione un Periodo',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }else{
                            var winSeguimientoPacientes4505 = new winSeguimientoPacientes4505Ui();
                            Ext.getCmp('sysTipoDoc').setValue(Ext.getCmp('sysTipDoc').getValue());
                            Ext.getCmp('sysDocumento').setValue(Ext.getCmp('sysDoc').getValue());
                            Ext.getCmp('sysPrimerNombre').setValue(Ext.getCmp('sysPrimer_Nombre').getValue());
                            Ext.getCmp('sysSegundoNombre').setValue(Ext.getCmp('sysSegundo_Nombre').getValue());
                            Ext.getCmp('sysPrimerApellido').setValue(Ext.getCmp('sysPrimer_Apellido').getValue());
                            Ext.getCmp('sysSegundoApellido').setValue(Ext.getCmp('sysSegundo_Apellido').getValue());
                            Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNac').getValue());
                            Ext.getCmp('sysGenero').setValue(Ext.getCmp('sysSexo').getValue());
                            Ext.getCmp('sysIdPaciente').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
                            Ext.getCmp('sysId4505').setValue(Ext.getCmp('sysId_4505').getValue());
                            Ext.getCmp('sysIdCliente').setValue(Ext.getCmp('sysCliente').getValue());
                            winSeguimientoPacientes4505.show();
                        }
                    }
                }
            }
        });
    },
    
    LimpiarDatosPaciente: function(){
        Ext.getCmp('intPacienteLegalizacion').setValue(0);
        Ext.getCmp('sysPacienteLegalizacion').setValue(null);
        Ext.getCmp('gridSeguimientoPacientes4505').store.baseParams = {
            task: 'LISTAR_REGUNICO',
            pPaciente: 0,
            /*pIPS: ID_IPS,
            //pId4505: Ext.getCmp('sysId_4505').getValue(),
            pCliente: 0,*/
            start: 0, 
            limit: 15
        };
        Ext.getCmp('gridSeguimientoPacientes4505').store.load();
    },
    ListarPacientes: function(){
        if(Ext.getCmp('sysCliente').getValue() == null || Ext.getCmp('sysCliente').getValue() == ""){
            Ext.getCmp('gridSeguimientoPacientes4505').store.baseParams = {
                task: 'LISTAR_REGUNICO',
                pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                /*pIPS: ID_IPS,
                //pId4505: Ext.getCmp('sysId_4505').getValue(),
                pCliente: 0,*/
                start: 0, 
                limit: 15
            };
            Ext.getCmp('gridSeguimientoPacientes4505').store.load();
        }else{
            Ext.getCmp('gridSeguimientoPacientes4505').store.baseParams = {
                task: 'LISTAR_REGUNICO',
                pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                //pIPS: ID_IPS,
                //pId4505: Ext.getCmp('sysId_4505').getValue(),
                //pCliente: Ext.getCmp('sysCliente').getValue(),
                start: 0, 
                limit: 15
            };
            Ext.getCmp('gridSeguimientoPacientes4505').store.load();
        }
    },
    BuscarPacienteLegaliza: function(){
        buscarpaciente("Resolucion4505");
    },
    BuscarPacienteAgendaManual: function(){
        buscarpacienteagendamanual();
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
});
