/*
* @category    Formulario Alerta Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddAlertaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Alerta por Paciente ::.',
    width: 1000,
    autoHeight: true,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    autoScroll: true,
    padding: 10,
    id: 'winAddAlerta',
    initComponent: function() {
        
        var dataTipoAlerta = [
            ['A','ADMINISTRATIVA'],
            ['S','CONDICION DE SALUD']
        ];
        var stTipoAlerta = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stTipoAlerta.loadData(dataTipoAlerta);
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '85%',
                id: 'panelHC',
                border: false,
                autoHeight: true,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'form',
                        frame: true,
                        anchor: '100%',
                        id: 'frmAddAlerta',
                        padding: 10,
                        border: false,
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'ConsecutivoRegistro',
                                id: 'sysConsecutivoRegistro'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'IdPacienteAlerta',
                                id: 'sysIdPacienteAlerta'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'FechaRegistro',
                                value: new Date().format('Y-m-d'),
                                id: 'sysFechaRegistro'
                            },
                            {
                                xtype: 'panel',
                                title: '<center>ALERTA</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnAlerta',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo Alerta',
                                        name: 'Tipo Alerta',
                                        anchor: '95%',
                                        allowBlank: false,
                                        store: stTipoAlerta,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strTipoAlerta'
                                    },
                                    {
                                        xtype: 'textarea',
                                        anchor: '95%',
                                        fieldLabel: 'Alerta',
                                        name: 'Alerta',
                                        height: 80,
                                        allowBlank: true,
                                        id: 'memAlerta'
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Crear Registro',
                            iconCls: 'btnAsignarCita',
                            id: 'btnCrearAlerta',
                            listeners:{
                                click : function(){
                                    guardarAlerta();
                            }
                        }
                    }
                ]
            }
        }];
        winAddAlertaUi.superclass.initComponent.call(this);
    }
});

function guardarAlerta(){
        Ext.Msg.show({
        title: 'Guardar Alerta....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn){
            if(btn === "yes"){
              var frm = Ext.getCmp('frmAddAlerta').getForm();
                if (frm.isValid()){
                    frm.submit({
                        url: '../../controlador/pacientes/controlador_pacientes_kardex.php',
                        params: {
                            task: 'CREAR_ALERTA',
                            pUsuario: ID_USUARIO,
                            pPaciente: Ext.getCmp('sysIdPacienteAlerta').getValue(),
                            pTipoAlerta: Ext.getCmp('strTipoAlerta').getValue(),
                            pAlerta: Ext.getCmp('memAlerta').getValue()
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar Alerta',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('winAddAlerta').close();
                                    Ext.getCmp('gridAlertasPacientes').store.reload();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar Alerta',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}
