/*
* @category    Alertas por Paciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winShowAlertaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Alertas por Paciente ::.',
    width: 1000,
    autoHeight: true,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    autoScroll: true,
    padding: 10,
    id: 'winShowAlerta',
    initComponent: function() {
        var stGridAlerta = new StoreGridAlertasPacientes();
        
        function DescripcionAlertaS(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        this.items = [
            {
                xtype: 'grid',
                id: 'gridAlertasPacientesS',
                store: stGridAlerta,
                autoWidth: true,
                height: 350,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        header: 'Fecha',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Fecha',
                        align: 'center',
                        width: 100,
                        hideable: false
                    },
                    {
                        header: 'Tipo Alerta',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'TipoAlerta',
                        align: 'center',
                        width: 230,
                        hideable: false
                    },
                    {
                        header: 'Alerta',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Alerta',
                        align: 'left',
                        width: 570,
                        renderer: DescripcionAlertaS,
                        hideable: false
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                view: new Ext.grid.GroupingView({
                //view: new Ext.ux.grid.LockingGridView({
                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                    getRowClass: function(record, index, rowParams, store){
                        var estado = record.data.TipoAlerta;
                        switch (estado){
                            case "CONDICION DE SALUD":
                                return 'NoApto';
                                break;
                            default:
                                return; 
                                break;
                        }
                    }
                }),
                //view: new Ext.ux.grid.LockingGridView(),
                columnLines: true,
                bbar: {
                    xtype: 'toolbar',
                    anchor:'100%',
                    items:[
                        {
                            xtype: 'button',
                            text: 'Actualizar',
                            iconCls: 'btnActualizarGrid',
                            id: 'btnAlertasS',
                            listeners: {
                                click: function(){
                                    try {
                                        var campoIdPaciente = Ext.getCmp('intIdPaciente');
                                        if ( campoIdPaciente !== null ) {
                                            Ext.getCmp('gridAlertasPacientesS').store.load({
                                                params: {
                                                    pPaciente: Ext.getCmp('intIdPaciente').getValue()
                                                }
                                            });
                                        }
                                    }catch(ex) {
                                        Ext.getCmp('gridAlertasPacientesS').store.reload();
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                try {
                    var campoIdPaciente = Ext.getCmp('intIdPaciente');
                    if ( campoIdPaciente !== null ) {
                        Ext.getCmp('gridAlertasPacientesS').store.load({
                            params: {
                                pPaciente: Ext.getCmp('intIdPaciente').getValue()
                            }
                        });
                    }
                }catch(ex) {
                    Ext.getCmp('gridAlertasPacientesS').store.reload();
                }
            }}
        }); 
        winShowAlertaUi.superclass.initComponent.call(this);
    }
});