/*
* @category    Programacion Eventos Formulario Demanda Inducida
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmDemandaInducida = Ext.extend(winFrmDemandaInducidaUi, {
    initComponent: function() {
        winFrmDemandaInducida.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";

        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        
        Ext.getCmp('sysIdEmpresa').setValue(ID_EMPRESA);
        Ext.getCmp('sysIPS').setValue(ID_IPS);
        
        var btnBuscarPacienteLegalizacion = Ext.getCmp('btnBuscarPacienteLegalizacion').on("click",this.BuscarPacienteLegaliza,this);
        var btnLimpiarPacienteLegalizacion = Ext.getCmp('btnLimpiarPacienteLegalizacion').on("click",this.LimpiarDatosPaciente,this);
        var btnListarD = Ext.getCmp('btnListarD').on("click",this.ListarPacienteD,this);
        var btnNuevoRegistroD = Ext.getCmp('btnNuevoRegistroD').on("click",this.NuevoRegistroD,this);
        var btnDelRegistroD = Ext.getCmp('btnDelRegistroD').on("click",this.EliminarRegistroD,this);
        var btnSalirD = Ext.getCmp('btnSalirD').on("click",this.SalirOpcionD,this);
        var sm_griddemanda = Ext.getCmp('gridDemandaInducida').getSelectionModel();
        sm_griddemanda.on("rowselect",this.UpdateDetalleResumenDemanda,this);
    },
    UpdateDetalleResumenDemanda: function(sm, rowIdx, r) {
        /*alert("Tipo Contacto " + r.data.TipoContacto);
        alert('&pDemanda=' + r.data.Consecutivo);
        alert('&pTipDoc=' + r.data.TipDoc);
        alert('&pDocumento=' + r.data.Documento);
        alert('&pPrimerApellido=' + PonerAcentosMayusculas(r.data.PrimerApellido));
        alert('&pSegundoApellido=' + PonerAcentosMayusculas(r.data.SegundoApellido));
        alert('&pPrimerNombre=' + PonerAcentosMayusculas(r.data.PrimerNombre));
        alert('&pSegundoNombre=' + PonerAcentosMayusculas(r.data.SegundoNombre));
        alert('&pFecNac=' + PonerAcentosMayusculas(r.data.FecNac));
        alert('&pGenero=' + PonerAcentosMayusculas(r.data.Genero));
        alert('&pDireccion=' + PonerAcentosMayusculas(r.data.Direccion));
        alert('&pTelefono=' + PonerAcentosMayusculas(r.data.Telefono));
        alert('&pTelefono1=' + PonerAcentosMayusculas(r.data.Telefono1));
        alert('&pTipoRegistro=' + PonerAcentosMayusculas(r.data.TipoRegistro));
        alert('&pFechaContacto=' + r.data.FechaContacto);
        alert('&pHoraContacto=' + r.data.HoraContacto);
        alert('&pTipoContacto=' + PonerAcentosMayusculas(r.data.TipoContacto));
        alert('&pContactoEfectivo=' + PonerAcentosMayusculas(r.data.ContactoEfectivo));
        alert('&pPersonaContacto=' + PonerAcentosMayusculas(r.data.PersonaContacto));
        alert('&pParentesco=' + PonerAcentosMayusculas(r.data.Parentesco));
        alert('&pProgramaRemitido=' + PonerAcentosMayusculas(r.data.ProgramaRemitido));
        alert('&pPrograma=' + PonerAcentosMayusculas(r.data.Programa));
        alert('&pObservacion=' + PonerAcentosMayusculas(r.data.Observacion));
        alert('&pCAS=' + r.data.CAS);
        alert('&pFechaEstudio=' + r.data.FechaEstudio);
        alert('&pProfesional=' + PonerAcentosMayusculas(r.data.Profesional));
        alert('&pFechaAtencion=' + r.data.FechaAtencion);
        alert('&pRealizaProximoContrato=' + r.data.RealizaProximoContrato);
        alert('&pProximoContacto=' + r.data.ProximoContacto);
        alert('&pMotivoProximoContacto=' + PonerAcentosMayusculas(r.data.MotivoProximoContacto));
        alert('&pUsuario=' + PonerAcentosMayusculas(r.data.NomUsuario));*/
        //var URL = encodeURI('../../controlador/pacientes/viewdemanda.php?pEmpresa=' + ID_EMPRESA + '&pIPS=' + ID_IPS + '&pPaciente=' + r.data.Paciente + '&pDemanda=' + r.data.Consecutivo + '&pIPS=' + r.data.IPS + '&pPaciente=' + r.data.Paciente + '&pTipDoc=' + r.data.TipDoc + '&pDocumento=' + r.data.Documento + '&pPrimerApellido=' + PonerAcentosMayusculas(r.data.PrimerApellido) + '&pSegundoApellido=' + PonerAcentosMayusculas(r.data.SegundoApellido) + '&pPrimerNombre=' + PonerAcentosMayusculas(r.data.PrimerNombre) + '&pSegundoNombre=' + PonerAcentosMayusculas(r.data.SegundoNombre) + '&pFecNac=' + PonerAcentosMayusculas(r.data.FecNac) + '&pGenero=' + PonerAcentosMayusculas(r.data.Genero) + '&pDireccion=' + PonerAcentosMayusculas(r.data.Direccion) + '&pTelefono=' + PonerAcentosMayusculas(r.data.Telefono) + '&pTelefono1=' + PonerAcentosMayusculas(r.data.Telefono1) + '&pTipoRegistro=' + PonerAcentosMayusculas(r.data.TipoRegistro) + '&pFechaContacto=' + r.data.FechaContacto + '&pHoraContacto=' + r.data.HoraContacto + '&pTipoContacto=' + PonerAcentosMayusculas(r.data.TipoContacto) + '&pContactoEfectivo=' + PonerAcentosMayusculas(r.data.ContactoEfectivo) + '&pPersonaContacto=' + PonerAcentosMayusculas(r.data.PersonaContacto) + '&pParentesco=' + PonerAcentosMayusculas(r.data.Parentesco) + '&pProgramaRemitido=' + PonerAcentosMayusculas(r.data.ProgramaRemitido) + '&pPrograma=' + PonerAcentosMayusculas(r.data.Programa) + '&pObservacion=' + PonerAcentosMayusculas(r.data.Observacion) + '&pCAS=' + r.data.CAS + '&pFechaEstudio=' + r.data.FechaEstudio + '&pProfesional=' + PonerAcentosMayusculas(r.data.Profesional) + '&pFechaAtencion=' + r.data.FechaAtencion + '&pRealizaProximoContrato=' + r.data.RealizaProximoContrato + '&pProximoContacto=' + r.data.ProximoContacto + '&pMotivoProximoContacto=' + PonerAcentosMayusculas(r.data.MotivoProximoContacto) + '&pUsuario=' + PonerAcentosMayusculas(r.data.NomUsuario));
        //alert(URL);
        Ext.getCmp('DetalleResumenDemanda').load({
            url: '../../controlador/pacientes/viewdemanda201601.php?pDemanda=' + r.data.Consecutivo,
            scripts:true,
            scope:this,
            nocache: false,
            text: 'Cargando...'
        });
    },
    EliminarRegistroD: function(){
        if(parseInt(Ext.getCmp('gridDemandaInducida').selModel.getCount()) === 1){
            var selections = Ext.getCmp('gridDemandaInducida').selModel.getSelections();
            var aFecha1 = selections[0].json.FechaContacto.split('-'); 
            var fmesReg = parseInt(aFecha1[1]); 
            var f = new Date();
            var fmesAct = parseInt(f.getMonth()+1);
            var fdiasTrans = parseInt(diasTranscurridos(selections[0].json.FechaContacto,new Date().format('Y-m-d')));
            var borrarReg = 0;
            if(parseInt(selections[0].json.Usuario) === parseInt(ID_USUARIO)){
                if(fdiasTrans >= 10){
                    if(fmesAct == fmesReg){
                        borrarReg = 1;
                    }else{
                        borrarReg = 0;
                    }
                }else{
                    borrarReg = 1;
                }
                if(borrarReg == 1){
                    Ext.Msg.show({
                        title: 'Demanda Inducida y Seguimiento',
                        msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.Programa + ': ' + selections[0].json.FechaContacto + '?',
                        buttons: Ext.Msg.YESNO,
                        icon: Ext.Msg.QUESTION,
                        fn: function(btn){
                            if(btn === "yes"){
                                fnEliminarDemanda("../../controlador/pacientes/controlador_demanda_inducida.php",{task: "ELIMINAR_DEMANDA", pDemanda: selections[0].json.Consecutivo}, 'gridDemandaInducida');
                            }
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'El registro por rango de fechas no se puede eliminar',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'Usted no fue el usuario que creo el registro, por tal motivo no la puede eliminar',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    NuevoRegistroD: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea Crear un Nuevo Registro?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if(Ext.getCmp('intPacienteLegalizacion').getValue() == 0 || Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == ""){
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Seleccione un Paciente',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }else{
                        var winFrmAddDemandaInducida = new winFrmAddDemandaInducidaUi();
                        Ext.getCmp('sysTipoDoc').setValue(Ext.getCmp('sysTipDoc').getValue());
                        Ext.getCmp('sysDocumento').setValue(Ext.getCmp('sysDoc').getValue());
                        Ext.getCmp('sysPrimerNombre').setValue(Ext.getCmp('sysPrimer_Nombre').getValue());
                        Ext.getCmp('sysSegundoNombre').setValue(Ext.getCmp('sysSegundo_Nombre').getValue());
                        Ext.getCmp('sysPrimerApellido').setValue(Ext.getCmp('sysPrimer_Apellido').getValue());
                        Ext.getCmp('sysSegundoApellido').setValue(Ext.getCmp('sysSegundo_Apellido').getValue());
                        Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNac').getValue());
                        Ext.getCmp('sysGenero').setValue(Ext.getCmp('sysSexo').getValue());
                        Ext.getCmp('sysIdPaciente').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
                        winFrmAddDemandaInducida.show();
                    }
                }
            }
        });
    },
    
    ListarPacienteD: function(){
        if(Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == "" || Ext.getCmp('intPacienteLegalizacion').getValue() == 0){
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Seleccione el Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }else{
            Ext.getCmp('gridDemandaInducida').store.baseParams = {
                task: 'LISTAR',
                pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                pIPS: ID_IPS
            };
            Ext.getCmp('gridDemandaInducida').store.load();
        }
    },
    LimpiarDatosPaciente: function(){
        Ext.getCmp('intPacienteLegalizacion').setValue(0);
        Ext.getCmp('sysPacienteLegalizacion').setValue(null);
        Ext.getCmp('gridDemandaInducida').store.baseParams = {
            task: 'LISTAR',
            pPaciente: 0,
            pIPS: ID_IPS
        };
        Ext.getCmp('gridDemandaInducida').store.load();
    },
    
    BuscarPacienteLegaliza: function(){
        buscarpaciente("Resolucion4505");
    },
    SalirOpcionD: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
});

function fnEliminarDemanda(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    Ext.MessageBox.show({
                        title: 'eOfiClinic',
                        msg: 'Se elimino el registro satisfactorimente',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}