/*
* @category    Formulario Visualizacion de Eventos x Paciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

function verInfoActividadesxPaciente(wPaciente, wInfoBasica){
    var HTML = "";
    var classbody = "";
    var winListadoAtencion;
    var Contenido;
    var ID_PACIENTE = wPaciente;
    
    //creamos la ventana que contendrá el formulario
    
    var stGridAlerta = new StoreGridAlertasPacientes();
    stGridAlerta.load({
        params: {
            pPaciente: wPaciente
        }
    });
    
    var stGridActividadesPyPxPac = new StoreGridActividadesPyPPacientes();
    stGridActividadesPyPxPac.load({
        params: {
            pPaciente: wPaciente
        }
    });
    
    var stGridInsasistenciasPac = new StoreGridInasistenciasxPaciente();
    stGridInsasistenciasPac.load({
        params: {
            pPaciente: wPaciente
        },
        callback: function(){
            stGridInsasistenciasPac.each(function(record){
                if(record.get('Origen') === "ODONTOLOGIA"){
                    SI_ASIGNAR_CITAS = 0;
                }
            });
        }
    });
        
    function DescripcionAlertaS(val, x, store){
        mostrarHC = '<table><tr><td style="padding: 1px;">';
        mostrarHC += val;
        mostrarHC += '</td></tr></table>';
        return mostrarHC;
    }
        
    function VerMotivoInasistePac(value,metaData){
        metaData.attr = 'style="white-space:normal; color:#8A0808"';
        return value;
    }
    
    var verInfoActividadesxPaciente = new Ext.Window({ 
            title: '.:: Actividades Detalladas: ' + wInfoBasica + ' ::.', 
            width: 1004,
            height: 600,
            closable: false,
            resizable: false,
            draggable: false,
            modal: true,
            id: 'winInfoActividadesxPaciente',
            bbar:{
                items: [
                    {
                        xtype: 'tbfill'
                    },
                    {
                        xtype: 'tbseparator'
                    },
                    {
                        xtype: 'button',
                        text: 'Salir',
                        iconCls: 'btnSalir',
                        disabled: true,
                        id: 'btnSalirInfoActividadesxPaciente',
                        listeners:{
                            click : function(){
                                Ext.getCmp('winInfoActividadesxPaciente').close();
                            }
                        }
                    }
                ]
            },
            items: [
                {
                    xtype: 'panel',
                    border: false, 
                    autoHeight: true,
                    layout: {
                        columns: 2,
                        type: 'table'
                    },
                    items:[
                        {
                            xtype: 'panel',
                            title: 'Actividades PyP',
                            autoScroll: true,
                            width: 498,
                            height: 270,
                            frame: true,
                            border: false,
                            items: [
                                {
                                    xtype: 'grid',
                                    id: 'gridActividadesPyPPacientes',
                                    store: stGridActividadesPyPxPac,
                                    autoWidth: true,
                                    height: 230,
                                    border: false,
                                    frame: true,
                                    loadMask: true,
                                    stripeRows: true,
                                    colModel: new Ext.ux.grid.LockingColumnModel([
                                        {
                                            header: 'Concepto',
                                            readOnly: true,
                                            sortable: false,
                                            dataIndex: 'Concepto',
                                            width: 315,
                                            hideable: false
                                        },
                                        {
                                            header: 'Informacion',
                                            readOnly: true,
                                            sortable: false,
                                            dataIndex: 'Estado',
                                            width: 135,
                                            hideable: false
                                        }
                                    ]),
                                    selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                    view: new Ext.ux.grid.LockingGridView({
                                        //groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                                        getRowClass: function(record, index, rowParams, store){
                                            var estado = record.data.Estado;
                                            switch (estado){
                                                case "SIN REALIZAR":
                                                    return 'NoApto';
                                                    break;
                                                default:
                                                    return 'Apto';
                                                    break;
                                            }
                                        }
                                    }),
                                    columnLines: true,
                                    bbar: {
                                        xtype: 'toolbar',
                                        anchor:'100%',
                                        items:[
                                            {
                                                xtype: 'button',
                                                text: 'Actualizar',
                                                iconCls: 'btnActualizarGrid',
                                                listeners: {
                                                    click: function(){
                                                        stGridActividadesPyPxPac.load({
                                                            params: {
                                                                pPaciente: wPaciente
                                                            }
                                                        });
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            }
                                        ]
                                    }
                                }
                            ]
                        },
                        {
                            xtype: 'panel',
                            title: 'Alertas',
                            autoScroll: true,
                            width: 498,
                            height: 270,
                            frame: true,
                            border: false,
                            items: [
                                {
                                    xtype: 'grid',
                                    id: 'gridAlertasPacientesS',
                                    store: stGridAlerta,
                                    autoWidth: true,
                                    height: 230,
                                    border: false,
                                    frame: true,
                                    loadMask: true,
                                    stripeRows: true,
                                    colModel: new Ext.ux.grid.LockingColumnModel([
                                        {
                                            header: 'Tipo Alerta',
                                            readOnly: true,
                                            sortable: false,
                                            dataIndex: 'TipoAlerta',
                                            width: 0,
                                            hideable: false,
                                            hidden: true
                                        },
                                        {
                                            header: 'Fecha',
                                            readOnly: true,
                                            sortable: false,
                                            dataIndex: 'Fecha',
                                            align: 'center',
                                            width: 100,
                                            hideable: false
                                        },
                                        {
                                            header: 'Alerta',
                                            readOnly: true,
                                            sortable: false,
                                            dataIndex: 'Alerta',
                                            align: 'left',
                                            width: 350,
                                            renderer: DescripcionAlertaS,
                                            hideable: false
                                        }
                                    ]),
                                    selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                    view: new Ext.grid.GroupingView({
                                        groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                                        getRowClass: function(record, index, rowParams, store){
                                            var estado = record.data.TipoAlerta;
                                            switch (estado){
                                                case "CONDICION DE SALUD":
                                                    return 'NoApto';
                                                    break;
                                                default:
                                                    return; 
                                                    break;
                                            }
                                        }
                                    }),
                                    columnLines: true,
                                    bbar: {
                                        xtype: 'toolbar',
                                        anchor:'100%',
                                        items:[
                                            {
                                                xtype: 'button',
                                                text: 'Actualizar',
                                                iconCls: 'btnActualizarGrid',
                                                id: 'btnAlertasS',
                                                listeners: {
                                                    click: function(){
                                                        Ext.getCmp('gridAlertasPacientesS').store.load({
                                                            params: {
                                                                pPaciente: wPaciente
                                                            }
                                                        });
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            }
                                        ]
                                    }
                                }
                            ]
                        },
                        {
                            xtype: 'panel',
                            title: 'Multas',
                            autoScroll: true,
                            width: 996,
                            height: 270,
                            frame: true,
                            border: false,
                            colspan: 2,
                            items: [
                                {
                                    xtype: 'grid',
                                    id: 'gridInasistenciasxPac',
                                    store: stGridInsasistenciasPac,
                                    autoWidth: true,
                                    height: 230,
                                    border: false,
                                    frame: true,
                                    loadMask: true,
                                    stripeRows: true,
                                    colModel: new Ext.ux.grid.LockingColumnModel([
                                        {
                                            xtype: 'gridcolumn',
                                            header: 'Id',
                                            sortable: false,
                                            width: 1,
                                            hidden: true,
                                            hideable: false,
                                            dataIndex: 'idPaciente'
                                        },
                                        {
                                            xtype: 'gridcolumn',
                                            header: 'Fecha',
                                            sortable: false,
                                            width: 90,
                                            dataIndex: 'FecCita',
                                            renderer: Ext.util.Format.dateRenderer('d/m/Y')
                                        },
                                        {
                                            xtype: 'gridcolumn',
                                            header: 'Descripción Cita',
                                            sortable: false,
                                            width: 200,
                                            dataIndex: 'DesCita'
                                        },
                                        {
                                            xtype: 'gridcolumn',
                                            header: 'CAS',
                                            sortable: true,
                                            width: 100,
                                            dataIndex: 'CAS'
                                        },
                                        {
                                            xtype: 'gridcolumn',
                                            header: 'Profesional',
                                            sortable: false,
                                            width: 250,
                                            dataIndex: 'Profesional'
                                        },
                                        {
                                            xtype: 'gridcolumn',
                                            header: 'Actividad Programada',
                                            sortable: false,
                                            width: 450,
                                            dataIndex: 'DescProcedimiento'
                                        },
                                        {
                                            xtype: 'gridcolumn',
                                            header: 'Cliente',
                                            sortable: false,
                                            width: 250,
                                            dataIndex: 'Cliente'
                                        },
                                        {
                                            xtype: 'gridcolumn',
                                            header: 'Motivo Inasistencia',
                                            sortable: false,
                                            width: 250,
                                            dataIndex: 'MotivoCancela',
                                            renderer: VerMotivoInasistePac
                                        }
                                    ]),
                                    selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                    view: new Ext.ux.grid.LockingGridView({
                                        //groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                                        getRowClass: function(record, index, rowParams, store){
                                            var estado = record.data.Origen;
                                            switch (estado){
                                                case "ODONTOLOGIA":
                                                    return 'NoApto';
                                                    break;
                                                default:
                                                    return 'Amarillo';
                                                    break;
                                            }
                                        }
                                    }),
                                    columnLines: true,
                                    bbar: {
                                        xtype: 'toolbar',
                                        anchor:'100%',
                                        items:[
                                            {
                                                xtype: 'button',
                                                text: 'Actualizar',
                                                iconCls: 'btnActualizarGrid',
                                                listeners: {
                                                    click: function(){
                                                        Ext.getCmp('gridInasistenciasxPac').store.load({
                                                            params: {
                                                                pPaciente: wPaciente
                                                            }
                                                        });
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    ]
                }
            ]
    }); 
    verInfoActividadesxPaciente.show();
}
