/*
* @category    Formulario kardex de Pacientes 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmKardexPacientesUi = Ext.extend(Ext.Window, {
    layout: 'fit',
    title: '.:: Kardex de Pacientes ::.',
    width: 1000,
    autoHeight: true,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    closable: false,
    draggable: false,
    resizable: false,
    id: 'winFrmKardexPacientes',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        wPaciente = 0;
        wCAS = 0;
        
        var stGrid = new StoreGridKardexPacientes();
        var stGridAlerta = new StoreGridAlertasPacientes();
        
        
        //Store Local
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                autoHeight: true,
                anchor: '100%',
                autoScroll: true,
                id: 'frmKardexPacientes',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intPacienteLegalizacion',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIdEmpresa',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIPS',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysTipDoc',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysDoc',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPrimer_Nombre',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSegundo_Nombre',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPrimer_Apellido',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSegundo_Apellido',
                        value: 0
                    },
                    {
                        xtype: 'datefield',
                        hidden: true,
                        id: 'sysFecNac',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSexo',
                        value: 0
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 815,
                                fieldLabel: 'Paciente',
                                readOnly: true,
                                allowBlank: true,
                                emptyText: 'Debe Buscar Paciente....',
                                id: 'sysPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                tooltip: 'Limpiar Datos del Paciente',
                                iconCls: 'btnLimpiar',
                                id: 'btnLimpiarPacienteLegalizacion'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'tabpanel',
                anchor: '99%',
                autoHeight: true,
                border: false,
                enableTabScroll: true,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Kardex Programas',
                        autoHeight: true,
                        autoScroll: true,
                        anchor: '98%',
                        frame: true,
                        border: false,
                        id: 'fichaKardex',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'grid',
                                id: 'gridKardexPacientes',
                                store: stGrid,
                                autoWidth: true,
                                height: 350,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        header: 'Programa',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'ProgramaNom',
                                        align: 'center',
                                        width: 250,
                                        hideable: false
                                    },
                                    {
                                        header: 'FechaIngreso',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'FechaIngreso',
                                        align: 'center',
                                        width: 104,
                                        hideable: false
                                    },
                                    {
                                        header: 'ViaIngreso',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'ViaIngreso',
                                        align: 'center',
                                        width: 150,
                                        hideable: false
                                    },
                                    {
                                        header: 'Estado',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Estado',
                                        align: 'center',
                                        width: 150,
                                        hideable: false
                                    },
                                    {
                                        header: 'FechaRetiro',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'FechaRetiro',
                                        align: 'center',
                                        width: 104,
                                        hideable: false
                                    },
                                    {
                                        header: 'MotivoRetiro',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'MotivoRetiro',
                                        align: 'center',
                                        width: 200,
                                        hideable: false
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                view: new Ext.ux.grid.LockingGridView({
                                    getRowClass: function(record, index, rowParams, store){
                                        var estado = record.data.Estado;
                                        switch(estado){
                                            case "R":
                                                return "NoActivo";
                                                break;
                                            case "A":
                                                return "Apto";
                                                break;
                                            case "P":
                                                return "Triage3";
                                                break;
                                            default:
                                                return "NoActivo";
                                                break;
                                        }
                                    }
                                }),
                                columnLines: true,
                                tbar: {
                                    xtype: 'toolbar',
                                    anchor:'100%',
                                    items:[
                                        {
                                            xtype: 'button',
                                            text: 'Listar Programas',
                                            iconCls: 'btnActualizarGrid',
                                            id: 'btnPacientes'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Demanda Inducida',
                                            iconCls: 'btnEvolucionar1',
                                            id: 'btnDemandaInducida'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Pre-Inscribir a Programa',
                                            iconCls: 'btnEditRow',
                                            id: 'btnCrearRegistro'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Retiro del Programa',
                                            iconCls: 'btnDelRow',
                                            id: 'btnRetiroPrograma'
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Alertas',
                        autoHeight: true,
                        autoScroll: true,
                        anchor: '98%',
                        frame: true,
                        border: false,
                        id: 'fichaAlertas',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'grid',
                                id: 'gridAlertasPacientes',
                                store: stGridAlerta,
                                autoWidth: true,
                                height: 350,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        header: 'Tipo Alerta',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'TipoAlerta',
                                        align: 'center',
                                        width: 300,
                                        hideable: false
                                    },
                                    {
                                        header: 'Alerta',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Alerta',
                                        align: 'left',
                                        width: 658,
                                        hideable: false
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                view: new Ext.ux.grid.LockingGridView(),
                                columnLines: true,
                                tbar: {
                                    xtype: 'toolbar',
                                    anchor:'100%',
                                    items:[
                                        {
                                            xtype: 'button',
                                            text: 'Listar Alertas',
                                            iconCls: 'btnActualizarGrid',
                                            id: 'btnAlertas'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Crear Alerta',
                                            iconCls: 'btnAddRow',
                                            id: 'btnCrearRegistroAlerta'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Eliminar Alerta',
                                            iconCls: 'btnDelRow',
                                            id: 'btnEliminarAlerta'
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winFrmKardexPacientesUi.superclass.initComponent.call(this);
    }
});
