/*
* @category    Formulario Pre-Inscripcion Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winRetiroProgramaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Retiro Programa ::.',
    width: 1000,
    autoHeight: true,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    autoScroll: true,
    padding: 10,
    id: 'winRetiroPrograma',
    initComponent: function() {
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '85%',
                id: 'panelHC',
                border: false,
                autoHeight: true,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'form',
                        frame: true,
                        anchor: '100%',
                        id: 'frmRetiroPrograma',
                        padding: 10,
                        border: false,
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                value: 'NA',
                                fieldLabel: 'Pantalla',
                                id: 'sysPantalla'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'ConsecutivoRegistro',
                                id: 'sysConsecutivoRegistro'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'IdPaciente',
                                id: 'sysIdPaciente'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'IdKardex',
                                id: 'sysIdKardex'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'FechaRegistro',
                                value: new Date().format('Y-m-d'),
                                id: 'sysFechaRegistro'
                            },
                            {
                                xtype: 'panel',
                                title: '<center>DATOS BASICOS</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnDatosBasicos',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Tipo Doc ID',
                                                anchor: '75%',
                                                name: 'cbTdoc',
                                                allowBlank: false,
                                                store: 'StoreTdocPac',
                                                readOnly: true,
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Tipo Documento....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                id: 'sysTipoDoc'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: 'Documento',
                                                id: 'sysDocumento'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                emptyText: 'Primer Apellido',
                                                id: 'sysPrimerApellido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                readOnly: true,
                                                emptyText: 'Segundo Apellido',
                                                id: 'sysSegundoApellido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: 'Primer Nombre',
                                                id: 'sysPrimerNombre'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                readOnly: true,
                                                emptyText: 'Segundo Nombre',
                                                id: 'sysSegundoNombre'
                                            },
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 150,
                                                name: 'Fecha Nac',
                                                fieldLabel: 'Fecha Nac',
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Genero'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 200,
                                                name: 'Genero',
                                                allowBlank: false,
                                                readOnly: true,
                                                store: 'StoreGenero',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                emptyText: 'Seleccione Genero....',
                                                forceSelection: true,
                                                id: 'sysGenero'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '<center>RETIRO PROGRAMA</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnPreInscripcionPrograma',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        anchor: '95%',
                                        allowBlank: true,
                                        readOnly: true,
                                        emptyText: 'Programa',
                                        id: 'sysPrograma'
                                    },
                                    {
                                        xtype: 'textarea',
                                        anchor: '95%',
                                        fieldLabel: 'Motivo del Retiro',
                                        name: 'Motivo del Retiro',
                                        height: 80,
                                        allowBlank: true,
                                        id: 'memMotivoRetiro'
                                    },
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Retiro Programa',
                            iconCls: 'btnDelRow',
                            id: 'btnRetiroPrograma',
                            listeners:{
                                click : function(){
                                    retiroPrograma()
                            }
                        }
                    }
                ]
            }
        }];
        winRetiroProgramaUi.superclass.initComponent.call(this);
    }
});

function retiroPrograma(){
        Ext.Msg.show({
        title: 'Retiro Programa....!',
        msg: 'Esta seguro que desea Retirar al Paciente del Programa?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn=="yes")
            {
              var frm = Ext.getCmp('frmRetiroPrograma').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/pacientes/controlador_pacientes_kardex.php',
                        params: {
                            task: 'RETIRO_PROGRAMA',
                            pUsuario: ID_USUARIO,
                            pIdKardex: Ext.getCmp('sysIdKardex').getValue(),
                            pMotivoRetiro: Ext.getCmp('memMotivoRetiro').getValue()
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Retiro Programa',
                                        msg: 'Se Retiro al Paciente del Programa con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('winRetiroPrograma').close();
                                    Ext.getCmp('gridKardexPacientes').store.load();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar Alerta',
                                        msg: 'Ocurrio un error al Retirar al Paciente el Programa o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Retirar al Paciente el Programa en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}
