/*
* @category    Formulario Tipo Componente
* @package     OfiClinic Web
* @author      Héctor Iván Ramírez Cardona<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

/**
*  Pre: ---
*  Post: ---
*  Return: winTipoEquipoUi Object
*  Resumen: Crea el formulario para registrar un tipo de Componente y modificarla
**/

winFecProgramacionUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Programar Fecha ::.',
    width: 700,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winFecProgramacionUi',
    
    /**
    *  Pre:---
    *  Post: ---
    *  Return: --- 
    *  Resumen: Inicializa el componente del formulario tipo componente
    **/
   
    initComponent: function() 
    {
        this.items = [
                {
                    xtype: 'form',
                    frame: true,
                    anchor: '100%',
                    id: 'frmAddPacProgramaUi',
                    padding: 10,
                    items: [
                        {
                            xtype: 'panel',
                            layout: 'form',
                            border: false,
                            labelWidth: 90,
                            items:[
                                {
                                    xtype:'hidden',
                                    id:'intKarProgramacion'
                                },
                                {
                                    xtype:'hidden',
                                    id:'intIdKardex'
                                },
                                {
                                    xtype: 'datefield',
                                    width:100,
                                    fieldLabel: 'Fecha Proxima Cita',
                                    name: 'Fecha Proxima Cita',
                                    allowBlank: false,
                                    id:'fecProximaCita'
                                },
                                {
                                    xtype: 'textfield',
                                    width:400,
                                    fieldLabel: 'Profesional',
                                    name: 'Profesional',
                                    allowBlank: false,
                                    id:'intProfesional'
                                },
                                {
                                    xtype: 'textfield',
                                    width:400,
                                    fieldLabel: 'Especialidad',
                                    name: 'Profesional',
                                    allowBlank: false,
                                    id:'intEspecialidad'
                                },
                                {
                                    xtype:'hidden',
                                    id:'intUsuProgramo'
                                }
                            ]
                        }
                    ],
                    tbar:
                    {
                        items: [
                            {
                                xtype: 'tbfill'
                            },
                            {
                                xtype: 'button',
                                text: 'Guardar',
                                iconCls: 'btnGuardar',
                                id: 'btn_AddFecProgramacion'
                            }
                        ]
                    },
                    bbar:
                    {   
                        items: [
                            {
                                xtype: 'tbfill'
                            },
                            {   
                                xtype: 'button',
                                text: 'Salir',
                                iconCls: 'btnSalir',
                                id: 'btn_SalirFecProgramacion'
                            }
                        ]
                    }
                }
            ];
        winFecProgramacionUi.superclass.initComponent.call(this);    
    }
});
